/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.Constants;

public class Token
implements Constants {
    public final int type;
    public final int index;
    public String lex;
    public int opType;
    public boolean booleanValue;

    Token(int type, int index, String lex) {
        this.type = type;
        this.index = index;
        this.lex = lex;
    }

    public static Token operator(int opType, int index, String lex) {
        Token t = new Token(6, index, lex);
        t.opType = opType;
        return t;
    }

    public static Token integer(int index, String lex) {
        Token t = new Token(3, index, lex);
        return t;
    }

    public static Token bool(int index, String lex, boolean value) {
        Token t = new Token(4, index, lex);
        t.booleanValue = value;
        return t;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(32);
        sbuf.append(TOKEN_STRINGS[this.type]);
        if (this.lex != null) {
            sbuf.append(": '").append(this.lex).append('\'');
        } else if (this.type == 4) {
            sbuf.append(": '").append(this.booleanValue).append('\'');
        } else if (this.type == 6) {
            sbuf.append(": '").append(OPTYPE_STRINGS[this.opType]).append('\'');
        }
        return sbuf.toString();
    }

    public String toDisplay() {
        if (this.lex != null) {
            return this.lex;
        }
        if (this.type == 6) {
            return OPTYPE_STRINGS[this.opType];
        }
        return TOKEN_STRINGS[this.type];
    }
}

