/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.AstOut;
import com.tridium.neql.Constants;
import com.tridium.neql.ExprParser;
import com.tridium.neql.NeqlTokenizer;
import com.tridium.neql.Token;
import com.tridium.neql.UnexpectedTokenTypeException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.baja.neql.Expression;
import javax.baja.neql.Projection;
import javax.baja.neql.Select;

public class SelectParser
implements Constants {
    private NeqlTokenizer tokens;
    private Token current;

    public Select parse(NeqlTokenizer tokens) {
        this.tokens = tokens;
        this.next();
        Projection projection = null;
        Expression predicate = null;
        if (this.current.type == 15) {
            this.match(15);
            this.skipWhitespace();
            ArrayList<Expression> projectionElems = new ArrayList<Expression>();
            if (this.current.type != 17 && this.current.type != 2) {
                tokens.push(this.current);
                Expression elem = new ExprParser().parse(tokens);
                projectionElems.add(elem);
                this.next();
                this.skipWhitespace();
                while (this.current.type == 12) {
                    this.match(12);
                    this.skipWhitespace();
                    tokens.push(this.current);
                    elem = new ExprParser().parse(tokens);
                    projectionElems.add(elem);
                    this.next();
                    this.skipWhitespace();
                }
                if (this.current.type == 17) {
                    this.match(17);
                    this.skipWhitespace();
                    tokens.push(this.current);
                    predicate = new ExprParser().parse(tokens);
                    this.next();
                }
            }
            projection = new Projection(projectionElems.toArray(new Expression[projectionElems.size()]));
        } else {
            tokens.push(this.current);
            predicate = new ExprParser().parse(tokens);
            this.next();
        }
        this.skipWhitespace();
        this.match(2);
        return new Select(projection, predicate);
    }

    private Token next() {
        Token result = this.current;
        this.current = this.tokens.next();
        return result;
    }

    private Token match(int matchType) {
        Token result = this.current;
        if (this.current.type != matchType) {
            throw new UnexpectedTokenTypeException(this.current.index, matchType, this.current.type);
        }
        this.next();
        return result;
    }

    private Token skipWhitespace() {
        while (this.current.type == 0) {
            this.next();
        }
        return this.current;
    }

    private Token matchOperator(int matchOpType) {
        Token op = this.match(6);
        if (op.opType != matchOpType) {
            throw new UnexpectedTokenTypeException(this.current.index, 6, this.current.type);
        }
        return op;
    }

    public static void main(String[] args) {
        Select result = null;
        NeqlTokenizer tokens = null;
        String input = null;
        input = "equip and ahu";
        tokens = new NeqlTokenizer(input);
        result = new SelectParser().parse(tokens);
        AstOut out = new AstOut(new PrintWriter(System.out));
        out.write(result);
        out.flush();
    }
}

