/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.NeqlUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;
import javax.baja.tag.Relation;

public class RelatedEntityIterator
implements Iterator<Entity> {
    private final Iterator<Relation> relations;
    private final Context context;
    private boolean done;
    private boolean moved;
    private Entity current;

    public RelatedEntityIterator(Iterator<Relation> relations, Context context) {
        this.relations = relations;
        this.context = context;
        this.done = false;
    }

    @Override
    public boolean hasNext() {
        if (this.done) {
            return false;
        }
        if (!this.moved) {
            this.current = this.nextImpl();
            this.moved = true;
        }
        return this.current != null;
    }

    @Override
    public Entity next() {
        if (this.done) {
            throw new NoSuchElementException("Iterator is already done");
        }
        if (this.moved) {
            this.moved = false;
            return this.current;
        }
        this.current = this.nextImpl();
        if (this.current != null) {
            return this.current;
        }
        throw new NoSuchElementException("Could not find a next");
    }

    private Entity nextImpl() {
        if (this.done) {
            return null;
        }
        if (!this.relations.hasNext()) {
            this.done = true;
            return null;
        }
        while (this.relations.hasNext()) {
            Relation relation = this.relations.next();
            Entity endpoint = relation.getEndpoint();
            if (!NeqlUtil.hasPermission(endpoint, this.context)) continue;
            return endpoint;
        }
        return null;
    }
}

