/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.RelatedEntityIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.Expression;
import javax.baja.neql.GetRelationExpression;
import javax.baja.neql.TraverseInExpression;
import javax.baja.neql.TraverseOutExpression;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;

public final class EvalOnIterator
implements Iterator<Entity> {
    private final Entity rootEntity;
    private final Context context;
    private final List<IdDirection> relations;
    private final int relationCount;
    private final Deque<RelatedEntityIterator> iterators;
    private boolean done = false;
    private boolean moved = false;
    private Entity current = null;

    private EvalOnIterator(List<IdDirection> relations, Entity rootEntity, Context context) {
        this.relations = relations;
        this.rootEntity = rootEntity;
        this.context = context;
        this.relationCount = relations.size();
        this.iterators = new ArrayDeque<RelatedEntityIterator>(this.relationCount);
    }

    public static EvalOnIterator make(EvalOnExpression rootExpression, Entity rootEntity, Context context) {
        ArrayList<IdDirection> relations = new ArrayList<IdDirection>();
        EvalOnIterator.addRelations(rootExpression.getTarget(), relations, context);
        return new EvalOnIterator(relations, rootEntity, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addRelations(Expression traverse, List<IdDirection> relations, Context context) {
        Expression traverseInner;
        int direction;
        int traverseType = traverse.getNodeType();
        if (traverseType == 18) {
            direction = 2;
            traverseInner = ((TraverseOutExpression)traverse).getExpression();
        } else {
            if (traverseType != 17) throw new LocalizableRuntimeException("neql", "evalOnIterator.invalidEvalOnTarget", new Object[]{traverse.getClass().getSimpleName()});
            direction = 1;
            traverseInner = ((TraverseInExpression)traverse).getExpression();
        }
        int traverseInnerType = traverseInner.getNodeType();
        if (traverseInnerType == 19) {
            EvalOnExpression evalOn = (EvalOnExpression)traverseInner;
            EvalOnIterator.addRelations(evalOn.getTarget(), relations, context);
            Expression evalOnInner = evalOn.getExpression();
            if (evalOnInner.getNodeType() != 4) throw new LocalizableRuntimeException("neql", "evalOnIterator.invalidEvalOnInner", new Object[]{evalOnInner.getClass().getSimpleName()});
            relations.add(new IdDirection(((GetRelationExpression)evalOnInner).getId(context), direction));
            return;
        } else {
            if (traverseInnerType != 4) throw new LocalizableRuntimeException("neql", "evalOnIterator.invalidTraverseInner", new Object[]{traverseInner.getClass().getSimpleName()});
            relations.add(new IdDirection(((GetRelationExpression)traverseInner).getId(context), direction));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.done) {
            return false;
        }
        if (this.moved) {
            return this.current != null;
        }
        this.current = this.nextImpl();
        this.moved = true;
        return this.current != null;
    }

    @Override
    public Entity next() {
        if (this.done) {
            throw new NoSuchElementException("Already completed iterations");
        }
        if (this.moved) {
            this.moved = false;
            return this.current;
        }
        this.current = this.nextImpl();
        if (this.current != null) {
            return this.current;
        }
        throw new NoSuchElementException("Could not find a next item");
    }

    private Entity nextImpl() {
        if (this.done) {
            return null;
        }
        if (this.iterators.isEmpty()) {
            IdDirection idDirection = this.relations.get(0);
            this.pushIterator(this.rootEntity, idDirection);
        }
        while (!this.iterators.isEmpty()) {
            RelatedEntityIterator iterator = this.iterators.peek();
            if (iterator.hasNext()) {
                int iteratorsSize = this.iterators.size();
                if (iteratorsSize < this.relationCount) {
                    this.pushIterator(iterator.next(), this.relations.get(iteratorsSize));
                    continue;
                }
                return iterator.next();
            }
            this.iterators.pop();
        }
        this.done = true;
        return null;
    }

    private void pushIterator(Entity entity, IdDirection idDirection) {
        Collection entityRelations = entity.relations().getAll(idDirection.id, idDirection.direction);
        if (!entityRelations.isEmpty()) {
            RelatedEntityIterator iterator = new RelatedEntityIterator(entityRelations.iterator(), this.context);
            this.iterators.push(iterator);
        }
    }

    private static class IdDirection {
        final Id id;
        final int direction;

        IdDirection(Id id, int direction) {
            this.id = id;
            this.direction = direction;
        }
    }
}

