/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.guidedTour;

import com.tridiumx.guidedTour.BStep;
import com.tridiumx.guidedTour.BStepOption;
import com.tridiumx.guidedTour.BStepProgress;
import com.tridiumx.guidedTour.BStepUpdate;
import com.tridiumx.guidedTour.GuideCommand;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class GuidedTour {
    private String cancelText;
    private BStep[] steps;
    public Lexicon lex;
    public int uiWidth;
    private Command guideCommand;
    private BImage arrowLeft = BImage.make((String)"module://guidedTour/com/tridiumx/guidedTour/img/arrowLeft.png");
    private BImage arrowRight = BImage.make((String)"module://guidedTour/com/tridiumx/guidedTour/img/arrowRight.png");
    private BImage arrowLeftDisabled = BImage.make((String)"module://guidedTour/com/tridiumx/guidedTour/img/arrowLeft-disabled.png");
    private BImage arrowRightDisabled = BImage.make((String)"module://guidedTour/com/tridiumx/guidedTour/img/arrowRight-disabled.png");

    public GuidedTour(BOrd pathToXml, int initialStepNumber) {
        this.lex = Lexicon.make(this.getClass());
        try {
            BIFile file = (BIFile)pathToXml.get();
            InputStream in = file.getInputStream();
            XElem tour = XParser.make((InputStream)in).parse();
            in.close();
            this.uiWidth = Integer.parseInt(tour.get("uiWidth", "-1"));
            XElem[] s = tour.elems("step");
            this.steps = new BStep[s.length];
            for (int i = 0; i < s.length; ++i) {
                BStep step = new BStep();
                String n = s[i].get("name", "");
                step.setStepName(n);
                XElem e = s[i].elem("instructions");
                step.setInstructions(this.getText(e.text().toString()));
                XElem[] options = s[i].elems("option");
                for (int j = 0; j < options.length; ++j) {
                    String p;
                    String g;
                    BStepOption option = new BStepOption();
                    XElem ee = options[j].elem("instructions");
                    option.setInstructions(this.getText(ee.text().toString()));
                    XElem o = options[j].elem("ord");
                    if (o != null) {
                        option.setOrd(BOrd.make((String)o.text().toString()));
                    }
                    if ((g = options[j].get("goto", null)) != null) {
                        option.setGotoStep(g);
                    }
                    if ((p = options[j].get("progress", "inProgress")) != null) {
                        option.setProgressUpdate(BStepProgress.make(p));
                    }
                    boolean exit = options[j].getb("exit", false);
                    option.setExit(exit);
                    XElem[] progressUpdates = options[j].elems("progressUpdate");
                    for (int k = 0; k < progressUpdates.length; ++k) {
                        BStepUpdate update = new BStepUpdate();
                        String updateText = progressUpdates[k].text().toString();
                        String[] split = TextUtil.split((String)updateText, (char)',');
                        String name = split[0];
                        update.setStepName(name);
                        if (split.length > 1) {
                            update.setProgress(BStepProgress.make(split[1]));
                        }
                        option.add("progressUpdate" + k, (BValue)update);
                    }
                    step.add("option" + j, (BValue)option);
                }
                if (initialStepNumber > i) {
                    step.setProgress(BStepProgress.complete);
                }
                this.steps[i] = step;
            }
        }
        catch (Exception e) {
            System.out.println("Guided Step Unavailable");
            e.printStackTrace();
        }
    }

    public void popUp(HxOp op) throws Exception {
        if (this.guideCommand == null) {
            this.guideCommand = new GuideCommand(null, this);
            op.getProfile().registerEvent((Event)this.guideCommand);
        }
        StringBuffer b = new StringBuffer();
        b.append("hx.setFormValue(&quot;").append(op.scope("guidedTourStep")).append("&quot;,&quot;");
        b.append("0&quot;);");
        b.append("hx.fireEvent(");
        b.append("&quot;").append(op.getPath()).append("&quot;");
        b.append(",");
        b.append("&quot;").append(this.guideCommand.getId()).append("&quot;");
        b.append(");");
        op.addOnload(b.toString());
    }

    public void write(HxOp op) throws Exception {
        String tag;
        op.addStyleSheet("module://guidedTour/com/tridiumx/guidedTour/guidedTour.css");
        if (this.guideCommand == null) {
            this.guideCommand = new GuideCommand(null, this);
            op.getProfile().registerEvent((Event)this.guideCommand);
        }
        HtmlWriter out = op.getHtmlWriter();
        BOrd self = op.getOrd();
        int nextStep = this.getNextStep();
        out.w((Object)"<span style='cursor:default'");
        out.attr("id", op.scope("guideSpan")).w((Object)">");
        String hideStart = op.getCookie("hideStart");
        if (hideStart == null) {
            int amount = nextStep - this.uiWidth;
            if (amount >= 0) {
                StringBuffer b = new StringBuffer();
                b.append("hx.setFormValue(&quot;").append(op.scope("guidedTourStep")).append("&quot;,&quot;");
                b.append("right" + amount + "&quot;);");
                b.append(this.guideCommand.getInvokeCode(op));
                op.addOnload(b.toString());
            }
            hideStart = "0";
        }
        int iHide = Integer.parseInt(hideStart);
        if (this.steps.length > 0) {
            tag = this.steps[0].getProgress().getTag();
            if (0 == nextStep) {
                tag = "available";
            }
            out.w((Object)"<span ");
            out.attr("id", op.scope("stepSpanSpacer"));
            out.w((Object)">&nbsp;");
            out.w((Object)"<span class='step-").w((Object)tag).w((Object)"' ");
            out.attr("id", op.scope("stepSpan0"));
            out.w((Object)"onclick='");
            out.w((Object)"hx.setFormValue(&quot;").w((Object)op.scope("guidedTourStep")).w((Object)"&quot;,&quot;");
            out.w((Object)"0");
            out.w((Object)"&quot;);");
            out.w((Object)this.guideCommand.getInvokeCode(op)).w((Object)"'");
            out.w((Object)">").safe((Object)this.lex.getText("guidedTour.guidedTour")).w((Object)"</span>");
            out.w((Object)"&nbsp;");
            out.w((Object)"</span>");
        }
        if (this.uiWidth > -1 && this.uiWidth < this.getStepLength()) {
            tag = "available";
            out.w((Object)"&nbsp;<span class='step-").w((Object)tag).w((Object)"' ");
            out.attr("style", "padding: 1px 4px 2px");
            out.w((Object)"onclick='");
            out.w((Object)"hx.setFormValue(&quot;").w((Object)op.scope("guidedTourStep")).w((Object)"&quot;,&quot;");
            out.w((Object)"left");
            out.w((Object)"&quot;);");
            out.w((Object)this.guideCommand.getInvokeCode(op)).w((Object)"'");
            out.w((Object)">");
            out.w((Object)"<span ");
            if (iHide != 0) {
                out.attr("style", "display: none");
            }
            out.attr("id", op.scope("stepLeftDisabled")).w((Object)">");
            HxUtil.makeImageJS((BImage)this.arrowLeftDisabled, (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"<span ");
            if (iHide == 0) {
                out.attr("style", "display: none");
            }
            out.attr("id", op.scope("stepLeft")).w((Object)">");
            HxUtil.makeImageJS((BImage)this.arrowLeft, (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"</span>");
            out.w((Object)"&nbsp;");
        }
        for (int i = 1; i < this.steps.length; ++i) {
            String tag2 = this.steps[i].getProgress().getTag();
            if (i == nextStep) {
                tag2 = "available";
            }
            out.w((Object)"<span ");
            out.attr("id", op.scope("stepSpanSpacer" + i));
            if (this.uiWidth > -1 && (i <= iHide || i > iHide + this.uiWidth)) {
                out.attr("style", "display:none");
            }
            out.w((Object)">&nbsp;");
            out.w((Object)"<span class='step-").w((Object)tag2).w((Object)"' ");
            out.attr("id", op.scope("stepSpan" + i));
            out.w((Object)"onclick='if(this.className != &quot;step-notStarted&quot;){");
            out.w((Object)"hx.setFormValue(&quot;").w((Object)op.scope("guidedTourStep")).w((Object)"&quot;,&quot;");
            out.w(i);
            out.w((Object)"&quot;);");
            out.w((Object)this.guideCommand.getInvokeCode(op)).w((Object)"}'");
            out.w((Object)">");
            if (i < 10) {
                out.w((Object)"&nbsp;").w(i).w((Object)"&nbsp;");
            } else {
                out.w(i);
            }
            out.w((Object)"</span>");
            out.w((Object)"&nbsp;");
            out.w((Object)"</span>");
        }
        if (this.uiWidth > -1 && this.uiWidth < this.getStepLength()) {
            String tag3 = "available";
            out.w((Object)"&nbsp;<span class='step-").w((Object)tag3).w((Object)"' ");
            out.attr("style", "padding: 1px 4px 2px");
            out.w((Object)"onclick='");
            out.w((Object)"hx.setFormValue(&quot;").w((Object)op.scope("guidedTourStep")).w((Object)"&quot;,&quot;");
            out.w((Object)"right");
            out.w((Object)"&quot;);");
            out.w((Object)this.guideCommand.getInvokeCode(op)).w((Object)"'");
            out.w((Object)">");
            out.w((Object)"<span ");
            if (iHide + this.uiWidth + 1 != this.getStepLength()) {
                out.attr("style", "display: none");
            }
            out.attr("id", op.scope("stepRightDisabled")).w((Object)">");
            HxUtil.makeImageJS((BImage)this.arrowRightDisabled, (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"<span ");
            if (iHide + this.uiWidth + 1 == this.getStepLength()) {
                out.attr("style", "display: none");
            }
            out.attr("id", op.scope("stepRight")).w((Object)">");
            HxUtil.makeImageJS((BImage)this.arrowRight, (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"</span>");
        }
        out.w((Object)"</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public int getNextStep() {
        for (int i = 0; i < this.steps.length; ++i) {
            BStepProgress progress = this.steps[i].getProgress();
            if (progress.equals((Object)BStepProgress.complete)) continue;
            if (progress.equals((Object)BStepProgress.notStarted)) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    public String getText(String original) {
        try {
            if (!original.trim().startsWith("lexicon:")) {
                return original;
            }
            String[] split = TextUtil.split((String)original, (char)':');
            String module = split[1];
            String lexEntry = split[2];
            return Lexicon.make((String)module).getText(lexEntry);
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    public BStep getStep(int i) {
        return this.steps[i];
    }

    public int getStepLength() {
        return this.steps.length;
    }

    public String getCancelText() {
        return this.cancelText;
    }
}

