/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.BRdbmsOptionalColumnSelection;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.sql.SqlParser;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.history.BRdbmsColumnSelection;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BRdbmsHistoryImport
extends BHistoryImport {
    private static Lexicon lex = Lexicon.make((String)"driver");
    public static final Property rdbTableName = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property rdbCatalogName = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property rdbSchemaName = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property timestampColumn = BRdbmsHistoryImport.newProperty((int)0, (BValue)new BRdbmsColumnSelection(), null);
    public static final Property valueColumn = BRdbmsHistoryImport.newProperty((int)0, (BValue)new BRdbmsColumnSelection(), null);
    public static final Property statusColumn = BRdbmsHistoryImport.newProperty((int)0, (BValue)new BRdbmsOptionalColumnSelection(), null);
    public static final Property queryPredicate = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property fullImportOnExecute = BRdbmsHistoryImport.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("import.fullImport.enabled"), (String)lex.getText("import.fullImport.disabled")));
    public static final Type TYPE = Sys.loadType(BRdbmsHistoryImport.class);
    private Connection connection;
    private RdbmsDialect rdbmsContext;
    private BRdbms db;
    private BRdbmsHistoryDeviceExt devicelet;
    private BRdbmsDeprecatedDialect dialect;
    private int timestampColumnType = 93;
    private boolean timestampColumnTypeInitialized = false;
    private boolean importingLicensed = false;
    private String licenseFailure = null;
    private static HashMap<String, Integer> importCounts = new HashMap();
    private static final TimeZone localTimeZone = BTimeZone.getLocal().getJavaTimeZone();
    private static final Calendar utcCalender = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    private static final String HISTORY_CONFIG_TABLE = "HISTORY_CONFIG";
    private static final String HISTORY_TYPE_MAP_TABLE = "HISTORY_TYPE_MAP";
    private static final String TIMEZONE_COLUMN = "TIMEZONE";
    private static final String DB_TIMEZONE_COLUMN = "DB_TIMEZONE";

    public String getRdbTableName() {
        return this.getString(rdbTableName);
    }

    public void setRdbTableName(String v) {
        this.setString(rdbTableName, v, null);
    }

    public String getRdbCatalogName() {
        return this.getString(rdbCatalogName);
    }

    public void setRdbCatalogName(String v) {
        this.setString(rdbCatalogName, v, null);
    }

    public String getRdbSchemaName() {
        return this.getString(rdbSchemaName);
    }

    public void setRdbSchemaName(String v) {
        this.setString(rdbSchemaName, v, null);
    }

    public BRdbmsColumnSelection getTimestampColumn() {
        return (BRdbmsColumnSelection)this.get(timestampColumn);
    }

    public void setTimestampColumn(BRdbmsColumnSelection v) {
        this.set(timestampColumn, (BValue)v, null);
    }

    public BRdbmsColumnSelection getValueColumn() {
        return (BRdbmsColumnSelection)this.get(valueColumn);
    }

    public void setValueColumn(BRdbmsColumnSelection v) {
        this.set(valueColumn, (BValue)v, null);
    }

    public BRdbmsColumnSelection getStatusColumn() {
        return (BRdbmsColumnSelection)this.get(statusColumn);
    }

    public void setStatusColumn(BRdbmsColumnSelection v) {
        this.set(statusColumn, (BValue)v, null);
    }

    public String getQueryPredicate() {
        return this.getString(queryPredicate);
    }

    public void setQueryPredicate(String v) {
        this.setString(queryPredicate, v, null);
    }

    public boolean getFullImportOnExecute() {
        return this.getBoolean(fullImportOnExecute);
    }

    public void setFullImportOnExecute(boolean v) {
        this.setBoolean(fullImportOnExecute, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkLicense();
        if (this.importingLicensed) {
            this.importDescriptorStarted();
        }
    }

    public void importDescriptorStarted() throws Exception {
    }

    private void checkLicense() {
        try {
            Feature feature = ((BRdbms)this.getDevice()).getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
            this.importingLicensed = feature.getb("historyImport", false);
            if (this.importingLicensed) {
                String key = feature.getVendorName() + ":" + feature.getFeatureName();
                key = TextUtil.toLowerCase((String)key);
                Integer importCount = importCounts.get(key);
                int count = 0;
                if (importCount != null) {
                    count = importCount;
                }
                importCounts.put(key, new Integer(++count));
                String val = feature.get("history.limit", "0");
                int limit = Integer.MAX_VALUE;
                if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
                    limit = Integer.parseInt(val);
                }
                if (limit == 0) {
                    this.importingLicensed = false;
                    this.licenseFailure = "Unlicensed: history.limit is zero or non-existent";
                } else if (count > limit) {
                    this.importingLicensed = false;
                    this.licenseFailure = "Unlicensed: Exceeded history.limit of " + limit;
                }
            } else {
                this.licenseFailure = "Unlicensed: Missing or disabled historyImport license attribute";
            }
        }
        catch (Exception e) {
            this.importingLicensed = false;
            this.licenseFailure = "Unlicensed: " + e;
        }
        if (!this.importingLicensed) {
            this.executeFail(this.licenseFailure);
        }
    }

    public final void doExecute() {
        if (this.importingLicensed) {
            this.executeRdbImport();
        } else {
            this.executeFail(this.licenseFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeRdbImport() {
        Statement stmt = null;
        Statement ps = null;
        ResultSet rs = null;
        this.executeInProgress();
        try {
            SqlParser parser;
            boolean predicateExists;
            BHistoryId id = this.getHistoryId();
            if (id.isNull()) {
                this.executeFail(lex.getText("import.error.nullId"));
                return;
            }
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (localDb == null) {
                this.executeFail(lex.getText("import.error.dbNotAvailable"));
                return;
            }
            this.devicelet = (BRdbmsHistoryDeviceExt)this.getDeviceExt();
            this.db = (BRdbms)this.devicelet.getDevice();
            this.dialect = BRdbmsDeprecatedDialect.make(this.db);
            this.connection = this.db.getConnection();
            this.connection.setCatalog(this.getRdbCatalogName());
            String schemaName = this.getRdbSchemaName();
            String tableName = this.getRdbTableName();
            this.rdbmsContext = (RdbmsDialect)this.db.getRdbmsContext();
            String timestampCol = BRdbmsHistoryImport.getColumnIdentifier(schemaName, tableName, SlotPath.unescape((String)this.getTimestampColumn().getColumn().getTag()), this.rdbmsContext);
            String valueCol = BRdbmsHistoryImport.getColumnIdentifier(schemaName, tableName, SlotPath.unescape((String)this.getValueColumn().getColumn().getTag()), this.rdbmsContext);
            String statusCol = BRdbmsHistoryImport.getColumnIdentifier(schemaName, tableName, SlotPath.unescape((String)this.getStatusColumn().getColumn().getTag()), this.rdbmsContext);
            tableName = BRdbmsHistoryImport.getTableIdentifier(schemaName, tableName, this.rdbmsContext);
            BTimeZone timezone = this.getImportTimeZone();
            Calendar importCalender = Calendar.getInstance(timezone.getJavaTimeZone());
            String additionalPredicate = this.getQueryPredicate().trim().toUpperCase();
            if (additionalPredicate.startsWith("WHERE ")) {
                additionalPredicate = additionalPredicate.substring(6).trim();
            } else if (additionalPredicate.equals("WHERE")) {
                additionalPredicate = null;
            }
            boolean bl = predicateExists = additionalPredicate != null && !additionalPredicate.isEmpty();
            if (predicateExists && (parser = new SqlParser(new StringReader("SELECT X FROM Y WHERE " + additionalPredicate))).parse() != 0) {
                throw new Exception("Invalid query predicate");
            }
            boolean timestampColExists = true;
            if (this.getTimestampColumn().getType().is(BRdbmsOptionalColumnSelection.TYPE)) {
                timestampColExists = !((BRdbmsOptionalColumnSelection)this.getTimestampColumn()).getUnspecified();
            }
            boolean statusColExists = true;
            if (this.getStatusColumn().getType().is(BRdbmsOptionalColumnSelection.TYPE)) {
                statusColExists = !((BRdbmsOptionalColumnSelection)this.getStatusColumn()).getUnspecified();
            }
            StringBuffer query = new StringBuffer();
            query.append("SELECT " + valueCol);
            if (timestampColExists) {
                query.append("," + timestampCol);
            }
            if (statusColExists) {
                query.append("," + statusCol);
            }
            query.append(" FROM " + tableName);
            BHistoryConfig config = null;
            BTypeSpec recordType = null;
            BIHistory history = null;
            try (HistoryDatabaseConnection historyDbConn = localDb.getDbConnection(null);){
                block115: {
                    BAbsTime lastTimestamp;
                    block117: {
                        block116: {
                            block114: {
                                if (historyDbConn.exists(id)) break block114;
                                if (predicateExists) {
                                    query.append(" WHERE " + additionalPredicate);
                                }
                                stmt = this.connection.createStatement();
                                String sqlQuery = query.toString();
                                if (this.db.getLogger().isLoggable(Level.FINE)) {
                                    this.db.getLogger().fine("Issuing the following SQL query to import data for history: " + id);
                                    this.db.getLogger().fine("    " + sqlQuery);
                                }
                                rs = stmt.executeQuery(sqlQuery);
                                ResultSetMetaData rsmd = rs.getMetaData();
                                recordType = BRdbmsHistoryImport.getRecordType(rsmd, 1);
                                if (timestampColExists) {
                                    this.timestampColumnType = rsmd.getColumnType(2);
                                    this.timestampColumnTypeInitialized = true;
                                }
                                if (recordType == null) {
                                    Object[] args = new Object[]{valueCol};
                                    this.executeFail(lex.getText("import.error.invalidRecordType", args));
                                    return;
                                }
                                config = this.makeLocalConfig(this.makeLocalRdbConfig(id, recordType));
                                historyDbConn.createHistory(config);
                                history = historyDbConn.getHistory(id);
                                break block115;
                            }
                            if (this.getFullImportOnExecute()) {
                                historyDbConn.clearAllRecords(id);
                            }
                            config = this.makeLocalConfig(historyDbConn.getHistory(id).getConfig());
                            historyDbConn.reconfigureHistory(config);
                            history = historyDbConn.getHistory(id);
                            if (history == null) {
                                throw new HistoryNotFoundException();
                            }
                            lastTimestamp = historyDbConn.getLastTimestamp(history);
                            if (!timestampColExists) break block116;
                            if (lastTimestamp != null && !this.getFullImportOnExecute()) {
                                query.append(" WHERE (" + timestampCol + " > ?)");
                                if (predicateExists) {
                                    query.append(" AND (" + additionalPredicate + ")");
                                }
                                break block117;
                            } else if (predicateExists) {
                                query.append(" WHERE " + additionalPredicate);
                            }
                            break block117;
                        }
                        if (predicateExists) {
                            query.append(" WHERE " + additionalPredicate);
                        }
                    }
                    String sqlQuery = query.toString();
                    if (this.db.getLogger().isLoggable(Level.FINE)) {
                        this.db.getLogger().fine("Issuing the following SQL query to import data for history: " + id);
                        this.db.getLogger().fine("    " + sqlQuery);
                    }
                    ps = this.connection.prepareStatement(sqlQuery);
                    if (timestampColExists && lastTimestamp != null && !this.getFullImportOnExecute()) {
                        if (!this.timestampColumnTypeInitialized) {
                            ResultSet columnRs = this.connection.getMetaData().getColumns(null, null, this.getRdbTableName(), this.getTimestampColumn().getColumn().getTag());
                            if (!columnRs.next()) throw new Exception("Unable to determine timestamp column type");
                            this.timestampColumnType = columnRs.getInt("DATA_TYPE");
                        }
                        if (this.timestampColumnType == 93) {
                            ps.setTimestamp(1, new Timestamp(lastTimestamp.getMillis()), importCalender);
                        } else {
                            ps.setLong(1, lastTimestamp.getMillis());
                        }
                    }
                    rs = ps.executeQuery();
                }
                recordType = config.getRecordType();
                String recTypeName = recordType.getTypeName();
                BHistoryRecord rec = config.makeRecord();
                boolean firstAppend = true;
                BAbsTime duplicateTimestamp = null;
                while (rs.next()) {
                    BAbsTime tstamp = null;
                    if (timestampColExists) {
                        Timestamp ts = null;
                        long millis = -1L;
                        try {
                            ts = rs.getTimestamp(2, importCalender);
                            if (ts == null) continue;
                            millis = ts.getTime();
                        }
                        catch (Exception ex) {
                            millis = rs.getLong(2);
                        }
                        tstamp = BAbsTime.make((long)millis);
                    } else {
                        tstamp = BAbsTime.now();
                    }
                    BStatus status = BStatus.ok;
                    if (statusColExists) {
                        status = BStatus.make((int)rs.getInt(this.getStatusColumn().getColumn().getTag()));
                    }
                    if (!firstAppend && rec.getTimestamp().equals((Object)tstamp)) {
                        duplicateTimestamp = tstamp;
                        continue;
                    }
                    if (recTypeName.equals("NumericTrendRecord")) {
                        double val = rs.getDouble(1);
                        historyDbConn.append(history, (BIHistoryRecordSet)((BNumericTrendRecord)rec).set(tstamp, val, status));
                    } else if (recTypeName.equals("BooleanTrendRecord")) {
                        boolean val = rs.getBoolean(1);
                        historyDbConn.append(history, (BIHistoryRecordSet)((BBooleanTrendRecord)rec).set(tstamp, val, status));
                    } else if (recTypeName.equals("StringTrendRecord")) {
                        String val = rs.getString(1);
                        historyDbConn.append(history, (BIHistoryRecordSet)((BStringTrendRecord)rec).set(tstamp, val, status));
                    }
                    firstAppend = false;
                }
                if (duplicateTimestamp != null) {
                    this.executeFail(lex.getText("import.error.duplicateTimestamp", new Object[]{duplicateTimestamp}));
                    return;
                }
                this.executeOk();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.executeFail(e);
            return;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected final IFuture postExecute(Action action, BValue arg, Context cx) {
        BRdbms db = (BRdbms)this.getDevice();
        if (db != null) {
            db.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    private boolean columnExists(Connection conn, String tableName, String columnName) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        ResultSet rs = metadata.getColumns(null, null, tableName, columnName);
        boolean columnExists = rs.next();
        rs.close();
        return columnExists;
    }

    private BTimeZone getImportTimeZone() throws SQLException {
        String tz;
        ResultSet results;
        String sql;
        String tzColumn;
        if (this.rdbmsContext.useUtcTimestamps()) {
            return BTimeZone.UTC;
        }
        String tableName = "'" + this.getRdbTableName() + "'";
        Statement stmt = this.connection.createStatement();
        BTimeZone timezone = BTimeZone.getLocal();
        boolean tzFound = false;
        if (this.dialect.tableExists(this.db, this.connection, HISTORY_CONFIG_TABLE)) {
            try {
                String string = this.columnExists(this.connection, HISTORY_CONFIG_TABLE, DB_TIMEZONE_COLUMN) ? DB_TIMEZONE_COLUMN : (tzColumn = this.devicelet.getUseHistoryConfigTimeZone() && this.columnExists(this.connection, HISTORY_CONFIG_TABLE, TIMEZONE_COLUMN) ? TIMEZONE_COLUMN : null);
                if (tzColumn != null) {
                    sql = "SELECT " + tzColumn + " FROM " + HISTORY_CONFIG_TABLE + " WHERE TABLE_NAME = " + tableName;
                    results = stmt.executeQuery(sql);
                    if (results.next()) {
                        tz = results.getString(tzColumn);
                        tz = tz.substring(0, tz.indexOf("(")).trim();
                        timezone = BTimeZone.getTimeZone((String)tz);
                        tzFound = true;
                    }
                    results.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!tzFound && this.dialect.tableExists(this.db, this.connection, HISTORY_TYPE_MAP_TABLE)) {
            try {
                String string = this.columnExists(this.connection, HISTORY_TYPE_MAP_TABLE, DB_TIMEZONE_COLUMN) ? DB_TIMEZONE_COLUMN : (tzColumn = this.devicelet.getUseHistoryConfigTimeZone() && this.columnExists(this.connection, HISTORY_TYPE_MAP_TABLE, TIMEZONE_COLUMN) ? TIMEZONE_COLUMN : null);
                if (tzColumn != null) {
                    sql = "SELECT " + tzColumn + " FROM " + HISTORY_TYPE_MAP_TABLE + " WHERE TABLE_NAME = " + tableName;
                    results = stmt.executeQuery(sql);
                    if (results.next()) {
                        tz = results.getString(tzColumn);
                        tz = tz.substring(0, tz.indexOf("(")).trim();
                        timezone = BTimeZone.getTimeZone((String)tz);
                    }
                    results.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stmt.close();
        return timezone;
    }

    private BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }

    private BHistoryConfig makeLocalRdbConfig(BHistoryId id, BTypeSpec recordType) {
        BHistoryConfig result = new BHistoryConfig(id, recordType);
        result.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        result.setSourceHandle(this.getHandleOrd());
        result.setTimeZone(BTimeZone.getLocal());
        return result;
    }

    private static BTypeSpec getRecordType(ResultSetMetaData rsmd, int column) throws SQLException {
        if (rsmd == null) {
            return null;
        }
        int columnType = rsmd.getColumnType(column);
        BTypeSpec recordType = null;
        switch (columnType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                recordType = BNumericTrendRecord.TYPE.getTypeSpec();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                recordType = BStringTrendRecord.TYPE.getTypeSpec();
                break;
            }
            case -7: 
            case 16: {
                recordType = BBooleanTrendRecord.TYPE.getTypeSpec();
            }
        }
        return recordType;
    }

    private static String getColumnIdentifier(String schemaName, String tableName, String columnName, RdbmsContext rCx) {
        if (rCx instanceof RdbmsDialect) {
            return ((RdbmsDialect)rCx).getColumnIdentifier(schemaName, tableName, columnName);
        }
        if (schemaName != null && schemaName.length() > 0) {
            return schemaName + "." + tableName + ".\"" + columnName + "\"";
        }
        return tableName + ".\"" + columnName + "\"";
    }

    private static String getTableIdentifier(String schemaName, String tableName, RdbmsContext rCx) {
        if (rCx instanceof RdbmsDialect) {
            return ((RdbmsDialect)rCx).getTableIdentifier(schemaName, tableName);
        }
        if (schemaName != null && schemaName.length() > 0) {
            return schemaName + "." + tableName;
        }
        return tableName;
    }
}

