/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import java.util.logging.Logger;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.DdlCommand;

public class CreateIndex
implements DdlCommand {
    private final String indexName;
    private final String tableName;
    private final boolean isUnique;
    private final BClustered clustered;
    private final Column[] columns;

    public CreateIndex(String indexName, String tableName, boolean isUnique, Column[] columns) {
        this(indexName, tableName, isUnique, BClustered.unspecified, columns);
    }

    public CreateIndex(String indexName, String tableName, boolean isUnique, BClustered clustered, Column[] columns) {
        this.indexName = indexName;
        this.tableName = tableName;
        this.isUnique = isUnique;
        this.clustered = clustered;
        this.columns = columns;
    }

    public CreateIndex(String indexName, String tableName, boolean isUnique, String[] columnNames) {
        this(indexName, tableName, isUnique, CreateIndex.makeColumns(columnNames));
    }

    public CreateIndex(String indexName, String tableName, boolean isUnique, BClustered clustered, String[] columnNames) {
        this(indexName, tableName, isUnique, clustered, CreateIndex.makeColumns(columnNames));
    }

    private static Column[] makeColumns(String[] columnNames) {
        Column[] columns = new Column[columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new Column(columnNames[i]);
        }
        return columns;
    }

    @Override
    public String getDdl(RdbmsContext context) {
        RdbmsDialect dialect = (RdbmsDialect)context;
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        if (this.isUnique) {
            sql.append("UNIQUE ");
        }
        sql.append(CreateIndex.clusteredDdl(dialect, this.tableName, this.clustered));
        sql.append("INDEX ").append(this.indexName);
        sql.append(" ON ").append(this.tableName);
        sql.append("(");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[i].getName());
            if (!this.columns[i].isDescending()) continue;
            sql.append(" DESC");
        }
        sql.append(")");
        return sql.toString();
    }

    static String clusteredDdl(RdbmsDialect dialect, String tableName, BClustered clustered) {
        if (!clustered.equals((Object)BClustered.unspecified) && !dialect.supportsClusteredIndex()) {
            Logger.getLogger("rdb.jdbc").warning(dialect.getClass().getName() + " does not support clustered indexes. Table " + tableName + " will not have clustering specified.");
            return "";
        }
        switch (clustered.getOrdinal()) {
            case 0: {
                return "";
            }
            case 1: {
                return "CLUSTERED ";
            }
            case 2: {
                return "NONCLUSTERED ";
            }
        }
        throw new IllegalStateException();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public BClustered isClustered() {
        return this.clustered;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public static class Column {
        private final String name;
        private final boolean descending;

        public Column(String name) {
            this(name, false);
        }

        public Column(String name, boolean descending) {
            this.name = name;
            this.descending = descending;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDescending() {
            return this.descending;
        }
    }
}

