/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BFixedWidthTranslator;
import javax.baja.rdb.RdbmsContext;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;

public class Column {
    private static final int IDENTITY = 1;
    private static final int KEY = 2;
    private static final int UNIQUE = 4;
    private static final int CLOB = 8;
    private final String name;
    private final Type type;
    private final BValue defaultValue;
    private final int width;
    private final int flags;

    public static Column makeIdentity(String name, boolean isKey) {
        return new Column(name, BInteger.TYPE, (BValue)BInteger.DEFAULT, -1, isKey ? 3 : 1);
    }

    public static Column makeKey(String name, Type type, BValue defaultValue) {
        return new Column(name, type, defaultValue, -1, 2);
    }

    public static Column makeKey(String name, Type type, BValue defaultValue, int width) {
        return new Column(name, type, defaultValue, width, 2);
    }

    public static Column makeUnique(String name, Type type, BValue defaultValue) {
        return new Column(name, type, defaultValue, -1, 4);
    }

    public static Column makeUnique(String name, Type type, BValue defaultValue, int width) {
        return new Column(name, type, defaultValue, width, 4);
    }

    public static Column makeClob(String name) {
        return new Column(name, BString.TYPE, (BValue)BString.DEFAULT, -1, 8);
    }

    public static Column make(String name, Type type, BValue defaultValue) {
        return new Column(name, type, defaultValue, -1, 0);
    }

    public static Column make(String name, Type type, BValue defaultValue, int width) {
        return new Column(name, type, defaultValue, width, 0);
    }

    public static Column make(String name, Type type, BValue defaultValue, int width, int flags) {
        return new Column(name, type, defaultValue, width, flags);
    }

    private Column(String name, Type type, BValue defaultValue, int width, int flags) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.width = width;
        this.flags = flags;
    }

    public String getDdl(RdbmsContext context) {
        return this.getDdl(context, false);
    }

    public String getDdl(RdbmsContext context, boolean alteration) {
        RdbmsDialect dialect = (RdbmsDialect)context;
        StringBuffer sql = new StringBuffer();
        sql.append(this.getName()).append(" ");
        if (alteration && dialect.getAlterColumnSuffix() != null) {
            sql.append(dialect.getAlterColumnSuffix()).append(" ");
        }
        sql.append(this.makeTypeDdl(dialect));
        if (this.isIdentity()) {
            if (dialect.getInsertionMode() != 0 && !alteration) {
                sql.append(" ").append(dialect.getIdentityCreation());
            }
            if (!alteration || dialect.getAlterColumnSupportsNotNull()) {
                sql.append(" NOT NULL");
            }
        } else if ((this.isKey() || this.isUnique()) && (!alteration || dialect.getAlterColumnSupportsNotNull())) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    private String makeTypeDdl(RdbmsDialect dialect) {
        BColumnTranslator translator = BColumnTranslator.makeTranslator(dialect, this.defaultValue);
        switch (translator.getSqlType().getOrdinal()) {
            case 0: {
                this.checkNoWidth();
                return dialect.getIntType();
            }
            case 1: {
                this.checkNoWidth();
                return dialect.getLongType();
            }
            case 2: {
                this.checkNoWidth();
                return dialect.getFloatType();
            }
            case 3: {
                this.checkNoWidth();
                return dialect.getDoubleType();
            }
            case 9: {
                this.checkNoWidth();
                return dialect.getUuidType();
            }
            case 10: {
                this.checkNoWidth();
                return dialect.getBlobType();
            }
            case 4: {
                this.checkNoWidth();
                return dialect.supportsBooleanType() ? dialect.getBooleanType() : dialect.getCharType() + "(1)";
            }
            case 5: {
                this.checkNoWidth();
                return dialect.supportsMillisecondTimestamp() ? dialect.getTimestampType() : dialect.getLongType();
            }
            case 11: {
                this.checkNoWidth();
                return dialect.supportsDateType() ? dialect.getDateType() : dialect.getTimestampType();
            }
            case 6: {
                if (translator instanceof BFixedWidthTranslator) {
                    this.checkNoWidth();
                    return dialect.getCharType() + "(" + ((BFixedWidthTranslator)translator).getColumnWidth() + ")";
                }
                this.checkHasWidth();
                return dialect.getCharType() + "(" + this.width + ")";
            }
            case 7: {
                if (this.isClob()) {
                    this.checkNoWidth();
                    return dialect.getClobType();
                }
                this.checkHasWidth();
                return dialect.getVarCharType() + "(" + this.width + ")";
            }
        }
        throw new IllegalStateException();
    }

    private void checkNoWidth() {
        if (this.width != -1) {
            throw new BajaRuntimeException("Illegal WIDTH specification '" + this.width + "' for column  '" + this.name + "'");
        }
    }

    private void checkHasWidth() {
        if (this.width == -1) {
            throw new BajaRuntimeException("Missing WIDTH specification for column  '" + this.name + "'");
        }
    }

    public static boolean requiresWidth(RdbmsContext context, BValue defaultValue) {
        RdbmsDialect dialect = (RdbmsDialect)context;
        BColumnTranslator translator = BColumnTranslator.makeTranslator(dialect, defaultValue);
        switch (translator.getSqlType().getOrdinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 11: {
                return false;
            }
            case 6: {
                return !(translator instanceof BFixedWidthTranslator);
            }
            case 7: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public BValue getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isIdentity() {
        return (this.flags & 1) != 0;
    }

    public boolean isKey() {
        return (this.flags & 2) != 0;
    }

    public boolean isUnique() {
        return (this.flags & 4) != 0;
    }

    public boolean isClob() {
        return (this.flags & 8) != 0;
    }
}

