/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.rdb.fox.BSqlSchemeChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsFolder;
import javax.baja.status.BStatus;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRdbmsNetwork
extends BDeviceNetwork
implements BIService {
    public static final Type TYPE = Sys.loadType(BRdbmsNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    public static final Logger log = Logger.getLogger("rdb");

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BRdbms.TYPE;
    }

    public Type getDeviceFolderType() {
        return BRdbmsFolder.TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        if (this.isOperational()) {
            try {
                BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
                if (registry.get("sql") == null) {
                    registry.add("sql", (BValue)new BSqlSchemeChannel());
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to add BSqlSchemeChannel. " + e.getLocalizedMessage(), e);
            }
        }
    }

    public void serviceStopped() throws Exception {
        try {
            BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
            if (registry.get("sql") != null) {
                registry.remove("sql");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to remove BSqlSchemeChannel. " + e.getLocalizedMessage(), e);
        }
    }

    public final boolean isOperational() {
        BStatus status = this.getStatus();
        return !this.isFatalFault() && !status.isDisabled() && !status.isFault();
    }
}

