/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.jdbc.trans.BSqlType;
import com.tridium.rdb.util.BRdbmsUpdateJob;
import com.tridium.rdb.util.BRdbmsUpdater;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BUnicodeUpdateJob
extends BRdbmsUpdateJob {
    public static final Type TYPE = Sys.loadType(BUnicodeUpdateJob.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BUnicodeUpdateJob() {
    }

    public BUnicodeUpdateJob(BRdbmsUpdater updater) {
        super(updater);
    }

    @Override
    protected void updateTable(String tableName) throws SQLException {
        String sql;
        this.log().message("Updating table " + tableName);
        HashMap<String, String> indexToColumnMap = new HashMap<String, String>();
        this.log().message("Dropping indexes on columns");
        ResultSet rs = this.metadata.getIndexInfo(null, null, tableName, false, false);
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null || !indexName.startsWith("IDX_")) continue;
            indexToColumnMap.put(indexName, rs.getString("COLUMN_NAME"));
            String sql2 = this.dialect.makeDropIndexSql(indexName, tableName);
            this.statement.execute(sql2);
            this.log().message("Dropped index " + indexName + "on table " + tableName);
        }
        rs.close();
        this.log().message("Indexes on table " + tableName + " dropped");
        this.log().message("Updating VARCHAR columns to Unicode");
        rs = this.metadata.getColumns(null, null, tableName, null);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            String columnType = rs.getString("TYPE_NAME").toUpperCase();
            int columnWidth = rs.getInt("COLUMN_SIZE");
            if (!columnType.startsWith("VARCHAR")) continue;
            sql = this.dialect.makeAlterColumnTypeSql(tableName, columnName, BSqlType.sqlNVarchar, columnWidth);
            this.statement.execute(sql);
        }
        rs.close();
        this.log().message("Columns updated");
        this.log().message("Reconstructing indexes on " + tableName);
        Iterator it = indexToColumnMap.keySet().iterator();
        while (it.hasNext()) {
            String indexName = ((String)it.next()).toString();
            String columnName = ((String)indexToColumnMap.get(indexName)).toString();
            sql = "CREATE INDEX " + indexName + " ON " + tableName + "(" + columnName + ")";
            this.statement.execute(sql);
            this.log().message("Index " + indexName + " created on " + tableName + "." + columnName);
        }
        this.log().message("Indexes reconstructed");
        this.log().success("Updates to table " + tableName + " complete");
    }
}

