/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.io.IOException;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSimpleTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType(BSimpleTranslator.class);

    public BSimpleTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    @Override
    public BSqlType getSqlType() {
        return BSqlType.sqlVarchar;
    }

    @Override
    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        try {
            prep.setString(index, ((BSimple)value).encodeToString());
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        try {
            String str = rs.getString(index);
            if (str == null) {
                str = "";
            }
            return (BSimple)((BSimple)this.getValueType().getInstance()).decodeFromString(str);
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Type getType() {
        return TYPE;
    }
}

