/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.BRdbmsDiscoveredTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRdbmsDiscoverTablesJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BRdbmsDiscoverTablesJob.class);
    private static BIcon icon = BIcon.std((String)"find.png");
    private static String[] typeFilter = new String[]{"TABLE"};
    BRdbmsHistoryDeviceExt histDevExt;
    boolean discoverCanceled = false;

    public Type getType() {
        return TYPE;
    }

    public BRdbmsDiscoverTablesJob(BRdbmsHistoryDeviceExt histDevExt) {
        this.histDevExt = histDevExt;
    }

    public BRdbmsDiscoverTablesJob() {
    }

    public void doCancel(Context cx) {
        this.discoverCanceled = true;
        super.doCancel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.histDevExt == null) {
            throw new IllegalStateException("Must submit through RdbmsHistoryDeviceExt.submitRdbTableDiscoveryJob()");
        }
        if (this.discoverCanceled) {
            throw new JobCancelException();
        }
        this.progress(0);
        this.log().start("Rdb Table Discovery");
        this.removeAll();
        Connection con = null;
        ResultSet rs = null;
        try {
            BPassword password;
            BRdbms db = (BRdbms)this.histDevExt.getDevice();
            String userName = db.getUserName();
            if (userName == null) {
                userName = "";
            }
            if ((password = db.getPassword()) == null) {
                password = BPassword.DEFAULT;
            }
            con = db.getConnection(userName, password);
            this.log().message("  Finding catalogs...");
            DatabaseMetaData metaData = con.getMetaData();
            rs = metaData.getCatalogs();
            Vector<String> searchList = new Vector<String>();
            searchList.addElement("");
            while (rs.next()) {
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String catalog = rs.getString("TABLE_CAT");
                this.log().message("    Found catalog: " + catalog);
                if (catalog == null) continue;
                searchList.addElement(catalog);
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception catalog) {
                    // empty catch block
                }
            }
            this.progress(10);
            int numCatalogs = searchList.size();
            this.log().message("  Found " + (numCatalogs - 1) + " total catalogs.");
            this.log().message("  Finding tables in each catalog...");
            Vector<String> tableList = new Vector<String>();
            Vector<String> catalogList = new Vector<String>();
            Vector<String> schemaList = new Vector<String>();
            for (int i = 0; i < numCatalogs; ++i) {
                this.progress((int)((float)i / (float)numCatalogs * 20.0f) + 10);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String catalog = (String)searchList.elementAt(i);
                try {
                    rs = metaData.getTables(catalog, null, null, typeFilter);
                }
                catch (SQLException e) {
                    this.log().failed("    Encountered problem finding tables for catalog " + catalog, (Throwable)e);
                    if (rs == null) continue;
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                while (rs.next()) {
                    if (this.discoverCanceled) {
                        throw new JobCancelException();
                    }
                    String tableCatalog = rs.getString("TABLE_CAT");
                    if (catalog.isEmpty() && tableCatalog != null) continue;
                    String tableName = rs.getString("TABLE_NAME");
                    String tableSchema = rs.getString("TABLE_SCHEM");
                    catalogList.addElement(tableCatalog);
                    tableList.addElement(tableName);
                    schemaList.addElement(tableSchema);
                }
                if (rs == null) continue;
                try {
                    rs.close();
                    continue;
                }
                catch (Exception tableCatalog) {
                    // empty catch block
                }
            }
            this.progress(30);
            int numTables = tableList.size();
            this.log().message("  Found " + numTables + " total tables.");
            this.log().message("  Finding columns for each table...");
            for (int i = 0; i < numTables; ++i) {
                int numColumns;
                this.progress((int)((float)i / (float)numTables * 70.0f) + 30);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String tableName = (String)tableList.elementAt(i);
                if (tableName == null) continue;
                BRdbmsDiscoveredTable discovery = new BRdbmsDiscoveredTable(tableName);
                String catalog = (String)catalogList.elementAt(i);
                boolean nonNullCatalog = catalog instanceof String;
                discovery.setCatalogName(nonNullCatalog ? catalog : "");
                String schema = (String)schemaList.elementAt(i);
                boolean nonNullSchema = schema instanceof String;
                discovery.setSchemaName(nonNullSchema ? schema : "");
                try {
                    rs = metaData.getColumns(nonNullCatalog ? catalog : null, nonNullSchema ? schema : null, tableName, null);
                }
                catch (SQLException e) {
                    this.log().failed("    Encountered problem finding columns for table " + tableName + " (catalog=" + (nonNullCatalog ? catalog : "null") + ", schema=" + (nonNullSchema ? schema : "null") + ")", (Throwable)e);
                    if (rs == null) continue;
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Vector<String> columnList = new Vector<String>();
                while (rs.next()) {
                    if (this.discoverCanceled) {
                        throw new JobCancelException();
                    }
                    columnList.addElement(rs.getString("COLUMN_NAME"));
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((numColumns = columnList.size()) > 0) {
                    String[] colEnumTags = (String[])columnList.stream().distinct().map(SlotPath::escape).toArray(String[]::new);
                    try {
                        BEnumRange range = BEnumRange.make((String[])colEnumTags);
                        discovery.setTimestampColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                        discovery.setValueColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                        discovery.setStatusColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                    }
                    catch (Exception e) {
                        this.log().failed("    Error creating range from columns for table " + tableName, (Throwable)e);
                    }
                }
                this.add("s" + i, (BValue)discovery, 1);
            }
            this.progress(100);
            this.log().message("  Finished finding columns for each table.");
            this.log().success("Rdb Table Discovery complete (" + numTables + " tables found).");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

