/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.util;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.WriteDownLoadData;
import com.tridium.nrio.messages.WriteDownLoadStart;
import com.tridium.nrio.messages.WriteDownLoadStop;
import com.tridium.nrio.util.IntelHexFile;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.sys.Clock;

public class FirmwareUpgradeUtils
implements NrioMessageConst {
    public static boolean upgradeFirmware(BNrioNetwork accessNet, BNrioDevice device, BIFile downLoadFile, BJob job) {
        if (downLoadFile == null) {
            FirmwareUpgradeUtils.logMessage(accessNet, job, "downloadFile is null!!");
            return false;
        }
        FirmwareUpgradeUtils.logMessage(accessNet, job, " upgrading device: " + device.getDisplayName(null) + " with file " + downLoadFile.getFileName());
        IntelHexFile hexFile = IntelHexFile.make(downLoadFile);
        if (hexFile == null) {
            FirmwareUpgradeUtils.logMessage(accessNet, job, "hexFile is null!!!!!!!!!!!!!!!!!");
            return false;
        }
        Vector<IntelHexFile.MemoryBlock> v = hexFile.readMemoryBlocks();
        if (v == null) {
            FirmwareUpgradeUtils.logMessage(accessNet, job, "vector is null!!!!!!!!!!!!!!!!!");
            return false;
        }
        long startTicks = Clock.ticks();
        device.setInstalledVersion("upgrading");
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        WriteDownLoadStart message = new WriteDownLoadStart(device.getAddress());
        NrioMessage response = accessNet.sendDownLoadMessage(message, 0);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (response == null || response.getStatus() != 0) {
            FirmwareUpgradeUtils.logMessage(accessNet, job, "Aborting - start down load returned error!");
            device.setInstalledVersion("upgrade failed");
            return false;
        }
        boolean doesC000Exist = false;
        for (int i = 0; i < v.size(); ++i) {
            IntelHexFile.MemoryBlock memBlock = v.elementAt(i);
            if (memBlock.baseAddress < 49152 || memBlock.baseAddress >= 53248) continue;
            doesC000Exist = true;
            if (!FirmwareUpgradeUtils.writeMemoryBlock(accessNet, device.getAddress(), memBlock)) {
                FirmwareUpgradeUtils.logMessage(accessNet, job, " WriteDownLoad message returned error!!!");
                device.setInstalledVersion("upgrade failed");
                return false;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WriteDownLoadStop stopMsg = new WriteDownLoadStop(device.getAddress());
        response = accessNet.sendDownLoadMessage(stopMsg, 0);
        if (!doesC000Exist) {
            FirmwareUpgradeUtils.logMessage(accessNet, job, " Oxc000 block does not exist!!!");
            device.setInstalledVersion("upgrade failed");
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            IntelHexFile.MemoryBlock memBlock = v.elementAt(i);
            if (memBlock.baseAddress >= 49152 && memBlock.baseAddress < 53248) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FirmwareUpgradeUtils.writeMemoryBlock(accessNet, device.getAddress(), memBlock);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stopMsg = new WriteDownLoadStop(device.getAddress());
        response = accessNet.sendDownLoadMessage(stopMsg, 0);
        long loadTimeMillis = Clock.ticks() - startTicks;
        FirmwareUpgradeUtils.logMessage(accessNet, job, device.getDisplayName(null) + " - Download completed in " + loadTimeMillis + " milliseconds");
        device.setInstalledVersion("upgraded");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean writeMemoryBlock(BNrioNetwork accessNet, int address, IntelHexFile.MemoryBlock memBlock) {
        int offset;
        byte[] bytes = memBlock.out.toByteArray();
        WriteDownLoadData message = new WriteDownLoadData(address, bytes, memBlock.baseAddress, offset);
        for (offset = 0; offset < bytes.length; offset += 64) {
            message.setOffset(offset);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NrioMessage response = accessNet.sendDownLoadMessage(message, 2);
            if (response != null && response.getStatus() == 0) continue;
            return false;
        }
        return true;
    }

    private static void logMessage(BNrioNetwork accessNet, BJob job, String message) {
        if (job != null) {
            job.log().message(message);
        }
        if (accessNet != null) {
            int severity = accessNet.getLog().getSeverity();
            accessNet.getLog().setSeverity(1);
            accessNet.getLog().message("Upgrade Firmware Job:" + message);
            accessNet.getLog().setSeverity(severity);
        }
    }
}

