/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import java.io.ByteArrayInputStream;

public class NrioInputStream
extends ByteArrayInputStream {
    public NrioInputStream(byte[] buf) {
        super(buf);
    }

    public NrioInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public int readInt() {
        int value = this.read() & 0xFF;
        return value |= (this.read() & 0xFF) << 8;
    }

    public int readCount() {
        int value = this.read() & 0xFF;
        value <<= 8;
        return value |= this.read() & 0xFF;
    }

    public int readSdi() {
        int value = this.read() & 0xFF;
        return value |= (this.read() & 0xFF) << 8;
    }

    public int readInt(int numBytes) {
        int temp = this.read() & 0xFF;
        for (int i = 1; i < numBytes; ++i) {
            temp |= (this.read() & 0xFF) << 8;
        }
        return temp;
    }

    public long readLong() {
        long temp = (long)this.readWord() & 0xFFFFL;
        return temp | ((long)this.readWord() & 0xFFFFL) << 16;
    }

    public int readWord() {
        int temp = this.read() & 0xFF;
        return temp | (this.read() & 0xFF) << 8;
    }

    public byte[] readBytes(int numBytes) {
        byte[] bytes = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            bytes[i] = (byte)(this.read() & 0xFF);
        }
        return bytes;
    }
}

