/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.job;

import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.util.FirmwareUpgradeUtils;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BUpgradeFirmwareJob
extends BSimpleJob
implements NrioMessageConst {
    public static final Type TYPE = Sys.loadType(BUpgradeFirmwareJob.class);
    private static boolean isRunning = false;
    final BNrioNetwork accessNet;
    public static Logger logger = Logger.getLogger("nrio.upgradeFirmware");

    public Type getType() {
        return TYPE;
    }

    public BUpgradeFirmwareJob() {
        this.accessNet = null;
    }

    public BUpgradeFirmwareJob(BNrioNetwork net) {
        this.accessNet = net;
    }

    public void run(Context cx) throws Exception {
        if (isRunning) {
            throw new IllegalStateException("FirmwareUpgrade already running could not start!!!");
        }
        isRunning = true;
        this.logMessage("starting...");
        boolean downLoadError = false;
        BDevice[] devices = this.accessNet.getDevices();
        try {
            int i;
            this.accessNet.setDownLoadInProcess(true);
            this.logMessage("Wait 15 seconds to allow all devices to go 0ffline");
            for (i = 1; i <= 15; ++i) {
                this.progress(i);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < devices.length; ++i) {
                if (!(devices[i] instanceof BNrioDevice) || devices[i].isDown()) continue;
                BNrioDevice device = (BNrioDevice)devices[i];
                if (!this.upgradeFirmware(device)) {
                    downLoadError = true;
                }
                if (device instanceof BNrio34Module && !this.upgradeFirmware(((BNrio34Module)device).getIo34Sec())) {
                    downLoadError = true;
                }
                this.progress(15 + (i + 1) * 85 / devices.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.accessNet.setDownLoadInProcess(false);
        for (int i = 0; i < devices.length; ++i) {
            ((BNrioDevice)devices[i]).doPing();
            ((BNrioDevice)devices[i]).enablePolling();
        }
        isRunning = false;
        if (downLoadError) {
            throw new IllegalStateException("complete with errors");
        }
    }

    private boolean upgradeFirmware(BNrioDevice device) {
        boolean forceUpgrade = false;
        if (!forceUpgrade && device.getInstalledVersion().equals(device.getAvailableVersion())) {
            this.logMessage(" device " + device.getDisplayName(null) + " is up to date");
            return true;
        }
        BIFile downLoadFile = this.accessNet.getFirmwareFile(device.getDeviceType());
        if (downLoadFile == null) {
            this.logMessage("downloadFile is null!!");
            return false;
        }
        return FirmwareUpgradeUtils.upgradeFirmware(this.accessNet, device, downLoadFile, (BJob)this);
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.accessNet != null) {
            int severity = this.accessNet.getLog().getSeverity();
            this.accessNet.getLog().setSeverity(1);
            this.accessNet.getLog().message("Upgrade Firmware Job:" + message);
            this.accessNet.getLog().setSeverity(severity);
        }
    }
}

