/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.components;

import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BUiProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BUIPointEntry
extends BComponent {
    public static final Property ioType = BUIPointEntry.newProperty((int)0, (BValue)BNrioIoTypeEnum.digitalInput, null);
    public static final Property uiType = BUIPointEntry.newProperty((int)0, (BValue)BUniversalInputTypeEnum.undefined, null);
    public static final Property instance = BUIPointEntry.newProperty((int)0, (int)0, null);
    public static final Property usedByPoint = BUIPointEntry.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BUIPointEntry.class);

    public BNrioIoTypeEnum getIoType() {
        return (BNrioIoTypeEnum)this.get(ioType);
    }

    public void setIoType(BNrioIoTypeEnum v) {
        this.set(ioType, (BValue)v, null);
    }

    public BUniversalInputTypeEnum getUiType() {
        return (BUniversalInputTypeEnum)this.get(uiType);
    }

    public void setUiType(BUniversalInputTypeEnum v) {
        this.set(uiType, (BValue)v, null);
    }

    public int getInstance() {
        return this.getInt(instance);
    }

    public void setInstance(int v) {
        this.setInt(instance, v, null);
    }

    public String getUsedByPoint() {
        return this.getString(usedByPoint);
    }

    public void setUsedByPoint(String v) {
        this.setString(usedByPoint, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BUIPointEntry(BNrioIoTypeEnum type, int instance) {
        this.setIoType(type);
        this.setInstance(instance);
    }

    public BUIPointEntry() {
    }

    public boolean matches(BComponent point) {
        if (!(point instanceof BControlPoint)) {
            return false;
        }
        BControlPoint cp = (BControlPoint)point;
        BAbstractProxyExt proxy = cp.getProxyExt();
        if (!(proxy instanceof BNrio16ProxyExt)) {
            return false;
        }
        if (!((BNrio16ProxyExt)proxy).getEnabled()) {
            return false;
        }
        int proxInstance = ((BNrio16ProxyExt)proxy).getInstance();
        if (this.getInstance() != proxInstance) {
            return false;
        }
        if (cp instanceof BBooleanWritable) {
            return this.getIoType().equals((Object)BNrioIoTypeEnum.relayOutput);
        }
        if (cp instanceof BBooleanPoint) {
            return this.getIoType().equals((Object)BNrioIoTypeEnum.universalInput);
        }
        if (cp instanceof BNumericWritable) {
            return this.getIoType().equals((Object)BNrioIoTypeEnum.analogOutput);
        }
        if (cp instanceof BNumericPoint) {
            return this.getIoType().equals((Object)BNrioIoTypeEnum.universalInput);
        }
        return false;
    }

    public boolean isMatchable(BComponent point) {
        if (!(point instanceof BControlPoint)) {
            return false;
        }
        BControlPoint cp = (BControlPoint)point;
        BAbstractProxyExt proxy = cp.getProxyExt();
        if (!(proxy instanceof BUiProxyExt)) {
            return false;
        }
        int proxInstance = ((BUiProxyExt)proxy).getInstance();
        if (proxInstance != 0) {
            return false;
        }
        if (cp instanceof BBooleanWritable) {
            return this.getIoType().equals((Object)BNrioIoTypeEnum.relayOutput);
        }
        return this.getIoType().equals((Object)BNrioIoTypeEnum.digitalInput) && cp instanceof BBooleanPoint;
    }
}

