/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.components;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BNrioLearnDeviceEntry
extends BComponent
implements Runnable {
    public static final Property address = BNrioLearnDeviceEntry.newProperty((int)0, (int)0, null);
    public static final Property uid = BNrioLearnDeviceEntry.newProperty((int)0, (BValue)BBlob.DEFAULT, null);
    public static final Property deviceType = BNrioLearnDeviceEntry.newProperty((int)0, (BValue)BNrioDeviceTypeEnum.none, null);
    public static final Property version = BNrioLearnDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property usedBy = BNrioLearnDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property secAddr = BNrioLearnDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNrioLearnDeviceEntry.class);
    public static Lexicon lex = Lexicon.make(BNrioLearnDeviceEntry.class);
    private static final int WINK_COUNT = 20;
    private static final long WINK_CYCLE = 500L;
    private BNrioNetwork network;
    private Thread winkThread;
    private static boolean winkActive = false;
    private int winkValue = 0;

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    public BBlob getUid() {
        return (BBlob)this.get(uid);
    }

    public void setUid(BBlob v) {
        this.set(uid, (BValue)v, null);
    }

    public BNrioDeviceTypeEnum getDeviceType() {
        return (BNrioDeviceTypeEnum)this.get(deviceType);
    }

    public void setDeviceType(BNrioDeviceTypeEnum v) {
        this.set(deviceType, (BValue)v, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    public String getUsedBy() {
        return this.getString(usedBy);
    }

    public void setUsedBy(String v) {
        this.setString(usedBy, v, null);
    }

    public String getSecAddr() {
        return this.getString(secAddr);
    }

    public void setSecAddr(String v) {
        this.setString(secAddr, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy, int secAddr) {
        this.setAddress(address);
        this.setDeviceType(type);
        this.setUid(BBlob.make((byte[])uid));
        this.setVersion(version);
        this.setUsedBy(usedBy);
        if (secAddr > 0) {
            this.setSecAddr(Integer.toString(secAddr));
        }
    }

    public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy) {
        this.setAddress(address);
        this.setDeviceType(type);
        this.setUid(BBlob.make((byte[])uid));
        this.setVersion(version);
        this.setUsedBy(usedBy);
    }

    public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid) {
        this.setAddress(address);
        this.setDeviceType(type);
        this.setUid(BBlob.make((byte[])uid));
    }

    public BNrioLearnDeviceEntry() {
    }

    public String getDefaultAddAddress() {
        switch (this.getDeviceType().getOrdinal()) {
            case 4: {
                return this.getDeviceType().getTag() + "_" + this.getAddress();
            }
            case 6: {
                return this.getDeviceType().getTag() + "_" + this.getAddress() + "_" + this.getSecAddr();
            }
        }
        return this.getDeviceType().getTag() + "_" + this.getAddress();
    }

    public boolean isMatchable(BComponent device) {
        if (!(device instanceof BNrioDevice)) {
            return false;
        }
        BNrioDevice dbDevice = (BNrioDevice)device;
        if (!dbDevice.getDeviceType().isMatchable(this.getDeviceType())) {
            return false;
        }
        return dbDevice.isDown() || dbDevice.getAddress() == 0;
    }

    public int getSecAddrInt() {
        String secAddr = this.getSecAddr();
        int addr = -1;
        try {
            addr = Integer.parseInt(secAddr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addr;
    }

    public boolean isWinkActive() {
        return winkActive;
    }

    public void doWinkDevice(BNrioNetwork network, BBoolean value) {
        this.network = network;
        if (!winkActive) {
            this.winkThread = new Thread(this);
            this.winkValue = 1;
            winkActive = true;
            network.enableWinking(this);
            this.winkThread.start();
            this.setUsedBy(lex.get("winking"));
        } else {
            winkActive = false;
            network.disableWinking(this);
            this.setUsedBy("");
        }
    }

    public void stopWink() {
        if (winkActive) {
            this.network.disableWinking(this);
        }
        winkActive = false;
        if (this.getUsedBy().equals(lex.get("winking"))) {
            this.setUsedBy("");
        }
    }

    @Override
    public void run() {
        int count = 0;
        while (winkActive) {
            this.winkValue = this.winkValue == 0 ? 1 : 0;
            this.network.winkDevice(BInteger.make((int)(this.getAddress() << 8 | this.winkValue)));
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            winkActive = ++count <= 20;
        }
        this.setUsedBy("");
        this.network.disableWinking(this);
    }
}

