/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.IoModuleIOStatus;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.WriteConfigMessage;
import com.tridium.nrio.messages.WriteDOMessage;
import com.tridium.nrio.points.BNrioIOPoints;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNrioInputOutputModule
extends BNrioDevice {
    public static final Property deviceType = BNrioInputOutputModule.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.remoteInputOutput, null);
    public static final Property points = BNrioInputOutputModule.newProperty((int)0, (BValue)new BNrioIOPoints(), null);
    public static final Action writeConfig = BNrioInputOutputModule.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNrioInputOutputModule.class);
    private int wrDoValue = 0;
    private int lastWriteValue = 0;
    private static byte[] NO_DATA = new byte[0];

    @Override
    public BNrioPointDeviceExt getPoints() {
        return (BNrioPointDeviceExt)this.get(points);
    }

    @Override
    public void setPoints(BNrioPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public void writeConfig() {
        this.invoke(writeConfig, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(status) && (this.isDown() || this.isDisabled())) {
            this.lastWriteValue = 0;
        }
    }

    public void doWriteConfig() {
        this.sendWriteConfig();
    }

    @Override
    public int sendWriteConfig() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        WriteConfigMessage cReq = new WriteConfigMessage(this.getAddress(), 0);
        NrioMessage cRsp = network.sendNrioMessage(cReq);
        return cRsp.getStatus();
    }

    @Override
    public int setDoValue(boolean value, int instance) {
        int mask = 128 << instance;
        this.setWrDoValue(value, mask);
        return 0;
    }

    public synchronized void setWrDoValue(boolean value, int mask) {
        this.wrDoValue = value ? (this.wrDoValue |= mask) : (this.wrDoValue &= ~mask);
        ((BNrioNetwork)this.getNetwork()).interruptWriteThread();
    }

    @Override
    public int doWriteDoValues() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        int thisWrite = this.wrDoValue;
        if (thisWrite != this.lastWriteValue) {
            WriteDOMessage req = new WriteDOMessage(this.getAddress(), thisWrite);
            NrioMessage rsp = network.sendNrioMessage(req);
            if (rsp != null && rsp.getStatus() == 0) {
                if (!this.getFirstPing()) {
                    this.pingOk();
                }
                this.lastWriteValue = thisWrite;
            }
            return rsp.getStatus();
        }
        return 0;
    }

    @Override
    public void doDumpIoMap() {
        int i;
        BOrd[] map = this.getUsedDiArray();
        System.out.println("Digital input use map:");
        for (i = 0; i < map.length; ++i) {
            System.out.println("   di" + (i + 1) + " used = " + map[i]);
        }
        map = this.getUsedRelayArray();
        System.out.println("Relay output use map:");
        for (i = 0; i < map.length; ++i) {
            System.out.println("   ro" + (i + 1) + " used = " + map[i]);
        }
        map = this.getUsedSdiArray();
        System.out.println("Sdi use map:");
        for (i = 0; i < map.length; ++i) {
            System.out.println("   sdi" + (i + 1) + " used = " + map[i]);
        }
    }

    @Override
    public BOrd[] getUsedRelayArray() {
        return this.getUsedRelayArray(8);
    }

    @Override
    public BOrd[] getUsedDiArray() {
        return this.getUsedDiArray(2);
    }

    @Override
    public BOrd[] getUsedSdiArray() {
        return this.getUsedSdiArray(8);
    }

    @Override
    public void updateProxyValues() {
        byte[] statusBytes = ((BIoStatus)this.getIoStatus()).copyBytes();
        if (statusBytes.length < 12) {
            return;
        }
        NrioMessage statusMsg = new NrioMessage();
        statusMsg.decodeFromBytes(statusBytes, statusBytes.length);
        ((BNrioIOPoints)this.getPoints()).setIoStatus(new IoModuleIOStatus(statusMsg.getData()));
    }
}

