/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.nrio.BNrioDeviceFolder;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.ClearInfoMemoryMessage;
import com.tridium.nrio.messages.NrioDeviceIoStatus;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.PingResponse;
import com.tridium.nrio.messages.ReadInfoMemoryMessage;
import com.tridium.nrio.messages.SetLogicalAddressMessage;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridium.nrio.points.BNrioProxyExt;
import com.tridium.nrio.util.DualModuleUtils;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.point.BProxyExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BNrioDevice
extends BBasicDevice {
    static byte[] defaultUid = new byte[]{0, 0, 0, 0, 0, 0};
    public static final Action download = BNrioDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Action upload = BNrioDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Property address = BNrioDevice.newProperty((int)65, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)16));
    public static final Property deviceType = BNrioDevice.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.none, null);
    public static final Property uid = BNrioDevice.newProperty((int)65, (BValue)BBlob.make((byte[])defaultUid), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"nrio:FlexBlobFE")));
    public static final Property installedVersion = BNrioDevice.newProperty((int)65, (String)"", null);
    public static final Property availableVersion = BNrioDevice.newProperty((int)1, (String)"", null);
    public static final Property winkOutput = BNrioDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)8));
    public static final Property winkDuration = BNrioDevice.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)60), (String)"min", (BIDataValue)BRelTime.makeSeconds((int)5)));
    public static final Property points = BNrioDevice.newProperty((int)0, (BValue)new BNrioPointDeviceExt(), null);
    public static final Property ioStatus = BNrioDevice.newProperty((int)65, (BValue)new BIoStatus(), null);
    public static final Action winkDevice = BNrioDevice.newAction((int)0, null);
    public static final Action winkTimeout = BNrioDevice.newAction((int)4, null);
    public static final Action winkCancel = BNrioDevice.newAction((int)4, null);
    public static final Action enablePolling = BNrioDevice.newAction((int)4, null);
    public static final Action disablePolling = BNrioDevice.newAction((int)4, null);
    public static final Action setPingOk = BNrioDevice.newAction((int)4, null);
    public static final Action setAddressAndPing = BNrioDevice.newAction((int)20, null);
    public static final Action dumpIoMap = BNrioDevice.newAction((int)4, null);
    public static final Action readInfoMemory = BNrioDevice.newAction((int)20, null);
    public static final Action clearInfoMemory = BNrioDevice.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BNrioDevice.class);
    public static final Log pingFailLog = Log.getLog((String)"nrio.pingFail");
    private boolean pingOkFlag = true;
    private boolean winkActive = false;
    private Clock.Ticket winkDurationTicket;
    private boolean winkOutState = false;
    private Clock.Ticket winkTicket;
    private NrioMessage statusMessage = new NrioMessage();
    private NrioDeviceIoStatus lastIoStatus = new NrioDeviceIoStatus();
    private BNrioNetwork accessNet;
    private boolean isPollingActive = false;
    public boolean firstPing = true;
    public int pingFailCount = 0;

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    public BNrioDeviceTypeEnum getDeviceType() {
        return (BNrioDeviceTypeEnum)this.get(deviceType);
    }

    public void setDeviceType(BNrioDeviceTypeEnum v) {
        this.set(deviceType, (BValue)v, null);
    }

    public BBlob getUid() {
        return (BBlob)this.get(uid);
    }

    public void setUid(BBlob v) {
        this.set(uid, (BValue)v, null);
    }

    public String getInstalledVersion() {
        return this.getString(installedVersion);
    }

    public void setInstalledVersion(String v) {
        this.setString(installedVersion, v, null);
    }

    public String getAvailableVersion() {
        return this.getString(availableVersion);
    }

    public void setAvailableVersion(String v) {
        this.setString(availableVersion, v, null);
    }

    public int getWinkOutput() {
        return this.getInt(winkOutput);
    }

    public void setWinkOutput(int v) {
        this.setInt(winkOutput, v, null);
    }

    public BRelTime getWinkDuration() {
        return (BRelTime)this.get(winkDuration);
    }

    public void setWinkDuration(BRelTime v) {
        this.set(winkDuration, (BValue)v, null);
    }

    public BNrioPointDeviceExt getPoints() {
        return (BNrioPointDeviceExt)this.get(points);
    }

    public void setPoints(BNrioPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BStruct getIoStatus() {
        return (BStruct)this.get(ioStatus);
    }

    public void setIoStatus(BStruct v) {
        this.set(ioStatus, (BValue)v, null);
    }

    public void winkDevice() {
        this.invoke(winkDevice, null, null);
    }

    public void winkTimeout() {
        this.invoke(winkTimeout, null, null);
    }

    public void winkCancel() {
        this.invoke(winkCancel, null, null);
    }

    public void enablePolling() {
        this.invoke(enablePolling, null, null);
    }

    public void disablePolling() {
        this.invoke(disablePolling, null, null);
    }

    public void setPingOk() {
        this.invoke(setPingOk, null, null);
    }

    public void setAddressAndPing() {
        this.invoke(setAddressAndPing, null, null);
    }

    public void dumpIoMap() {
        this.invoke(dumpIoMap, null, null);
    }

    public BComponent readInfoMemory() {
        return (BComponent)this.invoke(readInfoMemory, null, null);
    }

    public void clearInfoMemory() {
        this.invoke(clearInfoMemory, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BNrioDeviceTypeEnum type = this.getDeviceType();
        this.accessNet = (BNrioNetwork)this.getNetwork();
        try {
            if (type.equals((Object)BNrioDeviceTypeEnum.remoteReader)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2030")).getString());
            } else if (type.equals((Object)BNrioDeviceTypeEnum.remoteInputOutput)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2034")).getString());
            } else if (type.equals((Object)BNrioDeviceTypeEnum.baseBoardReader)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2029")).getString());
            } else if (type.equals((Object)BNrioDeviceTypeEnum.io16)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2041")).getString());
            } else if (type.equals((Object)BNrioDeviceTypeEnum.io16V1)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2101")).getString());
            } else {
                this.setAvailableVersion("");
            }
        }
        catch (Exception e) {
            this.setAvailableVersion("");
        }
        this.setIsRemote(!type.equals((Object)BNrioDeviceTypeEnum.baseBoardReader));
        this.setFlags((Slot)upload, this.getFlags((Slot)upload) | 4);
        this.setFlags((Slot)download, this.getFlags((Slot)download) | 4);
        if (this.isUidDefault()) {
            this.configFail("Invalid UID: Do Discover and Match.");
        } else {
            this.configOk();
        }
        this.accessNet.addDevice(this);
    }

    public void stopped() throws Exception {
        try {
            this.accessNet.removeDevice(this.getAddress());
            this.doDisablePolling();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isUidDefault() {
        byte[] currentUid = this.getUid().copyBytes();
        if (currentUid.length != defaultUid.length) {
            return false;
        }
        for (int i = 0; i < defaultUid.length; ++i) {
            if (currentUid[i] == defaultUid[i]) continue;
            return false;
        }
        return true;
    }

    public Type getNetworkType() {
        return BNrioNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNrioDeviceFolder || parent instanceof BNrioNetwork;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(status)) {
            if (this.getStatus().isDisabled() || this.getStatus().isDown()) {
                this.firstPing = true;
            } else if (this.firstPing) {
                this.ping();
            }
        } else if (p.equals(enabled)) {
            if (!this.getEnabled()) {
                this.disablePolling();
            } else {
                this.enablePolling();
                this.ping();
            }
        } else if (p.equals(uid) || p.equals(address)) {
            int address = this.getAddress();
            if (this.isUidDefault()) {
                this.configFail("Invalid UID: Do Discover and Match.");
            } else if (address <= 0 && address > 16) {
                this.configFail("Invalid Address: " + address);
            } else {
                this.configOk();
                this.accessNet.removeDevice(address);
                this.accessNet.addDevice(this);
            }
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(clearInfoMemory) || action.equals(setAddressAndPing) || action.equals(readInfoMemory)) {
            return this.postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    public boolean getFirstPing() {
        return this.firstPing;
    }

    public void setFirstPing(boolean firstPing) {
        this.firstPing = firstPing;
    }

    public void doPing() {
        boolean needsInitialized;
        boolean bl = needsInitialized = this.isDown() || this.firstPing;
        if (DualModuleUtils.sendPing(this) != 0) {
            return;
        }
        DualModuleUtils.processPostPing(this, needsInitialized);
    }

    public void readBuildInfo() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        network.getLog().trace(">>> BNrioDevice(" + this.getName() + ").readBuildInfo");
        String version = network.readBuildInfo(this.getAddress());
        network.getLog().trace(">>> BNrioDevice(" + this.getName() + ").device version =" + version);
        this.setInstalledVersion(version);
    }

    public boolean isFirmwareUptodate() {
        String availVersion = this.getAvailableVersion().trim();
        String installedVersion = this.getInstalledVersion();
        return availVersion.length() > 0 && installedVersion.equals(this.getAvailableVersion());
    }

    public void doEnablePolling() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        if (this.isFault() || this.isDisabled()) {
            this.isPollingActive = false;
            network.getLog().message(">>> BNrioDevice(" + this.getName() + ") polling is not enabled because of fault or disabled status");
        } else {
            if (!this.isPollingActive) {
                network.getLog().trace(">>> BNrioDevice(" + this.getName() + ") pollingEnabled");
            }
            network.enablePolling(this.getAddress());
            this.isPollingActive = true;
        }
    }

    public void doDisablePolling() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        network.getLog().trace(">>> BNrioDevice(" + this.getName() + ") pollingDisabled");
        network.disablePolling(this.getAddress());
        this.isPollingActive = false;
        this.firstPing = true;
    }

    public boolean incrementPingFailCount() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        int maxFails = network.getMaxFailsUntilDown();
        if (++this.pingFailCount > maxFails) {
            this.pingFailCount = maxFails;
        }
        pingFailLog.trace(this.getName() + ": pingFailCount = " + this.pingFailCount + ", maxFailCount = " + maxFails);
        return this.pingFailCount == maxFails;
    }

    public void clearPingFailCount() {
        this.pingFailCount = 0;
    }

    public void pingFail(String cause) {
        if (!this.getStatus().isDown()) {
            ((BNrioNetwork)this.getNetwork()).getLog().message(this.getAddress() + ": device down. Cause: " + cause);
        }
        this.pingOkFlag = false;
        this.firstPing = true;
        super.pingFail(cause);
    }

    public void pingOk() {
        if (!this.pingOkFlag) {
            this.pingOkFlag = true;
            ((BNrioNetwork)this.getNetwork()).getLog().message(this.getAddress() + ": device up. ");
        }
        this.clearPingFailCount();
        super.pingOk();
    }

    public void doDumpIoMap() {
    }

    public void doWinkDevice() {
        this.winkDurationTicket = this.setTimer(this.winkDurationTicket, this.getWinkDuration(), winkCancel);
        int winkOut = this.getWinkOutput();
        this.winkTicket = this.setTimer(this.winkTicket, BRelTime.makeSeconds((int)1), winkTimeout);
        this.setDoValue(true, winkOut);
        this.winkOutState = true;
        this.winkActive = true;
        this.setFlags((Slot)winkDevice, this.getFlags((Slot)winkDevice) | 4);
        this.setFlags((Slot)winkCancel, this.getFlags((Slot)winkCancel) & 0xFFFFFFFB);
    }

    public void doWinkTimeout() {
        if (this.winkActive) {
            this.setDoValue(!this.winkOutState, this.getWinkOutput());
            this.winkOutState = !this.winkOutState;
        }
    }

    public void doWinkCancel() {
        this.winkActive = false;
        this.cancelTimer(this.winkTicket);
        this.cancelTimer(this.winkDurationTicket);
        this.setDoValue(false, this.getWinkOutput());
        this.setFlags((Slot)winkDevice, this.getFlags((Slot)winkDevice) & 0xFFFFFFFB);
        this.setFlags((Slot)winkCancel, this.getFlags((Slot)winkCancel) | 4);
    }

    public void doSetPingOk() {
        this.pingOk();
    }

    public void initLastWrite() {
    }

    public boolean isDualModule() {
        return false;
    }

    public int doWriteDoValues() {
        return -1;
    }

    public int setDoValue(boolean value, int instance) {
        return -1;
    }

    public void processStatusMessage(NrioReceivedMessage statusMsg) {
    }

    public void updateProxyValues() {
    }

    public void setIsRemote(boolean value) {
    }

    public boolean getIsRemote() {
        return true;
    }

    public int sendWriteConfig() {
        return 0;
    }

    public int sendOutputConfig() {
        return 0;
    }

    public BControlPoint checkForProxyExtConflicts(BControlPoint sourcePoint) {
        if (!(sourcePoint.getProxyExt() instanceof BNrioProxyExt)) {
            return null;
        }
        BNrioProxyExt sourceProxy = (BNrioProxyExt)sourcePoint.getProxyExt();
        BControlPoint[] cps = this.getPoints().getPoints();
        for (int i = 0; i < cps.length; ++i) {
            BNrioProxyExt testProxy;
            if (cps[i].getHandle() != null && sourcePoint.getHandle() != null && cps[i].getHandle().equals(sourcePoint.getHandle()) || !(testProxy = (BNrioProxyExt)cps[i].getProxyExt()).getEnabled() || !sourceProxy.getEnabled() || testProxy.getInstance() != sourceProxy.getInstance() || testProxy.getIsSdi() != sourceProxy.getIsSdi() || sourcePoint.isWritablePoint() != cps[i].isWritablePoint()) continue;
            return cps[i];
        }
        return null;
    }

    public void processIoStatusMessage(NrioMessage statusMessage) {
    }

    public NrioDeviceIoStatus getLastIoStatus() {
        return this.lastIoStatus;
    }

    public BComponent doReadInfoMemory() {
        BComponent info = new BComponent();
        try {
            ReadInfoMemoryMessage req = new ReadInfoMemoryMessage(this.getAddress());
            NrioMessage rsp = this.accessNet.sendNrioMessage(req);
            if (rsp.getStatus() != 0) {
                return info;
            }
            byte[] infoData = rsp.getData();
            info.add("nodeAddr", (BValue)BInteger.make((int)(infoData[0] & 0xFF)));
            info.add("numMsgsOurAddr", (BValue)BInteger.make((int)(infoData[1] & 0xFF)));
            info.add("numMsgsRcvd", (BValue)BInteger.make((int)(infoData[2] & 0xFF)));
            info.add("numBadMsgsRcvd", (BValue)BInteger.make((int)(infoData[3] & 0xFF)));
            info.add("numMsgsTransmitted", (BValue)BInteger.make((int)(infoData[4] & 0xFF)));
            info.add("numIOStatusCrcErrors", (BValue)BInteger.make((int)(infoData[5] & 0xFF)));
            info.add("numCardReadsProcessed", (BValue)BInteger.make((int)(infoData[6] & 0xFF)));
            info.add("numCardReadsXmitted", (BValue)BInteger.make((int)(infoData[7] & 0xFF)));
            info.add("numCardReadErrors", (BValue)BInteger.make((int)(infoData[8] & 0xFF)));
            info.add("num485ResetsOnRcv", (BValue)BInteger.make((int)(infoData[9] & 0xFF)));
            info.add("lastResetState", (BValue)BInteger.make((int)(infoData[10] & 0xFF)));
        }
        catch (Exception e) {
            this.accessNet.getLog().message(this.getName() + ": doReadInfoMemory caught exception: " + e);
        }
        return info;
    }

    public void doClearInfoMemory() {
        try {
            ClearInfoMemoryMessage req = new ClearInfoMemoryMessage(this.getAddress());
            NrioMessage nrioMessage = this.accessNet.sendNrioMessage(req);
        }
        catch (Exception e) {
            this.accessNet.getLog().message(this.getName() + ": doReadInfoMemory caught exception: " + e);
        }
    }

    public void doSetAddressAndPing() {
        int logicalAddress = this.getAddress();
        byte[] uid = this.getUid().copyBytes();
        int type = this.getDeviceType().getRawInt();
        SetLogicalAddressMessage setAddrMsg = new SetLogicalAddressMessage(logicalAddress, uid);
        NrioMessage rsp = this.accessNet.sendNrioMessage(setAddrMsg);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PingMessage pReq = new PingMessage(logicalAddress, uid, type);
        PingResponse pRsp = (PingResponse)this.accessNet.sendNrioMessage(pReq);
        this.doPing();
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action) {
        if (ticket != null) {
            ticket.cancel();
        }
        return Clock.schedulePeriodically((BComponent)this, (BRelTime)time, (Action)action, null);
    }

    private void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
        }
    }

    public BOrd[] getUsedRelayArray() {
        return null;
    }

    public BOrd[] getUsedDiArray() {
        return null;
    }

    public BOrd[] getUsedSdiArray() {
        return null;
    }

    public BOrd[] getUsedRelayArray(int maxSize) {
        BOrd[] usedRelayMap = new BOrd[maxSize];
        BControlPoint[] points = this.getPoints().getPoints();
        for (int i = 0; i < points.length; ++i) {
            int instance;
            BProxyExt proxyExt = (BProxyExt)points[i].getProxyExt();
            if (!(proxyExt instanceof BNrioProxyExt) || !(points[i] instanceof BBooleanWritable) || !proxyExt.getEnabled() || (instance = ((BNrioProxyExt)proxyExt).getInstance()) <= 0 || instance > usedRelayMap.length) continue;
            usedRelayMap[instance - 1] = points[i].getSlotPathOrd();
        }
        return usedRelayMap;
    }

    public BOrd[] getUsedDiArray(int maxSize) {
        BOrd[] usedDiMap = new BOrd[maxSize];
        BControlPoint[] points = this.getPoints().getPoints();
        for (int i = 0; i < points.length; ++i) {
            BProxyExt proxyExt = (BProxyExt)points[i].getProxyExt();
            if (!(proxyExt instanceof BNrioProxyExt) || !(points[i] instanceof BBooleanPoint) || points[i].isWritablePoint() || ((BNrioProxyExt)proxyExt).getIsSdi() || !proxyExt.getEnabled()) continue;
            try {
                int instance = ((BNrioProxyExt)proxyExt).getInstance();
                if (instance <= 0 || instance > usedDiMap.length) continue;
                usedDiMap[instance - 1] = points[i].getSlotPathOrd();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return usedDiMap;
    }

    public BOrd[] getUsedSdiArray(int maxSize) {
        BOrd[] usedSdiMap = new BOrd[maxSize];
        BControlPoint[] points = this.getPoints().getPoints();
        for (int i = 0; i < points.length; ++i) {
            int instance;
            BProxyExt proxyExt = (BProxyExt)points[i].getProxyExt();
            if (!(proxyExt instanceof BNrioProxyExt) || !(points[i] instanceof BBooleanPoint) || points[i].isWritablePoint() || !((BNrioProxyExt)proxyExt).getIsSdi() || !proxyExt.getEnabled() || (instance = ((BNrioProxyExt)proxyExt).getInstance()) <= 0 || instance > usedSdiMap.length) continue;
            usedSdiMap[instance - 1] = points[i].getSlotPathOrd();
        }
        return usedSdiMap;
    }

    public BNrioLearnDeviceEntry makeLearnDeviceEntry() {
        return new BNrioLearnDeviceEntry(this.getAddress(), this.getDeviceType(), this.getUid().copyBytes(), this.getInstalledVersion(), this.getDisplayName(null), -1);
    }

    public boolean isWriteOutputDefaultsInProgress() {
        return false;
    }
}

