/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.nrio.BM2mIoNetwork;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIOutputDefaultValues;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.components.BOutputDefaultValues;
import com.tridium.nrio.components.BOutputFailsafeConfig;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.NrIo16WriteConfigMessage;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.ReadDefaultOutputStateMessage;
import com.tridium.nrio.messages.ReadInfoMemoryMessage;
import com.tridium.nrio.messages.ReadScaleOffsetMessage;
import com.tridium.nrio.messages.WriteIOStateMapStart;
import com.tridium.nrio.messages.WriteIoMessage;
import com.tridium.nrio.messages.WriteOutputConfigMessage;
import com.tridium.nrio.points.BNrio16Points;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridium.nrio.points.BNrioRelayOutputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.nrio.points.BUiProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BNrio16Module
extends BNrioDevice {
    public static final Property deviceType = BNrio16Module.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.io16, null);
    public static final Property outputDefaultValues = BNrio16Module.newProperty((int)0, (BValue)new BOutputDefaultValues(), null);
    public static final Property points = BNrio16Module.newProperty((int)0, (BValue)new BNrio16Points(), null);
    public static final Property ioStatus = BNrio16Module.newProperty((int)0, (BValue)new BNrio16Status(), null);
    public static final Action writeConfig = BNrio16Module.newAction((int)20, null);
    public static final Action writeIo = BNrio16Module.newAction((int)4, null);
    public static final Action clearTotals = BNrio16Module.newAction((int)0, null);
    public static final Action readScaleOffset = BNrio16Module.newAction((int)20, null);
    public static final Action writeOutputDefaultInfo = BNrio16Module.newAction((int)20, null);
    public static final Action readOutputDefaultInfo = BNrio16Module.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BNrio16Module.class);
    private int wrDoValue = 0;
    private int[] wrAoValue = new int[4];
    private byte[] lastWriteData = new byte[7];
    private byte[] uiConfig = new byte[]{17, 17, 17, 17};
    protected boolean defaultOutputSupport = false;
    protected boolean forceWrite = true;
    protected boolean isWriteDefaultOutputInProcess = false;
    protected static byte[] NO_DATA = new byte[0];
    protected static final int NUM_AOS = 4;
    protected static final int NUM_UIS = 8;
    protected static final int NUM_DOS = 5;
    private Clock.Ticket wrOutputConfigTicket;

    public BComponent getOutputDefaultValues() {
        return (BComponent)this.get(outputDefaultValues);
    }

    public void setOutputDefaultValues(BComponent v) {
        this.set(outputDefaultValues, (BValue)v, null);
    }

    @Override
    public BNrioPointDeviceExt getPoints() {
        return (BNrioPointDeviceExt)this.get(points);
    }

    @Override
    public void setPoints(BNrioPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    public BStruct getIoStatus() {
        return (BStruct)this.get(ioStatus);
    }

    @Override
    public void setIoStatus(BStruct v) {
        this.set(ioStatus, (BValue)v, null);
    }

    public void writeConfig() {
        this.invoke(writeConfig, null, null);
    }

    public void writeIo() {
        this.invoke(writeIo, null, null);
    }

    public void clearTotals() {
        this.invoke(clearTotals, null, null);
    }

    public BComponent readScaleOffset() {
        return (BComponent)this.invoke(readScaleOffset, null, null);
    }

    public void writeOutputDefaultInfo() {
        this.invoke(writeOutputDefaultInfo, null, null);
    }

    public BComponent readOutputDefaultInfo() {
        return (BComponent)this.invoke(readOutputDefaultInfo, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(writeConfig) || action.equals(readScaleOffset) || action.equals(writeOutputDefaultInfo) || action.equals(readOutputDefaultInfo)) {
            return this.postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postWriteConfig(BValue arg, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, writeConfig, arg, cx));
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.initDefaultValueSupport();
        }
        if (this.getAddress() != 0) {
            return;
        }
        BDeviceNetwork network = this.getNetwork();
        if (network != null && network instanceof BM2mIoNetwork) {
            ((BM2mIoNetwork)network).doSubmitDeviceDiscoveryJob();
        }
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || cx != null && cx.equals(Context.decoding)) {
            return;
        }
        if (p.equals(outputDefaultValues)) {
            this.postWriteOutputDefaults();
        } else if (p.equals(status)) {
            if (this.isDown() || this.isDisabled()) {
                this.forceWrite = true;
                for (int i = 0; i < this.lastWriteData.length; ++i) {
                    this.lastWriteData[i] = ~this.lastWriteData[i];
                }
            } else {
                this.postWriteOutputDefaults();
            }
        } else if (p.equals(installedVersion)) {
            this.initDefaultValueSupport();
        }
    }

    public void initDefaultValueSupport() {
        float version = 0.0f;
        try {
            version = Float.parseFloat(this.getInstalledVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((double)version != 0.0) {
            this.setDefaultOutputSupport(version >= 1.35f);
            if (this.isDefaultOutputSupport()) {
                this.setFlags((Slot)outputDefaultValues, this.getFlags((Slot)outputDefaultValues) & 0xFFFFFFFB);
            } else {
                this.setFlags((Slot)outputDefaultValues, this.getFlags((Slot)outputDefaultValues) | 4);
            }
        }
    }

    public BComponent doReadScaleOffset() {
        int i;
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        ReadScaleOffsetMessage cReq = new ReadScaleOffsetMessage(this.getAddress());
        NrioMessage cRsp = network.sendNrioMessage(cReq);
        if (this.getConfigLog().isTraceOn()) {
            byte[] bytes = cReq.getByteArray();
            this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            bytes = cRsp.getByteArray();
            this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
        }
        if (cRsp.getStatus() != 0) {
            return null;
        }
        BComponent info = new BComponent();
        byte[] infoData = cRsp.getData();
        NrioInputStream in = new NrioInputStream(infoData);
        for (i = 1; i < 9; ++i) {
            info.add("uiResitive" + i + "scale", (BValue)BInteger.make((int)in.readInt()));
            info.add("uiResitive" + i + "offset", (BValue)BInteger.make((int)in.readInt()));
        }
        for (i = 1; i < 9; ++i) {
            info.add("uiPlat" + i + "scale", (BValue)BInteger.make((int)in.readInt()));
            info.add("uiPlat" + i + "offset", (BValue)BInteger.make((int)in.readInt()));
        }
        for (i = 1; i < 9; ++i) {
            info.add("uiVolts" + i + "scale", (BValue)BInteger.make((int)in.readInt()));
            info.add("uiVolts" + i + "offset", (BValue)BInteger.make((int)in.readInt()));
        }
        for (i = 1; i < 5; ++i) {
            info.add("aoVolts" + i + "scale", (BValue)BInteger.make((int)in.readInt()));
            info.add("aoVolts" + i + "offset", (BValue)BInteger.make((int)in.readInt()));
        }
        return info;
    }

    public void doClearTotals() {
        ((BNrio16Status)this.getIoStatus()).doClearTotals();
    }

    public void doWriteConfig() {
        if (this.isDisabled() || this.isDown() || this.firstPing) {
            return;
        }
        this.sendWriteConfig();
    }

    @Override
    public int sendWriteConfig() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        NrIo16WriteConfigMessage cReq = new NrIo16WriteConfigMessage(this.getAddress(), this.getUiConfigBytes());
        NrioMessage cRsp = network.sendNrioMessage(cReq);
        if (this.getConfigLog().isTraceOn()) {
            byte[] bytes = cReq.getByteArray();
            this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            bytes = cRsp.getByteArray();
            this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
        }
        return cRsp.getStatus();
    }

    @Override
    public boolean isWriteOutputDefaultsInProgress() {
        return this.isWriteDefaultOutputInProcess;
    }

    public void doWriteOutputDefaultInfo() {
        if (this.isDisabled() || this.isDown()) {
            return;
        }
        try {
            if (!this.isDefaultOutputSupport()) {
                return;
            }
            this.getConfigLog().trace(this.getName() + ": writeOutputDefaults");
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            this.doDisablePolling();
            this.setFirstPing(false);
            this.isWriteDefaultOutputInProcess = true;
            WriteIOStateMapStart req = new WriteIOStateMapStart(this.getAddress());
            NrioMessage rsp = network.sendNrioMessage(req);
            if (this.getConfigLog().isTraceOn()) {
                byte[] bytes = req.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = rsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (rsp.getStatus() != 0) {
                this.getConfigLog().trace("WriteIOStateMapStart pri response error: " + rsp.getStatus());
            }
            BOutputFailsafeConfig failsafeConfig = network.getOutputFailsafeConfig();
            WriteOutputConfigMessage wrReq = new WriteOutputConfigMessage(this.getAddress(), failsafeConfig.getStartupTimeout(), failsafeConfig.getCommLossTimeout(), (BIOutputDefaultValues)this.getOutputDefaultValues(), true);
            NrioMessage wrRsp = network.sendNrioMessage(wrReq);
            if (this.getConfigLog().isTraceOn()) {
                byte[] bytes = wrReq.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = wrRsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (wrRsp.getStatus() != 0) {
                this.getConfigLog().trace("WriteOutputConfigMessage primary response error: " + wrRsp.getStatus());
            }
            this.doEnablePolling();
        }
        catch (Exception e) {
            this.getConfigLog().trace("doWriteOutputDefaultInfo caught exception: " + e);
        }
        this.isWriteDefaultOutputInProcess = false;
    }

    public BComponent doReadOutputDefaultInfo() {
        try {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            ReadDefaultOutputStateMessage req = new ReadDefaultOutputStateMessage(this.getAddress());
            NrioMessage rsp = network.sendNrioMessage(req);
            if (this.getConfigLog().isTraceOn()) {
                byte[] bytes = req.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = rsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (rsp.getStatus() != 0) {
                return null;
            }
            byte[] infoData = rsp.getData();
            BOutputDefaultValues defaultValues = BOutputDefaultValues.makeFromBytes(infoData);
            return defaultValues;
        }
        catch (Exception e) {
            this.getConfigLog().trace("doReadOutputDefaultInfo caught exception: " + e);
            return null;
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        Property[] props = null;
        if (!this.isDualModule()) {
            BComponent priInfo = this.doReadInfoMemory();
            out.startProps("CPU Info Memory");
            props = priInfo.getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                Property p = props[i];
                out.prop((Object)p.getName(), (Object)priInfo.get(p));
            }
            out.endProps();
        }
        out.startProps("Output Write Values");
        out.prop((Object)"wrDoValue", (Object)("0b" + Integer.toBinaryString(this.wrDoValue)));
        for (int i = 0; i < this.wrAoValue.length; ++i) {
            out.prop((Object)"wrAoValue", (Object)("0x" + Integer.toHexString(this.wrAoValue[i])));
        }
        out.endProps();
        BComponent info = this.doReadScaleOffset();
        out.startProps("Calibration Info");
        if (info != null) {
            for (Property property : info.getProperties()) {
                out.prop((Object)property.getName(), (Object)info.get(property));
            }
        }
        out.endProps();
        BComponent defaultValues = this.doReadOutputDefaultInfo();
        if (defaultValues == null) {
            return;
        }
        out.startProps("Output Default Value Info");
        props = defaultValues.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            out.prop((Object)props[i].getName(), (Object)defaultValues.get(props[i]));
        }
        out.endProps();
    }

    @Override
    public BComponent doReadInfoMemory() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        BComponent info = new BComponent();
        try {
            ReadInfoMemoryMessage req = new ReadInfoMemoryMessage(this.getAddress());
            NrioMessage rsp = network.sendNrioMessage(req);
            if (rsp.getStatus() != 0) {
                return info;
            }
            byte[] infoData = rsp.getData();
            info.add("nodeAddr", (BValue)BInteger.make((int)(infoData[0] & 0xFF)));
            info.add("numMsgsOurAddr", (BValue)BInteger.make((int)(infoData[1] & 0xFF)));
            info.add("numMsgsRcvd", (BValue)BInteger.make((int)(infoData[2] & 0xFF)));
            info.add("numBadMsgsRcvd", (BValue)BInteger.make((int)(infoData[3] & 0xFF)));
            info.add("numMsgsTransmitted", (BValue)BInteger.make((int)(infoData[4] & 0xFF)));
            info.add("numIOStatusCrcErrors", (BValue)BInteger.make((int)(infoData[5] & 0xFF)));
            info.add("num485ResetsOnRcv", (BValue)BInteger.make((int)(infoData[9] & 0xFF)));
            info.add("lastResetState", (BValue)BInteger.make((int)(infoData[10] & 0xFF)));
        }
        catch (Exception e) {
            network.getLog().message(this.getName() + ": doReadInfoMemory caught exception: " + e);
        }
        return info;
    }

    public void postWriteOutputDefaults() {
        if (this.isDisabled() || this.isDown() || !this.isDefaultOutputSupport()) {
            return;
        }
        this.getConfigLog().trace(this.getName() + ": writeOutputDefaults posted: will write in 5 seconds");
        if (this.wrOutputConfigTicket != null) {
            this.wrOutputConfigTicket.cancel();
        }
        this.wrOutputConfigTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)5), (Action)writeOutputDefaultInfo, null);
    }

    @Override
    public BControlPoint checkForProxyExtConflicts(BControlPoint sourcePoint) {
        BNrio16ProxyExt sourceProxy = (BNrio16ProxyExt)sourcePoint.getProxyExt();
        BControlPoint[] cps = this.getPoints().getPoints();
        for (int i = 0; i < cps.length; ++i) {
            boolean sameInstance;
            BNrio16ProxyExt testProxy;
            if (cps[i].equals((Object)sourcePoint) || !(testProxy = (BNrio16ProxyExt)cps[i].getProxyExt()).getEnabled()) continue;
            boolean bl = sameInstance = testProxy.getInstance() == sourceProxy.getInstance();
            if (testProxy instanceof BUiProxyExt && sourceProxy instanceof BUiProxyExt && sameInstance) {
                return cps[i];
            }
            if (testProxy instanceof BNrioVoltageOutputProxyExt && sourceProxy instanceof BNrioVoltageOutputProxyExt && sameInstance) {
                return cps[i];
            }
            if (!(testProxy instanceof BNrioRelayOutputProxyExt) || !(sourceProxy instanceof BNrioRelayOutputProxyExt) || !sameInstance) continue;
            return cps[i];
        }
        return null;
    }

    @Override
    public void initLastWrite() {
        for (int i = 0; i < this.lastWriteData.length; ++i) {
            this.lastWriteData[i] = -1;
        }
    }

    public int setAoValue(int value, int instance) {
        if (instance <= 0 || instance > 4) {
            return 1;
        }
        this.wrAoValue[instance - 1] = value;
        return 0;
    }

    @Override
    public int setDoValue(boolean value, int instance) {
        if (instance <= 0) {
            return 1;
        }
        int mask = 1 << instance - 1;
        this.setWrDoValue(value, mask);
        return 0;
    }

    public synchronized void setWrDoValue(boolean value, int mask) {
        this.wrDoValue = value ? (this.wrDoValue |= mask) : (this.wrDoValue &= ~mask);
    }

    @Override
    public int doWriteDoValues() {
        return this.doWriteIoValues();
    }

    public void atSteadyState() {
        this.initDefaultValueSupport();
        this.forceWrite = true;
    }

    public void doWriteIo() {
        this.forceWrite = true;
    }

    public int doWriteIoValues() {
        if (this.isDown() || this.isFault() || this.isDisabled()) {
            return 0;
        }
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        byte[] thisWrite = this.getIoData();
        if (this.forceWrite || this.hasWrDataChanged(thisWrite)) {
            if (this.isWriteOutputDefaultsInProgress()) {
                this.getConfigLog().trace(this.getAddress() + ": WriteOutputDefaultsInProgress blocking nrio msgType: 0x9");
                return 0;
            }
            this.forceWrite = false;
            WriteIoMessage req = new WriteIoMessage(this.getAddress(), this.getIoData());
            NrioMessage rsp = network.sendNrioMessage(req);
            if (this.getWrIoLog().isTraceOn()) {
                byte[] bytes = req.getByteArray();
                this.getWrIoLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = rsp.getByteArray();
                this.getWrIoLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (rsp != null && rsp.getStatus() == 0) {
                if (!this.getFirstPing()) {
                    this.pingOk();
                }
                for (int i = 0; i < this.lastWriteData.length; ++i) {
                    this.lastWriteData[i] = thisWrite[i];
                }
            }
            return rsp.getStatus();
        }
        return 0;
    }

    @Override
    public BOrd[] getUsedRelayArray() {
        return this.getUsedRelayArray(8);
    }

    @Override
    public BOrd[] getUsedDiArray() {
        return this.getUsedDiArray(2);
    }

    @Override
    public BOrd[] getUsedSdiArray() {
        return this.getUsedSdiArray(8);
    }

    @Override
    public void updateProxyValues() {
        byte[] statusBytes = ((BNrio16Status)this.getIoStatus()).copyBytes();
        if (statusBytes.length < 12) {
            return;
        }
        NrioMessage statusMsg = new NrioMessage();
        statusMsg.decodeFromBytes(statusBytes, statusBytes.length);
        this.getPoints().setDynamicPoints();
    }

    public String toString(Context cx) {
        StringBuffer b = new StringBuffer();
        return b.toString();
    }

    public void setUiConfig(int instance, int uiType) {
        switch (instance - 1) {
            case 0: {
                this.uiConfig[0] = (byte)(this.uiConfig[0] & 0xF | (uiType & 0xF) << 4);
                break;
            }
            case 1: {
                this.uiConfig[0] = (byte)(this.uiConfig[0] & 0xF0 | uiType & 0xF);
                break;
            }
            case 2: {
                this.uiConfig[1] = (byte)(this.uiConfig[1] & 0xF | (uiType & 0xF) << 4);
                break;
            }
            case 3: {
                this.uiConfig[1] = (byte)(this.uiConfig[1] & 0xF0 | uiType & 0xF);
                break;
            }
            case 4: {
                this.uiConfig[2] = (byte)(this.uiConfig[2] & 0xF | (uiType & 0xF) << 4);
                break;
            }
            case 5: {
                this.uiConfig[2] = (byte)(this.uiConfig[2] & 0xF0 | uiType & 0xF);
                break;
            }
            case 6: {
                this.uiConfig[3] = (byte)(this.uiConfig[3] & 0xF | (uiType & 0xF) << 4);
                break;
            }
            case 7: {
                this.uiConfig[3] = (byte)(this.uiConfig[3] & 0xF0 | uiType & 0xF);
            }
        }
        if (this.isRunning()) {
            this.writeConfig();
        }
    }

    public byte[] getUiConfigBytes() {
        return this.uiConfig;
    }

    public byte[] getIoData() {
        byte[] ioData = new byte[7];
        ioData[0] = (byte)this.wrDoValue;
        block6: for (int i = 0; i < 4; ++i) {
            int rawValue = this.getAoRawValue(i);
            switch (i) {
                case 0: {
                    ioData[1] = (byte)(rawValue >> 4 & 0xFF);
                    ioData[2] = (byte)((rawValue & 0xF) << 4);
                    continue block6;
                }
                case 1: {
                    ioData[2] = (byte)(ioData[2] | rawValue >> 8 & 0xF);
                    ioData[3] = (byte)(rawValue & 0xFF);
                    continue block6;
                }
                case 2: {
                    ioData[4] = (byte)(rawValue >> 4 & 0xFF);
                    ioData[5] = (byte)((rawValue & 0xF) << 4);
                    continue block6;
                }
                case 3: {
                    ioData[5] = (byte)(ioData[5] | rawValue >> 8 & 0xF);
                    ioData[6] = (byte)(rawValue & 0xFF);
                }
            }
        }
        return ioData;
    }

    private int getAoRawValue(int instance) {
        int retValue = this.wrAoValue[instance];
        if (retValue > 4095) {
            retValue = 4095;
        }
        if (retValue < 0) {
            retValue = 0;
        }
        return retValue;
    }

    private boolean hasWrDataChanged(byte[] thisWrite) {
        if (thisWrite.length != this.lastWriteData.length) {
            return true;
        }
        for (int i = 0; i < thisWrite.length; ++i) {
            if (thisWrite[i] == this.lastWriteData[i]) continue;
            return true;
        }
        return false;
    }

    public Log getConfigLog() {
        return Log.getLog((String)(this.getNetwork().getName() + ".config"));
    }

    public Log getWrIoLog() {
        return Log.getLog((String)(this.getNetwork().getName() + ".wrIo"));
    }

    public boolean isDefaultOutputSupport() {
        return this.defaultOutputSupport;
    }

    public void setDefaultOutputSupport(boolean value) {
        this.defaultOutputSupport = value;
    }
}

