/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BGridPane;

public class BPointDiscoveryModeSelectPane
extends BGridPane {
    public static final Action modeChanged = BPointDiscoveryModeSelectPane.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BPointDiscoveryModeSelectPane.class);
    private DiscoveryModeListener modeListener = null;
    private ToggleCommandGroup<ToggleCommand> selectionGroup = new ToggleCommandGroup();
    private BRadioButton scanDeviceDatabaseButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BPointDiscoveryModeSelectPane.scanDatabaseButton"));
    private BRadioButton liveDeviceScanButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BPointDiscoveryModeSelectPane.liveDataScanButton"));

    public void modeChanged(BWidgetEvent event) {
        this.invoke(modeChanged, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPointDiscoveryModeSelectPane() {
        this.init();
    }

    public BPointDiscoveryModeSelectPane(DiscoveryModeListener modeListener) {
        this.modeListener = modeListener;
        this.init();
    }

    private void init() {
        this.setColumnCount(1);
        this.add(null, (BValue)this.scanDeviceDatabaseButton);
        this.add(null, (BValue)this.liveDeviceScanButton);
        this.linkTo("scanDeviceDatabaseModeLink", (BComponent)this.scanDeviceDatabaseButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.linkTo("scanLiveDeviceModeLink", (BComponent)this.liveDeviceScanButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.scanDeviceDatabaseButton.setSelected(true);
    }

    public void doModeChanged(BWidgetEvent event) {
        if (this.modeListener != null) {
            this.modeListener.modeChanged();
        }
    }

    public boolean isScanDatabaseDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.scanDeviceDatabaseButton.getText());
    }

    public boolean isScanLiveDeviceDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.liveDeviceScanButton.getText());
    }

    public static interface DiscoveryModeListener {
        public void modeChanged();
    }
}

