/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.jobs.BMbusLivePointSearchDiscoveryJob;
import com.tridium.mbus.learn.BMbusPointEntry;
import com.tridium.mbus.point.BMbusPointFolder;
import com.tridium.mbus.point.BMbusProxyExt;
import com.tridium.mbus.ui.PointDiscoveryWizardModel;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public final class BMbusPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BMbusPointManager.class);
    static Lexicon lex = Lexicon.make(BMbusPointManager.class);
    String wholeName = "";
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(4);
    MgrColumn colToString = new MgrColumn.ToString("Out", 4);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 1);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    private MgrColumn colDescription = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.description}, 5);
    private MgrColumn colOrthoDescription = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.orthogonalDescription}, 5);
    private MgrColumn colFunction = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.function}, 5);
    private MgrColumn colMbusUnit = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.mbusUnit}, 5);
    private MgrColumn colExponent = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.exponent}, 5);
    private MgrColumn colNumberType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.numberType}, 5);
    private MgrColumn colRecordNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.recordNumber}, 1);
    private MgrColumn colMsgSlotNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.messageSlotNumber}, 5);
    private MgrColumn colStorageNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.storageNumber}, 5);
    private MgrColumn colCycleNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.cycleNumber}, 5);
    private MgrColumn colMode = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.deviceMode}, 5);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colDescription, this.colOrthoDescription, this.colFunction, this.colMbusUnit, this.colExponent, this.colToString, this.colMode, this.colRecordNumber, this.colCycleNumber, this.colFacets, this.colStorageNumber, this.colTuning, this.colConversion, this.colFaultCause, this.colPath, this.colType, this.colEnabled, this.colNumberType, this.colMsgSlotNumber};
    BMbusPointEntry[] lastLearn = null;
    private BDevice device = null;
    private BAbstractMbusNetwork net = null;
    private static final BImage defaultIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        if (obj instanceof BPointDeviceExt) {
            this.device = ((BPointDeviceExt)obj).getDevice();
        } else if (obj instanceof BMbusPointFolder) {
            this.device = ((BMbusPointFolder)obj).getDevice();
        }
        this.device.lease();
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BMbusPointEntry[])event.getChildren(BMbusPointEntry.class);
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    public BAbstractMbusNetwork getNetwork() {
        if (this.net == null) {
            this.net = this.findNetwork((BComponent)this.getCurrentValue());
        }
        return this.net;
    }

    public BMbusDevice getDevice() {
        BComponent currentItem;
        for (currentItem = (BComponent)this.getCurrentValue(); !(currentItem instanceof BMbusDevice) && currentItem != null; currentItem = (BComponent)currentItem.getParent()) {
        }
        return (BMbusDevice)currentItem;
    }

    private BAbstractMbusNetwork findNetwork(BComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof BAbstractMbusNetwork) {
            return (BAbstractMbusNetwork)comp;
        }
        return this.findNetwork((BComponent)comp.getParent());
    }

    public static class MbusMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo pntType;
        private BMbusUnit mbusUnit;
        private String description;
        private int msgSlotNumber;
        private BMbusFunction function;
        private int storageNumber;
        private int recordNumber;
        private int cycleNumber;
        private String displayName;
        private BMbusOrthogonalDescription orthoDesc;
        private int exponent;
        private int mode;
        private static final BImage defaultIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");

        public MbusMgrTypeInfo(BMbusUnit mbusUnit, String description, TypeInfo pntType, BMbusOrthogonalDescription orthoDesc, int msgSlotNumber, int storageNumber, int recordNumber, int cycleNumber, int exponent, BMbusFunction function, int mode) {
            block5: {
                this.pntType = null;
                this.mbusUnit = null;
                this.description = null;
                this.msgSlotNumber = 0;
                this.function = BMbusFunction.instantaneous;
                this.storageNumber = 0;
                this.recordNumber = 0;
                this.cycleNumber = 0;
                this.displayName = "Invalid";
                this.orthoDesc = null;
                this.exponent = 0;
                this.mode = 0;
                this.mbusUnit = mbusUnit;
                this.description = description;
                this.orthoDesc = orthoDesc;
                this.pntType = pntType;
                this.exponent = exponent;
                this.msgSlotNumber = msgSlotNumber;
                this.recordNumber = recordNumber;
                this.cycleNumber = cycleNumber;
                this.storageNumber = storageNumber;
                this.function = function;
                this.mode = mode;
                try {
                    this.displayName = !orthoDesc.equals((Object)BMbusOrthogonalDescription.none) ? description.toString() + " " + orthoDesc.toString() : description.toString();
                    if (msgSlotNumber != 0 & storageNumber < 1) {
                        this.displayName = this.displayName + new Integer(msgSlotNumber).toString();
                    } else if (storageNumber != 0) {
                        this.displayName = this.displayName + new Integer(storageNumber).toString();
                    }
                }
                catch (Exception e) {
                    if (MbusToolkit.getLogger() == null) break block5;
                    MbusToolkit.error((String)"Error Point Manager MbusMgrTypeInfo", (Throwable)e);
                }
            }
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public BProxyConversion getConverter() {
            return BDefaultProxyConversion.DEFAULT;
        }

        public BImage getIcon() {
            return defaultIcon;
        }

        public BComponent newInstance() {
            BControlPoint pnt = null;
            pnt = (BControlPoint)this.pntType.getInstance();
            BMbusProxyExt ext = new BMbusProxyExt();
            ext.setMbusUnit(this.mbusUnit);
            ext.setDescription(this.description);
            ext.setOrthogonalDescription(this.orthoDesc);
            ext.setRecordNumber(this.recordNumber);
            ext.setCycleNumber(this.cycleNumber);
            ext.setMessageSlotNumber(this.msgSlotNumber);
            ext.setStorageNumber(this.storageNumber);
            ext.setFunction(this.function);
            ext.setExponent(this.exponent);
            ext.setDeviceMode(this.mode);
            int precision = 0;
            if (this.exponent < 0) {
                precision = -this.exponent;
            }
            BUnit unitHold = BMbusUnit.getNiagaraUnits((BMbusUnit)this.mbusUnit);
            BFacets facetHold = BFacets.makeNumeric((BUnit)unitHold, (int)precision);
            ext.setDeviceFacets(facetHold);
            pnt.setProxyExt((BAbstractProxyExt)ext);
            pnt.setFacets(facetHold);
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    private class Learn
    extends MgrLearn {
        Learn(BMbusPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BMbusPointEntry.description), new MgrColumn.Prop(BMbusPointEntry.orthogonalDescription), new MgrColumn.Prop(BMbusPointEntry.function), new MgrColumn.Prop(BMbusPointEntry.mbusUnit), new MgrColumn.Prop(BMbusPointEntry.exponent), new MgrColumn.Prop(BMbusPointEntry.numberType), new MgrColumn.Prop(BMbusPointEntry.deviceMode), new MgrColumn.Prop(BMbusPointEntry.recordNumber), new MgrColumn.Prop(BMbusPointEntry.cycleNumber), new MgrColumn.Prop(BMbusPointEntry.messageSlotNumber), new MgrColumn.Prop(BMbusPointEntry.storageNumber)};
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return false;
        }

        public BImage getIcon(Object dis) {
            MgrTypeInfo[] infos = this.toTypes(dis);
            if (infos.length > 0) {
                BIcon icon = ((MbusMgrTypeInfo)infos[0]).getPointTypeInfo().getInstance().getIcon();
                return BImage.make((BIcon)icon);
            }
            return defaultIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            BMbusPointEntry entry = (BMbusPointEntry)dis;
            Array typeInfoArray = new Array(MgrTypeInfo.class);
            if (entry.getNumberType().equals((Object)BMbusNumberType.numericIp)) {
                typeInfoArray.add((Object)new MbusMgrTypeInfo(entry.getMbusUnit(), entry.getDescription(), Sys.getRegistry().getType("control:NumericPoint"), entry.getOrthogonalDescription(), entry.getMessageSlotNumber(), entry.getStorageNumber(), entry.getRecordNumber(), entry.getCycleNumber(), entry.getExponent(), entry.getFunction(), entry.getDeviceMode()));
            } else if (entry.getNumberType().equals((Object)BMbusNumberType.booleanIp)) {
                typeInfoArray.add((Object)new MbusMgrTypeInfo(entry.getMbusUnit(), entry.getDescription(), Sys.getRegistry().getType("control:BooleanPoint"), entry.getOrthogonalDescription(), entry.getMessageSlotNumber(), entry.getStorageNumber(), entry.getRecordNumber(), entry.getCycleNumber(), entry.getExponent(), entry.getFunction(), entry.getDeviceMode()));
            } else if (entry.getNumberType().equals((Object)BMbusNumberType.enumIp)) {
                typeInfoArray.add((Object)new MbusMgrTypeInfo(entry.getMbusUnit(), entry.getDescription(), Sys.getRegistry().getType("control:EnumPoint"), entry.getOrthogonalDescription(), entry.getMessageSlotNumber(), entry.getStorageNumber(), entry.getRecordNumber(), entry.getCycleNumber(), entry.getExponent(), entry.getFunction(), entry.getDeviceMode()));
            } else if (entry.getNumberType().equals((Object)BMbusNumberType.dateIp) || entry.getNumberType().equals((Object)BMbusNumberType.stringIp)) {
                typeInfoArray.add((Object)new MbusMgrTypeInfo(entry.getMbusUnit(), entry.getDescription(), Sys.getRegistry().getType("control:StringPoint"), entry.getOrthogonalDescription(), entry.getMessageSlotNumber(), entry.getStorageNumber(), entry.getRecordNumber(), entry.getCycleNumber(), entry.getExponent(), entry.getFunction(), entry.getDeviceMode()));
            }
            return (MgrTypeInfo[])typeInfoArray.trim();
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BMbusPointManager.this.wholeName = "";
            BMbusPointEntry entry = (BMbusPointEntry)dis;
            row.setCell(BMbusPointManager.this.colMbusUnit, (BValue)entry.getMbusUnit());
            row.setCell(BMbusPointManager.this.colDescription, (BValue)BString.make((String)entry.getDescription()));
            row.setCell(BMbusPointManager.this.colOrthoDescription, (BValue)entry.getOrthogonalDescription());
            row.setCell(BMbusPointManager.this.colFunction, (BValue)entry.getFunction());
            row.setCell(BMbusPointManager.this.colExponent, (BValue)BInteger.make((int)entry.getExponent()));
            row.setCell(BMbusPointManager.this.colNumberType, (BValue)entry.getNumberType());
            row.setCell(BMbusPointManager.this.colRecordNumber, (BValue)BInteger.make((int)entry.getRecordNumber()));
            row.setCell(BMbusPointManager.this.colCycleNumber, (BValue)BInteger.make((int)entry.getCycleNumber()));
            row.setCell(BMbusPointManager.this.colMsgSlotNumber, (BValue)BInteger.make((int)entry.getMessageSlotNumber()));
            row.setCell(BMbusPointManager.this.colStorageNumber, (BValue)BInteger.make((int)entry.getStorageNumber()));
            row.setCell(BMbusPointManager.this.colMode, (BValue)BInteger.make((int)entry.getDeviceMode()));
            BMbusPointManager.this.wholeName = !entry.getOrthogonalDescription().equals((Object)BMbusOrthogonalDescription.none) ? entry.getDescription().toString() + " " + entry.getOrthogonalDescription().toString() : entry.getDescription();
            String recordNumberHold = "";
            if (entry.getRecordNumber() > 1) {
                recordNumberHold = new Integer(entry.getRecordNumber() - 1).toString();
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + recordNumberHold + "_R";
            }
            String cycleNumberHold = "";
            if (entry.getCycleNumber() > 0) {
                cycleNumberHold = new Integer(entry.getCycleNumber()).toString();
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + cycleNumberHold + "_C";
            }
            if (entry.getMessageSlotNumber() != 0 && entry.getStorageNumber() < 1) {
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + "SL" + new Integer(entry.getMessageSlotNumber()).toString();
            } else if (entry.getStorageNumber() != 0) {
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + "ST" + new Integer(entry.getStorageNumber()).toString();
            }
            BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName.replace(' ', '_');
            BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName.trim();
            row.setDefaultName(BMbusPointManager.this.wholeName);
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BMbusPointEntry entry = (BMbusPointEntry)discovery;
                return entry.is(component);
            }
            catch (Throwable e) {
                MbusToolkit.error((String)"Error asking is point existing");
                return false;
            }
        }

        public void jobComplete(final BJob job) {
            super.jobComplete(job);
            if (job instanceof BMbusLivePointSearchDiscoveryJob) {
                try {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BMbusPointManager.this.getLearn().setJob(BMbusPointManager.this.getNetwork().submitPointDiscoveryJob(BOrdList.make((BOrd[])new BOrd[]{BMbusPointManager.this.device.getSlotPathOrd(), job.getSlotPathOrd()})));
                                BMbusPointManager.this.getController().updateCommands();
                            }
                            catch (Exception e) {
                                MbusToolkit.error((String)MbusToolkit.getText((String)"MbusDeviceManager.discoveryError"), (Throwable)e);
                            }
                        }
                    }).start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BMbusPointManager.this.getController().updateCommands();
            } else {
                BMbusPointManager.this.updateDiscoveryRows((BComponent)job);
            }
        }
    }

    class Controller
    extends PointController {
        Controller(BPointManager mgr) {
            super(mgr);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add};
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            PointDiscoveryWizardModel model = new PointDiscoveryWizardModel();
            BMbusDevice device = BMbusPointManager.this.getDevice();
            if (device != null) {
                model.setDevice(device.getAbsoluteOrd());
            }
            BWizard.open((BWidget)this.getManager(), (WizardModel)model);
            if (!model.isUserFinished()) {
                return null;
            }
            if (model.isDatabasePointScan()) {
                BMbusPointManager.this.getLearn().setJob(BMbusPointManager.this.getNetwork().submitPointDiscoveryJob(BOrdList.make((BOrd[])new BOrd[]{device.getSlotPathOrd(), BOrd.NULL})));
            } else if (model.isLivePointScan()) {
                BMbusPointManager.this.getLearn().setJob(device.submitLivePointsDiscoveryJob(model.getPointDiscoverOptions()));
            }
            return null;
        }

        public void updateCommands() {
            super.updateCommands();
            if (BMbusPointManager.this.getLearn().getTable() != null) {
                this.add.setEnabled(BMbusPointManager.this.getLearn().getTable().getSelectedObject() != null);
            }
        }
    }

    class Model
    extends PointModel {
        Model(BPointManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BMbusPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = null;
            BMbusProxyExt ext = new BMbusProxyExt();
            ext.setMbusUnit(BMbusUnit.none);
            ext.setDescription("None");
            ext.setOrthogonalDescription(BMbusOrthogonalDescription.none);
            ext.setMessageSlotNumber(0);
            ext.setDeviceMode(0);
            pt = (BControlPoint)type.newInstance();
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            ext.setDeviceFacets(deviceFacets);
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

