/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.history.BMbusHistoryImport;
import com.tridium.mbus.learn.BMbusHistoryImportEntry;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.ImportModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public final class BMbusHistoryImportManager
extends BHistoryImportManager {
    public static final Type TYPE = Sys.loadType(BMbusHistoryImportManager.class);
    private MgrColumn colDescription = new MgrColumn.Prop(BMbusHistoryImport.description, 1);
    private MgrColumn colOrthoDescription = new MgrColumn.Prop(BMbusHistoryImport.orthogonalDescription, 1);
    private MgrColumn colFunction = new MgrColumn.Prop(BMbusHistoryImport.function, 1);
    private MgrColumn colMbusUnit = new MgrColumn.Prop(BMbusHistoryImport.mbusUnit, 1);
    private MgrColumn colExponent = new MgrColumn.Prop(BMbusHistoryImport.exponent, 1);
    private MgrColumn colNumberType = new MgrColumn.Prop(BMbusHistoryImport.numberType, 1);
    private MgrColumn colRecordNumber = new MgrColumn.Prop(BMbusHistoryImport.recordNumber, 5);
    private MgrColumn colMsgSlotNumber = new MgrColumn.Prop(BMbusHistoryImport.messageSlotNumber, 5);
    private MgrColumn colFacets = new MgrColumn.Prop(BMbusHistoryImport.facets, 1);
    private MgrColumn colConversion = new MgrColumn.Prop(BMbusHistoryImport.conversion, 1);
    private MgrColumn colStorageNumber = new MgrColumn.Prop(BMbusHistoryImport.storageNumber, 5);
    private MgrColumn colManuSpecDef = new MgrColumn.Prop(BMbusHistoryImport.manuSpecDefElementOrd, 1);
    private MgrColumn colMode = new MgrColumn.Prop(BMbusHistoryImport.deviceMode, 5);
    private static BImage icon = BImage.make((String)"module://icons/x16/device.png");
    private BMbusDevice device = null;
    private BAbstractMbusNetwork network = null;

    public Type getType() {
        return TYPE;
    }

    protected ImportModel makeImportModel() {
        return new MbusImportModel(this);
    }

    public MgrController makeController() {
        return new Controller(this);
    }

    public MgrLearn makeLearn() {
        return new Learn(this);
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BMbusHistoryImportEntry[])event.getChildren(BMbusHistoryImportEntry.class);
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    public BAbstractMbusNetwork getNetwork() {
        if (this.network == null) {
            this.network = this.findNetwork((BComponent)this.getCurrentValue());
        }
        return this.network;
    }

    private BAbstractMbusNetwork findNetwork(BComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof BAbstractMbusNetwork) {
            return (BAbstractMbusNetwork)comp;
        }
        return this.findNetwork((BComponent)comp.getParent());
    }

    public BMbusDevice getDevice() {
        if (this.device == null) {
            this.device = this.findDevice((BComponent)this.getCurrentValue());
        }
        return this.device;
    }

    private BMbusDevice findDevice(BComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof BAbstractMbusNetwork) {
            return (BMbusDevice)comp;
        }
        return this.findDevice((BComponent)comp.getParent());
    }

    private class Controller
    extends ArchiveManagerController {
        Controller(BMbusHistoryImportManager mgr) {
            super((BArchiveManager)mgr);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            BMbusHistoryImportManager.this.network = BMbusHistoryImportManager.this.getNetwork();
            BMbusHistoryImportManager.this.device = (BMbusDevice)((BHistoryDeviceExt)BMbusHistoryImportManager.this.getCurrentValue().asComponent()).getParent();
            BMbusHistoryImportManager.this.getLearn().setJob(BMbusHistoryImportManager.this.network.submitHistoryImportDiscoveryJob(BMbusHistoryImportManager.this.device.getSlotPathOrd()));
            return null;
        }
    }

    private class Learn
    extends MgrLearn {
        Learn(BMbusHistoryImportManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BMbusHistoryImportEntry.description), new MgrColumn.Prop(BMbusHistoryImportEntry.orthogonalDescription), new MgrColumn.Prop(BMbusHistoryImportEntry.function), new MgrColumn.Prop(BMbusHistoryImportEntry.mbusUnit), new MgrColumn.Prop(BMbusHistoryImportEntry.exponent), new MgrColumn.Prop(BMbusHistoryImportEntry.deviceMode), new MgrColumn.Prop(BMbusHistoryImportEntry.recordNumber), new MgrColumn.Prop(BMbusHistoryImportEntry.messageSlotNumber), new MgrColumn.Prop(BMbusHistoryImportEntry.facets), new MgrColumn.Prop(BMbusHistoryImportEntry.historyId), new MgrColumn.Prop(BMbusHistoryImportEntry.manuSpecDefElementOrd), new MgrColumn.Prop(BMbusHistoryImportEntry.storageNumber)};
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return false;
        }

        public BImage getIcon(Object dis) {
            return icon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return BMbusHistoryImportManager.this.getModel().getNewTypes();
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BMbusHistoryImportEntry entry = (BMbusHistoryImportEntry)dis;
            row.setCell(BMbusHistoryImportManager.this.colDescription, (BValue)BString.make((String)entry.getDescription()));
            row.setCell(BMbusHistoryImportManager.this.colOrthoDescription, (BValue)entry.getOrthogonalDescription());
            row.setCell(BMbusHistoryImportManager.this.colFunction, (BValue)entry.getFunction());
            row.setCell(BMbusHistoryImportManager.this.colMbusUnit, (BValue)entry.getMbusUnit());
            row.setCell(BMbusHistoryImportManager.this.colExponent, (BValue)BInteger.make((int)entry.getExponent()));
            row.setCell(BMbusHistoryImportManager.this.colMode, (BValue)BInteger.make((int)entry.getDeviceMode()));
            row.setCell(BMbusHistoryImportManager.this.colNumberType, (BValue)entry.getNumberType());
            row.setCell(BMbusHistoryImportManager.this.colRecordNumber, (BValue)BInteger.make((int)entry.getRecordNumber()));
            row.setCell(BMbusHistoryImportManager.this.colMsgSlotNumber, (BValue)BInteger.make((int)entry.getMessageSlotNumber()));
            row.setCell(BMbusHistoryImportManager.this.colStorageNumber, (BValue)BInteger.make((int)entry.getStorageNumber()));
            row.setCell(BMbusHistoryImportManager.this.colManuSpecDef, (BValue)entry.getManuSpecDefElementOrd());
            BUnit unitHold = BMbusUnit.getNiagaraUnits((BMbusUnit)entry.getMbusUnit());
            BFacets facetHold = BFacets.makeNumeric((BUnit)unitHold, (int)4);
            row.setCell(BMbusHistoryImportManager.this.colFacets, (BValue)facetHold);
            row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)entry.getHistoryId());
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BMbusHistoryImportEntry entry = (BMbusHistoryImportEntry)discovery;
                return entry.is(component);
            }
            catch (Throwable e) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace((String)"Error asking is device is existing");
                }
                return false;
            }
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BMbusHistoryImportManager.this.updateDiscoveryRows((BComponent)job);
        }
    }

    private class MbusImportModel
    extends ImportModel {
        public MbusImportModel(BMbusHistoryImportManager importManager) {
            super((BHistoryImportManager)importManager);
        }

        protected MgrColumn[] makeColumns() {
            Array colArray = new Array(MgrColumn.class);
            colArray.add((Object)BMbusHistoryImportManager.this.colDescription);
            colArray.add((Object)BMbusHistoryImportManager.this.colMbusUnit);
            colArray.add((Object)BMbusHistoryImportManager.this.colOrthoDescription);
            colArray.add((Object)BMbusHistoryImportManager.this.colFunction);
            colArray.add((Object)BMbusHistoryImportManager.this.colExponent);
            colArray.add((Object)BMbusHistoryImportManager.this.colNumberType);
            colArray.add((Object)BMbusHistoryImportManager.this.colMode);
            colArray.add((Object)BMbusHistoryImportManager.this.colRecordNumber);
            colArray.add((Object)BMbusHistoryImportManager.this.colMsgSlotNumber);
            colArray.add((Object)BMbusHistoryImportManager.this.colFacets);
            colArray.add((Object)BMbusHistoryImportManager.this.colStorageNumber);
            colArray.add((Object)BMbusHistoryImportManager.this.colConversion);
            colArray.add((Object)BMbusHistoryImportManager.this.colManuSpecDef);
            colArray.addAll((Object[])super.makeColumns());
            return (MgrColumn[])colArray.trim();
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BMbusHistoryImport.TYPE);
        }
    }
}

