/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.jobs.BMbusTxRxProfile;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDiscoveryCommSpeedSelectPane
extends BGridPane {
    public static final Action speedChanged = BDiscoveryCommSpeedSelectPane.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action customisedSpeed = BDiscoveryCommSpeedSelectPane.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BDiscoveryCommSpeedSelectPane.class);
    private DiscoveryCommSpeedListener speedListener = null;
    private ToggleCommandGroup<ToggleCommand> selectionGroup = new ToggleCommandGroup();
    private BRadioButton mbusStandardSpeedScanButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryCommSpeedSelectPane.mbusStandardSpeedScan"));
    private BRadioButton mbusSlowSpeedScanButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryCommSpeedSelectPane.mbusSlowSpeedScan"));
    private BRadioButton mbusCustomisedSpeedScanButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryCommSpeedSelectPane.mbusCustomisedSpeedScan"));
    private BGridPane speedsSelectedPane;
    private BWbFieldEditor retryFe;
    private BWbFieldEditor respTimeoutFe;
    private BWbFieldEditor intMsgDelayFe;
    private BWbFieldEditor initDelayFe;

    public void speedChanged(BWidgetEvent event) {
        this.invoke(speedChanged, (BValue)event, null);
    }

    public void customisedSpeed(BWidgetEvent event) {
        this.invoke(customisedSpeed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDiscoveryCommSpeedSelectPane() {
        this.init();
    }

    public BDiscoveryCommSpeedSelectPane(DiscoveryCommSpeedListener speedListener) {
        this.speedListener = speedListener;
        this.init();
    }

    private void init() {
        this.setColumnCount(1);
        this.add(null, (BValue)this.mbusStandardSpeedScanButton);
        this.add(null, (BValue)this.mbusSlowSpeedScanButton);
        this.add(null, (BValue)this.mbusCustomisedSpeedScanButton);
        this.speedsSelectedPane = new BGridPane();
        this.speedsSelectedPane.setColumnCount(2);
        BLabel retryCountLbl = new BLabel(MbusToolkit.lex.get("BDiscoveryCommSpeedPane.retryCount", "Retry count: "));
        this.speedsSelectedPane.add(null, (BValue)retryCountLbl);
        this.retryFe = BWbFieldEditor.makeFor((BObject)BInteger.make((int)2));
        this.speedsSelectedPane.add(null, (BValue)this.retryFe);
        BLabel respTimeoutLbl = new BLabel(MbusToolkit.lex.get("BDiscoveryCommSpeedPane.responseTimeout", "Response timeout: "));
        this.speedsSelectedPane.add(null, (BValue)respTimeoutLbl);
        this.respTimeoutFe = BWbFieldEditor.makeFor((BObject)BRelTime.SECOND);
        this.speedsSelectedPane.add(null, (BValue)this.respTimeoutFe);
        BLabel intMsgDelayLbl = new BLabel(MbusToolkit.lex.get("BDiscoveryCommSpeedPane.intermessageDelay", "Intermessage delay: "));
        this.speedsSelectedPane.add(null, (BValue)intMsgDelayLbl);
        this.intMsgDelayFe = BWbFieldEditor.makeFor((BObject)BRelTime.SECOND);
        this.speedsSelectedPane.add(null, (BValue)this.intMsgDelayFe);
        BLabel initDelayLbl = new BLabel(MbusToolkit.lex.get("BDiscoveryCommSpeedPane.initDelay", "Initalisation delay: "));
        this.speedsSelectedPane.add(null, (BValue)initDelayLbl);
        this.initDelayFe = BWbFieldEditor.makeFor((BObject)BRelTime.SECOND);
        this.speedsSelectedPane.add(null, (BValue)this.initDelayFe);
        this.add(null, (BValue)this.speedsSelectedPane);
        this.linkTo("mbusStandardSpeedLink", (BComponent)this.mbusStandardSpeedScanButton, (Slot)BAbstractButton.actionPerformed, (Slot)speedChanged);
        this.linkTo("slowSpeedLink", (BComponent)this.mbusSlowSpeedScanButton, (Slot)BAbstractButton.actionPerformed, (Slot)speedChanged);
        this.linkTo("networkSpeedLink", (BComponent)this.mbusCustomisedSpeedScanButton, (Slot)BAbstractButton.actionPerformed, (Slot)speedChanged);
        if (this.retryFe.getTopic(BWbPlugin.pluginModified.getName()) != null) {
            this.linkTo(null, (BComponent)this.retryFe, (Slot)BWbPlugin.pluginModified, (Slot)customisedSpeed);
        }
        if (this.respTimeoutFe.getTopic(BWbPlugin.pluginModified.getName()) != null) {
            this.linkTo(null, (BComponent)this.respTimeoutFe, (Slot)BWbPlugin.pluginModified, (Slot)customisedSpeed);
        }
        if (this.intMsgDelayFe.getTopic(BWbPlugin.pluginModified.getName()) != null) {
            this.linkTo(null, (BComponent)this.intMsgDelayFe, (Slot)BWbPlugin.pluginModified, (Slot)customisedSpeed);
        }
        if (this.initDelayFe.getTopic(BWbPlugin.pluginModified.getName()) != null) {
            this.linkTo(null, (BComponent)this.initDelayFe, (Slot)BWbPlugin.pluginModified, (Slot)customisedSpeed);
        }
        this.mbusStandardSpeedScanButton.setSelected(true);
        this.doSpeedChanged(new BWidgetEvent(1, (BWidget)this.mbusStandardSpeedScanButton));
    }

    public void doCustomisedSpeed(BWidgetEvent event) {
        if (!this.mbusCustomisedSpeedScanButton.isSelected()) {
            this.mbusCustomisedSpeedScanButton.setSelected(true);
            return;
        }
        this.doSpeedChanged(event);
    }

    public void doSpeedChanged(BWidgetEvent event) {
        if (this.mbusStandardSpeedScanButton.isSelected()) {
            this.retryFe.loadValue((BObject)BInteger.make((int)2));
            this.respTimeoutFe.loadValue((BObject)BRelTime.makeSeconds((int)2));
            this.intMsgDelayFe.loadValue((BObject)BRelTime.make((long)300L));
            this.initDelayFe.loadValue((BObject)BRelTime.SECOND);
            this.speedsSelectedPane.repaint();
            return;
        }
        if (this.mbusSlowSpeedScanButton.isSelected()) {
            this.retryFe.loadValue((BObject)BInteger.make((int)2));
            this.respTimeoutFe.loadValue((BObject)BRelTime.makeSeconds((int)10));
            this.intMsgDelayFe.loadValue((BObject)BRelTime.make((long)300L));
            this.initDelayFe.loadValue((BObject)BRelTime.makeSeconds((int)5));
            this.speedsSelectedPane.repaint();
            return;
        }
        if (this.speedListener != null) {
            this.speedListener.speedChanged();
        }
    }

    public BMbusTxRxProfile getTxRxProfile() {
        BMbusTxRxProfile profile = new BMbusTxRxProfile();
        try {
            profile.setRetryCount(((BInteger)this.retryFe.saveValue()).getInt());
            profile.setInitialisationDelay((BRelTime)this.initDelayFe.saveValue());
            profile.setResponseTimeout((BRelTime)this.respTimeoutFe.saveValue());
            profile.setInterMessageDelay((BRelTime)this.intMsgDelayFe.saveValue());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return profile;
    }

    public static interface DiscoveryCommSpeedListener {
        public void speedChanged();
    }
}

