/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iothub;

import com.tridium.cloud.client.iothub.BAbstractIotHubConnectorImpl;
import com.tridium.cloud.client.iothub.BConnectionStringState;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="connectionStringStatus", type="BConnectionStringState", defaultValue="BConnectionStringState.empty", flags=3)
@NiagaraAction(name="setConnectionString", parameterType="BString", defaultValue="BString.DEFAULT")
public final class BIotHubConnectorImpl
extends BAbstractIotHubConnectorImpl {
    public static final Property connectionStringStatus = BIotHubConnectorImpl.newProperty((int)3, (BValue)BConnectionStringState.empty, null);
    public static final Action setConnectionString = BIotHubConnectorImpl.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BIotHubConnectorImpl.class);
    private static final Map<String, String> PARAM_CONVERSION_MAP = new HashMap<String, String>();
    private static final String connectionStringPropName = "connectionString";
    private final Map<String, String> connectionInfoMap = new HashMap<String, String>();
    private static final Logger log;

    public BConnectionStringState getConnectionStringStatus() {
        return (BConnectionStringState)this.get(connectionStringStatus);
    }

    public void setConnectionStringStatus(BConnectionStringState v) {
        this.set(connectionStringStatus, (BValue)v, null);
    }

    public void setConnectionString(BString parameter) {
        this.invoke(setConnectionString, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.getConnectionString().isEmpty()) {
            this.parseConnectionString(this.getConnectionString());
            this.setConnectionStringStatus(BConnectionStringState.loaded);
        }
    }

    protected void doPing() throws Exception {
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "cloudIoTHubConnector");
    }

    @Override
    protected String getConnectionString() {
        BString connectionString = (BString)this.get(connectionStringPropName);
        return connectionString != null ? connectionString.toString() : "";
    }

    @Override
    public Map<String, String> getConnectionInfo(String id) {
        return this.connectionInfoMap;
    }

    public void doSetConnectionString(BString connectionString, Context cx) {
        if (connectionString.toString().isEmpty()) {
            if (this.get(connectionStringPropName) != null) {
                this.remove(connectionStringPropName);
            }
            this.setConnectionStringStatus(BConnectionStringState.empty);
        } else {
            if (this.get(connectionStringPropName) != null) {
                this.set(connectionStringPropName, (BValue)connectionString, cx);
            } else {
                this.add(connectionStringPropName, (BValue)connectionString, 5, BFacets.DEFAULT, cx);
            }
            this.setConnectionStringStatus(BConnectionStringState.loaded);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Connection String has been updated");
        }
        this.parseConnectionString(connectionString.toString());
        this.getCloudConnector().reconnectAsync("IotHubConnectorImpl.doSetConnectionString()");
    }

    private void parseConnectionString(String connectionString) {
        String[] kvPairs;
        this.connectionInfoMap.clear();
        for (String pair : kvPairs = connectionString.split(";")) {
            String[] parts = pair.split("=");
            this.connectionInfoMap.put(this.convertParamName(parts[0]), parts[1]);
        }
    }

    private String convertParamName(String s) {
        String newS = PARAM_CONVERSION_MAP.get(s);
        return newS != null ? newS : s;
    }

    static {
        PARAM_CONVERSION_MAP.put("HostName", "hostName");
        PARAM_CONVERSION_MAP.put("DeviceId", "id");
        PARAM_CONVERSION_MAP.put("SharedAccessSignature", "token");
        log = Logger.getLogger("cloud.iothub");
    }
}

