/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import org.apache.batik.util.ParsedURLData;

public class OrdParsedURLData
extends ParsedURLData {
    public static final String PROTOCOL = "ord";
    private BOrd ord;

    public OrdParsedURLData(BOrd ord, String ref) {
        if (ord == null) {
            throw new IllegalArgumentException("ORD required");
        }
        this.protocol = PROTOCOL;
        String ordString = ord.toString();
        if (ordString.indexOf(35) >= 0) {
            throw new IllegalArgumentException("ORD cannot contain a '#' character");
        }
        if (ref != null && ref.indexOf(35) >= 0) {
            throw new IllegalArgumentException("ref cannot contain a '#' character");
        }
        this.path = ordString;
        this.ord = ord;
        this.ref = ref;
    }

    @Override
    public InputStream openStream(String userAgent, Iterator mimeTypes) throws IOException {
        BIFile file = (BIFile)this.ord.get();
        return new ByteArrayInputStream(file.read());
    }

    @Override
    public InputStream openStreamRaw(String userAgent, Iterator mimeTypes) throws IOException {
        return this.openStream(userAgent, mimeTypes);
    }

    @Override
    public String toString() {
        return "ord://" + this.ord + (this.ref == null ? "" : "#" + this.ref);
    }

    @Override
    public boolean complete() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.ord.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OrdParsedURLData)) {
            return false;
        }
        OrdParsedURLData data = (OrdParsedURLData)o;
        if (!this.ord.equals((Object)data.ord)) {
            return false;
        }
        if (this.ref == null) {
            return data.ref == null;
        }
        return this.ref.equals(data.ref);
    }

    @Override
    protected boolean sameFile(ParsedURLData other) {
        if (!(other instanceof OrdParsedURLData)) {
            return false;
        }
        OrdParsedURLData data = (OrdParsedURLData)other;
        return this.ord.equals((Object)data.ord);
    }
}

