/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.block.DataRecoveryBlock;

public final class FreeDataRecoveryBlock
extends DataRecoveryBlock {
    public FreeDataRecoveryBlock(int desiredSize, boolean includingHeader) throws Exception {
        if (desiredSize < 0) {
            throw new Exception("Invalid desiredSize!");
        }
        if (includingHeader) {
            if (desiredSize < this.getHeaderSize()) {
                throw new Exception("Requested free block size is too small to contain header");
            }
            this.sourceSpace = 0;
            this.keyInSourceSpaceSize = 0;
            this.keyInSourceSpace = null;
            this.payloadSize = desiredSize - this.getHeaderSize();
            this.payload = null;
        } else {
            this.sourceSpace = 0;
            this.keyInSourceSpaceSize = 0;
            this.keyInSourceSpace = null;
            this.payloadSize = desiredSize;
            this.payload = null;
        }
    }

    @Override
    public final DataRecoveryBlock coalesce(DataRecoveryBlock toMerge) throws Exception {
        if (!(toMerge instanceof FreeDataRecoveryBlock)) {
            throw new UnsupportedOperationException("Can not merge data recovery blocks of different type (toMerge != FreeDataRecoveryBlock)");
        }
        FreeDataRecoveryBlock freeBlockToMerge = (FreeDataRecoveryBlock)toMerge;
        this.payloadSize += freeBlockToMerge.getTotalSize();
        return this;
    }

    @Override
    public byte getBlockState() {
        return 0;
    }

    public void setFreespace(int desiredSize, boolean includingHeader) throws Exception {
        if (desiredSize < 0) {
            throw new Exception("Invalid desiredSize!");
        }
        if (includingHeader) {
            if (desiredSize < this.getHeaderSize()) {
                throw new Exception("Requested free block size is too small to contain header");
            }
            this.payloadSize = desiredSize - this.getHeaderSize();
        } else {
            this.payloadSize = desiredSize;
        }
    }
}

