/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.block.FreeDataRecoveryBlock;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInvalidException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

public abstract class DataRecoveryBlock
implements Comparable<DataRecoveryBlock> {
    public static final byte MAGIC_START_BYTE = -2;
    public static final byte MAGIC_END_BYTE = -17;
    protected byte sourceSpace = 0;
    protected int keyInSourceSpaceSize = 0;
    protected byte[] keyInSourceSpace = null;
    protected int payloadSize = 0;
    protected byte[] payload = null;
    private volatile byte[] serializedForm = null;
    private static final ByteBuffer bufferUtil = new ByteBuffer();
    private static final Object bufferMonitor = new Object();
    private static boolean debug = false;
    static long maxReadSize = 0L;
    static int freeBlockHeaderSize = 0;
    static int fixedFieldsOfUsedBlockHeaderSize = 0;
    public static final byte BLOCK_STATE_FREE = 0;
    public static final byte BLOCK_STATE_USED = 1;

    public final int getTotalSize() {
        return this.getPayloadSize() + this.getHeaderSize();
    }

    protected final int getHeaderSize() {
        if (this.getBlockState() == 0) {
            return freeBlockHeaderSize;
        }
        return fixedFieldsOfUsedBlockHeaderSize + this.getKeyInSourceSpaceSize();
    }

    protected final int getPayloadSize() {
        return this.payloadSize;
    }

    protected final int getKeyInSourceSpaceSize() {
        if (this.getBlockState() == 0) {
            throw new BajaRuntimeException("Free data recovery block does not have key size");
        }
        return this.keyInSourceSpaceSize;
    }

    public final int getOverheadSpace() {
        if (this.getBlockState() == 0) {
            return 0;
        }
        return fixedFieldsOfUsedBlockHeaderSize;
    }

    public final int getUsedSpace() {
        if (this.getBlockState() == 0) {
            return 0;
        }
        return this.getKeyInSourceSpaceSize() + this.getPayloadSize();
    }

    public final int getFreeSpace() {
        if (this.getBlockState() == 0) {
            return this.getTotalSize();
        }
        return 0;
    }

    public final byte getSpaceIdentifier() {
        if (this.getBlockState() == 0) {
            throw new BajaRuntimeException("Free data recovery block does not have source identifier");
        }
        return this.sourceSpace;
    }

    public final byte[] getKeyInSourceSpace() {
        if (this.getBlockState() == 0) {
            throw new BajaRuntimeException("Free data recovery block does not have key");
        }
        return this.keyInSourceSpace;
    }

    public final byte[] getPayload() {
        if (this.getBlockState() == 0) {
            throw new BajaRuntimeException("Free data recovery block does not have payload");
        }
        return this.payload;
    }

    public abstract byte getBlockState();

    public abstract DataRecoveryBlock coalesce(DataRecoveryBlock var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(DataOutput output) throws Exception {
        byte[] localSerializeForm;
        long ticks = 0L;
        if (debug) {
            ticks = Clock.ticks();
        }
        if ((localSerializeForm = this.serializedForm) == null) {
            Object object = bufferMonitor;
            synchronized (object) {
                localSerializeForm = this.serializedForm;
                if (localSerializeForm == null) {
                    bufferUtil.reset();
                    bufferUtil.writeByte(-2);
                    bufferUtil.writeByte((int)this.getBlockState());
                    if (this.getBlockState() == 1) {
                        bufferUtil.writeByte((int)this.sourceSpace);
                        bufferUtil.writeShort(this.keyInSourceSpaceSize);
                        bufferUtil.write(this.keyInSourceSpace, 0, this.keyInSourceSpaceSize);
                        bufferUtil.writeInt(this.payloadSize);
                        bufferUtil.write(this.payload, 0, this.payloadSize);
                        bufferUtil.writeByte(-17);
                    } else if (this.getBlockState() == 0) {
                        bufferUtil.writeInt(this.payloadSize);
                    }
                    this.serializedForm = localSerializeForm = bufferUtil.toByteArray();
                }
            }
        }
        try {
            output.write(this.serializedForm);
        }
        catch (IOException exception) {
            throw new IOException("IOException occurred while writing data recovery: " + exception.getMessage());
        }
        if (debug && ticks != 0L) {
            System.out.println("DataRecoveryBlock::write() took: " + (Clock.ticks() - ticks) + " ms");
        }
    }

    public static DataRecoveryBlock read(DataInput input) throws Exception {
        DataRecoveryBlock result;
        byte magicStart;
        long ticks = 0L;
        if (debug) {
            ticks = Clock.ticks();
        }
        byte sourceSpace = 0;
        short keySize = 0;
        byte[] temporaryDataRecoveryKeyInSpace = null;
        int payloadSize = 0;
        boolean inputIsRAF = input instanceof RandomAccessFile;
        if (debug) {
            if (inputIsRAF) {
                System.out.println("DataRecoveryBlock::read() reading random access file");
            } else {
                System.out.println("DataRecoveryBlock::read() reading standard input");
            }
        }
        if ((magicStart = (byte)input.readUnsignedByte()) != -2) {
            if (debug) {
                System.out.println("DataRecoveryBlock::read() read non-magic starting byte: " + magicStart);
            }
            DataRecoveryBlockInvalidException cdbie = new DataRecoveryBlockInvalidException("MAGIC_START_BYTE not found");
            cdbie.setMagicStartByteInvalid();
            throw cdbie;
        }
        try {
            byte blockState = (byte)input.readUnsignedByte();
            if (blockState != 0 && blockState != 1) {
                throw new DataRecoveryBlockInvalidException("Invalid BLOCK_STATE: " + blockState);
            }
            if (debug) {
                switch (blockState) {
                    case 0: {
                        System.out.println("DataRecoveryBlock::read() reading free block");
                        break;
                    }
                    case 1: {
                        System.out.println("DataRecoveryBlock::read() reading used block");
                    }
                }
            }
            if (blockState != 0) {
                sourceSpace = (byte)input.readUnsignedByte();
                keySize = input.readShort();
                if (keySize < 0 || maxReadSize > 0L && (long)keySize > maxReadSize) {
                    throw new DataRecoveryBlockInvalidException("Invalid key size: " + keySize);
                }
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() read key size: " + keySize);
                }
                temporaryDataRecoveryKeyInSpace = new byte[keySize];
                if (inputIsRAF) {
                    int numRead = ((RandomAccessFile)input).read(temporaryDataRecoveryKeyInSpace, 0, keySize);
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read " + numRead + " key size bytes");
                    }
                    if (numRead != keySize) {
                        throw new DataRecoveryBlockInvalidException("Key bytes expectation failed: " + numRead + " != " + keySize);
                    }
                } else {
                    input.readFully(temporaryDataRecoveryKeyInSpace, 0, keySize);
                }
            }
            if ((payloadSize = input.readInt()) < 0 || maxReadSize > 0L && (long)payloadSize > maxReadSize) {
                throw new DataRecoveryBlockInvalidException("Invalid payload size: " + payloadSize);
            }
            if (debug) {
                System.out.println("DataRecoveryBlock::read() read payload size: " + payloadSize);
            }
            if (blockState == 0) {
                int skipped = input.skipBytes(payloadSize);
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() skipped " + skipped + " free payload bytes");
                }
                if (skipped != payloadSize) {
                    throw new DataRecoveryBlockInvalidException("Free payload bytes expectation failed: " + skipped + " != " + payloadSize);
                }
                result = new FreeDataRecoveryBlock(payloadSize, false);
            } else {
                byte[] temporaryPayload = new byte[payloadSize];
                if (inputIsRAF) {
                    int numRead = ((RandomAccessFile)input).read(temporaryPayload, 0, payloadSize);
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read " + numRead + " payload bytes");
                    }
                    if (numRead != payloadSize) {
                        throw new DataRecoveryBlockInvalidException("Used payload bytes expectation failed: " + numRead + " != " + payloadSize);
                    }
                } else {
                    input.readFully(temporaryPayload, 0, payloadSize);
                }
                byte magicEnd = (byte)input.readUnsignedByte();
                if (magicEnd != -17) {
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read non-magic ending byte: " + magicEnd);
                    }
                    DataRecoveryBlockInvalidException cdbie = new DataRecoveryBlockInvalidException("MAGIC_END_BYTE not found");
                    cdbie.setMagicEndByteInvalid();
                    throw cdbie;
                }
                result = new UsedDataRecoveryBlock(sourceSpace, keySize, temporaryDataRecoveryKeyInSpace, payloadSize, temporaryPayload);
            }
        }
        catch (EOFException eof) {
            throw new DataRecoveryBlockInvalidException("Unexpected EOF while reading block");
        }
        if (debug) {
            System.out.println("DataRecoveryBlock::read() created data recovery block with total size: " + result.getTotalSize());
        }
        if (debug && ticks != 0L) {
            System.out.println("DataRecoveryBlock::read() took: " + (Clock.ticks() - ticks) + " ms");
        }
        return result;
    }

    @Override
    public int compareTo(DataRecoveryBlock o) {
        if (o != null) {
            if (this.getBlockState() == 0 == (o.getBlockState() == 0)) {
                return 0;
            }
            if (this.getBlockState() == 0 && o.getBlockState() != 0) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    public static void resetMaxReadsize() {
        maxReadSize = 0L;
    }

    public static int getFreeBlockHeaderSize() {
        return freeBlockHeaderSize;
    }

    public static int getFixedFieldsOfUsedBlockHeaderSize() {
        return fixedFieldsOfUsedBlockHeaderSize;
    }

    public final void visual(PrintStream out) {
        if (this.getBlockState() == 0) {
            out.println("/------------\\");
            out.println("[ Free: " + this.getTotalSize() + "  ]  ");
            out.println("\\------------/");
        } else if (this.getBlockState() == 1) {
            out.println("/------------\\");
            out.println("[ Used: " + this.getTotalSize() + "  ] key = " + TextUtil.bytesToHexString((byte[])this.keyInSourceSpace) + " value: " + TextUtil.bytesToHexString((byte[])this.payload));
            out.println("\\------------/");
        }
    }

    static {
        try {
            debug = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.platDataRecovery.blockDebug"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ByteBuffer usedBuffer = new ByteBuffer();
        usedBuffer.writeByte(-2);
        usedBuffer.writeByte(-17);
        usedBuffer.writeByte(0);
        usedBuffer.writeByte(0);
        usedBuffer.writeShort(0);
        usedBuffer.writeInt(0);
        fixedFieldsOfUsedBlockHeaderSize = usedBuffer.toByteArray().length;
        ByteBuffer freeBuffer = new ByteBuffer();
        freeBuffer.writeByte(-2);
        freeBuffer.writeByte(0);
        freeBuffer.writeInt(0);
        freeBlockHeaderSize = freeBuffer.toByteArray().length;
    }
}

