/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.BDataRecoveryService;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.block.DataRecoveryWriteResponse;
import com.tridium.platDataRecovery.block.FreeDataRecoveryBlock;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInactiveException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreUnavailableException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDataRecoveryBlockAppendManager
extends BDataRecoveryBlockManager {
    public static final Type TYPE = Sys.loadType(BDataRecoveryBlockAppendManager.class);
    private DataOutputStream activeFileDataOutputStream = null;
    private FileOutputStream activeFileFileOutputStream = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void openActiveFile(String activeFileName) throws Exception {
        boolean trace = log.isLoggable(Level.FINEST);
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("Data recovery directories are not initialized");
        }
        if (activeFileName == null) {
            throw new NullPointerException("Can not open null activeFileName");
        }
        if (this.activeFileOpen) {
            if (trace) {
                log.finest("Data recovery active file already open");
            }
            if (this.file.getName().equals(activeFileName)) {
                return;
            }
            this.closeActiveFile();
        }
        if (trace) {
            log.finest("Opening active data recovery store with filename: " + activeFileName);
        }
        Object object = activeDirectoryMonitor;
        synchronized (object) {
            block31: {
                this.file = new File(activeDirectory, activeFileName);
                boolean createdNew = false;
                if (!this.file.exists()) {
                    try {
                        createdNew = AccessController.doPrivileged(() -> {
                            if (!this.file.createNewFile()) {
                                throw new Exception("createNewFile() returned false");
                            }
                            return true;
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        this.file = null;
                        log.log(Level.SEVERE, "Error creating active data recovery file with name: " + activeFileName, pae.getException());
                        throw new DataRecoveryException("Error creating active data recovery file with name: " + activeFileName, (Throwable)pae.getException());
                    }
                } else if (this.file.isDirectory()) {
                    this.file = null;
                    log.log(Level.SEVERE, "Error creating active data recovery file with name: " + activeFileName + ", file was directory");
                    throw new DataRecoveryException("Error creating active data recovery file with name: " + activeFileName + ", file was directory");
                }
                try {
                    this.activeFileOpen = true;
                    if (!createdNew) {
                        if (trace) {
                            log.finest("Active data recovery file already existed at: " + this.file.getCanonicalPath() + ", reading contents.");
                        }
                        this.readFromActive();
                        break block31;
                    }
                    if (trace) {
                        log.finest("Formatting new active data recovery file at: " + this.file.getCanonicalPath());
                    }
                    Object pae = this.blocksMonitor;
                    synchronized (pae) {
                        if (this.blocks == null) {
                            this.blocks = new ArrayList();
                        } else {
                            this.blocks.clear();
                        }
                        FreeDataRecoveryBlock toAdd = new FreeDataRecoveryBlock(this.getMaxCapacity(), true);
                        this.blocks.add(toAdd);
                        try {
                            this.activeFileFileOutputStream = AccessController.doPrivileged(() -> new FileOutputStream(this.file, false));
                        }
                        catch (PrivilegedActionException pae2) {
                            throw pae2.getException();
                        }
                        this.activeFileDataOutputStream = new DataOutputStream(this.activeFileFileOutputStream);
                        Object object2 = this.sizeMonitor;
                        synchronized (object2) {
                            this.setUsedSpace(toAdd.getUsedSpace());
                            this.setFreeSpace(toAdd.getFreeSpace());
                            this.setOverheadSpace(toAdd.getOverheadSpace());
                            if (chunkSize > 0) {
                                this.remainingChunks = totalChunks;
                            }
                            if (this.isSubscribed()) {
                                this.fireSizesUpdated(null);
                                this.lastMillisFired = System.currentTimeMillis();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error creating/reading active data recovery file: " + this.file.getName(), e);
                    throw new DataRecoveryException("Error creating/reading active data recovery file: " + this.file.getName(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public final void closeActiveFile() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryException("Active data recovery file is not open, can not close");
        }
        if (this.file.isDirectory()) {
            throw new DataRecoveryException("Active data recovery file was folder, can not close");
        }
        try {
            this.activeFileDataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.activeFileDataOutputStream = null;
        this.activeFileOpen = false;
        if (BDataRecoveryService.chunkFSPresent) {
            try {
                this.activeFileFileOutputStream = AccessController.doPrivileged(() -> new FileOutputStream(this.file, false));
            }
            catch (PrivilegedActionException pae) {
                log.log(Level.WARNING, "Error truncating the active file: " + this.file.getName(), pae.getException());
            }
            try {
                this.activeFileFileOutputStream.close();
            }
            catch (Exception pae) {}
        } else if (this.file.exists()) {
            boolean deleted = false;
            try {
                deleted = AccessController.doPrivileged(this.file::delete);
            }
            catch (PrivilegedActionException pae) {
                log.log(Level.WARNING, "Error deleting the active file: " + this.file.getName(), pae.getException());
            }
            if (!deleted) {
                log.log(Level.SEVERE, "Could not delete active data recovery file: " + this.file.getName() + ", truncating instead");
                try {
                    this.activeFileFileOutputStream = AccessController.doPrivileged(() -> new FileOutputStream(this.file, false));
                }
                catch (PrivilegedActionException pae) {
                    log.log(Level.WARNING, "Error truncating the active file: " + this.file.getName(), pae.getException());
                }
                try {
                    this.activeFileFileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.activeFileFileOutputStream = null;
        this.file = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Leaving BDataRecoveryBlockAppendManager::closeActiveFile()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void readFromActive() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            try {
                long fileLength;
                long ticks = 0L;
                if (debug) {
                    ticks = Clock.ticks();
                }
                if (this.blocks != null) {
                    this.blocks.clear();
                } else {
                    this.blocks = new ArrayList();
                }
                DataRecoveryBlock.maxReadSize = fileLength = BDataRecoveryService.lengthOfFile(this.file);
                long currentPositionInStream = 0L;
                long currentChunkPositionInStream = 0L;
                DataInputStream activeFileInput = new DataInputStream(new FileInputStream(this.file));
                while (currentPositionInStream < fileLength) {
                    if (debug) {
                        System.out.println("ActiveFileInput.currentPosition: " + currentPositionInStream);
                        System.out.println("ActiveFileInput.length(): " + fileLength);
                    }
                    try {
                        DataRecoveryBlock current = DataRecoveryBlock.read(activeFileInput);
                        currentPositionInStream += (long)current.getTotalSize();
                        if (chunkSize > 0) {
                            int requiredChunkSize = current.getTotalSize() / chunkSize;
                            if (current.getTotalSize() % chunkSize != 0) {
                                ++requiredChunkSize;
                            }
                            currentChunkPositionInStream += (long)(requiredChunkSize * chunkSize);
                        }
                        this.blocks.add(current);
                    }
                    catch (DataRecoveryException cde) {
                        log.log(Level.SEVERE, "Error while reading in data recovery: ", cde);
                        break;
                    }
                }
                if (chunkSize < 0) {
                    if (currentPositionInStream < (long)this.getMaxCapacity()) {
                        int difference = (int)((long)this.getMaxCapacity() - currentPositionInStream);
                        this.blocks.add(new FreeDataRecoveryBlock(difference, true));
                    }
                } else if (currentChunkPositionInStream < (long)this.getMaxCapacity()) {
                    int difference = (int)((long)this.getMaxCapacity() - currentChunkPositionInStream);
                    this.blocks.add(new FreeDataRecoveryBlock(difference, true));
                }
                try {
                    activeFileInput.close();
                }
                catch (Exception difference) {
                    // empty catch block
                }
                try {
                    this.activeFileFileOutputStream = AccessController.doPrivileged(() -> new FileOutputStream(this.file, true));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                this.activeFileDataOutputStream = new DataOutputStream(this.activeFileFileOutputStream);
                if (debug && ticks != 0L) {
                    System.out.println("BDataRecoveryBlockManager::readFromActive() took: " + (Clock.ticks() - ticks) + " ms");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error reading blocks: ", e);
                throw e;
            }
            this.recalculateSpace();
        }
    }

    @Override
    protected final void writeToActive() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void formatActiveFile() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            if (this.blocks == null) {
                this.blocks = new ArrayList();
            } else {
                this.blocks.clear();
            }
            FreeDataRecoveryBlock toAdd = new FreeDataRecoveryBlock(this.getMaxCapacity(), true);
            this.blocks.add(toAdd);
            try {
                try {
                    if (this.activeFileDataOutputStream != null) {
                        this.activeFileDataOutputStream.close();
                        this.activeFileDataOutputStream = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.activeFileFileOutputStream = AccessController.doPrivileged(() -> {
                        if (!this.file.exists() && !this.file.createNewFile()) {
                            throw new Exception("createNewFile() returned false");
                        }
                        return new FileOutputStream(this.file, false);
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                this.activeFileDataOutputStream = new DataOutputStream(this.activeFileFileOutputStream);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error formatting data recovery database: ", e);
            }
            Object object2 = this.sizeMonitor;
            synchronized (object2) {
                this.setUsedSpace(toAdd.getUsedSpace());
                this.setFreeSpace(toAdd.getFreeSpace());
                this.setOverheadSpace(toAdd.getOverheadSpace());
                if (chunkSize > 0) {
                    this.remainingChunks = totalChunks;
                }
                if (this.isSubscribed()) {
                    this.fireSizesUpdated(null);
                    this.lastMillisFired = System.currentTimeMillis();
                }
            }
        }
    }

    @Override
    public final boolean isActiveOpen() {
        return this.activeFileOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final DataRecoveryWriteResponse appendData(byte sourceSpaceIdentifier, byte[] recoveryKeyInSpace, byte[] dataToAdd) throws DataRecoveryException {
        int resultingByteSizeOfUsedBlock;
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        int resultingChunkSizeOfUsedBlock = 0;
        if (chunkSize <= 0) {
            resultingByteSizeOfUsedBlock = dataToAdd.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize + recoveryKeyInSpace.length;
            if (resultingByteSizeOfUsedBlock > this.getMaxCapacity()) {
                return DataRecoveryWriteResponse.TOO_LARGE;
            }
        } else {
            resultingByteSizeOfUsedBlock = dataToAdd.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize + recoveryKeyInSpace.length;
            resultingChunkSizeOfUsedBlock = resultingByteSizeOfUsedBlock / chunkSize;
            if (resultingByteSizeOfUsedBlock % chunkSize != 0) {
                ++resultingChunkSizeOfUsedBlock;
            }
            resultingByteSizeOfUsedBlock = resultingChunkSizeOfUsedBlock * chunkSize;
            if (resultingChunkSizeOfUsedBlock > totalChunks) {
                return DataRecoveryWriteResponse.TOO_LARGE;
            }
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            boolean added;
            int indexOfLastBlock;
            BDataRecoveryBlockManagerStatus currentStatus = this.getCurrentManagerStatus();
            if (currentStatus != BDataRecoveryBlockManagerStatus.active && currentStatus != BDataRecoveryBlockManagerStatus.reserved) {
                throw new DataRecoveryBlockInactiveException("The current block is not active, append can not be accomplished at this time");
            }
            if (chunkSize <= 0) {
                if (resultingByteSizeOfUsedBlock > this.getFreeSpace()) {
                    if (!log.isLoggable(Level.FINEST)) return DataRecoveryWriteResponse.FULL;
                    log.finest("Size of used block exceeds free space, forcing flush of block");
                    return DataRecoveryWriteResponse.FULL;
                }
            } else if (resultingChunkSizeOfUsedBlock > this.remainingChunks) {
                if (!log.isLoggable(Level.FINEST)) return DataRecoveryWriteResponse.FULL;
                log.finest("Size of used block (" + resultingChunkSizeOfUsedBlock + " chunks) exceeds remaining chunk space (" + this.remainingChunks + "), forcing flush of block");
                return DataRecoveryWriteResponse.FULL;
            }
            if ((indexOfLastBlock = this.blocks.size() - 1) < 0) {
                log.log(Level.SEVERE, "Empty DataRecoveryBlockList when appending data.");
                return DataRecoveryWriteResponse.FAILURE;
            }
            DataRecoveryBlock lastBlockInList = (DataRecoveryBlock)this.blocks.get(indexOfLastBlock);
            if (lastBlockInList.getBlockState() != 0) return DataRecoveryWriteResponse.FULL;
            FreeDataRecoveryBlock lastFreeBlock = (FreeDataRecoveryBlock)lastBlockInList;
            if (lastFreeBlock.getFreeSpace() == resultingByteSizeOfUsedBlock) {
                try {
                    UsedDataRecoveryBlock newUsedBlock = new UsedDataRecoveryBlock(sourceSpaceIdentifier, recoveryKeyInSpace.length, recoveryKeyInSpace, dataToAdd.length, dataToAdd);
                    this.blocks.set(indexOfLastBlock, newUsedBlock);
                    newUsedBlock.write(this.activeFileDataOutputStream);
                    this.activeFileDataOutputStream.flush();
                    if (!BDataRecoveryService.chunkFSPresent) {
                        this.activeFileFileOutputStream.getFD().sync();
                    }
                    added = true;
                    Object object2 = this.sizeMonitor;
                    synchronized (object2) {
                        long currentMillis;
                        if (chunkSize <= 0) {
                            this.setFreeSpace(this.getFreeSpace() - lastFreeBlock.getFreeSpace());
                            this.setUsedSpace(this.getUsedSpace() + newUsedBlock.getUsedSpace());
                            this.setOverheadSpace(this.getOverheadSpace() + newUsedBlock.getOverheadSpace());
                        } else {
                            this.remainingChunks -= resultingChunkSizeOfUsedBlock;
                            int chunkOverhead = resultingChunkSizeOfUsedBlock * chunkSize - newUsedBlock.getTotalSize();
                            this.setFreeSpace(this.remainingChunks * chunkSize);
                            this.setUsedSpace(this.getUsedSpace() + newUsedBlock.getUsedSpace());
                            this.setOverheadSpace(this.getOverheadSpace() + newUsedBlock.getOverheadSpace() + chunkOverhead);
                        }
                        if (!this.isSubscribed() || (currentMillis = System.currentTimeMillis()) - this.lastMillisFired <= 1000L) return added ? DataRecoveryWriteResponse.SUCCESS : DataRecoveryWriteResponse.FAILURE;
                        this.fireSizesUpdated(null);
                        this.lastMillisFired = currentMillis;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Append data: error replacing same size free block with used block, aborting: ", e);
                    added = false;
                }
            } else {
                if (lastFreeBlock.getFreeSpace() <= resultingByteSizeOfUsedBlock) return DataRecoveryWriteResponse.FULL;
                try {
                    UsedDataRecoveryBlock newUsedBlock = new UsedDataRecoveryBlock(sourceSpaceIdentifier, recoveryKeyInSpace.length, recoveryKeyInSpace, dataToAdd.length, dataToAdd);
                    int desiredFreeSize = 0;
                    desiredFreeSize = chunkSize <= 0 ? lastFreeBlock.getTotalSize() - newUsedBlock.getTotalSize() : (this.remainingChunks - resultingChunkSizeOfUsedBlock) * chunkSize;
                    int extraFreeSpaceRemoved = 0;
                    if (desiredFreeSize >= DataRecoveryBlock.getFreeBlockHeaderSize()) {
                        lastFreeBlock.setFreespace(desiredFreeSize, true);
                        this.blocks.add(indexOfLastBlock + 1, lastFreeBlock);
                    } else {
                        extraFreeSpaceRemoved = desiredFreeSize;
                    }
                    this.blocks.set(indexOfLastBlock, newUsedBlock);
                    newUsedBlock.write(this.activeFileDataOutputStream);
                    this.activeFileDataOutputStream.flush();
                    if (!BDataRecoveryService.chunkFSPresent) {
                        this.activeFileFileOutputStream.getFD().sync();
                    }
                    added = true;
                    Object object3 = this.sizeMonitor;
                    synchronized (object3) {
                        long currentMillis;
                        if (chunkSize <= 0) {
                            this.setFreeSpace(this.getFreeSpace() - (newUsedBlock.getTotalSize() + extraFreeSpaceRemoved));
                            this.setUsedSpace(this.getUsedSpace() + newUsedBlock.getUsedSpace());
                            this.setOverheadSpace(this.getOverheadSpace() + newUsedBlock.getOverheadSpace());
                        } else {
                            this.remainingChunks -= resultingChunkSizeOfUsedBlock;
                            int chunkOverhead = resultingChunkSizeOfUsedBlock * chunkSize - newUsedBlock.getTotalSize();
                            this.setFreeSpace(this.remainingChunks * chunkSize);
                            this.setUsedSpace(this.getUsedSpace() + newUsedBlock.getUsedSpace());
                            this.setOverheadSpace(this.getOverheadSpace() + newUsedBlock.getOverheadSpace() + chunkOverhead);
                        }
                        if (!this.isSubscribed() || (currentMillis = System.currentTimeMillis()) - this.lastMillisFired <= 1000L) return added ? DataRecoveryWriteResponse.SUCCESS : DataRecoveryWriteResponse.FAILURE;
                        this.fireSizesUpdated(null);
                        this.lastMillisFired = currentMillis;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Append data: error adding used block in free block split, aborting: ", e);
                    added = false;
                }
            }
            return added ? DataRecoveryWriteResponse.SUCCESS : DataRecoveryWriteResponse.FAILURE;
        }
    }
}

