/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platDataRecovery.BDataRecoveryServiceStatus;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockAppendManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.BDataRecoveryFlushEvent;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.block.DataRecoveryWriteResponse;
import com.tridium.platDataRecovery.config.BDataRecoveryConfig;
import com.tridium.platDataRecovery.config.BDataRecoveryFullPolicy;
import com.tridium.platDataRecovery.config.BDataRecoveryPersistenceCapacity;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInactiveException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockUnavailableException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreFullException;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.util.EscUtil;
import com.tridium.util.ThrowableUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.DataRecoveryInvalidKeyException;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.DataRecoveryTooLargeException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.io.BIEncodable;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="dataRecoveryStatus", type="BDataRecoveryServiceStatus", defaultValue="BDataRecoveryServiceStatus.unknown", flags=3), @NiagaraProperty(name="lastStationSave", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="lastStationSaveSuccessful", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="persistentStorageSize", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.MIN, BFacets.MAX }, new BIDataValue[] { BUnit.make(\"kilobyte\", \"KB\", BDimension.NULL, 1024d), BDouble.make(0), BDouble.POSITIVE_INFINITY })")}), @NiagaraProperty(name="dataRecoveryConfiguration", type="BDataRecoveryConfig", defaultValue="new BDataRecoveryConfig()", flags=3), @NiagaraProperty(name="dataRecoveryBlocks", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="alertOnReplay", type="boolean", defaultValue="false"), @NiagaraProperty(name="dataRecoveryAlarmSupport", type="BPlatformAlarmSupport", defaultValue="initDataRecoveryAlarmSupport()"), @NiagaraProperty(name="dataRecoveryAlarmProxy", type="BPlatformAlarmProxy", defaultValue="new BPlatformAlarmProxy()", flags=6), @NiagaraProperty(name="tooManySaves", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="stationSaveLimit", type="int", defaultValue="3", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN }, new BIDataValue[] { BInteger.make(1) })")}), @NiagaraProperty(name="stationSaveLimitPeriod", type="BRelTime", defaultValue="BRelTime.make(BRelTime.MILLIS_IN_MINUTE * 15)", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.MIN, BFacets.SHOW_SECONDS }, new BIDataValue[] { BUnit.getUnit(\"minute\"), BRelTime.make(0), BBoolean.FALSE })")})})
@NiagaraActions(value={@NiagaraAction(name="clearStationSaveCount", returnType="BBoolean", flags=4), @NiagaraAction(name="handleMinSaveTimeout", returnType="BBoolean", flags=4), @NiagaraAction(name="dumpRecoveryData", returnType="BBoolean", flags=4), @NiagaraAction(name="refreshPersistentStorageSize", parameterType="BDataRecoveryFlushEvent", defaultValue="new BDataRecoveryFlushEvent()", returnType="BBoolean", flags=4), @NiagaraAction(name="resetDataRecoveryStatistics", returnType="BBoolean", flags=4), @NiagaraAction(name="handleConfigChange", returnType="BBoolean", flags=4)})
@NiagaraTopic(name="blocksWritten")
public final class BDataRecoveryService
extends BPlatformService
implements BIAlarmablePlatformService,
BIDataRecoveryService,
BIDataRecoverySource {
    public static final Property enabled = BDataRecoveryService.newProperty((int)0, (boolean)true, null);
    public static final Property dataRecoveryStatus = BDataRecoveryService.newProperty((int)3, (BValue)BDataRecoveryServiceStatus.unknown, null);
    public static final Property lastStationSave = BDataRecoveryService.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property lastStationSaveSuccessful = BDataRecoveryService.newProperty((int)3, (boolean)false, null);
    public static final Property persistentStorageSize = BDataRecoveryService.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String[])new String[]{"units", "min", "max"}, (BIDataValue[])new BIDataValue[]{BUnit.make((String)"kilobyte", (String)"KB", (BDimension)BDimension.NULL, (double)1024.0), BDouble.make((double)0.0), BDouble.POSITIVE_INFINITY}));
    public static final Property dataRecoveryConfiguration = BDataRecoveryService.newProperty((int)3, (BValue)new BDataRecoveryConfig(), null);
    public static final Property dataRecoveryBlocks = BDataRecoveryService.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property alertOnReplay = BDataRecoveryService.newProperty((int)0, (boolean)false, null);
    public static final Property dataRecoveryAlarmSupport = BDataRecoveryService.newProperty((int)0, (BValue)BDataRecoveryService.initDataRecoveryAlarmSupport(), null);
    public static final Property dataRecoveryAlarmProxy = BDataRecoveryService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property tooManySaves = BDataRecoveryService.newProperty((int)3, (boolean)false, null);
    public static final Property stationSaveLimit = BDataRecoveryService.newProperty((int)1, (int)3, (BFacets)BFacets.make((String[])new String[]{"min"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1)}));
    public static final Property stationSaveLimitPeriod = BDataRecoveryService.newProperty((int)1, (BValue)BRelTime.make((long)900000L), (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.make((long)0L), BBoolean.FALSE}));
    public static final Action clearStationSaveCount = BDataRecoveryService.newAction((int)4, null);
    public static final Action handleMinSaveTimeout = BDataRecoveryService.newAction((int)4, null);
    public static final Action dumpRecoveryData = BDataRecoveryService.newAction((int)4, null);
    public static final Action refreshPersistentStorageSize = BDataRecoveryService.newAction((int)4, (BValue)new BDataRecoveryFlushEvent(), null);
    public static final Action resetDataRecoveryStatistics = BDataRecoveryService.newAction((int)4, null);
    public static final Action handleConfigChange = BDataRecoveryService.newAction((int)4, null);
    public static final Topic blocksWritten = BDataRecoveryService.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BDataRecoveryService.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"save.png"), (BIcon)BIcon.std((String)"badges/warning.png"));
    private static final Comparator<Long> BLOCK_MANAGER_SEQUENCE_COMPARATOR = (sequence1, sequence2) -> {
        long sequenceNumber1 = sequence1;
        long sequenceNumber2 = sequence2;
        if (sequenceNumber1 == -1L && sequenceNumber2 == -1L) {
            return 0;
        }
        if (sequenceNumber2 == -1L) {
            return -1;
        }
        if (sequenceNumber1 == -1L) {
            return 1;
        }
        if (sequenceNumber1 < sequenceNumber2) {
            return -1;
        }
        if (sequenceNumber1 > sequenceNumber2) {
            return 1;
        }
        throw new RuntimeException("Sequence numbers are equal (" + sequenceNumber1 + "), can not compare.");
    };
    private static final Comparator<File> ACTIVE_FILE_SEQUENCE_COMPARATOR = (file1, file2) -> {
        LinkedList<IDataRecoveryRecord> activeList1 = BDataRecoveryBlockManager.replayRecoveryDataHelper(file1, true);
        LinkedList<IDataRecoveryRecord> activeList2 = BDataRecoveryBlockManager.replayRecoveryDataHelper(file2, true);
        long sequenceNumber1 = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(activeList1);
        long sequenceNumber2 = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(activeList2);
        if (sequenceNumber1 == -1L && sequenceNumber2 == -1L) {
            return 0;
        }
        if (sequenceNumber2 == -1L) {
            return -1;
        }
        if (sequenceNumber1 == -1L) {
            return 1;
        }
        if (sequenceNumber1 < sequenceNumber2) {
            return -1;
        }
        if (sequenceNumber1 > sequenceNumber2) {
            return 1;
        }
        throw new RuntimeException("Sequence numbers are equal (" + sequenceNumber1 + "), can not compare.");
    };
    private Clock.Ticket clearStationSaveTimer = null;
    int stationSavesGenerated = 0;
    private final Object receivedMonitor = new Object();
    private final Object flushedMonitor = new Object();
    private long totalBytesReceivedSinceStart = 0L;
    private long totalBytesFlushedSinceStart = 0L;
    private long timesFlushedSinceStart = 0L;
    private double averageBytesFlushedPerFlush = 0.0;
    private final MRUFlushTimes mostRecentFlushTimes = new MRUFlushTimes(10);
    private long serviceStartTimeMilliseconds = 0L;
    private double averageBytesFlushedPerSecondSinceStart = 0.0;
    private double averageBytesReceivedPerSecondSinceStart = 0.0;
    private long numberOfRecordsReceivedSinceStart = 0L;
    private double averageRecordSize = 0.0;
    private long tooLargeEventsSinceStart = 0L;
    private String lastFaultMessage = null;
    private Throwable lastFaultThrowable = null;
    private long ticksOfLastTooLargeEvent = -1L;
    private long ticksOfLastSaveStarted = -1L;
    private long ticksOfLastSaveCompleted = -1L;
    private final Object blockMonitor = new Object();
    private static final Logger log = Logger.getLogger("platDataRecovery.service");
    private boolean serviceStarted = false;
    private boolean shutdownStarted = false;
    private final Object applicationMonitor = new Object();
    private HashMap<BOrd, ApplicationEntry> knownApplications = null;
    private int externalApplicationsEncountered = 0;
    private BDataRecoveryConfig lastConfig = null;
    private boolean replayOccurred = false;
    private final Object bufferUtilMonitor = new Object();
    private final ByteBuffer bufferUtil = new ByteBuffer();
    public static boolean chunkFSPresent = false;
    public static final String DATA_RECOVERY_FILE_EXTENSION = ".drdb";
    public static final String DATA_RECOVERY_FILE_RESERVED_EXTENSION = ".drdbr";
    public static final String DATA_RECOVERY_FILE_CHUNK_EXTENSION = ".chunkfs";
    public static final String DATA_RECOVERY_FILE_CHUNK_PREFIX = "chunkfs";
    public static final String DATA_RECOVERY_FILE_PREFIX = "datarecoveryblock";
    private final TimeoutSaveManager timeoutSaveManager = new TimeoutSaveManager();
    private static final String LICENSE_FEATURE = "dataRecovery";
    private static final String LICENSE_VENDOR = "tridium";
    private long persistentFileCounter = 0L;
    private long activeSequenceNumber = 0L;
    private BOrd selfAsOrd;
    private BDataRecoveryBlockManager[] blocksAsArray;
    protected static ExecutorService drsFlushService = Executors.newFixedThreadPool(1, new DRSFlushThreadFactory());
    private static IPlatformProvider platformProvider;
    private BIDataRecoverySource testSpySource = null;
    private BIDataRecoverySource testReserveSource = null;
    public static final FileFilter DATA_RECOVERY_FILE_FILTER;
    public static final FileFilter DATA_RECOVERY_WORKING_FILE_FILTER;
    public static final byte SELF_ORD_AS_BYTE = 0;
    private static final byte[] APPLICATIONS_KEY_AS_BYTES;
    private static final byte[] TOO_LARGE_EVENT_AS_BYTES;
    public static final BBlob TOO_LARGE_EVENT_AS_BLOB;
    public static final BBlob APPLICATIONS_KEY_AS_BLOB;
    private static int chunkfsDeviceSize;
    private static int chunkfsNumFiles;
    private static int chunkfsChunkSize;
    private static int chunkfsNumChunks;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BDataRecoveryServiceStatus getDataRecoveryStatus() {
        return (BDataRecoveryServiceStatus)this.get(dataRecoveryStatus);
    }

    public void setDataRecoveryStatus(BDataRecoveryServiceStatus v) {
        this.set(dataRecoveryStatus, (BValue)v, null);
    }

    public BAbsTime getLastStationSave() {
        return (BAbsTime)this.get(lastStationSave);
    }

    public void setLastStationSave(BAbsTime v) {
        this.set(lastStationSave, (BValue)v, null);
    }

    public boolean getLastStationSaveSuccessful() {
        return this.getBoolean(lastStationSaveSuccessful);
    }

    public void setLastStationSaveSuccessful(boolean v) {
        this.setBoolean(lastStationSaveSuccessful, v, null);
    }

    public double getPersistentStorageSize() {
        return this.getDouble(persistentStorageSize);
    }

    public void setPersistentStorageSize(double v) {
        this.setDouble(persistentStorageSize, v, null);
    }

    public BDataRecoveryConfig getDataRecoveryConfiguration() {
        return (BDataRecoveryConfig)this.get(dataRecoveryConfiguration);
    }

    public void setDataRecoveryConfiguration(BDataRecoveryConfig v) {
        this.set(dataRecoveryConfiguration, (BValue)v, null);
    }

    public BVector getDataRecoveryBlocks() {
        return (BVector)this.get(dataRecoveryBlocks);
    }

    public void setDataRecoveryBlocks(BVector v) {
        this.set(dataRecoveryBlocks, (BValue)v, null);
    }

    public boolean getAlertOnReplay() {
        return this.getBoolean(alertOnReplay);
    }

    public void setAlertOnReplay(boolean v) {
        this.setBoolean(alertOnReplay, v, null);
    }

    public BPlatformAlarmSupport getDataRecoveryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(dataRecoveryAlarmSupport);
    }

    public void setDataRecoveryAlarmSupport(BPlatformAlarmSupport v) {
        this.set(dataRecoveryAlarmSupport, (BValue)v, null);
    }

    public BPlatformAlarmProxy getDataRecoveryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(dataRecoveryAlarmProxy);
    }

    public void setDataRecoveryAlarmProxy(BPlatformAlarmProxy v) {
        this.set(dataRecoveryAlarmProxy, (BValue)v, null);
    }

    public boolean getTooManySaves() {
        return this.getBoolean(tooManySaves);
    }

    public void setTooManySaves(boolean v) {
        this.setBoolean(tooManySaves, v, null);
    }

    public int getStationSaveLimit() {
        return this.getInt(stationSaveLimit);
    }

    public void setStationSaveLimit(int v) {
        this.setInt(stationSaveLimit, v, null);
    }

    public BRelTime getStationSaveLimitPeriod() {
        return (BRelTime)this.get(stationSaveLimitPeriod);
    }

    public void setStationSaveLimitPeriod(BRelTime v) {
        this.set(stationSaveLimitPeriod, (BValue)v, null);
    }

    public BBoolean clearStationSaveCount() {
        return (BBoolean)this.invoke(clearStationSaveCount, null, null);
    }

    public BBoolean handleMinSaveTimeout() {
        return (BBoolean)this.invoke(handleMinSaveTimeout, null, null);
    }

    public BBoolean dumpRecoveryData() {
        return (BBoolean)this.invoke(dumpRecoveryData, null, null);
    }

    public BBoolean refreshPersistentStorageSize(BDataRecoveryFlushEvent parameter) {
        return (BBoolean)this.invoke(refreshPersistentStorageSize, (BValue)parameter, null);
    }

    public BBoolean resetDataRecoveryStatistics() {
        return (BBoolean)this.invoke(resetDataRecoveryStatistics, null, null);
    }

    public BBoolean handleConfigChange() {
        return (BBoolean)this.invoke(handleConfigChange, null, null);
    }

    public void fireBlocksWritten(BValue event) {
        this.fire(blocksWritten, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDataRecoveryService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("DataRecoveryService.description"));
    }

    public final Type[] getServiceTypes() {
        return new Type[]{BIDataRecoveryService.TYPE, TYPE};
    }

    public int getSlotFlags() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serviceStarted() throws Exception {
        if (this.serviceStarted) {
            return;
        }
        if (!this.getEnabled()) {
            log.fine("Data Recovery Service is disabled, preventing startup");
            return;
        }
        try {
            Feature dataRecovery = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            dataRecovery.check();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error starting service: ", e);
            this.captureServiceFault("Error starting service: " + e, e);
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            this.serviceStarted = false;
            throw new DataRecoveryServiceInFaultException("Error starting service: ", (Throwable)e);
        }
        if (!this.isValidPlatform()) {
            this.captureServiceFault("Data recovery Service is not supported on the current platform, setting status to fault.", new Throwable());
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            throw new DataRecoveryServiceInFaultException("Data recovery Service is not supported on the current platform, setting status to fault.");
        }
        boolean formatSRAM = AccessController.doPrivileged(() -> new File("/var/cookies/format-sramopt").exists());
        if (formatSRAM) {
            log.warning("The file \"/etc/format-sramopt\" is present, DATA WILL NOT BE RECOVERED on next power cycle.");
        }
        this.selfAsOrd = this.getOrdInSession();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Service starting");
        }
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.starting);
        this.serviceStarted = true;
        try {
            Object object = this.applicationMonitor;
            synchronized (object) {
                this.knownApplications = new HashMap();
                this.knownApplications.put(this.selfAsOrd, new ApplicationEntry(this.selfAsOrd.encodeToString(), 0, 0L, 0L));
                this.externalApplicationsEncountered = 0;
            }
            object = this.blockMonitor;
            synchronized (object) {
                this.configureDataRecoveryBlocks(this.getDataRecoveryConfiguration(), true);
            }
            if (!this.doRefreshPersistentStorageSize(null).getBoolean()) {
                throw new Exception("Failed to refresh persistent storage size during configuration, propagating error");
            }
            this.linkTo(this.getDataRecoveryConfiguration(), (Slot)BDataRecoveryConfig.configurationChanged, (Slot)handleConfigChange);
            Nre.spySysManagers.add("dataRecoveryManager", (Spy)new DataRecoveryServiceSpyPage());
            this.serviceStartTimeMilliseconds = System.currentTimeMillis();
            if (BDataRecoveryServiceStatus.fault == this.getDataRecoveryStatus()) {
                throw new Exception("Service set to fault during configuration, propagating error");
            }
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.ready);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error starting service: ", e);
            this.captureServiceFault("Error starting service: " + e, new Throwable());
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            this.serviceStarted = false;
            throw new DataRecoveryServiceInFaultException("Error starting service: ", (Throwable)e);
        }
        super.serviceStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serviceStopped() throws Exception {
        if (!this.serviceStarted) {
            return;
        }
        super.serviceStopped();
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.stopping);
        if (this.clearStationSaveTimer != null) {
            this.clearStationSaveTimer.cancel();
        }
        Object object = BDataRecoveryBlockManager.persistentDirectoryMonitor;
        synchronized (object) {
            AccessController.doPrivileged(() -> {
                File[] persistentChildren = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(DATA_RECOVERY_FILE_FILTER);
                if (persistentChildren != null) {
                    for (File persistentChild : persistentChildren) {
                        if (persistentChild.delete()) continue;
                        log.severe("Error deleting persistent file: " + persistentChild + ", unintended data recovery may replay on start.");
                    }
                }
                return null;
            });
        }
        object = BDataRecoveryBlockManager.activeDirectoryMonitor;
        synchronized (object) {
            try {
                Object object2 = this.blockMonitor;
                synchronized (object2) {
                    SlotCursor c = this.getDataRecoveryBlocks().getProperties();
                    while (c.next(BDataRecoveryBlockManager.class)) {
                        BDataRecoveryBlockManager tempManager = (BDataRecoveryBlockManager)c.get();
                        tempManager.closeActiveFile();
                    }
                    this.getDataRecoveryBlocks().removeAll();
                    this.blocksAsArray = null;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error stopping service: ", e);
                this.captureServiceFault("Error stopping service: " + e, new Throwable());
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            }
        }
        try {
            drsFlushService.shutdown();
            drsFlushService.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.stopped);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Service stopped");
        }
        this.serviceStarted = false;
    }

    public String getLicenseFeature() {
        return LICENSE_FEATURE;
    }

    public String getLicenseVendor() {
        return LICENSE_VENDOR;
    }

    public boolean isValidPlatform() {
        String mountPoint;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Determining platform validity for Data Recovery Service, Tridium provider = " + PlatformUtil.isTridiumPlatform());
        }
        if (PlatformUtil.isTridiumPlatform()) {
            if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
                return AccessController.doPrivileged(() -> new File("/dev/chunkfs").exists());
            }
            boolean development = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.platDataRecovery.development"));
            if (development) {
                log.info("Running in development / test environment, explicitly setting isValidPlatform to true");
            }
            return development;
        }
        if (PlatformUtil.isNpsdkPlatform() && (mountPoint = AccessController.doPrivileged(() -> System.getProperty("niagara.platDataRecovery.mountPath"))) != null) {
            return AccessController.doPrivileged(() -> new File(mountPoint).exists());
        }
        return false;
    }

    public void doStationStarted(BStation station) {
        super.doStationStarted(station);
        if (this.replayOccurred) {
            if (this.getAlertOnReplay()) {
                this.getDataRecoveryAlarmProxy().setAlarmSupport(this.getDataRecoveryAlarmSupport());
                BPlatformServiceAlarmRecord alarm = this.getDataRecoveryAlarmSupport().makeNewAlert();
                this.getDataRecoveryAlarmProxy().firePlatformServiceAlarmEvent(alarm);
            }
            this.replayOccurred = false;
        }
        this.clearStationSaveTimer = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getStationSaveLimitPeriod(), (Action)clearStationSaveCount, null);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 1001: {
                BDataRecoveryConfig targetConfiguration = BDataRecoveryService.generatePlatformConfiguration();
                if (targetConfiguration == null) {
                    log.severe("Error generating platform configuration, service will be disabled");
                    this.captureServiceFault("Error generating platform configuration, service will be disabled", new Throwable());
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                    break;
                }
                this.setDataRecoveryConfiguration(targetConfiguration);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private static BDataRecoveryConfig generatePlatformConfiguration() {
        BDataRecoveryConfig platformConfiguration = new BDataRecoveryConfig();
        platformProvider = PlatformUtil.getPlatformProvider();
        platformConfiguration.setActiveFullPolicy(BDataRecoveryFullPolicy.flush);
        if (PlatformUtil.isTridiumPlatform()) {
            if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
                chunkFSPresent = true;
                String persistentDirectoryPath = Nre.protectedStationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE;
                platformConfiguration.setPersistentDirectory(persistentDirectoryPath);
                platformConfiguration.setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeByStorageSize(BDataRecoveryService.getRequiredPersistentStorageBytes(persistentDirectoryPath)));
                if (new File("/dev/chunkfs").exists()) {
                    platformConfiguration.setActiveDirectory("/dev/chunkfs");
                }
                if (!BDataRecoveryService.loadGeom(platformConfiguration.getActiveDirectory() + "/geom")) {
                    return null;
                }
                platformConfiguration.setNumberBlocks(chunkfsNumFiles);
                platformConfiguration.setDataRecoverySize(chunkfsDeviceSize);
                BDataRecoveryBlockManager.setChunkSize(chunkfsChunkSize);
                BDataRecoveryBlockManager.setTotalChunks(chunkfsNumChunks);
            } else {
                chunkFSPresent = false;
                platformConfiguration.setActiveDirectory(Nre.protectedStationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE + File.separator + "active");
                platformConfiguration.setPersistentDirectory(Nre.protectedStationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE + File.separator + "persist");
                platformConfiguration.setDataRecoverySize(524288);
                platformConfiguration.setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeUnlimited());
            }
        } else if (PlatformUtil.isNpsdkPlatform()) {
            block19: {
                chunkFSPresent = true;
                String persistentDefaultPath = Nre.protectedStationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE;
                String persistentDirectoryPath = AccessController.doPrivileged(() -> System.getProperty("niagara.platDataRecovery.persistentDirectoryPath", persistentDefaultPath));
                platformConfiguration.setPersistentDirectory(persistentDirectoryPath);
                platformConfiguration.setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeByStorageSize(BDataRecoveryService.getRequiredPersistentStorageBytes(persistentDirectoryPath)));
                try {
                    String activeDirectory = AccessController.doPrivileged(() -> System.getProperty("niagara.platDataRecovery.activeDirectoryPath"));
                    if (activeDirectory == null) {
                        throw new Exception("niagara.platDataRecovery.activeDirectoryPath not defined");
                    }
                    if (new File(activeDirectory).exists()) {
                        if (!new File(activeDirectory).isDirectory()) {
                            throw new Exception("provided niagara.platDataRecovery.activeDirectoryPath path is not a directory");
                        }
                    } else {
                        throw new Exception("provided niagara.platDataRecovery.activeDirectoryPath path does not exist");
                    }
                    platformConfiguration.setActiveDirectory(activeDirectory);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error setting up active directory", e);
                    return null;
                }
                try {
                    String chunkGeometry = AccessController.doPrivileged(() -> System.getProperty("niagara.platDataRecovery.geomPath"));
                    if (chunkGeometry == null) {
                        throw new Exception("niagara.platDataRecovery.geomPath not defined");
                    }
                    if (new File(chunkGeometry).exists()) {
                        if (!BDataRecoveryService.loadGeom(chunkGeometry)) {
                            return null;
                        }
                        break block19;
                    }
                    throw new Exception("provided niagara.platDataRecovery.geomPath path does not exist");
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error loading chunkfs geometry: ", e);
                    return null;
                }
            }
            platformConfiguration.setNumberBlocks(chunkfsNumFiles);
            platformConfiguration.setDataRecoverySize(chunkfsDeviceSize);
            BDataRecoveryBlockManager.setChunkSize(chunkfsChunkSize);
            BDataRecoveryBlockManager.setTotalChunks(chunkfsNumChunks);
        } else {
            throw new BajaRuntimeException("Data Recovery not supported on the current platform");
        }
        return platformConfiguration;
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (cx == Context.decoding) {
            return;
        }
        if (!this.serviceStarted) {
            return;
        }
        if (p == persistentStorageSize) {
            if (this.getDataRecoveryConfiguration().getPersistentStorageCapacity().isByStorageSize()) {
                double totalStorageRestrictionKiB = this.getDataRecoveryConfiguration().getPersistentStorageCapacity().getMaxStorage() >> 10;
                double currentStorageKiB = this.getPersistentStorageSize();
                if (currentStorageKiB >= totalStorageRestrictionKiB * 0.75 && !this.getDataRecoveryStatus().equals((Object)BDataRecoveryServiceStatus.saving) && !this.getDataRecoveryStatus().equals((Object)BDataRecoveryServiceStatus.replaying) && !this.getDataRecoveryStatus().equals((Object)BDataRecoveryServiceStatus.configuring)) {
                    log.fine("Data recovery persistent storage capacity exceeded, saving station...");
                    try {
                        ++this.stationSavesGenerated;
                        Station.saveAsync(null);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error while saving station: ", e);
                    }
                }
            }
        } else if (p == dataRecoveryConfiguration) {
            this.dataRecoveryConfigChanged(this.getDataRecoveryConfiguration());
        } else if ((p == stationSaveLimitPeriod || p == stationSaveLimit) && this.clearStationSaveTimer != null) {
            this.clearStationSaveTimer.cancel();
            this.stationSavesGenerated = 0;
            this.clearStationSaveTimer = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getStationSaveLimitPeriod(), (Action)clearStationSaveCount, null);
        }
    }

    public final void dataRecoveryConfigChanged(BDataRecoveryConfig config) {
        if (!this.serviceStarted) {
            return;
        }
        if (config != this.getDataRecoveryConfiguration()) {
            return;
        }
        boolean relayoutRequired = false;
        if (this.lastConfig != null) {
            relayoutRequired = !config.getActiveDirectory().equals(this.lastConfig.getActiveDirectory());
            relayoutRequired = !config.getPersistentDirectory().equals(this.lastConfig.getPersistentDirectory()) || relayoutRequired;
            relayoutRequired = config.getDataRecoverySize() != this.lastConfig.getDataRecoverySize() || relayoutRequired;
            relayoutRequired = config.getNumberBlocks() != this.lastConfig.getNumberBlocks() || relayoutRequired;
        }
        this.lastConfig = (BDataRecoveryConfig)config.newCopy(true);
        if (relayoutRequired) {
            try {
                this.reconfigureDataRecoveryBlocks(config);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error reconfiguring data recovery blocks: ", e);
                this.captureServiceFault("Error reconfiguring data recovery blocks: ", new Throwable());
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDataRecoveryBlocks(BDataRecoveryConfig config, boolean replayRecoveryData) throws Exception {
        Object object = this.blockMonitor;
        synchronized (object) {
            SlotCursor c;
            BDataRecoveryBlockManager tempManager;
            File[] activeChildren;
            File activeFile;
            BDataRecoveryServiceStatus old = this.getDataRecoveryStatus();
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.configuring);
            String activePath = config.getActiveDirectory();
            String persistentPath = config.getPersistentDirectory();
            if (replayRecoveryData && new File(activePath).exists() && !new File(persistentPath).exists()) {
                boolean containsData = false;
                activeFile = new File(activePath);
                activeChildren = activeFile.listFiles(DATA_RECOVERY_FILE_FILTER);
                if (activeChildren != null && activeChildren.length != 0) {
                    for (File activeChild : activeChildren) {
                        if (BDataRecoveryService.lengthOfFile(activeChild) == 0L) continue;
                        containsData = true;
                        break;
                    }
                }
                if (containsData) {
                    log.warning("Truncating data in active directory, it was not generated by this instance of the service");
                    try {
                        AccessController.doPrivileged(() -> {
                            for (File activeChild : activeChildren) {
                                if (chunkFSPresent) {
                                    FileOutputStream temp = new FileOutputStream(activeChild, false);
                                    temp.close();
                                    continue;
                                }
                                if (activeChild.delete()) continue;
                                log.severe("Error deleting uninitialized active file: " + activeChild);
                            }
                            return null;
                        });
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error truncating the active file", e);
                        this.captureServiceFault("Error truncating the active file " + e, new Throwable());
                        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                        throw e;
                    }
                }
            }
            if (replayRecoveryData && new File(activePath).exists() && new File(persistentPath).exists()) {
                boolean activeContainsData = false;
                activeFile = new File(activePath);
                activeChildren = activeFile.listFiles(DATA_RECOVERY_FILE_FILTER);
                if (activeChildren != null && activeChildren.length != 0) {
                    for (File activeChild : activeChildren) {
                        if (BDataRecoveryService.lengthOfFile(activeChild) == 0L) continue;
                        activeContainsData = true;
                        break;
                    }
                }
                boolean persistentContainsData = false;
                File persistentFile = new File(persistentPath);
                File[] persistentChildren = persistentFile.listFiles(DATA_RECOVERY_FILE_FILTER);
                if (persistentChildren != null && persistentChildren.length != 0) {
                    persistentContainsData = true;
                }
                if (persistentContainsData && !activeContainsData) {
                    log.warning("Truncating data in persistent directory, it was not generated by this instance of the service");
                    AccessController.doPrivileged(() -> {
                        for (File persistentChild : persistentChildren) {
                            if (persistentChild.delete()) continue;
                            log.severe("Error deleting uninitialized persistent file: " + persistentChild);
                        }
                        return null;
                    });
                }
            }
            try {
                BDataRecoveryBlockManager.initializeDirectories(activePath, persistentPath);
                Object activeContainsData = BDataRecoveryBlockManager.persistentDirectoryMonitor;
                synchronized (activeContainsData) {
                    AccessController.doPrivileged(() -> {
                        File[] workingPersistentChildren = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(DATA_RECOVERY_WORKING_FILE_FILTER);
                        if (workingPersistentChildren != null) {
                            for (File persistentChild : workingPersistentChildren) {
                                if (persistentChild.delete()) continue;
                                log.severe("Could not delete persistent working file: " + persistentChild);
                            }
                        }
                        return null;
                    });
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error initializing data recovery directories: ", e);
                this.captureServiceFault("Error initializing data recovery directories: " + e, new Throwable());
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                throw e;
            }
            if (replayRecoveryData && BDataRecoveryBlockManager.recoveryDataExists()) {
                log.warning("Recovery data detected, replaying...");
                BBoolean replaySuccessful = this.doReplayRecoveryData();
                if (!replaySuccessful.getBoolean()) {
                    log.severe("Error(s) replaying recovery data, data since last save may been lost");
                }
                this.replayOccurred = true;
            }
            if (chunkFSPresent) {
                long freeSpaceBytes = BDataRecoveryService.freeStorageSizeBytes(config.getPersistentDirectory());
                long usedSpaceBytes = (long)Math.floor(this.getPersistentStorageSize() * 1024.0);
                long requiredSpaceBytes = config.getPersistentStorageCapacity().getMaxStorage();
                long remainingSpaceRequiredBytes = requiredSpaceBytes - usedSpaceBytes;
                if (freeSpaceBytes < remainingSpaceRequiredBytes) {
                    long availableKiB = freeSpaceBytes / 1024L;
                    long remainingSpaceRequiredKiB = remainingSpaceRequiredBytes / 1024L;
                    log.severe("Inadequate persistent storage available (" + availableKiB + " KB < " + remainingSpaceRequiredKiB + " KB), can not configure Data Recovery blocks");
                    this.captureServiceFault("Inadequate persistent storage available (" + availableKiB + " KB < " + remainingSpaceRequiredKiB + " KB), can not configure Data Recovery blocks", new Throwable());
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                    throw new DataRecoveryServiceInFaultException("Inadequate persistent storage available (" + availableKiB + " KB < " + remainingSpaceRequiredKiB + " KB)");
                }
            }
            int numberOfBlocks = config.getNumberBlocks();
            boolean allBlocksEmpty = true;
            for (int i = 0; i < numberOfBlocks; ++i) {
                String fileName = null;
                if (PlatformUtil.isTridiumPlatform()) {
                    fileName = OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx) ? i + DATA_RECOVERY_FILE_CHUNK_EXTENSION : DATA_RECOVERY_FILE_PREFIX + i + DATA_RECOVERY_FILE_EXTENSION;
                } else if (PlatformUtil.isNpsdkPlatform()) {
                    fileName = DATA_RECOVERY_FILE_CHUNK_PREFIX + i;
                }
                tempManager = new BDataRecoveryBlockAppendManager();
                if (chunkFSPresent) {
                    tempManager.setMaxCapacity(chunkfsChunkSize * chunkfsNumChunks);
                } else {
                    tempManager.setMaxCapacity((int)Math.floor((double)config.getDataRecoverySize() / (double)config.getNumberBlocks()));
                }
                tempManager.openActiveFile(fileName);
                this.linkTo(null, tempManager, (Slot)BDataRecoveryBlockManager.blockFlushed, (Slot)refreshPersistentStorageSize);
                if (!tempManager.isEmpty()) {
                    allBlocksEmpty = false;
                }
                this.getDataRecoveryBlocks().add(SlotPath.escape((String)(DATA_RECOVERY_FILE_PREFIX + i)), (BValue)tempManager, 3);
            }
            if (allBlocksEmpty) {
                log.fine("All data block managers are empty, activating first block...");
                boolean firstPass = true;
                c = this.getDataRecoveryBlocks().getProperties();
                while (c.next(BDataRecoveryBlockManager.class)) {
                    tempManager = (BDataRecoveryBlockManager)c.get();
                    if (firstPass) {
                        tempManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                        firstPass = false;
                        continue;
                    }
                    tempManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                }
            } else {
                log.fine("Data block managers were non empty, flushing contents to flash...");
                ArrayList<BDataRecoveryBlockManager> blockManagers = new ArrayList<BDataRecoveryBlockManager>();
                ArrayList<Long> blockManagersSequence = new ArrayList<Long>();
                SlotCursor c2 = this.getDataRecoveryBlocks().getProperties();
                while (c2.next(BDataRecoveryBlockManager.class)) {
                    tempManager = (BDataRecoveryBlockManager)c2.get();
                    blockManagers.add(tempManager);
                    blockManagersSequence.add(BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(BDataRecoveryBlockManager.replayRecoveryDataHelper(tempManager.getFile(), true)));
                }
                BDataRecoveryBlockManager[] blockManagersArray = blockManagers.toArray(new BDataRecoveryBlockManager[0]);
                Object[] blockManagersSequenceArray = blockManagersSequence.toArray(new Long[0]);
                SortUtil.sort((Object[])blockManagersSequenceArray, (Object[])blockManagersArray, BLOCK_MANAGER_SEQUENCE_COMPARATOR);
                for (BDataRecoveryBlockManager blockManager : blockManagersArray) {
                    String longString = String.valueOf(this.persistentFileCounter++);
                    blockManager.doFlushRecoveryData(longString + DATA_RECOVERY_FILE_EXTENSION);
                    blockManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                }
                blockManagersArray[0].setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                log.fine("Flush of old data complete.");
            }
            ArrayList<BDataRecoveryBlockManager> tempBlocksAsArray = new ArrayList<BDataRecoveryBlockManager>();
            c = this.getDataRecoveryBlocks().getProperties();
            while (c.next(BDataRecoveryBlockManager.class)) {
                tempBlocksAsArray.add((BDataRecoveryBlockManager)c.get());
            }
            this.blocksAsArray = tempBlocksAsArray.toArray(new BDataRecoveryBlockManager[0]);
            if (this.replayOccurred) {
                try {
                    byte[] knownApplicationsAsBytes = this.serializeKnownApplications();
                    if (knownApplicationsAsBytes.length != 0) {
                        this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, knownApplicationsAsBytes);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error persisting previously known application map: ", e);
                    this.captureServiceFault("Error persisting previously known application map: " + e, e);
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                    throw e;
                }
            }
            this.setDataRecoveryStatus(old);
        }
        this.fireBlocksWritten(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigureDataRecoveryBlocks(BDataRecoveryConfig config) throws Exception {
        boolean trace = log.isLoggable(Level.FINE);
        if (trace) {
            log.fine("Reconfiguring data recovery blocks...");
        }
        Object object = this.blockMonitor;
        synchronized (object) {
            for (BDataRecoveryBlockManager tempManager : this.blocksAsArray) {
                if (config.getActiveFullPolicy() == BDataRecoveryFullPolicy.flush) {
                    String longString = String.valueOf(this.persistentFileCounter++);
                    tempManager.doFlushRecoveryData(longString + DATA_RECOVERY_FILE_EXTENSION);
                }
                tempManager.closeActiveFile();
            }
            this.getDataRecoveryBlocks().removeAll();
            this.blocksAsArray = null;
            try {
                this.configureDataRecoveryBlocks(config, false);
                try {
                    byte[] knownApplicationsAsBytes = this.serializeKnownApplications();
                    if (knownApplicationsAsBytes.length != 0) {
                        this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, knownApplicationsAsBytes);
                    }
                }
                catch (Exception e) {
                    log.warning("Failed to append application list on reconfiguration.");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error reconfiguring data recovery blocks: ", e);
                this.captureServiceFault("Error reconfiguring data recovery blocks: " + e, e);
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                throw e;
            }
        }
        if (trace) {
            log.fine("Finished reconfiguring blocks");
        }
    }

    public final boolean isEnabled() {
        return this.getEnabled() && this.getDataRecoveryStatus() != BDataRecoveryServiceStatus.fault;
    }

    public final boolean append(BIDataRecoverySource source, BIEncodable key, byte[] data) throws BajaRuntimeException {
        return this.append(source, key, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean append(BIDataRecoverySource source, BIEncodable key, byte[] data, int offset, int length) throws BajaRuntimeException {
        Object object;
        BOrd sourceOrd;
        byte[] recoveryKey;
        if (!this.serviceStarted) {
            throw new DataRecoveryServiceInFaultException("Service not started");
        }
        BDataRecoveryServiceStatus currentStatus = this.getDataRecoveryStatus();
        if (currentStatus != BDataRecoveryServiceStatus.ready && currentStatus != BDataRecoveryServiceStatus.saving && currentStatus != BDataRecoveryServiceStatus.configuring) {
            throw new DataRecoveryServiceInFaultException("Can not append data recovery at this time, state is " + (Object)((Object)this.getDataRecoveryStatus()));
        }
        if (source == null) {
            throw new NullPointerException("Provided source can not be null");
        }
        if (key == null) {
            throw new DataRecoveryInvalidKeyException("Provided key can not be null");
        }
        if (data == null) {
            throw new NullPointerException("Provided data can not be null");
        }
        if (offset < 0) {
            throw new DataRecoveryException("Invalid data offset, offset < 0");
        }
        if (offset >= data.length && data.length != 0) {
            throw new DataRecoveryException("Invalid data offset, offset >= non-zero data.length");
        }
        if (length < 0) {
            throw new DataRecoveryException("Invalid data length, length < 0");
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        byte dataRecoverySource = 0;
        byte[] recoveryData = null;
        Exception encodingError = null;
        Object object2 = this.bufferUtilMonitor;
        synchronized (object2) {
            try {
                this.bufferUtil.reset();
                key.encode((DataOutput)this.bufferUtil);
                recoveryKey = this.bufferUtil.toByteArray();
                this.bufferUtil.reset();
                this.bufferUtil.write(data, offset, length);
                recoveryData = this.bufferUtil.toByteArray();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not encode data recovery key: ", e);
                recoveryKey = null;
                encodingError = e;
            }
        }
        if (recoveryKey == null) {
            if (encodingError != null) {
                throw new DataRecoveryInvalidKeyException("Could not encode data recovery key: " + encodingError.getMessage());
            }
            throw new DataRecoveryInvalidKeyException("Invalid key, data recovery == null after encoding");
        }
        if (recoveryData == null) {
            throw new DataRecoveryException("Invalid data, recoveryData == null after byte array conversion");
        }
        try {
            sourceOrd = source.getOrdInSession();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not obtain source ord: ", e);
            return false;
        }
        boolean internalRequest = false;
        if (source == this && sourceOrd.equals((Object)this.selfAsOrd)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Narcissistic append(encoded key bytes: " + key.toString() + ", data bytes: " + TextUtil.bytesToHexString((byte[])recoveryData) + ")");
            }
            internalRequest = true;
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("External append(" + sourceOrd + ", encoded key bytes: " + key.toString() + ", data bytes: " + TextUtil.bytesToHexString((byte[])recoveryData) + ")");
            }
            Object object3 = this.applicationMonitor;
            synchronized (object3) {
                ApplicationEntry target = this.knownApplications.get(sourceOrd);
                if (target == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Append encountered new data recovery source: " + sourceOrd);
                    }
                    ++this.externalApplicationsEncountered;
                    if (this.externalApplicationsEncountered != (byte)this.externalApplicationsEncountered) {
                        throw new DataRecoveryException("Data Recovery Service can not respond to request from source: " + sourceOrd + ", byte overflow detected.");
                    }
                    dataRecoverySource = (byte)this.externalApplicationsEncountered;
                    this.knownApplications.put(sourceOrd, new ApplicationEntry(sourceOrd.encodeToString(), dataRecoverySource, recoveryKey.length, recoveryData.length));
                    try {
                        byte[] knownApplicationsAsBytes = this.serializeKnownApplications();
                        if (knownApplicationsAsBytes.length != 0) {
                            this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, knownApplicationsAsBytes);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error persisting known application map: ", e);
                        this.captureServiceFault("Error persisting known application map: " + e, e);
                        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                        return false;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Successfully appended data recovery source");
                    }
                } else {
                    dataRecoverySource = target.getId();
                    target.updateMetrics(recoveryKey.length, recoveryData.length);
                }
            }
        }
        if (!internalRequest && this.outstandingTooLargeEventPresent()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Ignoring request " + sourceOrd + ", encoded key '" + key.toString() + " because we have an outstanding too large event, waiting until Station save started before accepting new data");
            }
            return true;
        }
        boolean successful = false;
        BDataRecoveryBlockManager targetBlock = null;
        DataRecoveryWriteResponse writeResponse = DataRecoveryWriteResponse.FAILURE;
        int retries = 0;
        while (retries <= 1) {
            try {
                object = this.blockMonitor;
                synchronized (object) {
                    if (this.shutdownStarted) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Ignoring external append(" + sourceOrd + ", encoded key bytes: " + key.toString() + "), application is shutting down");
                        }
                        return true;
                    }
                    targetBlock = this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.saving ? this.getBlock(BDataRecoveryBlockManagerStatus.reserved) : this.getBlock(BDataRecoveryBlockManagerStatus.active);
                    writeResponse = targetBlock.appendData(dataRecoverySource, recoveryKey, recoveryData);
                    if (writeResponse == DataRecoveryWriteResponse.SUCCESS || writeResponse == DataRecoveryWriteResponse.FAILURE) {
                        successful = writeResponse == DataRecoveryWriteResponse.SUCCESS;
                        break;
                    }
                }
                if (writeResponse == DataRecoveryWriteResponse.FULL) {
                    if (this.getDataRecoveryConfiguration().getActiveFullPolicy() != BDataRecoveryFullPolicy.flush) continue;
                    this.doFlushRecoveryData();
                    ++retries;
                    continue;
                }
                if (writeResponse != DataRecoveryWriteResponse.TOO_LARGE) continue;
                this.handleTooLargeEvent(new DataRecoveryTooLargeException(recoveryData.length, targetBlock.getMaxCapacity(), "Cannot store data with length of " + recoveryData.length), source);
                break;
            }
            catch (DataRecoveryStoreFullException cdsfe) {
                if (this.getDataRecoveryConfiguration().getActiveFullPolicy() != BDataRecoveryFullPolicy.flush) continue;
                this.doFlushRecoveryData();
                ++retries;
            }
            catch (DataRecoveryTooLargeException drtle) {
                this.handleTooLargeEvent(drtle, source);
                break;
            }
            catch (DataRecoveryBlockUnavailableException cdbue) {
                if (this.activateIdleIfAllIdle() || this.activateReservedIfReady()) continue;
                ++retries;
            }
            catch (DataRecoveryBlockInactiveException dataRecoveryBlockInactiveException) {
            }
        }
        if (successful) {
            object = this.receivedMonitor;
            synchronized (object) {
                ++this.numberOfRecordsReceivedSinceStart;
                this.totalBytesReceivedSinceStart += (long)(recoveryData.length + recoveryKey.length + DataRecoveryBlock.getFixedFieldsOfUsedBlockHeaderSize());
                this.averageBytesReceivedPerSecondSinceStart = (double)this.totalBytesReceivedSinceStart / (double)(System.currentTimeMillis() - this.serviceStartTimeMilliseconds) * 1000.0;
                this.averageRecordSize = (double)this.totalBytesReceivedSinceStart / (double)this.numberOfRecordsReceivedSinceStart;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Attempt to append data with key encoded as bytes: " + key.toString() + " successful");
            }
        } else {
            log.severe("Attempt to append data with key: " + key.toString() + " failed");
        }
        return successful;
    }

    private boolean outstandingTooLargeEventPresent() {
        if (Clock.ticks() < this.ticksOfLastSaveCompleted) {
            this.ticksOfLastSaveStarted = -1L;
            this.ticksOfLastSaveCompleted = -1L;
            this.ticksOfLastTooLargeEvent = -1L;
            return false;
        }
        return this.ticksOfLastTooLargeEvent > this.ticksOfLastSaveCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTooLargeEvent(DataRecoveryTooLargeException drtle, BIDataRecoverySource source) {
        byte[] tooLargeDataAsBytes;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DataRecoveryTooLargeException occurred, data can not be saved: ", drtle);
        }
        Object object = this.bufferUtilMonitor;
        synchronized (object) {
            try {
                this.bufferUtil.reset();
                BAbsTime.now().encode((DataOutput)this.bufferUtil);
                source.getOrdInSession().encode((DataOutput)this.bufferUtil);
                tooLargeDataAsBytes = this.bufferUtil.toByteArray();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not encode data too large event: ", e);
                this.captureServiceFault("Could not encode data too large event: " + e, e);
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                return;
            }
        }
        if (tooLargeDataAsBytes != null && tooLargeDataAsBytes.length != 0) {
            this.append(this, (BIEncodable)TOO_LARGE_EVENT_AS_BLOB, tooLargeDataAsBytes);
        }
        ++this.tooLargeEventsSinceStart;
        this.ticksOfLastTooLargeEvent = Clock.ticks();
        log.log(Level.FINE, "Requesting station save through timeout save manager to handle too large exception");
        this.timeoutSaveManager.requestSave();
    }

    public final boolean hasRecoveryData() throws BajaRuntimeException {
        return BDataRecoveryBlockManager.recoveryDataExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveStarted() {
        block28: {
            Object object;
            if (!this.serviceStarted) {
                return;
            }
            if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.fault) {
                return;
            }
            if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.saving) {
                return;
            }
            byte[] knownApplicationsAsBytes = null;
            String[] knownApplicationOrds = null;
            try {
                object = this.applicationMonitor;
                synchronized (object) {
                    knownApplicationsAsBytes = this.serializeKnownApplications();
                    knownApplicationOrds = this.encodeKnownApplications();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error serializing application mapping, service may be susceptible to data loss", e);
            }
            object = this.blockMonitor;
            synchronized (object) {
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.saving);
                BDataRecoveryBlockManager toReserve = null;
                for (int reserveAttempts = 0; reserveAttempts < 3; ++reserveAttempts) {
                    try {
                        toReserve = this.getBlock(BDataRecoveryBlockManagerStatus.idle, BDataRecoveryBlockManagerStatus.awaitingIdle);
                        break;
                    }
                    catch (DataRecoveryBlockUnavailableException unavailableException) {
                        log.warning("No idle block (" + unavailableException.getBlockStatuses() + ") at save during service state \"" + (Object)((Object)this.getDataRecoveryStatus()) + "\" on thread \"" + Thread.currentThread().getName() + "\", retrying (attempt " + (reserveAttempts + 1) + " of 3)");
                        try {
                            this.blockMonitor.wait(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (toReserve == null) {
                    log.severe("Could not obtain an idle block when attempting to save, a serious error has occurred");
                    this.dumpStatistics(System.err);
                    Thread.dumpStack();
                    this.captureServiceFault("Could not obtain an idle block when attempting to save, a serious error has occurred", new Throwable());
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                    break block28;
                }
                toReserve.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.reserved);
                if (knownApplicationsAsBytes != null && knownApplicationsAsBytes.length != 0) {
                    this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, knownApplicationsAsBytes);
                }
                if (knownApplicationOrds != null && knownApplicationOrds.length != 0) {
                    for (String knownApplicationOrd : knownApplicationOrds) {
                        BIDataRecoverySource source = null;
                        try {
                            source = (BIDataRecoverySource)BOrd.make((String)knownApplicationOrd).resolve().get();
                        }
                        catch (ClassCastException classCastException) {
                        }
                        catch (SyntaxException se) {
                            if (this.testReserveSource != null) {
                                source = this.testReserveSource;
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Error mapping source byte '" + knownApplicationOrd + "' to BIDataRecoverySource during reserve notification, source may contain stale data on replay", e);
                        }
                        try {
                            if (source == null) continue;
                            source.dataRecoveryReserve();
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Error occurred during reserve notification for '" + source + "', source may contain stale data on replay", e);
                        }
                    }
                }
                BDataRecoveryBlockManager toFlush = this.getBlock(BDataRecoveryBlockManagerStatus.active);
                String longString = String.valueOf(this.persistentFileCounter++);
                toFlush.doFlushRecoveryData(longString + DATA_RECOVERY_FILE_EXTENSION, false);
                toFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                this.blockMonitor.notify();
            }
        }
        this.ticksOfLastSaveStarted = Clock.ticks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveFinished() {
        if (!this.serviceStarted) {
            return;
        }
        this.setLastStationSaveSuccessful(true);
        this.setLastStationSave(BAbsTime.now());
        if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.fault) {
            log.warning("Data Recovery Service is in fault state, skipping service saveFinished listener implementation");
            return;
        }
        if (this.getDataRecoveryStatus() != BDataRecoveryServiceStatus.saving) {
            log.warning("Data Recovery Service saveFinished listener called while service in state '" + (Object)((Object)this.getDataRecoveryStatus()) + "', skipping service save listener implementation");
            return;
        }
        Object object = this.blockMonitor;
        synchronized (object) {
            BBoolean purgeSuccessful = this.doPurgeRecovery();
            if (!purgeSuccessful.getBoolean()) {
                log.severe("Error purging Data Recovery Service records in saveFinished, duplicate records may occur");
            }
            try {
                BDataRecoveryBlockManager toActivate = this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                toActivate.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
            }
            catch (DataRecoveryBlockUnavailableException e) {
                log.warning("No block was set to 'reserved' during Data Recovery Service saveFinished callback (" + e.getBlockStatuses() + "), skipping reserved block activation");
            }
            Object object2 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
            synchronized (object2) {
                long reservedLengthBytes = AccessController.doPrivileged(() -> {
                    long tempReservedLengthBytes = 0L;
                    File[] persistentChildren = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(DATA_RECOVERY_FILE_FILTER);
                    if (persistentChildren != null) {
                        for (File persistentChild : persistentChildren) {
                            if (!persistentChild.getName().endsWith(DATA_RECOVERY_FILE_RESERVED_EXTENSION)) continue;
                            String oldName = persistentChild.getAbsolutePath();
                            String newName = oldName.substring(0, oldName.length() - 1);
                            File newFile = new File(newName);
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("Renaming reserved file " + oldName + " to " + newName);
                            }
                            if (!persistentChild.renameTo(newFile)) {
                                log.severe("Error renaming persistent child: " + oldName);
                                tempReservedLengthBytes += persistentChild.length();
                                continue;
                            }
                            tempReservedLengthBytes += newFile.length();
                        }
                    }
                    return tempReservedLengthBytes;
                });
                double newPersistentFileSizeKB = (double)reservedLengthBytes / 1024.0;
                this.setPersistentStorageSize(newPersistentFileSizeKB);
            }
            if (this.timeoutSaveManager.timeoutCalledSave) {
                this.timeoutSaveManager.resetTimeout();
                this.timeoutSaveManager.timeoutCalledSave = false;
            }
            this.ticksOfLastSaveCompleted = Clock.ticks();
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.ready);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveFailed(Throwable cause) {
        if (!this.serviceStarted) {
            return;
        }
        this.setLastStationSaveSuccessful(false);
        if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.fault) {
            log.warning("Data Recovery Service is in fault state, skipping service saveFailed listener implementation");
            return;
        }
        if (this.getDataRecoveryStatus() != BDataRecoveryServiceStatus.saving) {
            log.warning("Data Recovery Service saveFailed listener called while service in state '" + (Object)((Object)this.getDataRecoveryStatus()) + "', skipping service save listener implementation");
            return;
        }
        if (this.getDataRecoveryConfiguration().getPersistentStorageCapacity().isByStorageSize()) {
            double totalStorageRestrictionKiB = this.getDataRecoveryConfiguration().getPersistentStorageCapacity().getMaxStorage() >> 10;
            double currentStorageKiB = this.getPersistentStorageSize();
            if (currentStorageKiB >= totalStorageRestrictionKiB * 0.75) {
                log.severe("Save failed when persistent storage size exceeded maximum, service can not continue");
                this.captureServiceFault("Save failed when persistent storage size exceeded maximum, service can not continue", new Throwable());
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                return;
            }
        }
        Object object = this.blockMonitor;
        synchronized (object) {
            try {
                BDataRecoveryBlockManager toActivate = this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                toActivate.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
            }
            catch (DataRecoveryBlockUnavailableException e) {
                log.warning("No block was set to 'reserved' during Data Recovery Service saveFailed callback (" + e.getBlockStatuses() + "), skipping reserved block activation");
            }
            Object object2 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
            synchronized (object2) {
                AccessController.doPrivileged(() -> {
                    File[] persistentChildren = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(DATA_RECOVERY_FILE_FILTER);
                    if (persistentChildren != null) {
                        for (File persistentChild : persistentChildren) {
                            if (!persistentChild.getName().endsWith(DATA_RECOVERY_FILE_RESERVED_EXTENSION)) continue;
                            String oldName = persistentChild.getAbsolutePath();
                            String newName = oldName.substring(0, oldName.length() - 1);
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("Renaming reserved file " + oldName + " to " + newName);
                            }
                            if (persistentChild.renameTo(new File(newName))) continue;
                            log.severe("Error renaming persistent child: " + oldName);
                        }
                    }
                    return null;
                });
            }
            if (this.timeoutSaveManager.timeoutCalledSave) {
                this.timeoutSaveManager.resetTimeout();
                this.timeoutSaveManager.timeoutCalledSave = false;
            }
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.ready);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownStarted() {
        Object object = this.blockMonitor;
        synchronized (object) {
            this.shutdownStarted = true;
        }
    }

    public final BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final BDataRecoveryBlockManager getBlock(BDataRecoveryBlockManagerStatus ... desiredStatuses) throws DataRecoveryBlockUnavailableException {
        BDataRecoveryBlockManager desiredBlock = null;
        String actualBlockStatusTags = null;
        Object object = this.blockMonitor;
        synchronized (object) {
            if (this.blocksAsArray == null) {
                throw new DataRecoveryException("Blocks not initialized, can not retrieve requested block!");
            }
            for (BDataRecoveryBlockManager bDataRecoveryBlockManager : this.blocksAsArray) {
                for (BDataRecoveryBlockManagerStatus desiredStatus : desiredStatuses) {
                    if (bDataRecoveryBlockManager.getCurrentManagerStatus() != desiredStatus) continue;
                    desiredBlock = bDataRecoveryBlockManager;
                    break;
                }
                if (desiredBlock != null) break;
            }
            if (desiredBlock == null) {
                void var8_14;
                StringBuilder stringBuilder = new StringBuilder();
                BDataRecoveryBlockManager[] bDataRecoveryBlockManagerArray = this.blocksAsArray;
                int n = bDataRecoveryBlockManagerArray.length;
                boolean bl = false;
                while (var8_14 < n) {
                    BDataRecoveryBlockManager tempManager2 = bDataRecoveryBlockManagerArray[var8_14];
                    stringBuilder.append("{").append(tempManager2.getCurrentManagerStatus().getTag()).append("}");
                    ++var8_14;
                }
                actualBlockStatusTags = stringBuilder.toString();
            }
        }
        if (desiredBlock == null) {
            StringBuilder desiredBlockStatusTags = new StringBuilder();
            for (BDataRecoveryBlockManagerStatus bDataRecoveryBlockManagerStatus : desiredStatuses) {
                desiredBlockStatusTags.append("{").append(bDataRecoveryBlockManagerStatus.getTag()).append("}");
            }
            throw new DataRecoveryBlockUnavailableException("Target status " + desiredBlockStatusTags.toString() + " not found", actualBlockStatusTags);
        }
        return desiredBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activateReservedIfReady() {
        if (this.getDataRecoveryStatus() != BDataRecoveryServiceStatus.ready) {
            return false;
        }
        Object object = this.blockMonitor;
        synchronized (object) {
            if (this.getDataRecoveryStatus() != BDataRecoveryServiceStatus.ready) {
                return false;
            }
            try {
                this.getBlock(BDataRecoveryBlockManagerStatus.reserved).setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                log.warning("Found 'reserved' data recovery block during 'ready' service status, activated 'reserved' block");
                return true;
            }
            catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activateIdleIfAllIdle() {
        if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.fault) {
            return false;
        }
        byte[] knownApplicationsAsBytes = null;
        try {
            knownApplicationsAsBytes = this.serializeKnownApplications();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error serializing application mapping, service may be susceptible to data loss", e);
        }
        Object object = this.blockMonitor;
        synchronized (object) {
            if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.fault) {
                return false;
            }
            for (BDataRecoveryBlockManager tempManager : this.blocksAsArray) {
                if (tempManager.getCurrentManagerStatus() == BDataRecoveryBlockManagerStatus.idle) continue;
                return false;
            }
            if (this.blocksAsArray.length == 0) {
                return false;
            }
            log.warning("All data recovery blocks were idle during executing, activating a block");
            if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.saving) {
                this.blocksAsArray[0].setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.reserved);
            } else {
                this.blocksAsArray[0].setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
            }
            return knownApplicationsAsBytes == null || knownApplicationsAsBytes.length == 0 || this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, knownApplicationsAsBytes);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] encodeKnownApplications() {
        ArrayList<String> buffer = new ArrayList<String>();
        Object object = this.applicationMonitor;
        synchronized (object) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Encoding known applications...");
            }
            for (ApplicationEntry applicationInfo : this.knownApplications.values()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Encoding application entry: " + applicationInfo.getId() + " -> " + applicationInfo.getEncodedOrd());
                }
                buffer.add(applicationInfo.getEncodedOrd());
            }
        }
        return buffer.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeKnownApplications() throws Exception {
        ByteBuffer buffer = new ByteBuffer();
        Object object = this.applicationMonitor;
        synchronized (object) {
            buffer.writeLong(this.activeSequenceNumber++);
            Collection<ApplicationEntry> valuesInMap = this.knownApplications.values();
            Iterator<ApplicationEntry> valueIterator = valuesInMap.iterator();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Serializing known applications...");
            }
            while (valueIterator.hasNext()) {
                ApplicationEntry temporary = valueIterator.next();
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Serializing application entry: " + temporary.getId() + " -> " + temporary.getEncodedOrd());
                }
                buffer.write(temporary.toRecoveryBytes());
            }
        }
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long extractActiveSequenceNumberFromRecoveryData(LinkedList<IDataRecoveryRecord> list) {
        long sequenceNumber = -1L;
        if (list == null || list.isEmpty()) {
            return -1L;
        }
        while (!list.isEmpty()) {
            boolean applicationEntryFound;
            byte[] recoveryData;
            block19: {
                IDataRecoveryRecord currentRecord = list.remove(0);
                if (currentRecord == null) {
                    log.warning("Null data recovery record in non-empty list, skipping list.");
                    break;
                }
                byte sourceByte = currentRecord.getDataRecoverySourceIdentifier();
                byte[] recoveryKey = currentRecord.getKey();
                recoveryData = currentRecord.getData();
                if (recoveryKey == null) {
                    log.warning("Null recovery data key detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (recoveryData == null) {
                    log.warning("Null recovery data detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (sourceByte != 0) continue;
                applicationEntryFound = false;
                try {
                    BBlob testBlob = (BBlob)BBlob.DEFAULT.decode((DataInput)new ByteBuffer(recoveryKey));
                    if (!testBlob.equals((Object)APPLICATIONS_KEY_AS_BLOB)) break block19;
                    applicationEntryFound = true;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error decoding suspect application bytes, skipping record: ", e);
                    continue;
                }
            }
            if (!applicationEntryFound) continue;
            FilterInputStream dis = null;
            try {
                dis = new DataInputStream(new ByteArrayInputStream(recoveryData));
                long l = sequenceNumber = ((DataInputStream)dis).readLong();
                return l;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unexpected error while replaying application map: ", e);
                long l = -1L;
                return l;
            }
            finally {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return sequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApplicationEntry[] extractMapFromRecoveryData(LinkedList<IDataRecoveryRecord> list) {
        foundMap = false;
        applicationEntriesEncountered = new ApplicationEntry[255];
        for (i = 0; i < 255; ++i) {
            applicationEntriesEncountered[i] = null;
        }
        applicationEntriesEncountered[0] = new ApplicationEntry(this.selfAsOrd.encodeToString(), 0, 0L, 0L);
        applicationEntriesEncounteredSize = 1;
        if (list == null) return null;
        if (list.isEmpty()) {
            return null;
        }
        while (!list.isEmpty()) {
            block17: {
                currentRecord = list.remove(0);
                sourceByte = currentRecord.getDataRecoverySourceIdentifier();
                recoveryKey = currentRecord.getKey();
                recoveryData = currentRecord.getData();
                if (recoveryKey == null) {
                    BDataRecoveryService.log.warning("Null recovery data key detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (recoveryData == null) {
                    BDataRecoveryService.log.warning("Null recovery data detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (sourceByte != 0) continue;
                applicationEntryFound = false;
                try {
                    testBlob = (BBlob)BBlob.DEFAULT.decode((DataInput)new ByteBuffer(recoveryKey));
                    if (!testBlob.equals((Object)BDataRecoveryService.APPLICATIONS_KEY_AS_BLOB)) break block17;
                    applicationEntryFound = true;
                }
                catch (Exception e) {
                    BDataRecoveryService.log.log(Level.SEVERE, "Error decoding suspect application bytes, skipping record: ", e);
                    continue;
                }
            }
            if (!applicationEntryFound) continue;
            try {
                dis = new DataInputStream(new ByteArrayInputStream(recoveryData));
                dis.readLong();
                while (true) {
                    try {
                        block18: {
                            temporaryEntry = new ApplicationEntry();
                            temporaryEntry.fromRecoveryBytes(dis);
                            if (BDataRecoveryService.log.isLoggable(Level.FINER)) {
                                BDataRecoveryService.log.finer("Found application entry: " + temporaryEntry.getId() + " -> " + temporaryEntry.getEncodedOrd());
                            }
                            if (applicationEntriesEncountered[temporaryEntry.id] != null) break block18;
                            applicationEntriesEncountered[temporaryEntry.id] = temporaryEntry;
                            ++applicationEntriesEncounteredSize;
                            ** GOTO lbl-1000
                        }
                        if (temporaryEntry.id == 0 || applicationEntriesEncountered[temporaryEntry.id].getEncodedOrd().equals(temporaryEntry.getEncodedOrd())) ** GOTO lbl-1000
                        BDataRecoveryService.log.severe("Duplicate id encountered: " + temporaryEntry.getEncodedOrd() + " != " + applicationEntriesEncountered[temporaryEntry.id].getEncodedOrd());
                        var13_17 = null;
                        ** GOTO lbl60
                    }
                    catch (EOFException e) {
                        break;
                    }
                    catch (Exception e) {
                        block19: {
                            break block19;
                            catch (Throwable var15_21) {
                                dis.close();
                                throw var15_21;
                            }
lbl60:
                            // 1 sources

                            dis.close();
                            return var13_17;
                        }
                        BDataRecoveryService.log.log(Level.SEVERE, "Unexpected error while replaying application map: ", e);
                        var14_20 = null;
                        dis.close();
                        return var14_20;
                    }
lbl-1000:
                    // 2 sources

                    {
                        foundMap = true;
                        continue;
                    }
                    break;
                }
                dis.close();
            }
            catch (Exception e) {
                BDataRecoveryService.log.log(Level.SEVERE, "Error while reading byte buffer input stream: ", e);
                return null;
            }
        }
        if (foundMap == false) return null;
        entries = new ApplicationEntry[applicationEntriesEncounteredSize];
        System.arraycopy(applicationEntriesEncountered, 0, entries, 0, applicationEntriesEncounteredSize);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doReplayRecoveryData() {
        BDataRecoveryServiceStatus old = this.getDataRecoveryStatus();
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.replaying);
        log.fine("Starting data recovery replay...");
        log.fine("Locating data recovery source map...");
        LinkedList<IDataRecoveryRecord> activeData = BDataRecoveryBlockManager.replayActiveRecoveryData(ACTIVE_FILE_SEQUENCE_COMPARATOR);
        ApplicationEntry[] applicationEntries = this.extractMapFromRecoveryData(activeData);
        if (applicationEntries == null || applicationEntries.length <= 1) {
            log.warning("Data recovery map not located in active store, continue search to persistent...");
            LinkedList<IDataRecoveryRecord> persistentData = BDataRecoveryBlockManager.replayLastPersistentFile();
            applicationEntries = this.extractMapFromRecoveryData(persistentData);
            if (applicationEntries == null || applicationEntries.length <= 1) {
                log.severe("Could not locate data recovery source map, data can not be recovered.");
                this.setDataRecoveryStatus(old);
                return BBoolean.FALSE;
            }
        }
        this.persistentFileCounter = BDataRecoveryBlockManager.getLastPersistentFileNumber() + 1L;
        HashMap<Byte, BIDataRecoverySource> resolvedSources = new HashMap<Byte, BIDataRecoverySource>();
        HashMap<BOrd, ApplicationEntry> unresolvedSources = new HashMap<BOrd, ApplicationEntry>();
        log.fine("Data recovery map located, resolving sources...");
        if (log.isLoggable(Level.FINE)) {
            for (ApplicationEntry entry : applicationEntries) {
                log.fine("Found map for: " + entry.getId() + " -> " + entry.getEncodedOrd());
            }
        }
        for (ApplicationEntry entry : applicationEntries) {
            try {
                unresolvedSources.put((BOrd)BOrd.DEFAULT.decodeFromString(entry.getEncodedOrd()), new ApplicationEntry(entry.getEncodedOrd(), entry.getId(), 0L, 0L));
                BIDataRecoverySource resolved = (BIDataRecoverySource)BOrd.make((String)entry.getEncodedOrd()).resolve().get();
                resolvedSources.put(entry.getId(), resolved);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not resolve Ord \"" + entry.getEncodedOrd() + "\", skipping...", e);
            }
        }
        log.fine("Sources resolved, replaying data to sources...");
        BDataRecoveryBlockManager.replayRecoveryData(resolvedSources, ACTIVE_FILE_SEQUENCE_COMPARATOR);
        Object object = this.applicationMonitor;
        synchronized (object) {
            this.knownApplications = unresolvedSources;
            this.externalApplicationsEncountered = this.knownApplications.size() == 0 ? 0 : this.knownApplications.size() - 1;
        }
        log.fine("Replay completed");
        this.setDataRecoveryStatus(old);
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doRefreshPersistentStorageSize(BDataRecoveryFlushEvent dataRecoveryFlushEvent) {
        Object object = BDataRecoveryBlockManager.persistentDirectoryMonitor;
        synchronized (object) {
            if (dataRecoveryFlushEvent == null || dataRecoveryFlushEvent.getFlushSizeBytes() == -1L) {
                String persistentDirectoryString = this.getDataRecoveryConfiguration().getPersistentDirectory();
                File persistentDirectory = new File(persistentDirectoryString);
                double totalLengthInBytes = AccessController.doPrivileged(() -> {
                    File[] files;
                    double tempLength = 0.0;
                    if (persistentDirectory.exists() && persistentDirectory.isDirectory() && (files = persistentDirectory.listFiles(DATA_RECOVERY_FILE_FILTER)) != null && files.length != 0) {
                        for (File file : files) {
                            tempLength += (double)file.length();
                        }
                    }
                    return tempLength;
                });
                double newPersistentFileSizeKB = totalLengthInBytes / 1024.0;
                this.setPersistentStorageSize(newPersistentFileSizeKB);
            } else {
                double newPersistentFileSizeKB = this.getPersistentStorageSize() + (double)dataRecoveryFlushEvent.getFlushSizeBytes() / 1024.0;
                this.setPersistentStorageSize(newPersistentFileSizeKB);
            }
        }
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doPurgeRecovery() {
        BBoolean rc;
        boolean individualErrorOccurred = false;
        boolean trace = log.isLoggable(Level.FINER);
        Object object = this.applicationMonitor;
        synchronized (object) {
            Object object2 = this.blockMonitor;
            synchronized (object2) {
                Object object3 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
                synchronized (object3) {
                    AccessController.doPrivileged(() -> {
                        Object[] persistentChildren = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(DATA_RECOVERY_FILE_FILTER);
                        if (persistentChildren != null) {
                            SortUtil.sort((Object[])persistentChildren, (Object[])persistentChildren, BDataRecoveryBlockManager.PERSISTENT_FILE_COMPARATOR);
                            for (Object persistentChild : persistentChildren) {
                                if (((File)persistentChild).getName().endsWith(DATA_RECOVERY_FILE_RESERVED_EXTENSION)) continue;
                                if (trace) {
                                    log.finer("Deleting persistent file " + ((File)persistentChild).getName());
                                }
                                if (((File)persistentChild).delete()) continue;
                                log.severe("Error deleting persistent file " + ((File)persistentChild).getAbsolutePath());
                            }
                        }
                        return null;
                    });
                }
                boolean foundAtLeastOne = false;
                ArrayList<BDataRecoveryBlockManager> managersToPurge = new ArrayList<BDataRecoveryBlockManager>();
                for (BDataRecoveryBlockManager tempManager : this.blocksAsArray) {
                    foundAtLeastOne = true;
                    if (tempManager.getCurrentManagerStatus() != BDataRecoveryBlockManagerStatus.reserved) {
                        managersToPurge.add(tempManager);
                        continue;
                    }
                    if (!trace) continue;
                    log.finer("Skipping purge operation on " + tempManager.getName() + ", manager state is reserved");
                }
                if (foundAtLeastOne) {
                    BDataRecoveryBlockManager[] bDataRecoveryBlockManagerArray = managersToPurge.toArray(new BDataRecoveryBlockManager[0]);
                    SortUtil.sort((Object[])bDataRecoveryBlockManagerArray, (Object[])bDataRecoveryBlockManagerArray, BDataRecoveryBlockManager.DEFAULT_RECOVERY_MANAGER_COMPARATOR);
                    for (BDataRecoveryBlockManager managerChild : bDataRecoveryBlockManagerArray) {
                        BBoolean individualPurge;
                        if (trace) {
                            log.finer("Purging manager " + managerChild.getName() + " (" + (managerChild.getUsedSpace() + managerChild.getOverheadSpace()) + " bytes)");
                        }
                        if ((individualPurge = managerChild.doPurgeRecoveryData()).getBoolean()) {
                            if (!trace) continue;
                            log.finer("Purge operation on " + managerChild.getName() + " successful");
                            continue;
                        }
                        individualErrorOccurred = true;
                        log.severe("Purge operation on " + managerChild.getName() + " failed");
                    }
                } else {
                    Object object4 = BDataRecoveryBlockManager.activeDirectoryMonitor;
                    synchronized (object4) {
                        AccessController.doPrivileged(() -> {
                            Object[] activeChildren = BDataRecoveryBlockManager.getActiveDirectory().listFiles(DATA_RECOVERY_FILE_FILTER);
                            if (activeChildren != null) {
                                SortUtil.sort((Object[])activeChildren, (Object[])activeChildren, ACTIVE_FILE_SEQUENCE_COMPARATOR);
                                for (Object activeChild : activeChildren) {
                                    if (chunkFSPresent) {
                                        try {
                                            if (trace) {
                                                log.finer("Truncating active file " + activeChild);
                                            }
                                            FileOutputStream temp = new FileOutputStream((File)activeChild, false);
                                            temp.close();
                                        }
                                        catch (Exception e) {
                                            log.log(Level.SEVERE, "Error truncating the active file", e);
                                            this.captureServiceFault("Error truncating the active file " + e, e);
                                            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                                        }
                                        continue;
                                    }
                                    if (((File)activeChild).delete()) continue;
                                    log.severe("Error deleting uninitialized active file: " + activeChild);
                                }
                            }
                            return null;
                        });
                    }
                }
                rc = this.doRefreshPersistentStorageSize(null);
            }
        }
        if (rc.getBoolean()) {
            if (!individualErrorOccurred) {
                if (trace) {
                    log.finer("Purge operation successful.");
                }
            } else {
                log.warning("Purge operation completed but not all blocks were purged.");
            }
        } else {
            log.severe("Purge operation failed.");
        }
        return rc;
    }

    public final BBoolean doHandleMinSaveTimeout() {
        this.timeoutSaveManager.timeoutExpired();
        return BBoolean.TRUE;
    }

    public final BBoolean doHandleConfigChange() {
        this.dataRecoveryConfigChanged(this.getDataRecoveryConfiguration());
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doResetDataRecoveryStatistics() {
        Object object = this.receivedMonitor;
        synchronized (object) {
            this.totalBytesReceivedSinceStart = 0L;
            this.averageBytesReceivedPerSecondSinceStart = 0.0;
            this.averageRecordSize = 0.0;
            this.numberOfRecordsReceivedSinceStart = 0L;
            this.tooLargeEventsSinceStart = 0L;
        }
        object = this.flushedMonitor;
        synchronized (object) {
            this.totalBytesFlushedSinceStart = 0L;
            this.timesFlushedSinceStart = 0L;
            this.mostRecentFlushTimes.clear();
            this.averageBytesFlushedPerFlush = 0.0;
            this.averageBytesFlushedPerSecondSinceStart = 0.0;
        }
        this.serviceStartTimeMilliseconds = System.currentTimeMillis();
        object = this.applicationMonitor;
        synchronized (object) {
            if (this.knownApplications != null) {
                Collection<ApplicationEntry> clients = this.knownApplications.values();
                clients.forEach(ApplicationEntry::clearMetrics);
            }
        }
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doFlushRecoveryData() {
        BBoolean rc;
        block27: {
            try {
                BDataRecoveryBlockManager toFlush;
                BDataRecoveryBlockManager toActivate = null;
                boolean flushingReserved = false;
                byte[] knownApplicationsAsBytes = null;
                try {
                    knownApplicationsAsBytes = this.serializeKnownApplications();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error serializing application mapping, service may be susceptible to data loss", e);
                }
                Object object = this.blockMonitor;
                synchronized (object) {
                    boolean needToActivate;
                    int activateAttempts;
                    BDataRecoveryServiceStatus currentStatus = this.getDataRecoveryStatus();
                    if (currentStatus == BDataRecoveryServiceStatus.ready) {
                        toFlush = this.getBlock(BDataRecoveryBlockManagerStatus.active);
                    } else if (currentStatus == BDataRecoveryServiceStatus.saving) {
                        toFlush = this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                        flushingReserved = true;
                    } else {
                        log.warning("Attempted to flush while status was neither ready or saving, aborting operation.");
                        throw new Exception("IllegalStatus during flush");
                    }
                    for (activateAttempts = 0; activateAttempts < 3; ++activateAttempts) {
                        try {
                            toActivate = this.getBlock(BDataRecoveryBlockManagerStatus.idle, BDataRecoveryBlockManagerStatus.awaitingIdle);
                            break;
                        }
                        catch (DataRecoveryBlockUnavailableException unavailableException) {
                            log.warning("No idle block (" + unavailableException.getBlockStatuses() + ") at flush during service state \"" + (Object)((Object)this.getDataRecoveryStatus()) + "\" on thread \"" + Thread.currentThread().getName() + "\", retrying (attempt " + (activateAttempts + 1) + " of 3)");
                            try {
                                this.blockMonitor.wait(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    toFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.flushQueued);
                    if (toActivate == null) {
                        log.severe("Could not obtain an idle block when attempting to flush, a serious error has occurred");
                        this.dumpStatistics(System.err);
                        Thread.dumpStack();
                        this.captureServiceFault("Could not obtain an idle block when attempting to flush, a serious error has occurred", new Throwable());
                        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                        rc = BBoolean.FALSE;
                        break block27;
                    }
                    BDataRecoveryBlockManagerStatus desiredStatus = currentStatus == BDataRecoveryServiceStatus.ready ? BDataRecoveryBlockManagerStatus.active : BDataRecoveryBlockManagerStatus.reserved;
                    if (activateAttempts == 0) {
                        needToActivate = true;
                    } else {
                        boolean foundTargetStatus = false;
                        for (BDataRecoveryBlockManager tempManager : this.blocksAsArray) {
                            if (tempManager.getCurrentManagerStatus() != desiredStatus) continue;
                            foundTargetStatus = true;
                            break;
                        }
                        boolean bl = needToActivate = !foundTargetStatus;
                    }
                    if (needToActivate) {
                        toActivate.setCurrentManagerStatus(desiredStatus);
                        if (knownApplicationsAsBytes != null && knownApplicationsAsBytes.length != 0) {
                            this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, knownApplicationsAsBytes);
                        }
                    }
                }
                drsFlushService.submit(new RecoveryDataFlushJob(toFlush, flushingReserved));
                rc = BBoolean.TRUE;
            }
            catch (Exception e) {
                if (e instanceof DataRecoveryBlockUnavailableException) {
                    DataRecoveryBlockUnavailableException unavailableException = (DataRecoveryBlockUnavailableException)((Object)e);
                    log.warning("Error active or inactive block (" + unavailableException.getBlockStatuses() + "), coult not flush: " + (Object)((Object)unavailableException));
                } else {
                    log.log(Level.SEVERE, "Error retrieving active or inactive block, could not flush: ", e);
                }
                rc = BBoolean.FALSE;
            }
        }
        if (rc.getBoolean()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Flush operation successful.");
            }
        } else {
            log.severe("Flush operation failed.");
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doDumpRecoveryData() {
        BBoolean rc;
        try {
            System.out.println("Current Application (Nav Ord) to Source ID Byte Map:");
            System.out.println("{");
            Object object = this.applicationMonitor;
            synchronized (object) {
                Collection<ApplicationEntry> clients = this.knownApplications.values();
                for (ApplicationEntry client : clients) {
                    System.out.println("  Encoded Ord: " + client.getEncodedOrd() + " -> " + client.getId());
                }
            }
            System.out.println("}");
            System.out.println();
            object = this.blockMonitor;
            synchronized (object) {
                for (BDataRecoveryBlockManager tempManager : this.blocksAsArray) {
                    tempManager.dump(System.out);
                }
            }
            rc = BBoolean.TRUE;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error printing data recovery debug information: ", e);
            rc = BBoolean.FALSE;
        }
        if (rc.getBoolean()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Dump operation successful.");
            }
        } else {
            log.severe("Dump operation failed.");
        }
        return rc;
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getDataRecoveryAlarmProxy().addPlatformServiceAlarmListener(listener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getDataRecoveryAlarmProxy().removePlatformServiceAlarmListener(listener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initDataRecoveryAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setAlertText(BFormat.make((String)"%lexicon(platDataRecovery:dataRecoveryReplay)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)LICENSE_FEATURE));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    public void dataRecoverySpy(SpyWriter out, Iterator<IDataRecoveryRecord> dataRecovery) {
    }

    public boolean dataRecoveryRestore(IDataRecoveryRecord record) {
        return false;
    }

    public void dataRecoveryRestoreComplete() {
    }

    public final BBoolean doClearStationSaveCount() {
        this.stationSavesGenerated = 0;
        return BBoolean.TRUE;
    }

    private boolean tooManySaves() {
        boolean tooManySaves;
        if (this.stationSavesGenerated >= this.getStationSaveLimit()) {
            tooManySaves = true;
            if (!this.getTooManySaves()) {
                BPlatform.log.warning("Data Recovery Service save limit exceeded");
            }
        } else {
            tooManySaves = false;
        }
        this.setTooManySaves(tooManySaves);
        return tooManySaves;
    }

    public String checkForStationFault() {
        if (this.tooManySaves()) {
            return "stationFault.dataRecoverySave";
        }
        if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.fault) {
            return "stationFault.dataRecoveryFault";
        }
        if (chunkFSPresent) {
            long freeSpaceBytes = BDataRecoveryService.freeStorageSizeBytes(this.getDataRecoveryConfiguration().getPersistentDirectory());
            long usedSpaceBytes = (long)Math.floor(this.getPersistentStorageSize() * 1024.0);
            long requiredSpaceBytes = this.getDataRecoveryConfiguration().getPersistentStorageCapacity().getMaxStorage();
            long remainingSpaceRequiredBytes = requiredSpaceBytes - usedSpaceBytes;
            if (freeSpaceBytes < remainingSpaceRequiredBytes) {
                long availableKiB = freeSpaceBytes / 1024L;
                long remainingSpaceRequiredKiB = remainingSpaceRequiredBytes / 1024L;
                log.warning("Inadequate persistent storage available (" + availableKiB + " KB < " + remainingSpaceRequiredKiB + " KB), service may enter fault");
                return "stationFault.dataRecoveryLowDisk";
            }
        }
        return null;
    }

    private void captureServiceFault(String faultMessage, Throwable faultThrowable) {
        this.lastFaultMessage = faultMessage;
        this.lastFaultThrowable = faultThrowable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpStatistics(PrintStream out) {
        out.println();
        out.println("Data Recovery Service statistics:");
        out.println("==============================================================================");
        out.println();
        out.println("Seconds Since Service Started / Last Reset:    " + (System.currentTimeMillis() - this.serviceStartTimeMilliseconds) / 1000L);
        out.println("Total Number Of Records Received:              " + this.numberOfRecordsReceivedSinceStart);
        out.println("Average Size of Record Received:               " + this.averageRecordSize);
        out.println("Total Bytes Received Since Start / Last Reset: " + this.totalBytesReceivedSinceStart);
        out.println("Average Bytes Received/Second:                 " + this.averageBytesReceivedPerSecondSinceStart);
        out.println("Total Bytes Flushed Since Start / Last Reset:  " + this.totalBytesFlushedSinceStart);
        out.println("Average Bytes Flushed/Second:                  " + this.averageBytesFlushedPerSecondSinceStart);
        out.println("Total Number of Times Flush Occurred:          " + this.timesFlushedSinceStart);
        out.println("Average Bytes Flushed/Flush:                   " + this.averageBytesFlushedPerFlush);
        out.println("Number of Too Large Events Encountered:        " + this.tooLargeEventsSinceStart);
        out.println();
        out.println("Last 10 Flushes: ");
        for (Map.Entry entry : this.mostRecentFlushTimes.entrySet()) {
            out.println("Flush " + entry.getKey() + ": " + entry.getValue() + "ms");
        }
        out.println();
        Object object = this.applicationMonitor;
        synchronized (object) {
            if (this.knownApplications != null) {
                Collection<ApplicationEntry> values = this.knownApplications.values();
                values.stream().filter(applicationInfo -> !applicationInfo.getEncodedOrd().equals(this.selfAsOrd.encodeToString())).forEach(applicationInfo -> {
                    out.println("Source Ord:             " + applicationInfo.getEncodedOrd());
                    try {
                        out.println("Source Type:            " + BOrd.make((String)applicationInfo.getEncodedOrd()).resolve().get().getType());
                    }
                    catch (Exception e) {
                        out.println("Source Type:            " + applicationInfo.getEncodedOrd());
                    }
                    out.println("Source Byte:            " + applicationInfo.getId());
                    out.println("Records Generated:      " + applicationInfo.getRecordsGenerated());
                    out.println("Key Data Generated:     " + applicationInfo.getKeyDataGenerated());
                    out.println("Payload Data Generated: " + applicationInfo.getPayloadDataGenerated());
                    out.println("Total Data Generated:   " + applicationInfo.getTotalDataGenerated());
                    out.println("Average Key Size:       " + applicationInfo.getAverageKeySize());
                    out.println("Average Payload Size:   " + applicationInfo.getAveragePayloadSize());
                    out.println("Average Record Size:    " + applicationInfo.getAverageRecordSize());
                    out.println();
                });
            }
        }
    }

    public static long lengthOfFile(File f) {
        long length;
        try (FileInputStream fin = new FileInputStream(f);){
            long read;
            byte[] buffer = new byte[1024];
            long readTotal = 0L;
            while ((read = (long)fin.read(buffer)) != -1L) {
                readTotal += read;
            }
            length = readTotal;
        }
        catch (Exception e) {
            length = 0L;
        }
        return length;
    }

    private static long totalStorageSpaceBytes(String directoryPath) {
        long totalSpace;
        try {
            totalSpace = AccessController.doPrivileged(() -> {
                File targetFileSystem = new File(directoryPath);
                while (!targetFileSystem.exists()) {
                    targetFileSystem = targetFileSystem.getParentFile();
                }
                return targetFileSystem.getTotalSpace();
            });
        }
        catch (PrivilegedActionException pae) {
            log.log(Level.SEVERE, "Failed to determine total space", pae.getException());
            throw new BajaRuntimeException((Throwable)pae.getException());
        }
        return totalSpace;
    }

    private static long freeStorageSizeBytes(String directoryPath) {
        long usableSpace;
        try {
            usableSpace = AccessController.doPrivileged(() -> {
                File targetFileSystem = new File(directoryPath);
                while (!targetFileSystem.exists()) {
                    targetFileSystem = targetFileSystem.getParentFile();
                }
                return targetFileSystem.getUsableSpace();
            });
        }
        catch (PrivilegedActionException pae) {
            log.log(Level.SEVERE, "Failed to determine free space", pae.getException());
            throw new BajaRuntimeException((Throwable)pae.getException());
        }
        return usableSpace;
    }

    private static long getRequiredPersistentStorageBytes(String persistentDirectoryPath) {
        long bytesTotal = BDataRecoveryService.totalStorageSpaceBytes(persistentDirectoryPath);
        long mibTotal = bytesTotal / 0x100000L;
        if (mibTotal >= 2048L) {
            return 0xA00000L;
        }
        return 0x500000L;
    }

    private static boolean loadGeom(String geomLocation) {
        return AccessController.doPrivileged(() -> {
            try (FileInputStream fis = new FileInputStream(geomLocation);){
                Properties p = new Properties();
                p.load(fis);
                chunkfsDeviceSize = Integer.valueOf(p.getProperty("deviceSize"));
                chunkfsNumFiles = Integer.valueOf(p.getProperty("numFiles"));
                chunkfsChunkSize = Integer.valueOf(p.getProperty("chunkSize"));
                chunkfsNumChunks = Integer.valueOf(p.getProperty("numChunks"));
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Error loading SRAM geometry: ", ioe);
                return false;
            }
            return true;
        });
    }

    static {
        DATA_RECOVERY_FILE_FILTER = f -> {
            if (f.isDirectory()) {
                return false;
            }
            String filename = f.getName().toLowerCase();
            if (filename.endsWith(DATA_RECOVERY_FILE_EXTENSION) || filename.endsWith(DATA_RECOVERY_FILE_RESERVED_EXTENSION) || filename.endsWith(DATA_RECOVERY_FILE_CHUNK_EXTENSION)) {
                return true;
            }
            return filename.startsWith(DATA_RECOVERY_FILE_CHUNK_PREFIX) && Character.isDigit(filename.charAt(filename.length() - 1));
        };
        DATA_RECOVERY_WORKING_FILE_FILTER = f -> {
            if (f.isDirectory()) {
                return false;
            }
            return f.getName().toLowerCase().endsWith("_working");
        };
        APPLICATIONS_KEY_AS_BYTES = new byte[]{0};
        TOO_LARGE_EVENT_AS_BYTES = new byte[]{1};
        TOO_LARGE_EVENT_AS_BLOB = BBlob.make((byte[])TOO_LARGE_EVENT_AS_BYTES);
        APPLICATIONS_KEY_AS_BLOB = BBlob.make((byte[])APPLICATIONS_KEY_AS_BYTES);
        chunkfsDeviceSize = 0;
        chunkfsNumFiles = 0;
        chunkfsChunkSize = 0;
        chunkfsNumChunks = 0;
    }

    private static final class ApplicationEntry {
        private static final int MAGIC = 45323;
        private String encodedOrd;
        byte id;
        private int recordsSinceStart;
        private long keyDataGenerated;
        private long payloadDataGenerated;
        private long totalDataGenerated;

        public ApplicationEntry() {
            this.encodedOrd = BOrd.NULL.encodeToString();
            this.id = 0;
        }

        public ApplicationEntry(String spaceNavName, byte idByte, long keySize, long payloadSize) {
            this.encodedOrd = spaceNavName;
            this.id = idByte;
            this.recordsSinceStart = 1;
            this.keyDataGenerated = keySize;
            this.payloadDataGenerated = payloadSize;
            this.totalDataGenerated = keySize + payloadSize + (long)DataRecoveryBlock.getFixedFieldsOfUsedBlockHeaderSize();
        }

        public final String getEncodedOrd() {
            return this.encodedOrd;
        }

        public final byte getId() {
            return this.id;
        }

        public final void updateMetrics(int keyDataWritten, int payloadDataWritten) {
            ++this.recordsSinceStart;
            this.keyDataGenerated += (long)keyDataWritten;
            this.payloadDataGenerated += (long)payloadDataWritten;
            this.totalDataGenerated += (long)(keyDataWritten + payloadDataWritten + DataRecoveryBlock.getFixedFieldsOfUsedBlockHeaderSize());
        }

        public final void clearMetrics() {
            this.recordsSinceStart = 1;
            this.keyDataGenerated = 0L;
            this.payloadDataGenerated = 0L;
            this.totalDataGenerated = 0L;
        }

        public final double getAverageRecordSize() {
            return (double)this.totalDataGenerated / (double)this.recordsSinceStart;
        }

        public final double getAverageKeySize() {
            return (double)this.keyDataGenerated / (double)this.recordsSinceStart;
        }

        public final double getAveragePayloadSize() {
            return (double)this.payloadDataGenerated / (double)this.recordsSinceStart;
        }

        public final long getKeyDataGenerated() {
            return this.keyDataGenerated;
        }

        public final long getPayloadDataGenerated() {
            return this.payloadDataGenerated;
        }

        public final long getTotalDataGenerated() {
            return this.totalDataGenerated;
        }

        public final int getRecordsGenerated() {
            return this.recordsSinceStart;
        }

        public final byte[] toRecoveryBytes() throws Exception {
            ByteBuffer buffer = new ByteBuffer();
            buffer.writeInt(45323);
            buffer.writeUTF(this.encodedOrd);
            buffer.writeByte((int)this.id);
            return buffer.toByteArray();
        }

        public final void fromRecoveryBytes(DataInputStream dis) throws Exception {
            int magic = dis.readInt();
            if (magic != 45323) {
                throw new Exception("Wrong magic number ( " + magic + " ) while reading table of contents");
            }
            this.encodedOrd = dis.readUTF();
            this.id = (byte)dis.readUnsignedByte();
        }
    }

    private static class DRSFlushThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private DRSFlushThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "DataRecovery:FlushThread-";
        }

        @Override
        public Thread newThread(Runnable job) {
            Thread flushThread = new Thread(this.group, job, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            flushThread.setDaemon(true);
            return flushThread;
        }
    }

    static final class DataRecoveryChunkFSSpyPage
    extends SpyDir {
        DataRecoveryChunkFSSpyPage() {
        }

        public final Spy find(String name) {
            return this;
        }

        public final void write(SpyWriter out) throws Exception {
            String line;
            BufferedReader in;
            try {
                in = AccessController.doPrivileged(() -> {
                    String statsPath;
                    if (PlatformUtil.isTridiumPlatform()) {
                        if (new File("/dev/chunkfs/stats").exists()) {
                            return new BufferedReader(new FileReader("/dev/chunkfs/stats"));
                        }
                        return null;
                    }
                    if (PlatformUtil.isNpsdkPlatform() && (statsPath = AccessController.doPrivileged(() -> System.getProperty("niagara.platDataRecovery.chunkfsStatsPath", null))) != null) {
                        return new BufferedReader(new FileReader(statsPath));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            if (in == null) {
                return;
            }
            out.startTable(true);
            out.trTitle((Object)"Chunk FS Geom/Statistics", 1);
            while ((line = in.readLine()) != null) {
                out.tr((Object)line);
            }
            out.endTable();
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class DataRecoverySourceSpyPage
    extends SpyDir {
        BIDataRecoverySource source = null;
        byte sourceByte = 0;

        public DataRecoverySourceSpyPage(BIDataRecoverySource source, byte id) {
            this.source = source;
            this.sourceByte = id;
        }

        public final Spy find(String name) {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(SpyWriter out) throws Exception {
            if (this.source == null) {
                out.write("null source provided to spy writer, further information not available");
                return;
            }
            Object object = BDataRecoveryService.this.blockMonitor;
            synchronized (object) {
                BDataRecoveryBlockManager toSpy = null;
                BDataRecoveryServiceStatus currentStatus = BDataRecoveryService.this.getDataRecoveryStatus();
                if (currentStatus == BDataRecoveryServiceStatus.ready) {
                    try {
                        toSpy = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.active);
                    }
                    catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {}
                } else if (currentStatus == BDataRecoveryServiceStatus.saving) {
                    try {
                        toSpy = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                    }
                    catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {}
                } else if (currentStatus == BDataRecoveryServiceStatus.fault) {
                    try {
                        toSpy = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.flushQueued);
                    }
                    catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
                        try {
                            toSpy = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                        }
                        catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException2) {
                            try {
                                toSpy = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.active);
                            }
                            catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException3) {
                                try {
                                    toSpy = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.fail);
                                }
                                catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException4) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (toSpy == null) {
                    out.write("Data Recovery Service in an indeterminate state while querying source '" + this.source + "', additional spy information is not available at this time");
                    return;
                }
                LinkedList<IDataRecoveryRecord> currentData = toSpy.scanBlocksForSource(this.sourceByte);
                this.source.dataRecoverySpy(out, currentData.iterator());
            }
        }
    }

    private final class DataRecoveryServiceSpyPage
    extends SpyDir {
        HashMap<String, DataRecoverySourceSpyPage> pages = null;

        public final Spy find(String name) {
            if ("CHUNK_FS_STATS".equals(name)) {
                return new DataRecoveryChunkFSSpyPage();
            }
            return (Spy)this.pages.get(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(SpyWriter out) throws Exception {
            out.startTable(false);
            out.startProps("Data recovery Performance Metrics");
            out.prop((Object)"Seconds Since Service Started / Last Reset", (Object)new Long((System.currentTimeMillis() - BDataRecoveryService.this.serviceStartTimeMilliseconds) / 1000L));
            out.prop((Object)"Total Number Of Records Received", (Object)new Long(BDataRecoveryService.this.numberOfRecordsReceivedSinceStart));
            out.prop((Object)"Average Size of Record Received", (Object)new Double(BDataRecoveryService.this.averageRecordSize));
            out.prop((Object)"Total Bytes Received Since Start / Last Reset", (Object)new Long(BDataRecoveryService.this.totalBytesReceivedSinceStart));
            out.prop((Object)"Average Bytes Received/Second", (Object)new Double(BDataRecoveryService.this.averageBytesReceivedPerSecondSinceStart));
            out.prop((Object)"Total Bytes Flushed Since Start / Last Reset", (Object)new Long(BDataRecoveryService.this.totalBytesFlushedSinceStart));
            out.prop((Object)"Average Bytes Flushed/Second", (Object)new Double(BDataRecoveryService.this.averageBytesFlushedPerSecondSinceStart));
            out.prop((Object)"Total Number of Times Flush Occurred", (Object)new Long(BDataRecoveryService.this.timesFlushedSinceStart));
            out.prop((Object)"Average Bytes Flushed/Flush", (Object)new Double(BDataRecoveryService.this.averageBytesFlushedPerFlush));
            out.prop((Object)"Number of Too Large Events Encountered", (Object)new Long(BDataRecoveryService.this.tooLargeEventsSinceStart));
            if (BDataRecoveryService.this.lastFaultMessage != null) {
                out.prop((Object)"Last Fault Message", (Object)BDataRecoveryService.this.lastFaultMessage);
            }
            if (BDataRecoveryService.this.lastFaultThrowable != null) {
                out.prop((Object)"Last Fault Throwable", (Object)ThrowableUtil.dumpToString((Throwable)BDataRecoveryService.this.lastFaultThrowable));
            }
            if (chunkFSPresent) {
                out.propValueLink((Object)"Chunk FS", (Object)"CHUNK_FS_STATS", (Object)" Statistics ");
            }
            out.endProps();
            out.startProps("Last 10 flushes");
            for (Map.Entry entry : BDataRecoveryService.this.mostRecentFlushTimes.entrySet()) {
                out.prop((Object)("Flush " + entry.getKey() + ": "), (Object)(entry.getValue() + "ms"));
            }
            out.endProps();
            Object object = BDataRecoveryService.this.blockMonitor;
            synchronized (object) {
                for (BDataRecoveryBlockManager tempManager : BDataRecoveryService.this.blocksAsArray) {
                    tempManager.spy(out, false);
                }
            }
            out.startProps("Data recovery Sources");
            if (this.pages != null) {
                this.pages.clear();
            }
            object = BDataRecoveryService.this.applicationMonitor;
            synchronized (object) {
                if (BDataRecoveryService.this.knownApplications != null) {
                    Collection collection = BDataRecoveryService.this.knownApplications.values();
                    for (ApplicationEntry applicationInfo : collection) {
                        BIDataRecoverySource source;
                        block21: {
                            if (applicationInfo.getEncodedOrd().equals(BDataRecoveryService.this.selfAsOrd.encodeToString())) continue;
                            out.prop((Object)"Source Ord", (Object)applicationInfo.getEncodedOrd());
                            try {
                                out.prop((Object)"Source Type", (Object)BOrd.make((String)applicationInfo.getEncodedOrd()).resolve().get().getType());
                            }
                            catch (Exception e) {
                                out.prop((Object)"Source Type", (Object)applicationInfo.getEncodedOrd());
                            }
                            out.prop((Object)"Source Byte", (int)applicationInfo.getId());
                            out.prop((Object)"Records Generated", applicationInfo.getRecordsGenerated());
                            out.prop((Object)"Key Data Generated", (Object)new Long(applicationInfo.getKeyDataGenerated()));
                            out.prop((Object)"Payload Data Generated", (Object)new Long(applicationInfo.getPayloadDataGenerated()));
                            out.prop((Object)"Total Data Generated", (Object)new Long(applicationInfo.getTotalDataGenerated()));
                            out.prop((Object)"Average Key Size", (Object)new Double(applicationInfo.getAverageKeySize()));
                            out.prop((Object)"Average Payload Size", (Object)new Double(applicationInfo.getAveragePayloadSize()));
                            out.prop((Object)"Average Record Size", (Object)new Double(applicationInfo.getAverageRecordSize()));
                            source = null;
                            try {
                                source = (BIDataRecoverySource)BOrd.make((String)applicationInfo.getEncodedOrd()).resolve().get();
                            }
                            catch (ClassCastException classCastException) {
                            }
                            catch (SyntaxException se) {
                                if (BDataRecoveryService.this.testSpySource == null) break block21;
                                source = BDataRecoveryService.this.testSpySource;
                            }
                        }
                        if (source == null) {
                            out.prop((Object)"", (Object)"");
                            continue;
                        }
                        DataRecoverySourceSpyPage sourcePage = new DataRecoverySourceSpyPage(source, applicationInfo.getId());
                        if (this.pages == null) {
                            this.pages = new HashMap();
                        }
                        this.pages.put(EscUtil.slot.escape(source.getType().getTypeSpec().encodeToString()), sourcePage);
                        out.propValueLink((Object)"Additional statistics", (Object)EscUtil.slot.escape(source.getType().getTypeSpec().encodeToString()), (Object)applicationInfo.getEncodedOrd());
                        out.prop((Object)"", (Object)"");
                    }
                }
            }
            out.endProps();
            out.endTable();
        }
    }

    private static class MRUFlushTimes
    extends LinkedHashMap<Long, Long> {
        public MRUFlushTimes(int initialSize) {
            super(initialSize);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Long> entry) {
            return this.size() > 10;
        }
    }

    private final class RecoveryDataFlushJob
    implements Runnable {
        BDataRecoveryBlockManager managerToFlush = null;
        boolean flushingReserved = false;

        public RecoveryDataFlushJob(BDataRecoveryBlockManager toFlush, boolean flushToReserved) {
            this.managerToFlush = toFlush;
            this.flushingReserved = flushToReserved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            BBoolean successful = BBoolean.FALSE;
            double bytesToFlush = 0.0;
            long millisAtStart = System.currentTimeMillis();
            if (this.managerToFlush != null) {
                bytesToFlush = this.managerToFlush.getMaxCapacity() - this.managerToFlush.getFreeSpace();
                String longString = String.valueOf(BDataRecoveryService.this.persistentFileCounter++);
                successful = this.flushingReserved ? this.managerToFlush.doFlushRecoveryData(longString + BDataRecoveryService.DATA_RECOVERY_FILE_RESERVED_EXTENSION) : this.managerToFlush.doFlushRecoveryData(longString + BDataRecoveryService.DATA_RECOVERY_FILE_EXTENSION);
            }
            if (successful.getBoolean()) {
                Object object = BDataRecoveryService.this.flushedMonitor;
                synchronized (object) {
                    BDataRecoveryService.this.totalBytesFlushedSinceStart = (long)((double)BDataRecoveryService.this.totalBytesFlushedSinceStart + bytesToFlush);
                    BDataRecoveryService.this.timesFlushedSinceStart++;
                    BDataRecoveryService.this.mostRecentFlushTimes.put(BDataRecoveryService.this.timesFlushedSinceStart, System.currentTimeMillis() - millisAtStart);
                    BDataRecoveryService.this.averageBytesFlushedPerSecondSinceStart = (double)BDataRecoveryService.this.totalBytesFlushedSinceStart / (double)(System.currentTimeMillis() - BDataRecoveryService.this.serviceStartTimeMilliseconds) * 1000.0;
                    BDataRecoveryService.this.averageBytesFlushedPerFlush = (double)BDataRecoveryService.this.totalBytesFlushedSinceStart / (double)BDataRecoveryService.this.timesFlushedSinceStart;
                }
                this.managerToFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.awaitingIdle);
                object = BDataRecoveryService.this.blockMonitor;
                synchronized (object) {
                    if (this.managerToFlush.getCurrentManagerStatus() == BDataRecoveryBlockManagerStatus.awaitingIdle) {
                        this.managerToFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                        BDataRecoveryService.this.blockMonitor.notify();
                    }
                }
            }
            log.severe("The manager failed to flush data successfully, a save is required");
            this.managerToFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.fail);
        }
    }

    private final class TimeoutSaveManager {
        private Clock.Ticket minSaveTimer = null;
        private final BRelTime minTime = BRelTime.make((long)AccessController.doPrivileged(() -> Long.getLong("niagara.platDataRecovery.tooLargeTimeout", 600000L)));
        private boolean timeoutSaveRequested = false;
        volatile boolean timeoutCalledSave = false;

        public synchronized void requestSave() {
            if (this.minSaveTimer != null && !this.minSaveTimer.isExpired() || this.timeoutCalledSave) {
                this.timeoutSaveRequested = true;
            } else {
                this.timeoutCalledSave = true;
                try {
                    new Thread("TimeoutSaveManagerRequest"){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(5000L);
                                log.log(Level.FINE, "Issuing save request from TimeoutManager");
                                Station.saveAsync(null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error while attempting to save station during too large event: ", e);
                    this.timeoutCalledSave = false;
                }
            }
        }

        private synchronized void timeoutExpired() {
            if (this.timeoutSaveRequested) {
                try {
                    if (BDataRecoveryService.this.ticksOfLastTooLargeEvent >= BDataRecoveryService.this.ticksOfLastSaveStarted) {
                        this.timeoutCalledSave = true;
                        Station.saveAsync(null);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error while attempting to save station during too large event: ", e);
                }
                this.timeoutSaveRequested = false;
            }
        }

        public synchronized void resetTimeout() {
            if (this.minSaveTimer != null && !this.minSaveTimer.isExpired()) {
                this.minSaveTimer.cancel();
            }
            this.minSaveTimer = Clock.schedule((BComponent)BDataRecoveryService.this, (BRelTime)this.minTime, (Action)handleMinSaveTimeout, null);
        }
    }
}

