/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.ui.BLazyListDropDown;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BRefFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BRefFE.class);
    private static BModule module = Sys.getModuleForClass(BRefFE.class);
    private BGridPane grid;
    private BListDropDown dropDown = new BLazyListDropDown(new RefLoader());
    private BButton linkButton;
    private boolean allowLinkButton = true;
    private BOrionDatabase db;

    public Type getType() {
        return TYPE;
    }

    public BRefFE() {
        this.dropDown.getList().setRenderer((ListRenderer)new Renderer());
        this.linkTo((BComponent)this.dropDown, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.grid = new BGridPane(2);
        this.grid.setStretchColumn(0);
        this.grid.add(null, (BValue)this.dropDown);
        this.linkButton = new BButton((Command)new Hyperlink());
        this.linkButton.setButtonStyle(BButtonStyle.toolBar);
        this.grid.add(null, (BValue)this.linkButton);
        this.setContent((BWidget)this.grid);
    }

    protected void doSetReadonly(boolean readonly) {
        if (this.dropDown != null) {
            this.dropDown.setEnabled(!readonly);
        }
    }

    public void started() {
        BObject val = this.getCurrentValue();
        if (val != null) {
            this.doLoadValue(val, this.getCurrentContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadValue(BObject o, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        boolean allowNull = false;
        if (cx != null && cx.getFacets() != null) {
            allowNull = cx.getFacets().getb("allowNull", false);
        }
        boolean shouldClose = false;
        OrionSession session = BOrionSpace.findSessionInContext((Context)cx);
        if (session == null) {
            session = this.createNewSession(cx);
            boolean bl = shouldClose = session != null;
        }
        if (session == null) {
            throw new OrionException("No database session available.");
        }
        this.db = session.getOrionDatabase();
        try {
            BRef ref = (BRef)o;
            BIOrionObject target = ref.getTarget(session);
            if (target != null) {
                this.dropDown.getList().addItem((Object)target);
                this.dropDown.getList().setSelectedItem((Object)target);
            }
            if (allowNull) {
                BRef unboundRef = BRef.make((BTypeSpec)ref.getTargetTypeSpec());
                this.dropDown.getList().addItem((Object)unboundRef);
                if (target == null) {
                    this.dropDown.getList().setSelectedItem((Object)unboundRef);
                }
            }
            if (this.allowLinkButton && this.getWbShell() != null) {
                this.linkButton.setEnabled(true);
            } else {
                this.linkButton.setEnabled(false);
            }
        }
        finally {
            if (shouldClose) {
                session.close();
            }
        }
    }

    public void allowLinkButton(boolean allow) {
        this.allowLinkButton = allow;
    }

    public BObject doSaveValue(BObject o, Context cx) {
        Object selectedObject = this.dropDown.getSelectedItem();
        if (selectedObject instanceof BIOrionObject) {
            BIOrionObject selection = (BIOrionObject)selectedObject;
            return BRef.make((BIOrionObject)selection);
        }
        if (selectedObject instanceof BRef) {
            return (BRef)selectedObject;
        }
        return o;
    }

    private OrionSession createNewSession(Context cx) {
        BOrionDatabase db = null;
        for (BComplex x = this.getParent(); x != null && db == null; x = x.getParent()) {
            BObject val;
            if (!(x instanceof BWbEditor) || !((val = ((BWbEditor)x).getCurrentValue()) instanceof BIOrionDatabaseObject)) continue;
            db = ((BIOrionDatabaseObject)val).getOrionDatabase();
            break;
        }
        if (db != null) {
            return db.createSession(cx);
        }
        return null;
    }

    private class Hyperlink
    extends Command {
        public Hyperlink() {
            super((BWidget)BRefFE.this, module, "refFE.hyperlink");
        }

        public CommandArtifact doInvoke() {
            try {
                Object selected = BRefFE.this.dropDown.getList().getSelectedItem();
                if (selected instanceof BIOrionObject) {
                    BIOrionObject target = (BIOrionObject)selected;
                    BRefFE.this.getWbShell().hyperlink(target.getOrdInSpace());
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Hyperlink Failed.", (Throwable)e);
            }
            return null;
        }

        public String getLabel() {
            return null;
        }
    }

    private class Renderer
    extends ListRenderer {
        public String getItemText(ListRenderer.Item item) {
            Object value = item.value;
            if (value instanceof BIOrionObject) {
                return ((BIOrionObject)value).toDisplayString(null);
            }
            if (value instanceof BRef && !((BRef)value).isBound()) {
                return Lexicon.make(BRefFE.class).get("refFE.none");
            }
            return value.toString();
        }
    }

    private class RefLoader
    implements BLazyListDropDown.Loader {
        private RefLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] loadList() {
            Array a = new Array(Object.class);
            boolean allowNull = false;
            Context cx = BRefFE.this.getCurrentContext();
            if (cx != null && cx.getFacets() != null) {
                allowNull = cx.getFacets().getb("allowNull", false);
            }
            BRef current = (BRef)BRefFE.this.getCurrentValue();
            if (allowNull) {
                BRef unboundRef = BRef.make((BTypeSpec)current.getTargetTypeSpec());
                BRefFE.this.dropDown.getList().addItem((Object)unboundRef);
                a.add((Object)unboundRef);
            }
            boolean doClose = true;
            OrionSession session = BOrionSpace.findSessionInContext((Context)cx);
            if (session != null && session.isOpen()) {
                doClose = false;
            } else {
                session = null;
            }
            if (session == null) {
                session = BRefFE.this.db.createSession(cx);
                doClose = true;
            }
            try {
                OrionType targetType = current.getTargetOrionType(session);
                Object[] items = session.scan(targetType).toArray();
                a.addAll(items);
                Object[] objectArray = a.trim();
                return objectArray;
            }
            finally {
                if (doClose) {
                    session.close();
                }
            }
        }
    }
}

