/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFieldSheet
extends BWbEditor {
    public static final Property labelMargin = BFieldSheet.newProperty((int)0, (double)10.0, null);
    public static final Property rowGap = BFieldSheet.newProperty((int)0, (double)8.0, null);
    public static final Property indent = BFieldSheet.newProperty((int)0, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BFieldSheet.class);
    public static final int MODE_NEW = 0;
    public static final int MODE_EDIT = 1;
    private BOrionDatabase db;
    private int mode;
    private Array<Field> fields;
    private double[] divs;

    public double getLabelMargin() {
        return this.getDouble(labelMargin);
    }

    public void setLabelMargin(double v) {
        this.setDouble(labelMargin, v, null);
    }

    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    public double getIndent() {
        return this.getDouble(indent);
    }

    public void setIndent(double v) {
        this.setDouble(indent, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFieldSheet() {
        throw new UnsupportedOperationException();
    }

    public BFieldSheet(int mode, BOrionDatabase db) {
        this.mode = mode;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadValue(BObject o, Context cx) {
        BIOrionObject obj = (BIOrionObject)o;
        OrionType type = obj.getOrionType();
        OrionSession session = BOrionSpace.findSessionInContext((Context)cx);
        boolean shouldCloseSession = false;
        if (session == null) {
            BOrionDatabase odb = this.db;
            if (odb == null) {
                odb = obj.getOrionDatabase();
            }
            session = odb.createSession(cx);
            shouldCloseSession = true;
        }
        try {
            Property[] props = type.getProperties();
            this.fields = new Array(Field.class, props.length);
            this.divs = new double[props.length];
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                if (this.mode == 0 && BOrionObject.isIdentity((Property)prop)) continue;
                BasicContext propContext = new BasicContext((Context)session, obj.getSlotFacets((Slot)prop));
                BValue propValue = obj.get(prop);
                BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)propValue, (Context)propContext);
                ed.setReadonly((prop.getDefaultFlags() & 1) != 0);
                ed.loadValue((BObject)propValue, (Context)propContext);
                if (BOrionObject.isIdentity((Property)prop)) {
                    ed.setReadonly(true);
                }
                BLabel label = new BLabel(obj.getDisplayName((Slot)prop, (Context)session));
                label.setValign(BValign.top);
                Field f = new Field(prop, label, ed);
                this.add("label" + i, (BValue)f.label);
                this.add("editor" + i, (BValue)f.editor);
                this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
                this.fields.add((Object)f);
            }
        }
        finally {
            if (shouldCloseSession) {
                session.close();
            }
        }
    }

    public BObject doSaveValue(BObject o, Context cx) throws CannotSaveException, Exception {
        BIOrionObject obj = (BIOrionObject)o;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            if (!f.editor.isModified()) continue;
            if (this.mode == 0) {
                obj.init(f.prop, (BValue)f.editor.saveValue((BObject)obj.get(f.prop), cx));
                continue;
            }
            obj.set(f.prop, (BValue)f.editor.saveValue((BObject)obj.get(f.prop), cx));
        }
        this.clearModified();
        return (BObject)obj;
    }

    public void computePreferredSize() {
        if (this.fields == null) {
            this.setPreferredSize(0.0, 0.0);
            return;
        }
        double maxLabel = 0.0;
        double maxEditor = 0.0;
        double ph = 0.0;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            f.label.computePreferredSize();
            f.editor.computePreferredSize();
            if (i == 0) {
                maxLabel = f.label.getPreferredWidth();
                maxEditor = f.editor.getPreferredWidth();
            } else {
                maxLabel = Math.max(maxLabel, f.label.getPreferredWidth());
                maxEditor = Math.max(maxEditor, f.editor.getPreferredWidth());
            }
            ph += this.getRowGap();
            ph += Math.max(f.label.getPreferredHeight(), f.editor.getPreferredHeight());
        }
        ph += this.getRowGap();
        this.setPreferredSize(this.getIndent() + maxLabel + maxEditor + this.getLabelMargin(), ph += this.getRowGap());
    }

    public void doLayout(BWidget[] kids) {
        if (this.fields == null) {
            return;
        }
        double labelWidth = 0.0;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            f.label.computePreferredSize();
            f.editor.computePreferredSize();
            labelWidth = i == 0 ? f.label.getPreferredWidth() : Math.max(labelWidth, f.label.getPreferredWidth());
        }
        double y = 0.0;
        double indent = this.getIndent();
        for (int i = 0; i < fc; ++i) {
            Field field = (Field)this.fields.get(i);
            double rowHeight = Math.max(field.label.getPreferredHeight(), field.editor.getPreferredHeight());
            field.label.setBounds(indent, y + (rowHeight - field.label.getPreferredHeight()) / 2.0, field.label.getPreferredWidth(), rowHeight);
            field.editor.setBounds(indent + labelWidth + this.getLabelMargin(), y + (rowHeight - field.editor.getPreferredHeight()) / 2.0, field.editor.getPreferredWidth(), rowHeight);
            this.divs[i] = y += rowHeight + this.getRowGap();
        }
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
        for (int i = 0; i < this.divs.length; ++i) {
            double y = this.divs[i] - this.getRowGap() / 2.0;
            g.strokeLine(0.0, y, this.getWidth(), y);
        }
    }

    private class Field {
        public Property prop;
        public BLabel label;
        public BWbFieldEditor editor;

        public Field(Property prop, BLabel label, BWbFieldEditor editor) {
            this.prop = prop;
            this.label = label;
            this.editor = editor;
        }
    }
}

