/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.filter.BNullFilter;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.DynamicTableResultModel;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BDynamicTableView
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType(BDynamicTableView.class);
    private BOrionDatabase db;
    protected Command hyperlinkCommand;
    protected Command filter;
    protected BTable table;
    private CommandBindings bindings = new CommandBindings();

    public Type getType() {
        return TYPE;
    }

    protected BOrionDatabase getDb() {
        if (this.db == null) {
            BDynamicTable table = (BDynamicTable)this.getCurrentValue();
            if (!table.getDbOrd().isNull()) {
                this.db = (BOrionDatabase)table.getDbOrd().get(table.getResolveBase());
            } else if (!table.getAppOrd().isNull()) {
                BOrionSpace orion = (BOrionSpace)BOrd.make((String)"orion:").get(table.getResolveBase());
                this.db = orion.getOrionDatabaseForApp(table.getAppOrd());
                if (this.db == null) {
                    throw new OrionException("Database not available.");
                }
            } else {
                throw new OrionException("Database not configured.");
            }
        }
        return this.db;
    }

    public void doLoadValue(BObject o, Context cx) throws Exception {
        OutOfMemoryError outOfMemoryException = null;
        DynamicTableResultModel model = null;
        try {
            BDynamicTable dt = (BDynamicTable)o;
            dt.lease(3);
            if (dt.getRowType().isNull()) {
                return;
            }
            dt = DynamicTableResultModel.ensureVisibleColumns(dt);
            BDynamicTableOptions options = BDynamicTableOptions.make();
            int sortCol = options.getSortColumnIndex(dt, cx);
            boolean asc = options.getSortColumnAscForIndex(dt, cx);
            BFilterSet filterSet = options.getFilterSet(dt);
            if (dt.hasDefaultFilters(cx) && filterSet == null) {
                filterSet = BDynamicTableOptions.rebuildFilterSet(dt, filterSet, cx);
            }
            try {
                model = this.runQuery(dt, sortCol, asc, filterSet, cx);
            }
            catch (OutOfMemoryError e) {
                outOfMemoryException = e;
                model = new ResultModel((OrionType)dt.getRowType().getTypeSpec().getResolvedType(), dt.getWorkingColumns(cx), new BIOrionObject[0], dt, cx);
            }
            catch (Exception e) {
                options.removeFilterSet(dt);
                throw e;
            }
            this.bindings = this.makeCommandBindings();
            this.table = new BCommandBoundTable((TableModel)model, (CommandBindings.TableController)new ResultController());
            if (sortCol != -1) {
                this.table.sortByColumn(sortCol, asc);
            }
        }
        catch (Exception ex) {
            this.table = new BCommandBoundTable((TableModel)new ResultModel(), (CommandBindings.TableController)new ResultController());
            BDialog.error((BWidget)this, (String)"Error", (Object)("Cannot load table. " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace();
        }
        BEdgePane main = new BEdgePane();
        if (model != null && (model.getRowCount() == BDynamicTable.MAX_RESULT_SIZE || model.getReachedMax())) {
            BLabel label = new BLabel(Lexicon.make(BDynamicTableView.class).getText("onlyTopWarning", new Object[]{BInteger.make((int)BDynamicTable.MAX_RESULT_SIZE)}));
            label.setHalign(BHalign.left);
            main.setTop((BWidget)label);
        } else {
            main.setTop((BWidget)new BNullWidget());
        }
        main.setCenter((BWidget)this.table);
        Command[] commands = this.getButtonCommands();
        if (commands != null) {
            BGridPane buttons = new BGridPane(commands.length);
            buttons.setUniformColumnWidth(true);
            buttons.setColumnGap(5.0);
            buttons.setColumnAlign(BHalign.fill);
            for (int i = 0; i < commands.length; ++i) {
                buttons.add(null, (BValue)new BButton(commands[i]));
            }
            main.setBottom((BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        }
        this.setContent((BWidget)main);
        if (outOfMemoryException != null) {
            BDialog.error((BWidget)this, (String)outOfMemoryException.getMessage(), (Object)"Result Set too Large: Try filtering your query to reduce the result size.", (Throwable)outOfMemoryException);
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        command.setEnabled(bindingBasedState);
    }

    public Command[] getButtonCommands() {
        Array a = new Array(Command.class);
        if (this.hyperlinkCommand != null) {
            a.add((Object)this.hyperlinkCommand);
        }
        this.filter = new FilterCommand();
        a.add((Object)this.filter);
        return (Command[])a.trim();
    }

    public CommandBindings makeCommandBindings() {
        CommandBindings result = new CommandBindings();
        this.hyperlinkCommand = new HyperlinkCommand();
        result.addCommand(this.hyperlinkCommand, BCommandEnablePolicy.singleSelection);
        return result;
    }

    public Command getDoubleClickCommand() {
        return this.hyperlinkCommand;
    }

    public final CommandBindings getCommandBindings() {
        if (this.bindings == null) {
            this.bindings = this.makeCommandBindings();
        }
        return this.bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultModel runQuery(BDynamicTable dt, int sortCol, boolean asc, BFilterSet filterSet, Context cx) throws Exception {
        OrionCursor c = null;
        OrionSession session = dt.getOrionDatabase().createSession(cx);
        try {
            if (filterSet == null) {
                filterSet = BDynamicTableOptions.rebuildFilterSet(dt, filterSet, cx);
            }
            BQuery query = dt.getQuery(sortCol, asc, new BPage(0, BDynamicTable.MAX_RESULT_SIZE), filterSet, cx);
            c = dt.resolve(session, query);
            OrionType dynamicRowType = c.getOrionType();
            ResultModel model = new ResultModel(dynamicRowType, dt.getWorkingColumns(cx), null, dt, cx);
            model.calculateResults(dt, dynamicRowType, c, BDynamicTable.MAX_RESULT_SIZE, cx);
            ResultModel resultModel = model;
            return resultModel;
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    public void configFilters() {
        BDynamicTable dt;
        BDynamicTableOptions options = BDynamicTableOptions.make();
        BFilterSet filterSet = options.getFilterSet(dt = (BDynamicTable)this.getCurrentValue());
        if (filterSet == null || !BDynamicTableOptions.isFilterSetValid(dt, filterSet, this.getCurrentContext())) {
            filterSet = BDynamicTableOptions.rebuildFilterSet(dt, filterSet, this.getCurrentContext());
            options.setFilterSet(dt, filterSet);
        }
        BFilterSetEditor setEditor = new BFilterSetEditor();
        setEditor.loadValue((BObject)filterSet);
        BBorderPane borderPane = new BBorderPane((BWidget)setEditor, 10.0, 10.0, 10.0, 10.0);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)borderPane, (int)3) != 2) {
            try {
                if (setEditor.isModified()) {
                    options.setFilterSet(dt, (BFilterSet)setEditor.saveValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (!(filterSet = options.getFilterSet(dt)).anyActive()) {
            boolean custom = false;
            BDynamicTableColumn[] columns = dt.getWorkingColumns(this.getCurrentContext());
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].getDefaultFilter().getType().equals(BNullFilter.TYPE)) continue;
                custom = true;
            }
            if (!custom) {
                options.removeFilterSet(dt);
            }
        }
    }

    protected class FilterCommand
    extends Command {
        public FilterCommand() {
            super((BWidget)BDynamicTableView.this, TYPE.getModule(), "command.filter");
        }

        public CommandArtifact doInvoke() throws Exception {
            BDynamicTableView.this.configFilters();
            BDynamicTableView.this.loadValue(BDynamicTableView.this.getCurrentValue());
            return null;
        }

        public BImage getIcon() {
            BDynamicTableOptions options = BDynamicTableOptions.make();
            BDynamicTable dt = (BDynamicTable)BDynamicTableView.this.getCurrentValue();
            BFilterSet filterSet = options.getFilterSet(dt);
            boolean defaultFilters = dt.hasDefaultFilters(BDynamicTableView.this.getCurrentContext());
            if (filterSet == null && !defaultFilters || filterSet != null && !filterSet.anyActive()) {
                return super.getIcon();
            }
            return super.getIcon().getHighlightedImage();
        }
    }

    protected class HyperlinkCommand
    extends Command {
        public HyperlinkCommand() {
            super((BWidget)BDynamicTableView.this, TYPE.getModule(), "command.hyperlink");
        }

        public CommandArtifact doInvoke() {
            try {
                int[] selection = BDynamicTableView.this.table.getSelection().getRows();
                if (selection.length == 0) {
                    return null;
                }
                BIOrionObject row = (BIOrionObject)BDynamicTableView.this.table.getModel().getSubject(selection[0]);
                BDynamicTable dt = (BDynamicTable)BDynamicTableView.this.getCurrentValue();
                BTypeSpec rowTypeSpec = dt.getRowType().getTypeSpec();
                OrionType rowType = (OrionType)rowTypeSpec.getResolvedType();
                Property[] keys = rowType.getKey();
                PropertyValue[] keyValues = new PropertyValue[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    keyValues[i] = new PropertyValue(keys[i], row.get(keys[i]));
                }
                BOrionDatabase db = BDynamicTableView.this.getDb();
                BOrd hyperlinkOrd = BOrionScheme.makeOrdInSession((BOrd)db.getOrdInSession(), (OrionType)rowType, (PropertyValue[])keyValues);
                BWbShell shell = BDynamicTableView.this.getWbShell();
                if (shell != null) {
                    shell.hyperlink(hyperlinkOrd);
                }
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                BDialog.error((BWidget)BDynamicTableView.this, (String)"Hyperlink failed.", (Object)ex);
                return null;
            }
        }
    }

    public class ResultModel
    extends DynamicTableResultModel {
        public ResultModel() {
        }

        public ResultModel(OrionType rowType, BDynamicTableColumn[] cols, BIOrionObject[] rows, BDynamicTable dt, Context cx) {
            super(rowType, cols, rows, dt, cx);
        }

        @Override
        public void sortByColumn(int col, boolean ascending) {
            if (this.manualSort) {
                BDynamicTableOptions options = BDynamicTableOptions.make();
                options.setSortColumnIndex((BDynamicTable)BDynamicTableView.this.getCurrentValue(), col, this.cx);
                BDynamicTableView.this.loadValue(BDynamicTableView.this.getCurrentValue());
            }
        }
    }

    public class ResultController
    extends CommandBindings.TableController {
        public ResultController() {
            super(BDynamicTableView.this.bindings);
        }

        protected void headerPressed(BMouseEvent event, int column) {
            if (event.isButton1Down()) {
                ((ResultModel)this.getModel()).setManualSort(true);
                super.headerPressed(event, column);
                ((ResultModel)this.getModel()).setManualSort(false);
            } else {
                super.headerPressed(event, column);
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            try {
                if (BDynamicTableView.this.getDoubleClickCommand() != null) {
                    BDynamicTableView.this.getDoubleClickCommand().invoke();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

