/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.filter.BNullFilter;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableReportType;
import com.tridium.orion.priv.dt.DTPrefilteringUtil;
import com.tridium.orion.sql.SqlColumns;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.BProjectionColumn;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;

public class BDynamicTableOptions
extends BOptions {
    public static final Type TYPE = Sys.loadType(BDynamicTableOptions.class);
    private static String SORT_ASC = "SortAsc";
    private static String SORT_INDEX = "SortIndex";
    private static String FILTER = "Filter";
    private static String COLUMNS = "Columns";
    private static String REPORT_TYPE = "ReportType";
    private static BDynamicTableOptions options;

    public Type getType() {
        return TYPE;
    }

    public static BDynamicTableOptions make() {
        if (options == null) {
            options = BWidget.getApplication() == null ? new BDynamicTableOptions() : (BDynamicTableOptions)BDynamicTableOptions.load((Type)TYPE);
        }
        return options;
    }

    public static String getKey(BDynamicTable dt) {
        return dt.getDefaultColumnsProvider().getOptionsKey(dt);
    }

    public void setColumns(BDynamicTable dt, BDynamicTableColumn[] columns, Context cx) {
        String propName = BDynamicTableOptions.getKey(dt) + COLUMNS;
        BComponent container = new BComponent();
        boolean allHidden = true;
        for (int i = 0; i < columns.length; ++i) {
            container.add(null, columns[i].newCopy());
            if (columns[i].getHiddenKey()) continue;
            allHidden = false;
        }
        if (allHidden) {
            this.removeColumns(dt);
            return;
        }
        if (this.get(propName) == null) {
            this.add(propName, (BValue)container);
        } else {
            this.set(propName, (BValue)container);
        }
    }

    public BDynamicTableColumn[] getColumns(BDynamicTable dt, Context cx) {
        BComponent container = (BComponent)this.get(BDynamicTableOptions.getKey(dt) + COLUMNS);
        if (container == null) {
            return null;
        }
        return (BDynamicTableColumn[])container.getChildren(BDynamicTableColumn.class);
    }

    public void removeColumns(BDynamicTable dt) {
        String propName = BDynamicTableOptions.getKey(dt) + COLUMNS;
        if (this.get(propName) != null) {
            this.remove(propName);
        }
    }

    public void setSortColumnIndex(BDynamicTable dt, int colIndex, Context cx) {
        String propName = BDynamicTableOptions.getKey(dt) + SORT_INDEX;
        BInteger col = BInteger.make((int)colIndex);
        BInteger oldCol = BInteger.make((int)this.getSortColumnIndex(dt, cx));
        boolean asc = true;
        if (oldCol.equals((Object)col)) {
            boolean bl = asc = !this.getSortColumnAsc(dt, cx);
        }
        if (this.get(propName) == null) {
            this.add(propName, (BValue)col);
        } else {
            this.set(propName, (BValue)col);
        }
        this.setSortColumnAsc(dt, asc);
    }

    public int getSortColumnIndex(BDynamicTable dt, Context cx) {
        BInteger col = (BInteger)this.get(BDynamicTableOptions.getKey(dt) + SORT_INDEX);
        if (col == null) {
            return dt.getDefaultColumnsProvider().getDefaultSortColumnIndex(dt, cx);
        }
        return col.getInt();
    }

    private void setSortColumnAsc(BDynamicTable dt, boolean ascending) {
        String propName = BDynamicTableOptions.getKey(dt) + SORT_ASC;
        BBoolean col = BBoolean.make((boolean)ascending);
        if (this.get(propName) == null) {
            this.add(propName, (BValue)col);
        } else {
            this.set(propName, (BValue)col);
        }
    }

    public boolean isDefaultAsc(BDynamicTable dt, Context cx) {
        BOrionTypeId orionTypeId;
        OrionType orionType;
        int col = this.getSortColumnIndex(dt, cx);
        boolean asc = true;
        BDynamicTableColumn[] children = dt.getWorkingColumns(cx);
        if (col < children.length && col > -1 && (orionType = (OrionType)(orionTypeId = children[col].getFromType()).getTypeSpec().getResolvedType()).getProperty(children[col].getFromProperty()).getType().equals(BAbsTime.TYPE)) {
            asc = false;
        }
        return asc;
    }

    public boolean getSortColumnAsc(BDynamicTable dt, Context cx) {
        BBoolean asc = (BBoolean)this.get(BDynamicTableOptions.getKey(dt) + SORT_ASC);
        if (asc == null) {
            return true;
        }
        return asc.getBoolean();
    }

    public boolean getSortColumnAscForIndex(BDynamicTable dt, Context cx) {
        boolean asc = this.getSortColumnAsc(dt, cx);
        if (!this.isDefaultAsc(dt, cx)) {
            return !asc;
        }
        return asc;
    }

    public void setReportType(BDynamicTable dt, BDynamicTableReportType reportType, Context cx) {
        String propName = BDynamicTableOptions.getKey(dt) + REPORT_TYPE;
        if (this.get(propName) == null) {
            this.add(propName, (BValue)reportType);
        } else {
            this.set(propName, (BValue)reportType);
        }
    }

    public BDynamicTableReportType getReportType(BDynamicTable dt, Context cx) {
        BDynamicTableReportType col = (BDynamicTableReportType)this.get(BDynamicTableOptions.getKey(dt) + REPORT_TYPE);
        if (col == null) {
            return dt.getReportType();
        }
        return col;
    }

    public void removeReportType(BDynamicTable dt) {
        String propName = BDynamicTableOptions.getKey(dt) + REPORT_TYPE;
        if (this.get(propName) != null) {
            this.remove(propName);
        }
    }

    public boolean getPrefiltering(BDynamicTable dt) {
        return DTPrefilteringUtil.getPrefiltering(dt, this, BDynamicTableOptions.getKey(dt) + DTPrefilteringUtil.PRE_FILTERING);
    }

    public void setPrefiltering(BDynamicTable dt, boolean prefiltering) {
        DTPrefilteringUtil.setPrefiltering(prefiltering, this, BDynamicTableOptions.getKey(dt) + DTPrefilteringUtil.PRE_FILTERING);
    }

    public void removePrefiltering(BDynamicTable dt) {
        DTPrefilteringUtil.removePrefiltering(this, BDynamicTableOptions.getKey(dt) + DTPrefilteringUtil.PRE_FILTERING);
    }

    public BFilterSet getFilterSet(BDynamicTable dt) {
        BFilterSet filter = (BFilterSet)this.get(BDynamicTableOptions.getKey(dt) + FILTER);
        return filter;
    }

    public void setFilterSet(BDynamicTable dt, BFilterSet filterSet) {
        String propName = BDynamicTableOptions.getKey(dt) + FILTER;
        if (this.get(propName) == null) {
            this.add(propName, (BValue)filterSet);
        } else {
            this.set(propName, (BValue)filterSet);
        }
    }

    public void removeFilterSet(BDynamicTable dt) {
        String propName = BDynamicTableOptions.getKey(dt) + FILTER;
        if (this.get(propName) != null) {
            this.remove(propName);
        }
    }

    public static void updateFilterSet(BFilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            BIQueryFilter filter = entries[i].toQueryFilter();
            if (!(filter instanceof BAbsTimeFilter)) continue;
            filter.init(null);
        }
    }

    public static boolean isFilterSetValid(BDynamicTable dt, BFilterSet filterSet, Context cx) {
        if (filterSet == null) {
            return true;
        }
        BDynamicTableColumn[] columns = dt.getWorkingColumns(cx);
        for (int i = 0; i < columns.length; ++i) {
            String fieldName = BDynamicTableOptions.getFilterName(columns[i]);
            if (filterSet.get(SlotPath.escape((String)fieldName)) != null) continue;
            return false;
        }
        BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            if (dt.get(entries[i].getName()) != null) continue;
            return false;
        }
        return true;
    }

    public static String getFilterName(BDynamicTableColumn column) {
        return "" + column.getFromType().getModuleName() + "_" + column.getFromType().getTypeName() + "." + column.getColumnName();
    }

    public static synchronized BFilterSet rebuildFilterSet(BDynamicTable dt, BFilterSet filterSet, Context cx) {
        if (filterSet == null) {
            filterSet = new BFilterSet();
        }
        BDynamicTableColumn[] columns = dt.getWorkingColumns(cx);
        BOrionDatabase db = dt.getOrionDatabase();
        for (int i = 0; i < columns.length; ++i) {
            Property prop;
            BValue value;
            AgentList agents;
            String fieldName;
            BDynamicTableColumn col = columns[i];
            if (col.getHiddenKey() || filterSet.get(SlotPath.escape((String)(fieldName = BDynamicTableOptions.getFilterName(col)))) != null || (agents = (value = (prop = col.makeDynamicProperty(db)).getDefaultValue()).getAgents().filter(AgentFilter.and((AgentFilter)AgentFilter.is((Type)BIQueryFilter.TYPE), (AgentFilter)new ProfileFilter(cx)))).size() == 0) continue;
            boolean flags = false;
            BIQueryFilter filter = null;
            boolean active = false;
            boolean activeReadonly = false;
            if (col.getDefaultFilter().getType().equals(BNullFilter.TYPE)) {
                filter = (BIQueryFilter)agents.getDefault().getInstance();
            } else {
                filter = (BIQueryFilter)col.getDefaultFilter().newCopy();
                active = !Flags.isUserDefined1((BComplex)col, (Slot)BDynamicTableColumn.defaultFilter);
            }
            if (Flags.isUserDefined2((BComplex)col, (Slot)BDynamicTableColumn.defaultFilter)) {
                activeReadonly = true;
            }
            filter.init((BObject)value);
            BProjectionColumn projectionColumn = SqlColumns.make((BTypeSpec)col.getFromType().getTypeSpec(), (String)col.getFromProperty());
            BFilterEntry entry = new BFilterEntry(active, col.getAlias().format((Object)dt, cx), filter, (BExpression)projectionColumn.getColumnExpression().newCopy());
            if (activeReadonly) {
                entry.setFlags((Slot)BFilterEntry.active, 1);
            }
            filterSet.add(SlotPath.escape((String)fieldName), (BValue)entry, 0, prop.getFacets(), null);
        }
        BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            String name = entries[i].getName();
            name = SlotPath.unescape((String)name);
            boolean found = false;
            for (int j = 0; j < columns.length; ++j) {
                if (!columns[j].getColumnName().equals(TextUtil.split((String)name, (char)'.')[1])) continue;
                found = true;
            }
            if (found) continue;
            filterSet.remove(entries[i].getPropertyInParent());
        }
        return filterSet;
    }

    public static class ProfileFilter
    extends AgentFilter {
        BIWebProfile profile;

        public ProfileFilter(Context cx) {
            if (cx != null && cx.getUser() != null) {
                BWebProfileConfig config = (BWebProfileConfig)cx.getUser().getMixIn(BWebProfileConfig.TYPE);
                this.profile = (BIWebProfile)config.getTypeSpec().getInstance();
            }
        }

        public boolean include(AgentInfo agent) {
            if (this.profile == null) {
                return true;
            }
            if (agent.getAppName() != null) {
                String[] profileAppNames = this.profile.getAppNames();
                for (int i = 0; i < profileAppNames.length; ++i) {
                    if (!profileAppNames[i].equals(agent.getAppName())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

