/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.dt;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.sql.SelectVisitor;
import com.tridium.orion.sql.BJoin;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BSubSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.query.BProjCol;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BSingleExtent;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Predicates;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public abstract class DynamicTableUtil {
    public static void join(BSqlQuery query, BJoin joinKind, OrionType fromType, Property fromProp, OrionType toType, Property toProp, BFilterSet filterSet, int joinCount, BTypeDependency u, BOrionDatabase db) throws Exception {
        BSqlField fromField = new BSqlField(fromType, fromProp);
        fromField.alias("B" + joinCount);
        BSqlField toField = new BSqlField(toType, toProp);
        String alias = "P";
        BSqlJoin[] joins = query.getJoins();
        for (int i = 0; i < joins.length; ++i) {
            if (!joins[i].getJoinTable().getBaseExtent().toString().equals(toType.toString())) continue;
            alias = joins[i].getJoinTable().getExtentAlias();
        }
        toField.alias(alias);
        BSqlQuery q = new BSqlQuery();
        BProjection projection = new BProjection();
        Property key = null;
        Property[] keys = fromType.getKey();
        if (keys.length == 1) {
            key = keys[0];
        } else {
            OrionType extentType = (OrionType)((BSingleExtent)query.getExtent()).getBaseExtent().getResolvedType();
            for (int i = 0; i < keys.length; ++i) {
                BRef ref;
                if (!keys[i].getType().is(BRef.TYPE) || !(ref = (BRef)keys[i].getDefaultValue()).getTargetTypeSpec().getResolvedType().is((Type)extentType)) continue;
                key = keys[i];
            }
        }
        BSqlField fromSubField = new BSqlField(fromType, key);
        fromField.alias("Bi" + joinCount);
        BSqlField subWhereField = new BSqlField(fromType, fromProp);
        fromField.alias("Bi" + joinCount);
        BSqlField onField = new BSqlField(fromType, key);
        onField.alias("B" + joinCount);
        BProjectionColumn projectionColumn = SqlColumns.make((BSqlField)fromSubField);
        projection.add(projectionColumn);
        q.select(projection);
        BSqlExtent fromExtent = new BSqlExtent(fromType.getTypeSpec());
        fromExtent.alias("Bi" + joinCount);
        q.from((BExtent)fromExtent);
        BExpression predicateExpr = Predicates.eq((BExpression)subWhereField.newExprCopy(), (BExpression)toField.newExprCopy());
        BSubSqlQuery subQuery = new BSubSqlQuery(q);
        BExpression joinExpression = Predicates.eq((BExpression)onField.newExprCopy(), (BExpression)subQuery);
        DynamicTableUtil.addSubQueryPredicate(q, filterSet, predicateExpr, fromType);
        q.page(new BPage(0, 1));
        boolean limitAssociateJoinToOneResult = false;
        if (u != null) {
            OrionType fromType2 = db.getType(u.getFromTypeId());
            OrionType toType2 = db.getType(u.getToTypeId());
            if (fromType2.equals(fromType) && toType2.equals(toType) && fromProp.getName().equals(u.getFromProperty()) && toProp.getName().equals(u.getToProperty())) {
                limitAssociateJoinToOneResult = true;
                BSubSqlQuery subQueryCopy = (BSubSqlQuery)subQuery.newExprCopy();
                BSqlField onFieldCopy = (BSqlField)onField.newExprCopy();
                joinExpression = Predicates.eq((BExpression)onField.newExprCopy(), (BExpression)toField.newExprCopy());
                joinExpression = DynamicTableUtil.limitAssociateJoinToOneResult(onFieldCopy, subQueryCopy, fromType, fromProp, joinExpression, joinCount);
            }
        }
        BSqlJoin join = new BSqlJoin();
        join.setJoinKind(joinKind);
        join.setOnExpr(joinExpression);
        BSqlExtent joinExtent = new BSqlExtent(fromType.getTypeSpec());
        joinExtent.alias("B" + joinCount);
        join.setJoinTable(joinExtent);
        query.join(join);
        DynamicTableUtil.fixAlias((BComponent)query.getProjection(), fromType, "B" + joinCount);
        DynamicTableUtil.fixAlias((BComponent)query.getPredicate(), fromType, "B" + joinCount);
        DynamicTableUtil.fixAlias((BComponent)query.getOrdering(), fromType, "B" + joinCount);
        if (u != null && !limitAssociateJoinToOneResult) {
            ++joinCount;
            OrionType fromType2 = db.getType(u.getFromTypeId());
            OrionType toType2 = db.getType(u.getToTypeId());
            BSqlField field1 = new BSqlField(toType2, u.getToProperty());
            field1.alias("P");
            BSqlField field2 = new BSqlField(fromType2, u.getFromProperty());
            field2.alias("B" + joinCount);
            if (SelectVisitor.dbSupportsFlexibleOnClause((BRdbms)db.getRdbms())) {
                q.join(new BSqlJoin(joinKind, field1, field2));
            } else {
                BExpression oneEqualsOne = Predicates.eq((BExpression)Exprs.simple((BSimple)BInteger.make((int)1)), (BSimple)BInteger.make((int)1));
                q.join(new BSqlJoin(joinKind, new BSqlExtent(fromType2).alias("B" + joinCount), oneEqualsOne));
                DynamicTableUtil.addAndExpressionToPredicate(q, Predicates.eq((BExpression)field1, (BExpression)field2));
            }
            if (query.hasProjection()) {
                query.getProjection().setDistinct(true);
            } else {
                BProjection newProjection = new BProjection();
                newProjection.setDistinct(true);
                query.select(newProjection);
            }
            DynamicTableUtil.fixAlias((BComponent)q.getPredicate(), fromType2, "B" + joinCount);
            DynamicTableUtil.fixAlias((BComponent)q.getProjection(), fromType2, "B" + joinCount);
            DynamicTableUtil.fixAlias((BComponent)q.getOrdering(), fromType2, "B" + joinCount);
        }
    }

    public static BExpression limitAssociateJoinToOneResult(BSqlField onFieldCopy, BSubSqlQuery subQueryCopy, OrionType fromType, Property fromProp, BExpression joinExpression, int joinCount) {
        Property[] key = fromType.getKey();
        Property otherKey = null;
        for (int i = 0; i < key.length; ++i) {
            if (key[i].equals(fromProp)) continue;
            otherKey = key[i];
        }
        if (otherKey == null) {
            return joinExpression;
        }
        onFieldCopy.setPropertyName(otherKey.getName());
        DynamicTableUtil.fixField((BComponent)subQueryCopy.getQuery().getProjection(), fromProp.getName(), otherKey.getName());
        DynamicTableUtil.fixAlias((BComponent)subQueryCopy.getQuery().getProjection(), fromType, "Bi" + ++joinCount);
        DynamicTableUtil.fixAlias((BComponent)subQueryCopy.getQuery().getPredicate(), fromType, "Bi" + joinCount);
        DynamicTableUtil.fixAlias((BComponent)subQueryCopy.getQuery().getOrdering(), fromType, "Bi" + joinCount);
        DynamicTableUtil.fixAlias((BComponent)subQueryCopy.getQuery().getExtent(), fromType, "Bi" + joinCount);
        return Predicates.and((BExpression)joinExpression, (BExpression)Predicates.eq((BExpression)onFieldCopy, (BExpression)subQueryCopy));
    }

    public static void addAndExpressionToPredicate(BSqlQuery query, BExpression and) {
        BPredicate predicate = query.getPredicate();
        ExpressionBuilder b = new ExpressionBuilder();
        if (predicate != null && predicate.getPredicateExpr() != null) {
            b.and(predicate.getPredicateExpr());
        }
        b.and(and);
        query.where(b.getExpression());
    }

    public static void addSubQueryPredicate(BSqlQuery query, BFilterSet filterSet, BExpression predicateExpr, OrionType orionType) {
        BExpression queryExpression = DynamicTableUtil.getQueryPredicate(filterSet, orionType);
        if (queryExpression != null) {
            query.where(new BPredicate(Predicates.and((BExpression)predicateExpr, (BExpression)queryExpression)));
        } else {
            query.where(new BPredicate(predicateExpr));
        }
    }

    public static BExpression getQueryPredicate(BFilterSet filterSet, OrionType orionType) {
        ExpressionBuilder b = new ExpressionBuilder();
        filterSet.loadSlots();
        SlotCursor c = filterSet.getProperties();
        while (c.next()) {
            BExpression e;
            BFilterEntry entry = (BFilterEntry)c.get();
            BSqlField sqlField = (BSqlField)entry.getColumnExpression();
            if (!sqlField.getExtentType().equals(orionType) || !entry.getActive() || (e = entry.getQueryPredicate()) == null) continue;
            b.and(e);
        }
        return b.getExpression();
    }

    public static void fixAlias(BComponent container, OrionType extent, String newAlias) {
        if (container == null) {
            return;
        }
        DynamicTableUtil.fixSelfAlias(container, extent, newAlias);
        BogCursor c = new BogCursor((BComplex)container, 100, new Type[]{BSqlField.TYPE, BSqlExtent.TYPE}, false, null);
        while (c.next()) {
            DynamicTableUtil.fixSelfAlias(c.get(), extent, newAlias);
        }
    }

    public static void fixSelfAlias(Object o, OrionType extent, String newAlias) {
        BSqlExtent sqlExtent;
        if (o instanceof BSqlField) {
            BSqlField field = (BSqlField)o;
            if (field.getExtent().toString().equals(extent.toString())) {
                field.alias(newAlias);
            }
        } else if (o instanceof BSqlExtent && (sqlExtent = (BSqlExtent)o).getBaseExtent().toString().equals(extent.toString())) {
            sqlExtent.alias(newAlias);
        }
    }

    public static void fixField(BComponent container, String oldProperty, String newProperty) {
        if (container == null) {
            return;
        }
        BogCursor c = new BogCursor((BComplex)container, 100, new Type[]{BSqlField.TYPE}, false, null);
        while (c.next()) {
            BSqlField field = (BSqlField)c.get();
            if (!field.getPropertyName().equals(oldProperty)) continue;
            field.setPropertyName(newProperty);
        }
    }

    public static void fixProjectionForDistictOrdering(BSqlQuery query, BOrionDatabase db) {
        if (!query.hasProjection() || !query.hasOrdering() || !query.getProjection().isDistinct() || SelectVisitor.dbSupportsFlexibleOrderByForDistict((BRdbms)db.getRdbms())) {
            return;
        }
        BProjection projection = query.getProjection();
        BOrderByColumn[] orderByCols = query.getOrdering().getOrderByColumns();
        for (int i = 0; i < orderByCols.length; ++i) {
            BSqlField orderByField;
            BExpression colExpression = orderByCols[i].getColumnExpression();
            if (!(colExpression instanceof BSqlField) || DynamicTableUtil.isFieldInProjection(orderByField = (BSqlField)colExpression, query)) continue;
            projection.add((BProjectionColumn)new BProjCol(colExpression.newExprCopy()));
        }
    }

    public static boolean isFieldInProjection(BSqlField field, BSqlQuery query) {
        BProjection projection = query.getProjection();
        if (projection == null) {
            return false;
        }
        BProjectionColumn[] projCols = projection.getProjectionColumns();
        for (int i = 0; i < projCols.length; ++i) {
            BSqlField projField;
            BExpression projExpression = projCols[i].getColumnExpression();
            if (!(projExpression instanceof BSqlField) || !(projField = (BSqlField)projExpression).getPropertyName().equals(field.getPropertyName()) || !projField.getExtentType().equals(field.getExtentType())) continue;
            return true;
        }
        return false;
    }
}

