/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tagdictionary.BInfoList;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;

@NiagaraType
public class BTagGroupInfoList
extends BInfoList
implements Iterable<TagGroupInfo> {
    public static final Type TYPE = Sys.loadType(BTagGroupInfoList.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Iterator<TagGroupInfo> iterator() {
        return this.getProperties().stream().filter(p -> !Flags.isHidden((BComplex)this, (Slot)p) && this.get((Property)p) instanceof TagGroupInfo).map(p -> (TagGroupInfo)this.get((Property)p)).iterator();
    }

    public boolean containsTagId(Id id) {
        return this.getTagGroup(id).isPresent();
    }

    public Optional<TagGroupInfo> getTagGroup(Id id) {
        SlotCursor c = this.getProperties();
        while (c.next(TagGroupInfo.class)) {
            TagGroupInfo tagGroup;
            if (Flags.isHidden((BComplex)this, (Slot)c.property()) || !(tagGroup = (TagGroupInfo)c.get()).getGroupId().equals((Object)id)) continue;
            return Optional.of(tagGroup);
        }
        return Optional.empty();
    }

    @Override
    public void checkRename(Property property, String newName, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue instanceof BTagGroupInfo) {
            BTagDictionary td = this.getTagDictionary();
            if (td == null) {
                return;
            }
            Id newId = Id.newId((String)td.getNamespace(), (String)newName);
            if (td.getTagDefinitions().containsTagId(newId)) {
                throw new IllegalNameException("tagdictionary", "tagGroupInfo.duplicateTagId", (Object[])new String[]{newId.toString()});
            }
        }
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        boolean isCommit;
        if (!(value instanceof TagGroupInfo)) {
            TagDictionaryUtil.handleIllegalChild(this, value, context);
        }
        boolean isDecoding = context != null && context.equals(Context.decoding);
        boolean bl = isCommit = context != null && context.equals(Context.commit);
        if (value instanceof BTagGroupInfo) {
            BTagDictionary td = this.getTagDictionary();
            if (td == null) {
                return;
            }
            Id newId = Id.newId((String)td.getNamespace(), (String)name);
            if (td.getTagDefinitions().containsTagId(newId)) {
                if (!isDecoding && !isCommit) {
                    throw new IllegalNameException("tagdictionary", "tagGroupInfo.duplicateTagId", (Object[])new String[]{newId.toString()});
                }
                if ((flags & 4) == 0) {
                    BTagDictionary.logger.warning(BTagDictionary.lex.getText("tagGroupInfo.duplicateTagId", new Object[]{newId.toString()}));
                }
            }
        }
    }

    @Override
    public void checkRemove(Property property, Context context) {
    }

    public void renamed(Property property, String oldName, Context context) {
        BValue value = this.get(property);
        if (value instanceof BTagGroupInfo) {
            ((BTagGroupInfo)value).groupRenamed();
        }
    }
}

