/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.relation;

import com.tridium.tagdictionary.relation.BParentNetworkRelation;
import java.util.Collection;
import java.util.Optional;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public class BChildDeviceRelation
extends BRelationInfo {
    public static final Type TYPE = Sys.loadType(BChildDeviceRelation.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity entity) {
        BDeviceNetwork network;
        if (entity instanceof BDeviceNetwork) {
            BDevice[] devices = BParentNetworkRelation.getDescendantDevices((BDeviceNetwork)entity);
            if (devices.length > 0) {
                return Optional.of(new BasicRelation(this.getRelationId(), (Entity)devices[0], false));
            }
        } else if (entity instanceof BDevice && (network = BParentNetworkRelation.getParentNetwork((BDevice)entity)) != null) {
            return Optional.of(new BasicRelation(this.getRelationId(), (Entity)network, true));
        }
        return Optional.empty();
    }

    public void addRelations(Entity entity, Collection<Relation> relations) {
        BDeviceNetwork network;
        if (entity instanceof BDeviceNetwork) {
            Id relationId = this.getRelationId();
            for (BDevice device : BParentNetworkRelation.getDescendantDevices((BDeviceNetwork)entity)) {
                relations.add((Relation)new BasicRelation(relationId, (Entity)device, false));
            }
        } else if (entity instanceof BDevice && (network = BParentNetworkRelation.getParentNetwork((BDevice)entity)) != null) {
            relations.add((Relation)new BasicRelation(this.getRelationId(), (Entity)network, true));
        }
    }
}

