/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.neqlize;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.tagdictionary.neqlize.BNeqlizeMode;
import com.tridium.tagdictionary.neqlize.FilteredTagsMap;
import com.tridium.tagdictionary.neqlize.TagSetSearch;
import com.tridium.util.CompUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tag.util.TagSet;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

@NiagaraType
@NiagaraSingleton
public final class BNeqlizeRpc
extends BObject {
    public static final BNeqlizeRpc INSTANCE = new BNeqlizeRpc();
    public static final Type TYPE = Sys.loadType(BNeqlizeRpc.class);
    private static final Logger logger = Logger.getLogger("tagdictionary.neqlize");
    private static final Lexicon lex = Lexicon.make((String)"tagdictionary");
    private static final int INDENT_FACTOR_2 = 2;
    public static final String CONVERSION_MODE = "mode";
    public static final String EXCLUDED_TAGS = "excludedTags";
    public static final String USE_SERVICE_EXCLUDED_TAGS = "useServiceExcludedTags";
    public static final String EXCLUDED_RELATIONS = "excludedRelations";
    public static final String USE_SERVICE_EXCLUDED_RELATIONS = "useServiceExcludedRelations";
    public static final String ERROR_KEY = "error";
    public static final String JSON_ENCODING_ERROR = "jsonEncodingError";
    public static final String TAGS_KEY = "tags";
    public static final String RELATION_ID_KEY = "relationId";
    public static final String RELATION_IS_INBOUND_KEY = "relationIsInbound";
    public static final String RELATIONS_KEY = "relations";
    public static final String NO_TAG_SET_FOUND = "noTagSetFound";
    public static final String NOT_ENDPOINT_OR_DESCENDANT = "notEndpointOrDescendant";

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static JSONObject getServiceExcludedTagsRelations(Context context) {
        Optional service = Sys.findService((Type)BTagDictionaryService.TYPE);
        if (!service.isPresent()) {
            throw new LocalizableRuntimeException("tagdictionary", "neqlizeRpc.missingTagDictionaryService");
        }
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)((Object)service.get());
        String serviceExcludeTags = tagDictionaryService.getNeqlizeOptions().getExcludedTags();
        String serviceExcludeRelations = tagDictionaryService.getNeqlizeOptions().getExcludedRelations();
        JSONObject result = new JSONObject();
        result.put(TAGS_KEY, (Object)serviceExcludeTags);
        result.put(RELATIONS_KEY, (Object)serviceExcludeRelations);
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static JSONObject getIdentifyingTagsRelations(String basePath, List<String> targetPaths, String optionsString, Context context) {
        List<RelationSearch> relationSearches;
        if (BNeqlizeRpc.isNullOrEmpty(basePath)) {
            throw new LocalizableRuntimeException("tagdictionary", "neqlizeRpc.basePathUndefined");
        }
        if (BNeqlizeRpc.isNullOrEmpty(targetPaths)) {
            throw new LocalizableRuntimeException("tagdictionary", "neqlizeRpc.ordTargetsUndefined");
        }
        for (String targetPath : targetPaths) {
            if (!BNeqlizeRpc.isNullOrEmpty(targetPath)) continue;
            throw new LocalizableRuntimeException("tagdictionary", "neqlizeRpc.ordTargetsUndefined");
        }
        BComponent base = BNeqlizeRpc.resolveBaseComponent(basePath, context);
        if (base == null) {
            JSONObject returnObject = new JSONObject();
            for (String targetPath : targetPaths) {
                returnObject.put(targetPath, (Object)BNeqlizeRpc.makeErrorObject(NO_TAG_SET_FOUND));
            }
            return returnObject;
        }
        JSONObject options = BNeqlizeRpc.decodeOptionsString(optionsString);
        BNeqlizeMode neqlizeMode = BNeqlizeRpc.getNeqlizeMode(options);
        Set<String> tagsToExclude = BNeqlizeRpc.getTagsToExclude(options);
        FilteredTagsMap filteredTagsMap = new FilteredTagsMap(tagsToExclude);
        switch (neqlizeMode.getOrdinal()) {
            case 0: {
                Set<String> relationsToExclude = BNeqlizeRpc.getRelationsToExclude(options);
                Set<RelationPatternFilter> excludeFilters = BNeqlizeRpc.getExcludeRelationFilters(relationsToExclude);
                relationSearches = BNeqlizeRpc.getRelationSearches((Entity)base, excludeFilters, filteredTagsMap);
                BComponent[] descendants = (BComponent[])CompUtil.getDescendants((BComponent)base, BComponent.class);
                relationSearches.add(new RelationSearch(new TagSetSearch(Arrays.asList(descendants), filteredTagsMap)));
                break;
            }
            case 1: {
                Set<String> relationsToExclude = BNeqlizeRpc.getRelationsToExclude(options);
                Set<RelationPatternFilter> excludeFilters = BNeqlizeRpc.getExcludeRelationFilters(relationsToExclude);
                relationSearches = BNeqlizeRpc.getRelationSearches((Entity)base, excludeFilters, filteredTagsMap);
                break;
            }
            case 2: {
                BComponent[] descendants = (BComponent[])CompUtil.getDescendants((BComponent)base, BComponent.class);
                relationSearches = Collections.singletonList(new RelationSearch(new TagSetSearch(Arrays.asList(descendants), filteredTagsMap)));
                break;
            }
            default: {
                throw new LocalizableRuntimeException("tagdictionary", "neqlizeRpc.unsupportedConversionMode");
            }
        }
        JSONObject result = new JSONObject();
        for (String targetPath : targetPaths) {
            BComponent target = BNeqlizeRpc.resolveComponent(targetPath, base, context);
            result.put(targetPath, (Object)BNeqlizeRpc.makeResult(target, relationSearches));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("  RESULT = " + result.toString(2));
        }
        return result;
    }

    private static Set<RelationPatternFilter> getExcludeRelationFilters(Set<String> relationsToExclude) {
        HashSet<RelationPatternFilter> excludeFilters = new HashSet<RelationPatternFilter>();
        for (String r : relationsToExclude) {
            String id;
            boolean acceptsInbound = true;
            boolean acceptsOutbound = true;
            if (r.endsWith("->")) {
                acceptsInbound = false;
                id = r.substring(0, r.length() - 2);
            } else if (r.endsWith("<-")) {
                acceptsOutbound = false;
                id = r.substring(0, r.length() - 2);
            } else {
                id = r;
            }
            PatternFilter idFilter = new PatternFilter(id);
            excludeFilters.add(new RelationPatternFilter(idFilter, acceptsInbound, acceptsOutbound));
        }
        return excludeFilters;
    }

    private static JSONObject decodeOptionsString(String optionsString) {
        try {
            JSONObject options = new JSONObject(optionsString);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Options = " + options.toString(2));
            }
            return options;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error decoding neqlize options: " + optionsString, e);
            return null;
        }
    }

    private static List<RelationSearch> getRelationSearches(Entity base, Collection<RelationPatternFilter> relationsToExclude, FilteredTagsMap filteredTagsMap) {
        TagSetSearch tagSetSearch;
        LinkedHashMap<Id, List> outboundEndpoints = new LinkedHashMap<Id, List>();
        LinkedHashMap<Id, List> inboundEndpoints = new LinkedHashMap<Id, List>();
        Collection relations = base.relations().getAll();
        for (Relation relation : relations) {
            Entity entity;
            if (BNeqlizeRpc.shouldExcludeRelation(relation, relationsToExclude) || !((entity = relation.getEndpoint()) instanceof BComponent)) continue;
            List endpoints = relation.isInbound() ? inboundEndpoints.computeIfAbsent(relation.getId(), k -> new ArrayList()) : outboundEndpoints.computeIfAbsent(relation.getId(), k -> new ArrayList());
            endpoints.add((BComponent)entity);
        }
        ArrayList<RelationSearch> tagSetSearches = new ArrayList<RelationSearch>(outboundEndpoints.size() + inboundEndpoints.size());
        for (Map.Entry entry : outboundEndpoints.entrySet()) {
            tagSetSearch = new TagSetSearch((Collection)entry.getValue(), filteredTagsMap);
            tagSetSearches.add(new RelationSearch((Id)entry.getKey(), false, tagSetSearch));
        }
        for (Map.Entry entry : inboundEndpoints.entrySet()) {
            tagSetSearch = new TagSetSearch((Collection)entry.getValue(), filteredTagsMap);
            tagSetSearches.add(new RelationSearch((Id)entry.getKey(), true, tagSetSearch));
        }
        return tagSetSearches;
    }

    private static boolean shouldExcludeRelation(Relation relation, Collection<RelationPatternFilter> relationsToExclude) {
        for (RelationPatternFilter excludedRelation : relationsToExclude) {
            if (!excludedRelation.accept(relation)) continue;
            return true;
        }
        return false;
    }

    private static JSONObject makeResult(BComponent target, Iterable<RelationSearch> relationSearches) {
        if (target == null) {
            return BNeqlizeRpc.makeErrorObject(NO_TAG_SET_FOUND);
        }
        boolean isEndpoint = false;
        for (RelationSearch relationSearch : relationSearches) {
            if (!relationSearch.tagSetSearch.isInSearchSet(target)) continue;
            isEndpoint = true;
            Set<Tag> tagSet = relationSearch.tagSetSearch.findIdentifyingTags(target);
            if (tagSet.isEmpty()) continue;
            return BNeqlizeRpc.makeTagSetObject(tagSet, relationSearch.id, relationSearch.isInbound);
        }
        return isEndpoint ? BNeqlizeRpc.makeErrorObject(NO_TAG_SET_FOUND) : BNeqlizeRpc.makeErrorObject(NOT_ENDPOINT_OR_DESCENDANT);
    }

    private static JSONObject makeTagSetObject(Collection<Tag> tags, Id relationId, boolean isInbound) {
        if (tags == null || tags.isEmpty()) {
            return BNeqlizeRpc.makeErrorObject(NO_TAG_SET_FOUND);
        }
        TagSet tagSet = new TagSet();
        tags.forEach(arg_0 -> ((TagSet)tagSet).set(arg_0));
        StringWriter tagWriter = new StringWriter();
        JSONWriter tagJsonWriter = QuickJSONWriter.make((Appendable)tagWriter);
        try {
            JsonEntityEncoder.encodeTags((JSONWriter)tagJsonWriter, (Tags)tagSet);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, lex.getText("neqlizeRpc.jsonEncodingError"), e);
            return BNeqlizeRpc.makeErrorObject(JSON_ENCODING_ERROR);
        }
        JSONObject result = new JSONObject();
        if (relationId != null) {
            result.put(RELATION_ID_KEY, (Object)relationId);
            result.put(RELATION_IS_INBOUND_KEY, isInbound);
        }
        result.put(TAGS_KEY, (Object)new JSONObject(tagWriter.toString()));
        return result;
    }

    private static JSONObject makeErrorObject(String errorValue) {
        JSONObject object = new JSONObject();
        object.put(ERROR_KEY, (Object)errorValue);
        return object;
    }

    private static Set<String> getTagsToExclude(JSONObject options) {
        Optional<BTagDictionaryService> tdService = BNeqlizeRpc.getTagDictionaryService();
        if (!tdService.isPresent() || tdService.get().isDisabled()) {
            if (options == null || !options.has(EXCLUDED_TAGS)) {
                return Collections.emptySet();
            }
            return FilteredTagsMap.getTagExclusions(options.optString(EXCLUDED_TAGS));
        }
        Set<String> serviceExclusions = tdService.get().getNeqlizeOptions().getExcludedTagFilters();
        if (options == null || !options.has(EXCLUDED_TAGS)) {
            return serviceExclusions;
        }
        Set<String> userExclusions = FilteredTagsMap.getTagExclusions(options.optString(EXCLUDED_TAGS));
        if (options.optBoolean(USE_SERVICE_EXCLUDED_TAGS)) {
            serviceExclusions.addAll(userExclusions);
            return serviceExclusions;
        }
        return userExclusions;
    }

    private static Set<String> getRelationsToExclude(JSONObject options) {
        Optional<BTagDictionaryService> tdService = BNeqlizeRpc.getTagDictionaryService();
        if (!tdService.isPresent() || tdService.get().isDisabled()) {
            if (options == null || !options.has(EXCLUDED_RELATIONS)) {
                return Collections.emptySet();
            }
            return FilteredTagsMap.getRelationExclusions(options.optString(EXCLUDED_RELATIONS));
        }
        Set<String> serviceExclusions = tdService.get().getNeqlizeOptions().getExcludedRelationFilters();
        if (options == null || !options.has(EXCLUDED_RELATIONS)) {
            return serviceExclusions;
        }
        Set<String> userExclusions = FilteredTagsMap.getRelationExclusions(options.optString(EXCLUDED_RELATIONS));
        if (options.optBoolean(USE_SERVICE_EXCLUDED_RELATIONS)) {
            serviceExclusions.addAll(userExclusions);
            return serviceExclusions;
        }
        return userExclusions;
    }

    private static BNeqlizeMode getNeqlizeMode(JSONObject options) {
        if (options == null) {
            return BNeqlizeMode.traverseIfPossible;
        }
        String modeString = options.optString(CONVERSION_MODE, null);
        return modeString == null || !BNeqlizeMode.DEFAULT.getRange().isTag(modeString) ? BNeqlizeMode.traverseIfPossible : BNeqlizeMode.make(modeString);
    }

    private static BComponent resolveBaseComponent(String path, Context context) {
        try {
            BComponentSpace componentSpace = Sys.getStation().getComponentSpace();
            BComponent rootComponent = componentSpace.getRootComponent();
            return BNeqlizeRpc.resolveComponent(path, rootComponent, context);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Could not resolve base Component at " + path, e);
            return null;
        }
    }

    private static BComponent resolveComponent(String path, BComponent base, Context context) {
        try {
            BComponent target = BOrd.make((String)path).resolve((BObject)base, context).getComponent();
            return target == null || !target.getPermissions(context).hasOperatorRead() ? null : target;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Could not resolve target Component at " + path + " relative to base " + base.getSlotPath(), e);
            return null;
        }
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    private static Optional<BTagDictionaryService> getTagDictionaryService() {
        Optional service = Sys.findService((Type)BTagDictionaryService.TYPE);
        if (service.isPresent()) {
            return Optional.of((BTagDictionaryService)((Object)service.get()));
        }
        return Optional.empty();
    }

    private static class RelationSearch {
        final Id id;
        final boolean isInbound;
        final TagSetSearch tagSetSearch;

        RelationSearch(TagSetSearch tagSetSearch) {
            this.id = null;
            this.isInbound = false;
            this.tagSetSearch = tagSetSearch;
        }

        RelationSearch(Id id, boolean isInbound, TagSetSearch tagSetSearch) {
            this.id = id;
            this.isInbound = isInbound;
            this.tagSetSearch = tagSetSearch;
        }
    }

    private static class RelationPatternFilter {
        private final PatternFilter idFilter;
        private final boolean acceptInbound;
        private final boolean acceptOutbound;

        RelationPatternFilter(PatternFilter idFilter, boolean acceptInbound, boolean acceptOutbound) {
            this.idFilter = idFilter;
            this.acceptInbound = acceptInbound;
            this.acceptOutbound = acceptOutbound;
        }

        public boolean accept(Relation relation) {
            return this.idFilter.accept(relation.getId().getQName()) && (this.acceptInbound && relation.isInbound() || this.acceptOutbound && relation.isOutbound());
        }
    }
}

