/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.condition;

import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.condition.BBooleanFilter;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Relation;

@NiagaraType
public class BHasAncestor
extends BBooleanFilter {
    public static final Type TYPE = Sys.loadType(BHasAncestor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHasAncestor() {
    }

    public BHasAncestor(String filter) {
        super(filter);
    }

    @Override
    public boolean test(Predicate<Entity> predicate, Entity entity) {
        if (!(entity instanceof BComponent)) {
            return false;
        }
        BComponent obj = (BComponent)entity;
        while (obj != null) {
            if (predicate.test((Entity)obj)) {
                return true;
            }
            obj = BHasAncestor.getParent(obj);
        }
        return false;
    }

    private static BComponent getParent(BComponent child) {
        BComponent parent = (BComponent)child.getParent();
        if (parent != null) {
            return parent;
        }
        Optional relation = child.relations().get(BNiagaraTagDictionary.PARENT, 2);
        return relation.isPresent() ? (BComponent)((Relation)relation.get()).getEndpoint() : null;
    }
}

