/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.npsdk;

import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.platSerial.npsdk.BSerialPortNpsdk;
import java.io.File;
import java.security.AccessController;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSerialPortPlatformServiceNpsdk
extends BSerialPortPlatformService {
    public static final Type TYPE = Sys.loadType(BSerialPortPlatformServiceNpsdk.class);
    private boolean nativesLoaded = false;

    public Type getType() {
        return TYPE;
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading serialnpsdk native library");
                System.loadLibrary("serialnpsdk");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load serialnpsdk native library", e);
            }
            return this.nativesLoaded;
        });
    }

    public boolean isValidPlatform() {
        String seriallibPath = Sys.getNiagaraHome() + File.separator + "bin" + File.separator + "libserialnpsdk.so";
        return AccessController.doPrivileged(() -> new File(seriallibPath).exists());
    }

    public int getSlotFlags() {
        return 0;
    }

    protected String[] loadPortIdentifiers() {
        int i;
        this.loadLibraries();
        log.fine("Loading comm port identifiers...");
        String[] osNames = this.getOsPortNames0();
        if (osNames == null) {
            log.severe("getOsPortNames0() returned NULL");
            return null;
        }
        String[] slotNames = this.getPortSlotNames0();
        if (slotNames == null) {
            log.severe("getPortSlotNames0() returned NULL");
            return null;
        }
        if (osNames.length != slotNames.length) {
            log.severe("Serial os name list length does not match slot name length");
            return null;
        }
        HashMap<String, String> duplicateDetector = new HashMap<String, String>();
        for (String slotName : slotNames) {
            if (duplicateDetector.put(slotName, slotName) == null) continue;
            log.severe("Slot names returned by getPortSlotNames0 contained duplicate: \"" + slotName + "\"");
            return null;
        }
        for (i = 0; i < osNames.length; ++i) {
            if (osNames[i] == null || osNames[i].trim().isEmpty()) {
                log.severe("Invalid name returned by getOsPortNames0: \"" + osNames[i] + "\"");
                return null;
            }
            if (!SlotPath.isValidName((String)slotNames[i])) {
                log.severe("Invalid slot path name returned by getPortSlotNames0: \"" + slotNames[i] + "\"");
                return null;
            }
            log.fine(slotNames[i] + " --> " + osNames[i]);
        }
        for (i = 0; i < osNames.length; ++i) {
            BSerialPortNpsdk p = new BSerialPortNpsdk(osNames[i], i);
            this.add(SlotPath.escape((String)slotNames[i]), (BValue)p, 3);
            log.fine("Create serial port slot " + slotNames[i] + " for " + osNames[i]);
        }
        return slotNames;
    }

    private native String[] getOsPortNames0();

    private native String[] getPortSlotNames0();
}

