/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnFidTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnTable;
import javax.baja.gx.BFont;
import javax.baja.gx.BSize;
import javax.baja.log.Log;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnFidTableWithTimeSchedule", "ccn:CcnDataTableWithTimeSchedule"}, requiredPermissions="r")})
@NiagaraAction(name="buildTimeScheduleList", flags=4)
public class BCcnTimeScheduleManager
extends BWbComponentView {
    public static final Action buildTimeScheduleList = BCcnTimeScheduleManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCcnTimeScheduleManager.class);
    BGridPane objMainPanel;
    BGridPane objButtonPanel;
    BGridPane objTablePanel;
    BScrollPane objScrollPane;
    BCanvasPane objCanvasPane;
    BCanvasPane objTextcanvasPane;
    BButton objButton;
    BTextField objTextField;
    BBorderPane objBorderPane;
    int maxRows;
    BWidget[][] rows;
    BLabel objLabel;
    BCcnTimeScheduleEntry[] entries;
    BCcnDevice ccnDevice = null;
    BCcnNetwork ccnNetwork = null;
    final String[] columnNames = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Holiday", "From", "To", "Period"};
    private static final Log ccnLog = Log.getLog((String)"CCNNetworkLog");

    public void buildTimeScheduleList() {
        this.invoke(buildTimeScheduleList, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCcnTable getFidTableWithTimeSchedule() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BCcnFidTableWithTimeSchedule) {
            return (BCcnFidTableWithTimeSchedule)owner;
        }
        if (owner instanceof BCcnDataTableWithTimeSchedule) {
            return (BCcnDataTableWithTimeSchedule)owner;
        }
        return null;
    }

    public void doLoadValue(BObject value, Context cx) {
        try {
            super.doLoadValue(value, cx);
            BCcnTable ccnTable = this.getFidTableWithTimeSchedule();
            this.objCanvasPane = new BCanvasPane();
            this.objCanvasPane.setViewSize(BSize.make((double)800.0, (double)200.0));
            this.objCanvasPane.setHalign(BHalign.center);
            this.objMainPanel = new BGridPane(1);
            this.objButtonPanel = new BGridPane(2);
            this.objButtonPanel.setHalign(BHalign.center);
            String title = "Time Schedule List For " + ccnTable.getTableName();
            this.objButton = new BButton("Save Time Schedules");
            new WidgetSubscriber(){

                public void actionPerformed(BWidgetEvent event) {
                    BCcnTimeScheduleManager.this.doSaveList();
                }
            }.subscribe((BComponent)this.objButton);
            this.objButtonPanel.add("button", (BValue)this.objButton);
            this.objTablePanel = new BGridPane(11);
            this.objTablePanel.setColumnGap(20.0);
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.objLabel = new BLabel(this.columnNames[i]);
                this.objLabel.setFont(BFont.make((String)"bold 12pt Tahoma"));
                this.objLabel.setHalign(BHalign.center);
                this.objTablePanel.add(this.columnNames[i], (BValue)this.objLabel);
            }
            this.invoke(buildTimeScheduleList, null);
            this.getNumberOfRows(ccnTable, this.objTablePanel);
            this.objScrollPane = new BScrollPane((BWidget)this.objTablePanel);
            this.objScrollPane.setSize(800.0, 200.0);
            this.objCanvasPane.add("scrollPane", (BValue)this.objScrollPane);
            this.objMainPanel.add("buttonPanel", (BValue)this.objButtonPanel);
            this.objMainPanel.add("canvasPane", (BValue)this.objCanvasPane);
            this.objBorderPane = new BBorderPane((BWidget)this.objMainPanel, title);
            this.setContent((BWidget)this.objBorderPane);
        }
        catch (Exception e) {
            ccnLog.error("Exception occurred while loading value", (Throwable)e);
        }
    }

    public void doBuildTimeScheduleList() {
        try {
            BCcnTimeScheduleEntry[] list;
            BCcnTable ccnTable = this.getFidTableWithTimeSchedule();
            if (ccnTable instanceof BCcnDataTableWithTimeSchedule) {
                ccnTable.lease(0, 500L);
                if (((BCcnDataTableWithTimeSchedule)ccnTable).getTimeScheduleList() == null) {
                    if (ccnLog.isTraceOn()) {
                        ccnLog.trace("Timeschdule list is null");
                    }
                    return;
                }
                ((BCcnDataTableWithTimeSchedule)ccnTable).getTimeScheduleList().lease(1, 500L);
                list = ((BCcnDataTableWithTimeSchedule)ccnTable).getTimeScheduleList().getTimeScheduleList();
                this.maxRows = list == null ? 8 : list.length;
            } else if (ccnTable instanceof BCcnFidTableWithTimeSchedule) {
                ccnTable.lease(0, 500L);
                if (((BCcnFidTableWithTimeSchedule)ccnTable).getTimeScheduleList() == null) {
                    if (ccnLog.isTraceOn()) {
                        ccnLog.trace("Timeschdule list is null");
                    }
                    return;
                }
                ((BCcnFidTableWithTimeSchedule)ccnTable).getTimeScheduleList().lease(1, 500L);
                list = ((BCcnFidTableWithTimeSchedule)ccnTable).getTimeScheduleList().getTimeScheduleList();
                this.maxRows = list == null ? 7 : list.length;
            } else {
                return;
            }
            this.initRows();
            if (list != null) {
                this.entries = new BCcnTimeScheduleEntry[list.length];
                for (int i = 0; i < list.length; ++i) {
                    list[i].lease();
                    this.entries[i] = new BCcnTimeScheduleEntry(list[i]);
                }
                this.load();
            }
        }
        catch (Exception e) {
            ccnLog.error("Exception occurred while building schedule list value", (Throwable)e);
        }
    }

    private synchronized void load() {
        try {
            if (this.entries != null && this.entries.length > 0) {
                this.setList(this.entries, this.objTablePanel);
            } else {
                this.setList(null, this.objTablePanel);
            }
        }
        catch (Exception e) {
            BDialog.error(null, (Object)("Cannot load: " + e));
        }
    }

    public void getNumberOfRows(BCcnTable ccnTable, BGridPane objTablePanel) {
        this.getNumberOfRows(ccnTable, null, objTablePanel);
    }

    public void getNumberOfRows(BCcnTable ccnTable, BCcnTimeScheduleEntry[] initList, BGridPane ObjTablePanel) {
        if (ccnTable instanceof BCcnDataTableWithTimeSchedule) {
            this.maxRows = initList == null ? 8 : initList.length;
        } else if (ccnTable instanceof BCcnFidTableWithTimeSchedule) {
            this.maxRows = initList == null ? 7 : initList.length;
        }
        this.initRows();
        this.setList(initList, this.objTablePanel);
    }

    public void setList(BCcnTimeScheduleEntry[] newList, BGridPane objTablePanel) {
        if (newList != null) {
            for (int i = 0; i < this.maxRows; ++i) {
                this.rows[i][0] = new BCheckBox();
                ((BCheckBox)this.rows[i][0]).setHalign(BHalign.right);
                ((BCheckBox)this.rows[i][0]).setSelected(newList[i].getMon());
                if (objTablePanel.get("checkBox" + i + 0) == null) {
                    objTablePanel.add("checkBox" + i + 0, (BValue)this.rows[i][0]);
                }
                this.rows[i][1] = new BCheckBox();
                ((BCheckBox)this.rows[i][1]).setHalign(BHalign.right);
                ((BCheckBox)this.rows[i][1]).setSelected(newList[i].getTues());
                if (objTablePanel.get("checkBox" + i + 1) == null) {
                    objTablePanel.add("checkBox" + i + 1, (BValue)this.rows[i][1]);
                }
                this.rows[i][2] = new BCheckBox();
                ((BCheckBox)this.rows[i][2]).setHalign(BHalign.center);
                ((BCheckBox)this.rows[i][2]).setSelected(newList[i].getWed());
                if (objTablePanel.get("checkBox" + i + 2) == null) {
                    objTablePanel.add("checkBox" + i + 2, (BValue)this.rows[i][2]);
                }
                this.rows[i][3] = new BCheckBox();
                ((BCheckBox)this.rows[i][3]).setHalign(BHalign.center);
                ((BCheckBox)this.rows[i][3]).setSelected(newList[i].getThur());
                if (objTablePanel.get("checkBox" + i + 3) == null) {
                    objTablePanel.add("checkBox" + i + 3, (BValue)this.rows[i][3]);
                }
                this.rows[i][4] = new BCheckBox();
                ((BCheckBox)this.rows[i][4]).setHalign(BHalign.center);
                ((BCheckBox)this.rows[i][4]).setSelected(newList[i].getFri());
                if (objTablePanel.get("checkBox" + i + 4) == null) {
                    objTablePanel.add("checkBox" + i + 4, (BValue)this.rows[i][4]);
                }
                this.rows[i][5] = new BCheckBox();
                ((BCheckBox)this.rows[i][5]).setHalign(BHalign.center);
                ((BCheckBox)this.rows[i][5]).setSelected(newList[i].getSat());
                if (objTablePanel.get("checkBox" + i + 5) == null) {
                    objTablePanel.add("checkBox" + i + 5, (BValue)this.rows[i][5]);
                }
                this.rows[i][6] = new BCheckBox();
                ((BCheckBox)this.rows[i][6]).setHalign(BHalign.center);
                ((BCheckBox)this.rows[i][6]).setSelected(newList[i].getSun());
                if (objTablePanel.get("checkBox" + i + 6) == null) {
                    objTablePanel.add("checkBox" + i + 6, (BValue)this.rows[i][6]);
                }
                this.rows[i][7] = new BCheckBox();
                ((BCheckBox)this.rows[i][7]).setHalign(BHalign.center);
                ((BCheckBox)this.rows[i][7]).setSelected(newList[i].getHoliday());
                if (objTablePanel.get("checkBox" + i + 7) == null) {
                    objTablePanel.add("checkBox" + i + 7, (BValue)this.rows[i][7]);
                }
                this.objTextcanvasPane = new BCanvasPane();
                this.objTextcanvasPane.setViewSize(BSize.make((double)50.0, (double)20.0));
                this.rows[i][8] = new BTextField();
                ((BTextField)this.rows[i][8]).setText(newList[i].getFrom());
                if (this.objTextcanvasPane.get("textField" + i + 8) == null) {
                    this.objTextcanvasPane.add("textField" + i + 8, (BValue)this.rows[i][8]);
                }
                if (objTablePanel.get("textCanvas" + i + 8) == null) {
                    objTablePanel.add("textCanvas" + i + 8, (BValue)this.objTextcanvasPane);
                }
                final String text = ((BTextField)this.rows[i][8]).getText();
                new WidgetSubscriber(){

                    public void actionPerformed(BWidgetEvent event) {
                        if (BCcnTimeScheduleManager.this.checkTime(text)) {
                            BDialog.message(null, (Object)("User value " + text + " out of limits.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59."));
                        }
                    }
                }.subscribe((BComponent)this.rows[i][8]);
                this.objTextcanvasPane = new BCanvasPane();
                this.objTextcanvasPane.setViewSize(BSize.make((double)50.0, (double)20.0));
                this.rows[i][9] = new BTextField();
                ((BTextField)this.rows[i][9]).setText(newList[i].getTo());
                final String text1 = ((BTextField)this.rows[i][9]).getText();
                if (this.objTextcanvasPane.get("textField" + i + 9) == null) {
                    this.objTextcanvasPane.add("textField" + i + 9, (BValue)this.rows[i][9]);
                }
                if (objTablePanel.get("textCanvas" + i + 9) == null) {
                    objTablePanel.add("textCanvas" + i + 9, (BValue)this.objTextcanvasPane);
                }
                new WidgetSubscriber(){

                    public void actionPerformed(BWidgetEvent event) {
                        if (!BCcnTimeScheduleManager.this.checkTime(text1)) {
                            BDialog.message(null, (Object)("User value " + text1 + " out of limits.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59."));
                        }
                    }
                }.subscribe((BComponent)this.rows[i][9]);
                this.objTextcanvasPane = new BCanvasPane();
                this.objTextcanvasPane.setViewSize(BSize.make((double)50.0, (double)20.0));
                this.rows[i][10] = new BLabel();
                ((BLabel)this.rows[i][10]).setText(newList[i].getPeriodNo());
                if (this.objTextcanvasPane.get("textField" + i + 10) == null) {
                    this.objTextcanvasPane.add("textField" + i + 10, (BValue)this.rows[i][10]);
                }
                if (objTablePanel.get("textCanvas" + i + 10) != null) continue;
                objTablePanel.add("textCanvas" + i + 10, (BValue)this.objTextcanvasPane);
            }
        }
    }

    public boolean checkTime(String value) {
        try {
            int hh = Integer.valueOf(value.substring(0, value.indexOf(":")));
            int mm = Integer.valueOf(value.substring(value.indexOf(":") + 1));
            if (hh >= 24 || hh < 0) {
                return false;
            }
            return mm < 60 && mm >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initRows() {
        this.rows = this.maxRows != 0 ? new BWidget[this.maxRows][11] : new BWidget[8][11];
    }

    private void doSaveList() {
        block8: {
            try {
                BCcnTable ccnTable = this.getFidTableWithTimeSchedule();
                this.entries = this.getList(ccnTable);
                if (ccnTable instanceof BCcnDataTableWithTimeSchedule) {
                    for (int i = 0; i < this.entries.length; ++i) {
                        if (!this.checkTime(this.entries[i].getFrom())) {
                            BDialog.message(null, (Object)("User value " + this.entries[i].getFrom() + " out of limits.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59. Please enter the value in hh:mm format."));
                            return;
                        }
                        if (this.checkTime(this.entries[i].getTo())) continue;
                        BDialog.message(null, (Object)("User value " + this.entries[i].getTo() + " out of limits.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59. Please enter the value in hh:mm format."));
                        return;
                    }
                    BCcnTimeScheduleList newList = new BCcnTimeScheduleList(this.entries);
                    ccnTable.invoke(BCcnDataTableWithTimeSchedule.saveTimeSchedule, (BValue)newList);
                    break block8;
                }
                if (ccnTable instanceof BCcnFidTableWithTimeSchedule) {
                    for (int i = 0; i < this.entries.length; ++i) {
                        if (!this.checkTime(this.entries[i].getFrom())) {
                            BDialog.message(null, (Object)("User value " + this.entries[i].getFrom() + " out of limits.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59. Please Enter the value in hh:mm format."));
                            return;
                        }
                        if (this.checkTime(this.entries[i].getTo())) continue;
                        BDialog.message(null, (Object)("User value " + this.entries[i].getTo() + " out of limits.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59. Please Enter the value in hh:mm format."));
                        return;
                    }
                    BCcnTimeScheduleList newList = new BCcnTimeScheduleList(this.entries);
                    ccnTable.invoke(BCcnFidTableWithTimeSchedule.saveTimeSchedule, (BValue)newList);
                    break block8;
                }
                return;
            }
            catch (Exception e) {
                ccnLog.error("Exception occurred while saving schedule list value", (Throwable)e);
            }
        }
        this.load();
    }

    public BCcnTimeScheduleEntry[] getList(BCcnTable node) {
        try {
            int getRows = 8;
            if (node instanceof BCcnFidTableWithTimeSchedule) {
                getRows = 7;
            }
            BCcnTimeScheduleEntry[] entries = new BCcnTimeScheduleEntry[getRows];
            for (int i = 0; i < getRows; ++i) {
                entries[i] = new BCcnTimeScheduleEntry(((BCheckBox)this.objTablePanel.get("checkBox" + i + 0)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 1)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 2)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 3)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 4)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 5)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 6)).getSelected(), ((BCheckBox)this.objTablePanel.get("checkBox" + i + 7)).getSelected(), ((BTextField)((BCanvasPane)this.objTablePanel.get("textCanvas" + i + 8)).get("textField" + i + 8)).getText(), ((BTextField)((BCanvasPane)this.objTablePanel.get("textCanvas" + i + 9)).get("textField" + i + 9)).getText(), ((BLabel)((BCanvasPane)this.objTablePanel.get("textCanvas" + i + 10)).get("textField" + i + 10)).getText());
            }
            return entries;
        }
        catch (Exception e) {
            ccnLog.error("Exception occurred while obtaining table list schedule list value", (Throwable)e);
            return null;
        }
    }
}

