/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.job.BCcnLearnDataTablesJob;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnPocTable"}, requiredPermissions="r")})
public class BCcnDataTableManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BCcnDataTableManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colTablename = new MgrColumn.Prop(BCcnTable.tableName, 1);
    MgrColumn colTableTypeString = new MgrColumn.Prop(BCcnTable.tableTypeString, 4);
    MgrColumn colTableType = new MgrColumn.Prop(BCcnTable.tableType, 4);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colTablename, this.colTableType, this.colTableTypeString};
    BCcnTableEntry learnEntry;
    BCcnTableEntry table;
    BCcnDataTable dataTable = null;
    BCcnDataTableWithTimeSchedule dataTableWithTimeSchedule = null;
    private static final BImage tableImage = BImage.make((String)"module://ccn/images/CcnTable.png");

    public Type getType() {
        return TYPE;
    }

    public BCcnPocTable getPocTable() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BCcnPocTable) {
            return (BCcnPocTable)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    void updateLearnData() {
        try {
            Object[] dataTables = (BCcnTableEntry[])this.getPocTable().getLearnedDataTables().getChildren(BCcnTableEntry.class);
            if (dataTables != null && dataTables.length > 0) {
                for (int i = 0; i < dataTables.length; ++i) {
                    dataTables[i].lease();
                }
            }
            this.getLearn().updateRoots(dataTables);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new TridiumCCNDataTableModel(this);
    }

    protected MgrController makeController() {
        return new TridiumCCNDataTableController(this);
    }

    protected MgrLearn makeLearn() {
        return new TridiumCCNDataTableLearn(this);
    }

    protected MgrState makeState() {
        return new TridiumCCNDataTableState();
    }

    class TridiumCCNDataTableController
    extends MgrController {
        TridiumCCNDataTableController(BFolderManager mgr) {
            super((BAbstractManager)mgr);
            this.newCommand.setEnabled(true);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BCcnPocTable ccnTable;
            super.doDiscover(cx);
            BCcnTableEntry[] learnedDataTables = (BCcnTableEntry[])BCcnDataTableManager.this.getPocTable().getLearnedDataTables().getChildren(BCcnTableEntry.class);
            if (learnedDataTables.length > 0) {
                BCcnDataTableManager.this.getPocTable().getLearnedDataTables().removeAll();
            }
            if ((ccnTable = BCcnDataTableManager.this.getPocTable()) == null) {
                throw new Exception("Network null, can not discover devices");
            }
            this.discover.setEnabled(false);
            BOrd ordToDiscoveryJob = ccnTable.submitDataTableDiscoveryJob();
            BCcnDataTableManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        public CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            Object[] disSelRows = this.getLearnTable().getSelectedObjects();
            BCcnTableEntry[] createList = new BCcnTableEntry[disSelRows.length];
            for (int i = 0; i < disSelRows.length; ++i) {
                boolean isExisting = false;
                if (BCcnDataTableManager.this.getLearn().getExisting(disSelRows[i]) != null) {
                    isExisting = true;
                    continue;
                }
                if (isExisting) continue;
                createList[i] = (BCcnTableEntry)discovery[i];
            }
            BCcnTableList tableTable = new BCcnTableList(createList);
            BCcnPocTable pocTable = BCcnDataTableManager.this.getPocTable();
            if (pocTable == null) {
                throw new Exception("Device is null, can not add tables");
            }
            if (tableTable.getTableList().length > 0) {
                BOrd ordToAddDataTablesJob = pocTable.submitAddDataTablesJob(tableTable);
                BCcnDataTableManager.this.getLearn().setJob(ordToAddDataTablesJob);
            } else {
                BDialog.message(null, (Object)"The selected table/s are already added to station database");
            }
            return null;
        }

        public void updateCommands() {
            super.updateCommands();
            if (BCcnDataTableManager.this.getCurrentValue() instanceof BCcnTableGroup) {
                this.discover.setEnabled(false);
            }
        }
    }

    class TridiumCCNDataTableLearn
    extends MgrLearn {
        TridiumCCNDataTableLearn(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BCcnTableEntry.tableName), new MgrColumn.Prop(BCcnTableEntry.tableType), new MgrColumn.Prop(BCcnTableEntry.tableTypeString)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BCcnTableEntry.TYPE);
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BCcnTableEntry learnEntry = (BCcnTableEntry)discovery;
            BCcnTable table = (BCcnTable)row.getTarget();
            table.setTableName(learnEntry.getTableName().trim());
            table.setTableType(learnEntry.getTableType());
            table.setTableTypeString(learnEntry.getTableTypeString());
            row.setDefaultName(learnEntry.getTableName());
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BCcnLearnDataTablesJob) {
                BCcnDataTableManager.this.updateLearnData();
            }
        }

        public final boolean isExisting(Object discovered, BComponent db) {
            if (!(db instanceof BCcnTable)) {
                return false;
            }
            BCcnTableEntry learnedTable = (BCcnTableEntry)discovered;
            BCcnTable table = (BCcnTable)db;
            boolean exists = false;
            if (learnedTable.getTableName().equalsIgnoreCase(table.getTableName()) && learnedTable.getTableNum() == table.getTableNum() && learnedTable.getTableInstance() == table.getTableInstance() && learnedTable.getTableType() == table.getTableType()) {
                exists = true;
            }
            return exists;
        }

        public final BImage getIcon(Object d) {
            return tableImage;
        }
    }

    class TridiumCCNDataTableModel
    extends MgrModel {
        TridiumCCNDataTableModel(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        public TridiumCCNDataTableModel(BCcnTableEntry[] initList) {
            super(null);
        }

        protected MgrColumn[] makeColumns() {
            return BCcnDataTableManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BCcnTable.TYPE);
        }
    }

    static class TridiumCCNDataTableState
    extends PointState {
        boolean isAllDescendants;
        MgrController controller;

        TridiumCCNDataTableState() {
        }

        protected void restoreForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                ((FolderController)controller).allDescendants.setSelected(this.isAllDescendants);
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                ((PointController)controller).allDescendants.setSelected(this.isAllDescendants);
            }
        }

        protected void saveForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                this.isAllDescendants = ((FolderController)controller).allDescendants.isSelected();
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                this.isAllDescendants = ((PointController)controller).allDescendants.isSelected();
            }
        }
    }
}

