/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.components.BCcnAlarmHistoryEntry;
import com.tridium.ccn.job.BCcnAlarmHistoryJob;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.tables.BCcnTable;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointState;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnAHTable"}, requiredPermissions="r")})
public class BCcnAlarmHistoryManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BCcnAlarmHistoryManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colAlarmDetail = new MgrColumn.Prop(BCcnAlarmHistoryEntry.alarm, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colAlarmDetail};
    BCcnAlarmHistoryEntry learnEntry;

    public Type getType() {
        return TYPE;
    }

    public BCcnAHTable getAlarmTable() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BCcnAHTable) {
            return (BCcnAHTable)owner;
        }
        return null;
    }

    void updateLearnData() {
        try {
            Object[] ccnAlarms = (BCcnAlarmHistoryEntry[])this.getAlarmTable().getLearnedAlarms().getChildren(BCcnAlarmHistoryEntry.class);
            if (ccnAlarms != null && ccnAlarms.length > 0) {
                for (int i = 0; i < ccnAlarms.length; ++i) {
                    ccnAlarms[i].lease();
                }
            }
            this.getLearn().updateRoots(ccnAlarms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new TridiumCCNAlarmModel(this);
    }

    protected MgrController makeController() {
        return new TridiumCCNAlarmController(this);
    }

    protected MgrLearn makeLearn() {
        return new TridiumCCNAlarmLearn(this);
    }

    protected MgrState makeState() {
        return new TridiumCCNAlarmState();
    }

    static class TridiumCCNAlarmState
    extends PointState {
        boolean isAllDescendants;
        MgrController controller;

        TridiumCCNAlarmState() {
        }

        protected void restoreForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                ((FolderController)controller).allDescendants.setSelected(this.isAllDescendants);
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                ((PointController)controller).allDescendants.setSelected(this.isAllDescendants);
            }
        }

        protected void saveForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                this.isAllDescendants = ((FolderController)controller).allDescendants.isSelected();
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                this.isAllDescendants = ((PointController)controller).allDescendants.isSelected();
            }
        }
    }

    class TridiumCCNAlarmController
    extends MgrController {
        TridiumCCNAlarmController(BFolderManager mgr) {
            super((BAbstractManager)mgr);
            this.newCommand.setEnabled(true);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BCcnAHTable ccnAHTable = BCcnAlarmHistoryManager.this.getAlarmTable();
            if (ccnAHTable == null) {
                throw new Exception("Network null, can not discover devices");
            }
            this.discover.setEnabled(false);
            BOrd ordToAlarmJob = ccnAHTable.submitAlarmHistoryJob();
            BCcnAlarmHistoryManager.this.getLearn().setJob(ordToAlarmJob);
            return null;
        }
    }

    class TridiumCCNAlarmLearn
    extends MgrLearn {
        TridiumCCNAlarmLearn(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BCcnAlarmHistoryEntry.alarmTextSummary)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BCcnAlarmHistoryEntry.TYPE);
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BCcnAlarmHistoryManager.this.learnEntry = (BCcnAlarmHistoryEntry)discovery;
            row.setCell(BCcnAlarmHistoryManager.this.colAlarmDetail, (BValue)BString.make((String)BCcnAlarmHistoryManager.this.learnEntry.getAlarmTextSummary()));
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BCcnAlarmHistoryJob) {
                BCcnAlarmHistoryManager.this.updateLearnData();
            }
        }
    }

    class TridiumCCNAlarmModel
    extends MgrModel {
        TridiumCCNAlarmModel(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        public TridiumCCNAlarmModel(BCcnAlarmHistoryEntry[] initList) {
            super(null);
        }

        protected MgrColumn[] makeColumns() {
            return BCcnAlarmHistoryManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BCcnTable.TYPE);
        }
    }
}

