/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.ndriver.comm.ICommFilter;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.tcp.ITcpEventListener;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceExt;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.comm.MilestoneTcpListener;
import com.tridium.nmilestone.display.BMilestoneVideoDisplay;
import com.tridium.nmilestone.messages.MilestoneCentralReq;
import com.tridium.nmilestone.util.BMilestoneImageServerUserNameAndPassword;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

public class BMilestoneDvr
extends BVideoDvr
implements ITcpEventListener {
    public static final Property cameras = BMilestoneDvr.newProperty((int)0, (BValue)new BMilestoneCameraDeviceExt(), null);
    public static final Property milestoneEngineIpAddress = BMilestoneDvr.newProperty((int)0, (String)"###.###.###.###", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property milestoneImageServerPort = BMilestoneDvr.newProperty((int)0, (int)80, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property milestoneCentralPort = BMilestoneDvr.newProperty((int)0, (int)1237, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property uploadEventsPort = BMilestoneDvr.newProperty((int)0, (int)1234, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property webClientHttpPort = BMilestoneDvr.newProperty((int)0, (int)8081, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property webClientHttpsPort = BMilestoneDvr.newProperty((int)0, (int)8082, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property credentials = BMilestoneDvr.newProperty((int)0, (BValue)new BUsernameAndPassword(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property milestoneCentralCredentials = BMilestoneDvr.newProperty((int)0, (BValue)new BMilestoneImageServerUserNameAndPassword(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property recentSessionIds = BMilestoneDvr.newProperty((int)4, (String)"", null);
    public static final Property maxRecentSessionsToClose = BMilestoneDvr.newProperty((int)4, (int)100, null);
    public static final Property changeInCentralSever = BMilestoneDvr.newProperty((int)4, (boolean)false, null);
    public static final Property changeInImageSever = BMilestoneDvr.newProperty((int)4, (boolean)false, null);
    public static final Property imageServerFaultStatus = BMilestoneDvr.newProperty((int)4, (boolean)false, null);
    public static final Property centralServerFaultStatus = BMilestoneDvr.newProperty((int)4, (boolean)false, null);
    public static final Property imageServerFaultCause = BMilestoneDvr.newProperty((int)4, (String)"", null);
    public static final Property centralServerFaultCause = BMilestoneDvr.newProperty((int)4, (String)"", null);
    public static final Action startSession = BMilestoneDvr.newAction((int)0, null);
    public static final Action stopSession = BMilestoneDvr.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BMilestoneDvr.class);
    protected Object sessionTracking = new Object();
    static final int SESSION_INIT = 0;
    static final int SESSION_STARTING = 1;
    static final int SESSION_ACTIVE = 2;
    static final int SESSION_FAULT = 4;
    static final int SESSION_STOPPED = 5;
    public static int nextSessionPingTimerId = 1;
    public String milestoneSessionId = null;
    protected boolean milestoneSessionFailure1 = false;
    protected Object access = new Object();
    protected SessionPingTimer sessionPingTimer = null;
    public static final long FORTY_FIVE_SECONDS = 45000L;
    protected Object commSynchronizer = new Object();
    BMilestoneNetwork network;
    MilestoneTcpListener listener;
    private MilestoneTcpSession tcpIsSession;
    private MilestoneTcpSession tcpCpSession;

    public BCameraDeviceExt getCameras() {
        return (BCameraDeviceExt)this.get(cameras);
    }

    public void setCameras(BCameraDeviceExt v) {
        this.set(cameras, (BValue)v, null);
    }

    public String getMilestoneEngineIpAddress() {
        return this.getString(milestoneEngineIpAddress);
    }

    public void setMilestoneEngineIpAddress(String v) {
        this.setString(milestoneEngineIpAddress, v, null);
    }

    public int getMilestoneImageServerPort() {
        return this.getInt(milestoneImageServerPort);
    }

    public void setMilestoneImageServerPort(int v) {
        this.setInt(milestoneImageServerPort, v, null);
    }

    public int getMilestoneCentralPort() {
        return this.getInt(milestoneCentralPort);
    }

    public void setMilestoneCentralPort(int v) {
        this.setInt(milestoneCentralPort, v, null);
    }

    public int getUploadEventsPort() {
        return this.getInt(uploadEventsPort);
    }

    public void setUploadEventsPort(int v) {
        this.setInt(uploadEventsPort, v, null);
    }

    public int getWebClientHttpPort() {
        return this.getInt(webClientHttpPort);
    }

    public void setWebClientHttpPort(int v) {
        this.setInt(webClientHttpPort, v, null);
    }

    public int getWebClientHttpsPort() {
        return this.getInt(webClientHttpsPort);
    }

    public void setWebClientHttpsPort(int v) {
        this.setInt(webClientHttpsPort, v, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public BMilestoneImageServerUserNameAndPassword getMilestoneCentralCredentials() {
        return (BMilestoneImageServerUserNameAndPassword)this.get(milestoneCentralCredentials);
    }

    public void setMilestoneCentralCredentials(BMilestoneImageServerUserNameAndPassword v) {
        this.set(milestoneCentralCredentials, (BValue)v, null);
    }

    public String getRecentSessionIds() {
        return this.getString(recentSessionIds);
    }

    public void setRecentSessionIds(String v) {
        this.setString(recentSessionIds, v, null);
    }

    public int getMaxRecentSessionsToClose() {
        return this.getInt(maxRecentSessionsToClose);
    }

    public void setMaxRecentSessionsToClose(int v) {
        this.setInt(maxRecentSessionsToClose, v, null);
    }

    public boolean getChangeInCentralSever() {
        return this.getBoolean(changeInCentralSever);
    }

    public void setChangeInCentralSever(boolean v) {
        this.setBoolean(changeInCentralSever, v, null);
    }

    public boolean getChangeInImageSever() {
        return this.getBoolean(changeInImageSever);
    }

    public void setChangeInImageSever(boolean v) {
        this.setBoolean(changeInImageSever, v, null);
    }

    public boolean getImageServerFaultStatus() {
        return this.getBoolean(imageServerFaultStatus);
    }

    public void setImageServerFaultStatus(boolean v) {
        this.setBoolean(imageServerFaultStatus, v, null);
    }

    public boolean getCentralServerFaultStatus() {
        return this.getBoolean(centralServerFaultStatus);
    }

    public void setCentralServerFaultStatus(boolean v) {
        this.setBoolean(centralServerFaultStatus, v, null);
    }

    public String getImageServerFaultCause() {
        return this.getString(imageServerFaultCause);
    }

    public void setImageServerFaultCause(String v) {
        this.setString(imageServerFaultCause, v, null);
    }

    public String getCentralServerFaultCause() {
        return this.getString(centralServerFaultCause);
    }

    public void setCentralServerFaultCause(String v) {
        this.setString(centralServerFaultCause, v, null);
    }

    public void startSession() {
        this.invoke(startSession, null, null);
    }

    public void stopSession() {
        this.invoke(stopSession, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void videoDvrStarted() throws Exception {
        this.setRecentSessionIds("");
        this.postAsync(new Runnable(){

            @Override
            public void run() {
                BMilestoneDvr.this.milestoneDvrStarted();
            }
        });
        super.videoDvrStarted();
    }

    public void changed(Property p, Context c) {
        if (p.equals(milestoneEngineIpAddress)) {
            this.setChangeInImageSever(true);
            this.setChangeInCentralSever(true);
        } else if (p.equals(milestoneImageServerPort) || p.equals(uploadEventsPort) || p.equals(credentials)) {
            this.setChangeInImageSever(true);
        } else if (p.equals(milestoneCentralPort) || p.equals(milestoneCentralCredentials)) {
            this.setChangeInCentralSever(true);
        }
        super.changed(p, c);
    }

    public void milestoneDvrStarted() {
        this.getLogger().info("Milestone DVR starting..");
        this.setCentralServerFaultCause("Milestone Central server not yet connected..");
        this.setCentralServerFaultStatus(true);
        this.setImageServerFaultCause("Milestone Image server not yet connected..");
        this.setImageServerFaultStatus(true);
        this.startCentralServerSession();
        this.startImageServerSession();
        this.updatePingStatus();
        this.postAsync(new Runnable(){

            @Override
            public void run() {
                BMilestoneDvr.this.doStartSession();
            }
        });
    }

    private void startCentralServerSession() {
        try {
            if (this.listener != null) {
                this.getMilestoneNetwork().tcpcomm().unregisterCommListener((ICommListener)this.listener, this.getFilter());
            }
            this.startTcpCpSession();
            this.listener = new MilestoneTcpListener(this);
            this.getMilestoneNetwork().tcpcomm().registerCommListener((ICommListener)this.listener, this.getFilter(), false);
        }
        catch (Exception e) {
            this.setCentralServerFaultCause(e.getMessage());
            this.setCentralServerFaultStatus(true);
        }
    }

    private void startImageServerSession() {
        ((TcpLinkLayer)this.getMilestoneNetwork().tcpcomm().getLinkLayer()).registerTcpEvenListener((ITcpEventListener)this);
        try {
            this.startTcpIsSession();
        }
        catch (Exception e) {
            this.setImageServerFaultCause(e.getMessage());
            this.setImageServerFaultStatus(true);
        }
    }

    public void updatePingStatus() {
        if (this.getImageServerFaultStatus() && this.getCentralServerFaultStatus()) {
            this.pingFail(this.getImageServerFaultCause() + ". " + this.getCentralServerFaultCause());
        } else if (this.getImageServerFaultStatus()) {
            this.pingFail(this.getImageServerFaultCause());
        } else if (this.getCentralServerFaultStatus()) {
            this.pingFail(this.getCentralServerFaultCause());
        } else {
            this.pingOk();
        }
    }

    public void startTcpIsSession() throws Exception {
        this.tcpIsSession = new MilestoneTcpSession(this.httpAddress());
        this.tcpIsSession.start();
    }

    public void startTcpCpSession() throws Exception {
        this.tcpCpSession = new MilestoneTcpSession(this.tcpAddress());
        this.tcpCpSession.start();
        MilestoneCentralReq req = new MilestoneCentralReq("\r\n\r\n".getBytes());
        this.tcpCpSession.sendMessage(req);
    }

    ICommFilter getFilter() {
        return new ICommFilter(){

            public boolean accept(NMessage arg0) {
                return true;
            }
        };
    }

    public void stopped() throws Exception {
        try {
            this.getMilestoneNetwork().tcpcomm().unregisterCommListener((ICommListener)this.listener, null);
            this.milestoneDvrStopped();
            super.stopped();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void milestoneDvrStopped() throws Exception {
        this.stopCommunicating();
        if (this.tcpIsSession != null) {
            this.tcpIsSession.stop();
        }
        if (this.tcpCpSession != null) {
            this.tcpCpSession.stop();
        }
    }

    public void stopCommunicating() {
        if (this.sessionPingTimer != null) {
            this.sessionPingTimer.stopPingTimer();
        }
        if (this.milestoneSessionId != null) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("Sending stop...");
            }
            this.doStopSession(this.milestoneSessionId);
        }
    }

    public BMilestoneNetwork getMilestoneNetwork() {
        if (this.network != null) {
            return this.network;
        }
        BDeviceNetwork devnetwork = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BDeviceNetwork)) continue;
            devnetwork = (BDeviceNetwork)parent;
            break;
        }
        this.network = (BMilestoneNetwork)devnetwork;
        return this.network;
    }

    public boolean supportsMultistream() {
        return false;
    }

    public Type getVideoCameraType() {
        return BMilestoneCamera.TYPE;
    }

    public Type getVideoDisplayType() {
        return BMilestoneVideoDisplay.TYPE;
    }

    public void initPlaybackParams(BPlaybackParams arg0, IVideoSession arg1) {
    }

    public Type getNetworkType() {
        return BMilestoneNetwork.TYPE;
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
    }

    public void doPing() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getChangeInCentralSever() || this.getCentralServerFaultStatus()) {
            this.setChangeInCentralSever(false);
            try {
                if (this.tcpCpSession != null) {
                    this.tcpCpSession.stop();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.startCentralServerSession();
        }
        if (this.getChangeInImageSever() || this.getImageServerFaultStatus()) {
            try {
                if (this.tcpIsSession != null) {
                    this.tcpIsSession.stop();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.startImageServerSession();
        }
        try {
            String passKey = this.getUpdatedImageServerKey();
            BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
            usernameAndPassword.setUsername(this.getCredentials().getUsername());
            usernameAndPassword.setPassword(BPassword.make((String)passKey));
            MilestoneHttpUtil.getDvrStatus(this.getMilestoneNetwork().hcomm(), this.httpAddress(), usernameAndPassword);
            if (this.getChangeInImageSever() || this.getImageServerFaultStatus()) {
                this.setChangeInImageSever(false);
                this.doStartSession();
            } else {
                this.setImageServerFaultCause("");
                this.setImageServerFaultStatus(false);
            }
        }
        catch (Exception e) {
            this.setImageServerFaultCause("DVR is not reachable.");
            this.setImageServerFaultStatus(true);
            this.setCentralServerFaultStatus(true);
            if (this.milestoneSessionId != null) {
                this.doStopSession(this.milestoneSessionId);
            }
        }
        finally {
            this.updatePingStatus();
        }
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams arg0) {
        return null;
    }

    public void doStartSession() {
        this.postAsync(new Runnable(){

            @Override
            public void run() {
                BMilestoneDvr.this.closeRecentMilestoneSessions();
                BMilestoneDvr.this.doStartSessionSync();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rememberMilestoneSession(String milestoneSessionId) {
        Object object = this.sessionTracking;
        synchronized (object) {
            int x = this.getMaxRecentSessionsToClose();
            String recentSessions = this.getRecentSessionIds();
            String recentSessionsPossiblyTruncated = "";
            StringTokenizer t = new StringTokenizer(recentSessions, ";");
            int tokenNumber = 0;
            while (t.hasMoreTokens() && ++tokenNumber < x) {
                recentSessionsPossiblyTruncated = t.nextToken() + ';' + recentSessionsPossiblyTruncated;
            }
            recentSessionsPossiblyTruncated = milestoneSessionId + ';' + recentSessionsPossiblyTruncated;
            this.setRecentSessionIds(recentSessionsPossiblyTruncated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeRecentMilestoneSessions() {
        Object object = this.sessionTracking;
        synchronized (object) {
            int x = this.getMaxRecentSessionsToClose();
            String recentSessions = this.getRecentSessionIds();
            StringTokenizer t = new StringTokenizer(recentSessions, ";");
            int tokenNumber = 0;
            while (t.hasMoreTokens() && tokenNumber++ < x) {
                String msSessionId = t.nextToken();
                this.doStopSessionSync(msSessionId);
            }
            this.setRecentSessionIds("");
        }
    }

    public boolean doStartSessionSync() {
        if (this.isRunning()) {
            return this.doSessionStartSync();
        }
        return false;
    }

    public void doStopSession() {
        this.doStopSession(this.milestoneSessionId);
    }

    public void doStopSession(final String msSessionId) {
        this.postAsync(new Runnable(){

            @Override
            public void run() {
                BMilestoneDvr.this.doStopSessionSync(msSessionId);
            }
        });
    }

    public boolean doStopSessionSync(String msSessionId) {
        try {
            String meth = "GET";
            String uri = "/sessionhandler.xml?command=sessionend&sessionid=" + msSessionId;
            NHttpRequest rqst = new NHttpRequest(new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort()), meth, uri);
            String passKey = this.getUpdatedImageServerKey();
            BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
            usernameAndPassword.setUsername(this.getCredentials().getUsername());
            usernameAndPassword.setPassword(BPassword.make((String)passKey));
            rqst.setUsernamePassword(usernameAndPassword);
            rqst.addBasicAuthorization(this.getCredentials().getUsername(), passKey);
            rqst.setAddress((BAddress)this.httpAddress());
            byte[] rsp = this.getMilestoneNetwork().hcomm().sendRequest(rqst).getData();
            String milestoneResultString = "";
            XParser xmlParser = null;
            XElem milestoneMethodResponse = null;
            try {
                xmlParser = XParser.make((String)new String(rsp, 0, rsp.length));
                milestoneMethodResponse = xmlParser.parse();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("Unable to parse the expected XML response", e);
            }
            if (milestoneMethodResponse == null) {
                throw new Exception("SessionStop - No <methodresponse> tag.");
            }
            return "ok".equals(milestoneResultString);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error in Milestone Session Stop" + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSessionStartSync() {
        boolean milestoneSessionFailure = false;
        try {
            String meth = "GET";
            String uri = "/sessionhandler.xml?command=sessionstart";
            NHttpRequest rqst = new NHttpRequest(new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort()), meth, uri);
            String passKey = this.getUpdatedImageServerKey();
            BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
            usernameAndPassword.setUsername(this.getCredentials().getUsername());
            usernameAndPassword.setPassword(BPassword.make((String)passKey));
            rqst.setUsernamePassword(usernameAndPassword);
            rqst.addBasicAuthorization(this.getCredentials().getUsername(), passKey);
            rqst.setAddress((BAddress)this.httpAddress());
            byte[] rsp = this.getMilestoneNetwork().hcomm().sendRequest(rqst).getData();
            if (this.isSuccessfulSessionStart(rsp)) {
                if (milestoneSessionFailure) {
                    milestoneSessionFailure = false;
                }
                this.rememberMilestoneSession(this.milestoneSessionId);
                if (this.sessionPingTimer != null) {
                    this.sessionPingTimer.stopPingTimer();
                }
                this.sessionPingTimer = new SessionPingTimer();
                this.sessionPingTimer.start();
                this.setImageServerFaultCause("");
                this.setImageServerFaultStatus(false);
                boolean bl = true;
                return bl;
            }
            milestoneSessionFailure = true;
            this.milestoneSessionId = null;
            try {
                Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)45000L), (Action)startSession, null);
            }
            catch (NotRunningException notRunningException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Object[] args = new Object[]{new String(this.getMilestoneEngineIpAddress()), new Integer(this.getMilestoneImageServerPort())};
            this.setImageServerFaultCause(Lexicon.make(((Object)((Object)this)).getClass()).getText("MilestoneImageServerPingSessionStartFailure", args));
            this.setImageServerFaultStatus(true);
            this.getLogger().log(Level.SEVERE, Lexicon.make(((Object)((Object)this)).getClass()).getText("MilestoneImageServerPingSessionStartFailure", args), e.getStackTrace());
            boolean bl = false;
            return bl;
        }
        finally {
            this.updatePingStatus();
        }
    }

    public boolean isSuccessfulSessionStart(byte[] a) throws Exception {
        String milestoneResultString = "";
        XParser xmlParser = null;
        XElem milestoneMethodResponse = null;
        try {
            xmlParser = XParser.make((String)new String(a, 0, a.length));
            milestoneMethodResponse = xmlParser.parse();
        }
        catch (Exception e) {
            throw new Exception("Unable to parse the expected XML response", e);
        }
        if (milestoneMethodResponse != null) {
            XElem milestoneResult = milestoneMethodResponse.elem("result");
            if (milestoneResult != null) {
                XText milestoneResultText = milestoneResult.text();
                if (milestoneResultText != null) {
                    milestoneResultString = milestoneResultText.string();
                    if ("ok".equals(milestoneResultString)) {
                        XElem milestoneSessionIdElem = milestoneMethodResponse.elem("sessionid");
                        if (milestoneSessionIdElem != null) {
                            XText milestoneSessionIdText = milestoneSessionIdElem.text();
                            if (milestoneSessionIdText != null) {
                                String milestoneSessionIdString = milestoneSessionIdText.string().trim();
                                if (milestoneSessionIdString.length() > 0) {
                                    this.milestoneSessionId = milestoneSessionIdString;
                                    return true;
                                }
                                throw new Exception("Milestone sessionid string is an empty string.");
                            }
                            throw new Exception("SesionStart - <sessionid> ... </sessionid> tag contains no text.");
                        }
                        throw new Exception("SesionStart - No <sessionid> tag.");
                    }
                    throw new Exception("SesionStart - <result> ... </result> tag contains bad result: " + milestoneResultString);
                }
                throw new Exception("SesionStart - No <result> tag.");
            }
            throw new Exception("SesionStart - No <result> tag.");
        }
        throw new Exception("SesionStart - No <methodresponse> tag.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doPingSession() {
        BBoolean pinResult;
        block7: {
            block6: {
                pinResult = BBoolean.FALSE;
                try {
                    String meth = "GET";
                    String uri = "/sessionhandler.xml?command=sessionping&sessionid=" + this.milestoneSessionId;
                    NHttpRequest rqst = new NHttpRequest(new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort()), meth, uri);
                    String passKey = this.getUpdatedImageServerKey();
                    BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
                    usernameAndPassword.setUsername(this.getCredentials().getUsername());
                    usernameAndPassword.setPassword(BPassword.make((String)passKey));
                    rqst.setUsernamePassword(usernameAndPassword);
                    rqst.addBasicAuthorization(this.getCredentials().getUsername(), passKey);
                    rqst.setAddress((BAddress)this.httpAddress());
                    byte[] rsp = this.getMilestoneNetwork().hcomm().sendRequest(rqst).getData();
                    pinResult = this.isSuccessfulPingResponse(rsp) ? BBoolean.TRUE : BBoolean.FALSE;
                    if (pinResult != BBoolean.TRUE) break block6;
                    this.setImageServerFaultCause("");
                    this.setImageServerFaultStatus(false);
                    this.setCentralServerFaultStatus(false);
                    break block7;
                }
                catch (Exception e) {
                    block8: {
                        try {
                            e.printStackTrace();
                            pinResult = BBoolean.FALSE;
                            if (pinResult != BBoolean.TRUE) break block8;
                            this.setImageServerFaultCause("");
                            this.setImageServerFaultStatus(false);
                            this.setCentralServerFaultStatus(false);
                        }
                        catch (Throwable throwable) {
                            if (pinResult == BBoolean.TRUE) {
                                this.setImageServerFaultCause("");
                                this.setImageServerFaultStatus(false);
                                this.setCentralServerFaultStatus(false);
                            } else {
                                Object[] args = new Object[]{new String(this.getMilestoneEngineIpAddress()), new Integer(this.getMilestoneImageServerPort())};
                                this.setImageServerFaultCause(Lexicon.make(((Object)((Object)this)).getClass()).getText("MilestoneImageServerPingFailure", args));
                                this.setImageServerFaultStatus(true);
                                this.setCentralServerFaultStatus(true);
                            }
                            this.updatePingStatus();
                            throw throwable;
                        }
                    }
                    Object[] args = new Object[]{new String(this.getMilestoneEngineIpAddress()), new Integer(this.getMilestoneImageServerPort())};
                    this.setImageServerFaultCause(Lexicon.make(((Object)((Object)this)).getClass()).getText("MilestoneImageServerPingFailure", args));
                    this.setImageServerFaultStatus(true);
                    this.setCentralServerFaultStatus(true);
                    this.updatePingStatus();
                }
            }
            Object[] args = new Object[]{new String(this.getMilestoneEngineIpAddress()), new Integer(this.getMilestoneImageServerPort())};
            this.setImageServerFaultCause(Lexicon.make(((Object)((Object)this)).getClass()).getText("MilestoneImageServerPingFailure", args));
            this.setImageServerFaultStatus(true);
            this.setCentralServerFaultStatus(true);
        }
        this.updatePingStatus();
        return pinResult;
    }

    public boolean isSuccessfulPingResponse(byte[] a) {
        String milestoneResultString = "";
        XParser xmlParser = null;
        XElem milestoneMethodResponse = null;
        try {
            xmlParser = XParser.make((String)new String(a, 0, a.length));
            milestoneMethodResponse = xmlParser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (milestoneMethodResponse != null) {
            XElem milestoneResult = milestoneMethodResponse.elem("result");
            if (milestoneResult != null) {
                XText milestoneResultText = milestoneResult.text();
                if (milestoneResultText != null) {
                    milestoneResultString = milestoneResultText.string();
                    if ("ok".equals(milestoneResultString)) {
                        XElem milestoneSessionId = milestoneMethodResponse.elem("sessionid");
                        if (milestoneSessionId != null) {
                            XText milestoneSessionIdText = milestoneSessionId.text();
                            if (milestoneSessionIdText != null) {
                                String milestoneSessionIdString = milestoneSessionIdText.string().trim();
                                if (milestoneSessionIdString.length() > 0) {
                                    this.closeRecentMilestoneSessions();
                                    this.milestoneSessionId = milestoneSessionIdString;
                                    this.rememberMilestoneSession(milestoneSessionIdString);
                                    return true;
                                }
                                this.getLogger().log(Level.INFO, "Milestone sessionid string is an empty string.  ");
                                return false;
                            }
                            this.getLogger().log(Level.INFO, "SessionPing - <sessionid> ... </sessionid> tag contains no text.  ");
                            return false;
                        }
                        return true;
                    }
                    this.getLogger().log(Level.INFO, "SessionPing - <result> ... </result> tag contains bad result: " + milestoneResultString + ".  ");
                    return false;
                }
                this.getLogger().log(Level.INFO, "SessionPing - No <result> tag.  ");
                return false;
            }
            this.getLogger().log(Level.INFO, "SessionPing - No <result> tag.  ");
            return false;
        }
        this.getLogger().log(Level.INFO, "SessionPing - No <methodresponse> tag.  ");
        return false;
    }

    public String getMilestoneSessionId() {
        return this.milestoneSessionId;
    }

    public BIpAddress httpAddress() {
        return new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort());
    }

    public BIpAddress tcpAddress() {
        return new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneCentralPort());
    }

    private TcpLinkLayer link() {
        return (TcpLinkLayer)this.getMilestoneNetwork().tcpcomm().getLinkLayer();
    }

    public void socketTerminated(BIpAddress addr, boolean server) {
        int sid = addr.getSessionId();
        if (sid < 0) {
            return;
        }
        if (this.tcpIsSession.getLinkSessionId() == sid) {
            this.tcpIsSession.sessionTerminated();
        }
        if (this.tcpCpSession.getLinkSessionId() == sid) {
            this.tcpCpSession.sessionTerminated();
        }
    }

    public MilestoneTcpSession getTcpIsSession() throws Exception {
        if (this.tcpIsSession == null) {
            this.startTcpIsSession();
        }
        if (!this.tcpIsSession.isActive()) {
            this.tcpIsSession.start();
        }
        return this.tcpIsSession;
    }

    public MilestoneTcpSession getTcpCpSession() throws Exception {
        if (this.tcpCpSession == null) {
            this.startTcpCpSession();
        }
        if (!this.tcpCpSession.isActive()) {
            this.tcpCpSession.start();
        }
        return this.tcpCpSession;
    }

    public String getUpdatedImageServerKey() {
        String key = null;
        try {
            key = (String)FoxRpcUtil.doRpc((BISpaceNode)this, (String)"getImageServerKeyThruRpc", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC call to read Image Server password on Milestone DVR has failed"));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "RPC call to read Image Server password on Milestone DVR has failed", e);
        }
        return key;
    }

    public String getUpdatedCentralServerKey() {
        String key = null;
        try {
            key = (String)FoxRpcUtil.doRpc((BISpaceNode)this, (String)"getCentralServerKeyThruRpc", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC call to read Central Server password on Milestone DVR has failed"));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "RPC call to read Central Server password on Milestone DVR has failed", e);
        }
        return key;
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.fox)})
    public String getImageServerKeyThruRpc(Context cx) {
        return AccessController.doPrivileged(() -> ((BPassword)this.getCredentials().getPassword()).getValue());
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.fox)})
    public String getCentralServerKeyThruRpc(Context cx) {
        return AccessController.doPrivileged(() -> ((BPassword)this.getMilestoneCentralCredentials().getPassword()).getValue());
    }

    public class MilestoneTcpSession
    extends MilestoneSession {
        public MilestoneTcpSession(BIpAddress address) {
            super(address);
        }
    }

    public class MilestoneSession {
        BIpAddress adr;
        int state = 0;
        String status = "";

        public MilestoneSession(BIpAddress address) {
            this.adr = address;
        }

        synchronized void init() throws Exception {
            this.adr.setSessionId(BMilestoneDvr.this.link().createSession(this.adr));
        }

        synchronized void sessionTerminated() {
            if (this.state == 2) {
                try {
                    this.start();
                }
                catch (Exception exception) {}
            } else {
                this.adr = null;
                this.state = 5;
            }
        }

        synchronized void stop() throws Exception {
            if (this.adr == null) {
                return;
            }
            BMilestoneDvr.this.link().closeSession(this.adr.getSessionId());
            this.adr = null;
            this.state = 5;
        }

        public synchronized void sendMessage(NMessage req) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            req.setAddress((BAddress)this.adr);
            BMilestoneDvr.this.getMilestoneNetwork().tcpcomm().sendMessage(req);
        }

        public synchronized NMessage sendRequest(NMessage req) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            req.setAddress((BAddress)this.adr);
            return BMilestoneDvr.this.getMilestoneNetwork().tcpcomm().sendRequest(req);
        }

        public void restart() throws Exception {
            if (this.adr != null) {
                this.stop();
            }
            this.start();
        }

        public boolean isActive() {
            return this.state == 2;
        }

        synchronized void start() throws Exception {
            try {
                this.state = 1;
                this.init();
                this.state = 2;
            }
            catch (Exception e) {
                this.state = 4;
                throw e;
            }
        }

        synchronized int getLinkSessionId() {
            if (this.adr == null) {
                return -1;
            }
            return this.adr.getSessionId();
        }
    }

    public class SessionPingTimer
    extends Thread {
        public boolean running;
        BMilestoneDvr dvr;

        public SessionPingTimer() {
            super("milestone.sessionPing." + nextSessionPingTimerId++);
            this.running = true;
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    Thread.sleep(45000L);
                    BMilestoneDvr.this.doPingSession();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void stopPingTimer() {
            this.running = false;
            this.interrupt();
        }
    }
}

