/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone;

import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.nmilestone.BMilestoneCameraDiscoveryPreferences;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMilestoneCameraDeviceExt
extends BCameraDeviceExt {
    public static final Property discoveryPreferences = BMilestoneCameraDeviceExt.newProperty((int)0, (BValue)new BMilestoneCameraDiscoveryPreferences(), null);
    public static final Type TYPE = Sys.loadType(BMilestoneCameraDeviceExt.class);

    public Type getType() {
        return TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        BMilestoneDvr dvr = (BMilestoneDvr)this.getParent();
        try {
            HttpComm hcom = dvr.getMilestoneNetwork().hcomm();
            BIpAddress addr = dvr.httpAddress();
            String passKey = dvr.getUpdatedImageServerKey();
            BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
            usernameAndPassword.setUsername(dvr.getCredentials().getUsername());
            usernameAndPassword.setPassword(BPassword.make((String)passKey));
            return MilestoneHttpUtil.discoverCameras(hcom, addr, usernameAndPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException("Unable to discover camers in " + dvr.getDisplayName(null), (Throwable)e);
        }
    }
}

