/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone;

import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.BMilestoneVideoSourcePreferences;
import com.tridium.nmilestone.comm.BMilestoneTcpCommConfig;
import com.tridium.nmilestone.enums.BMilestoneStopRecordingModeEnum;
import com.tridium.nmilestone.event.BMilestoneEventCameraExt;
import com.tridium.nmilestone.event.BMilestoneEventRecall;
import com.tridium.nmilestone.messages.MilestoneCameraConnectReq;
import com.tridium.nmilestone.messages.MilestoneCameraConnectRsp;
import com.tridium.nmilestone.messages.MilestoneCameraInitiateRecordingReq;
import com.tridium.nmilestone.messages.MilestoneMoveToPresetReq;
import com.tridium.nmilestone.messages.MilestonePanTiltReq;
import com.tridium.nmilestone.messages.MilestoneStorePresetReq;
import com.tridium.nmilestone.messages.MilestoneVideoStreamReq;
import com.tridium.nmilestone.messages.MilestoneZoomReq;
import com.tridium.nmilestone.util.BMilestoneVideoCameraInfo;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nmilestone.util.MilestoneVideoStreamUtil;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.web.rpc.BChangeUserPasswordRpc;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import org.baja.ffmpeg.enums.BCodecIdEnum;

public class BMilestoneCamera
extends BVideoCamera
implements BIVideoEventProvider,
BIVideoAlarmRecorder {
    public static final Property videoDeviceId = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneCameraDeviceId(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property ptzSupport = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneVideoCameraInfo(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property cameraTcpConfig = BMilestoneCamera.newProperty((int)4, (BValue)new BMilestoneTcpCommConfig(), null);
    public static final Property videoPreferences = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneVideoSourcePreferences(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property milestoneDatabaseId = BMilestoneCamera.newProperty((int)68, (String)"", null);
    public static final Property milestoneGuid = BMilestoneCamera.newProperty((int)68, (String)"", null);
    public static final Property autoSetPtzSupport = BMilestoneCamera.newProperty((int)0, (boolean)true, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property stopRecordingMode = BMilestoneCamera.newProperty((int)0, (BValue)BMilestoneStopRecordingModeEnum.onTimer, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property presetText = BMilestoneCamera.newProperty((int)1, (BValue)BEnumRange.make((String[])new String[]{EscUtil.slot.escape("???")}), null);
    public static final Property highCompressionCodec = BMilestoneCamera.newProperty((int)0, (BValue)BCodecIdEnum.ffmpeg_CODEC_ID_MPEG4, (BFacets)BCodecIdEnum.makeFfmpegCodecFacets());
    public static final Property events = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneEventCameraExt(), null);
    public static final Property milestonePtzReconnectInterval = BMilestoneCamera.newProperty((int)4, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property eventRecaller = BMilestoneCamera.newProperty((int)6, (BValue)new BMilestoneEventRecall(), null);
    public static final Action moveToPreset = BMilestoneCamera.newAction((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action storePreset = BMilestoneCamera.newAction((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action forceStartRecording = BMilestoneCamera.newAction((int)4, null);
    public static final Action forceStopRecording = BMilestoneCamera.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BMilestoneCamera.class);
    protected boolean establishingMilestonePtzConnection;
    protected ConnectionMaintainer connectionMaintainer;
    protected boolean hasPingedAtLeastOnce;
    boolean initialized = false;
    boolean milestonePtzConnectionEstablished;
    protected static int videoRequestId = 1;

    public BVideoCameraInfo getPtzSupport() {
        return (BVideoCameraInfo)this.get(ptzSupport);
    }

    public void setPtzSupport(BVideoCameraInfo v) {
        this.set(ptzSupport, (BValue)v, null);
    }

    public BMilestoneTcpCommConfig getCameraTcpConfig() {
        return (BMilestoneTcpCommConfig)this.get(cameraTcpConfig);
    }

    public void setCameraTcpConfig(BMilestoneTcpCommConfig v) {
        this.set(cameraTcpConfig, (BValue)v, null);
    }

    public BVideoSourcePreferences getVideoPreferences() {
        return (BVideoSourcePreferences)this.get(videoPreferences);
    }

    public void setVideoPreferences(BVideoSourcePreferences v) {
        this.set(videoPreferences, (BValue)v, null);
    }

    public String getMilestoneDatabaseId() {
        return this.getString(milestoneDatabaseId);
    }

    public void setMilestoneDatabaseId(String v) {
        this.setString(milestoneDatabaseId, v, null);
    }

    public String getMilestoneGuid() {
        return this.getString(milestoneGuid);
    }

    public void setMilestoneGuid(String v) {
        this.setString(milestoneGuid, v, null);
    }

    public boolean getAutoSetPtzSupport() {
        return this.getBoolean(autoSetPtzSupport);
    }

    public void setAutoSetPtzSupport(boolean v) {
        this.setBoolean(autoSetPtzSupport, v, null);
    }

    public BMilestoneStopRecordingModeEnum getStopRecordingMode() {
        return (BMilestoneStopRecordingModeEnum)this.get(stopRecordingMode);
    }

    public void setStopRecordingMode(BMilestoneStopRecordingModeEnum v) {
        this.set(stopRecordingMode, (BValue)v, null);
    }

    public BEnumRange getPresetText() {
        return (BEnumRange)this.get(presetText);
    }

    public void setPresetText(BEnumRange v) {
        this.set(presetText, (BValue)v, null);
    }

    public BCodecIdEnum getHighCompressionCodec() {
        return (BCodecIdEnum)this.get(highCompressionCodec);
    }

    public void setHighCompressionCodec(BCodecIdEnum v) {
        this.set(highCompressionCodec, (BValue)v, null);
    }

    public BPointDeviceExt getEvents() {
        return (BPointDeviceExt)this.get(events);
    }

    public void setEvents(BPointDeviceExt v) {
        this.set(events, (BValue)v, null);
    }

    public BRelTime getMilestonePtzReconnectInterval() {
        return (BRelTime)this.get(milestonePtzReconnectInterval);
    }

    public void setMilestonePtzReconnectInterval(BRelTime v) {
        this.set(milestonePtzReconnectInterval, (BValue)v, null);
    }

    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    public void setEventRecaller(BVideoEventRecall v) {
        this.set(eventRecaller, (BValue)v, null);
    }

    public void moveToPreset(BValue presetPosition) {
        this.invoke(moveToPreset, presetPosition, null);
    }

    public void storePreset(BValue presetPosition) {
        this.invoke(storePreset, presetPosition, null);
    }

    public void forceStartRecording() {
        this.invoke(forceStartRecording, null, null);
    }

    public void forceStopRecording() {
        this.invoke(forceStopRecording, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void videoCameraStarted() throws Exception {
        this.getPtzSupport().setSupportsStorePreset(false);
        this.getPtzSupport().setSupportsIris(false);
        this.getPtzSupport().setSupportsFocus(false);
        BDeviceNetwork net = this.getNetwork();
        String cameraLimitFault = (String)net.fw(501, (Object)"camera.limit", null, null, null);
        if (cameraLimitFault != null) {
            this.configFatal(cameraLimitFault);
        }
        this.milestoneCameraStarted();
        super.videoCameraStarted();
    }

    protected void milestoneCameraStarted() {
        try {
            this.tcpCommunicatorStarted();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void doPing() {
        try {
            String passKey = this.getMilestoneDvr().getUpdatedImageServerKey();
            BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
            usernameAndPassword.setUsername(this.getMilestoneDvr().getCredentials().getUsername());
            usernameAndPassword.setPassword(BPassword.make((String)passKey));
            MilestoneHttpUtil.getCamStatus(this, this.getMilestoneNetwork().hcomm(), this.getMilestoneDvr().httpAddress(), usernameAndPassword);
            this.pingOk();
        }
        catch (Exception e) {
            this.pingFail(e.getLocalizedMessage());
        }
    }

    public void stopped() throws Exception {
        try {
            super.stopped();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changed(Property property, Context cx) {
        super.changed(property, cx);
        if (property.equals(autoSetPtzSupport)) {
            // empty if block
        }
    }

    public void descendantsStarted() throws Exception {
        String cameraGuid = ((BMilestoneCameraDeviceId)this.getVideoDeviceId()).getCameraGuid();
        if (cameraGuid.length() > 0) {
            this.considerEstablishingMilestoneCameraConnection(cameraGuid);
        }
    }

    protected void tcpCommunicatorStarted() throws Exception {
        this.connectionMaintainer = new ConnectionMaintainer(this);
        this.connectionMaintainer.start();
    }

    protected void tcpCommunicatorStopped() throws Exception {
        this.connectionMaintainer.stopConnectionMaintainer();
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        MilestoneVideoStreamReq videoReq = new MilestoneVideoStreamReq();
        videoReq.setVideoSource((BIVideoSource)this);
        videoReq.setVideoDestination(videoDestination);
        videoReq.setPlaybackParams(playbackParams);
        MilestoneVideoStreamUtil.sendStreamRequest(videoReq, this, this.getMilestoneDvr());
        IVideoStream ivs = videoReq.makeVideoStream();
        if (ivs != null) {
            videoDestination.receiveVideoStream(ivs);
        }
    }

    public void considerEstablishingMilestoneCameraConnection(String camDbId) {
        if (!this.milestonePtzConnectionEstablished && !this.establishingMilestonePtzConnection) {
            this.establishMilestonePtzCameraConnection(camDbId);
        }
    }

    public void establishMilestonePtzCameraConnection(String camDbId) {
        if (!this.isRunning()) {
            return;
        }
        this.establishingMilestonePtzConnection = true;
        try {
            MilestoneCameraConnectReq req = this.makeCameraConnectReq(camDbId);
            req.setAddress((BAddress)this.getMilestoneDvr().httpAddress());
            MilestoneCameraConnectRsp rsp = (MilestoneCameraConnectRsp)this.getMilestoneDvr().getTcpIsSession().sendRequest(req);
            rsp.setMilestoneCamera(this);
            rsp.fromInputStream(rsp.in);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("Make Camera Connect Req failed.");
        }
    }

    public MilestoneCameraConnectReq makeCameraPtzConnectReq() {
        return this.makeCameraConnectReq(((BMilestoneCameraDeviceId)this.getVideoDeviceId()).getCameraGuid());
    }

    public MilestoneCameraConnectReq makeCameraConnectReq(String camDbId) {
        String passKey = this.getMilestoneDvr().getUpdatedImageServerKey();
        String userName = this.getMilestoneDvr().getCredentials().getUsername();
        MilestoneCameraConnectReq connectReq = new MilestoneCameraConnectReq(userName, passKey, camDbId, true, this);
        connectReq.setAddress((BAddress)this.getMilestoneDvr().httpAddress());
        return connectReq;
    }

    public void setMilestonePtzConnectionEstablished(boolean milestonePtzConnectionEstablished) {
        this.milestonePtzConnectionEstablished = milestonePtzConnectionEstablished;
        this.establishingMilestonePtzConnection = false;
    }

    public boolean getHasPingedAtLeastOnce() {
        return this.hasPingedAtLeastOnce;
    }

    public void pingFail(String cause) {
        this.hasPingedAtLeastOnce = true;
        super.pingFail(cause);
    }

    public void pingOk() {
        this.hasPingedAtLeastOnce = true;
        this.establishMilestonePtzCameraConnection(((BMilestoneCameraDeviceId)this.getVideoDeviceId()).getCameraGuid());
        super.pingOk();
    }

    public BMilestoneDvr getMilestoneDvr() {
        return (BMilestoneDvr)this.getDvr();
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    public Action getStorePresetAction() {
        return storePreset;
    }

    public void initPlaybackParams(BPlaybackParams arg0, IVideoSession arg1) {
    }

    public Type getNetworkType() {
        return BMilestoneNetwork.TYPE;
    }

    public void onMove(BVideoPanTiltEnum panTiltAction) {
        if (panTiltAction != BVideoPanTiltEnum.none) {
            try {
                this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestonePanTiltReq(panTiltAction));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onZoom(BVideoZoomEnum zoomAction) {
        if (zoomAction != BVideoZoomEnum.none) {
            try {
                this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestoneZoomReq(zoomAction));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doMoveToPreset(BValue presetPosition) {
        try {
            this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestoneMoveToPresetReq((BDynamicEnum)presetPosition));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doStorePreset(BValue presetPosition) {
        try {
            this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestoneStorePresetReq((BDynamicEnum)presetPosition));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(moveToPreset) || action.equals(storePreset)) {
            return BDynamicEnum.make((BEnumRange)this.getPresetText());
        }
        return super.getActionParameterDefault(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecordingAlarm(BAlarmRecord alarmRecord) {
        if (alarmRecord.getSourceState() == BSourceState.normal) {
            BMilestoneStopRecordingModeEnum stopRecordingMode = this.getStopRecordingMode();
            if (stopRecordingMode == BMilestoneStopRecordingModeEnum.onTimer) return;
            if (stopRecordingMode != BMilestoneStopRecordingModeEnum.onAlarmToNormal) throw new IllegalStateException("Unrecognized BMilestoneStopRecordingModeEnum: " + (Object)((Object)stopRecordingMode));
            this.doForceStopRecording();
            return;
        } else {
            this.doForceStartRecording();
        }
    }

    public void doForceStartRecording() {
        MilestoneCameraInitiateRecordingReq initiateRecordingReq = new MilestoneCameraInitiateRecordingReq(this);
        initiateRecordingReq.setStartRecording(true);
        try {
            initiateRecordingReq.setAddress((BAddress)this.getMilestoneDvr().tcpAddress());
            this.getMilestoneDvr().getTcpCpSession().sendMessage(initiateRecordingReq);
        }
        catch (Exception e) {
            this.getLogger().severe("Error in Initiate Recording Req");
        }
    }

    public void doForceStopRecording() {
        MilestoneCameraInitiateRecordingReq initiateRecordingReq = new MilestoneCameraInitiateRecordingReq(this);
        initiateRecordingReq.setStartRecording(false);
        try {
            initiateRecordingReq.setAddress((BAddress)this.getMilestoneDvr().tcpAddress());
            this.getMilestoneDvr().getTcpCpSession().sendMessage(initiateRecordingReq);
        }
        catch (Exception e) {
            this.getLogger().severe("Error in Initiate Recording Req");
        }
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box)})
    public Map<String, Object> getServerConnectionParamsWithRpc(Context cx) throws BChangeUserPasswordRpc.JSONParseableException {
        if (!BMilestoneCamera.isAllowedToWirePasswords(cx)) {
            throw new BChangeUserPasswordRpc.JSONParseableException("Insecure webservice configuration");
        }
        Map usernamePasswordMap = AccessController.doPrivileged(() -> {
            HashMap<String, String> inMap = new HashMap<String, String>();
            BUsernameAndPassword usernameAndPassword = this.getMilestoneDvr().getCredentials();
            inMap.put("username", usernameAndPassword.getUsername());
            inMap.put("password", usernameAndPassword.getPassword().getValue());
            return inMap;
        });
        String uri = !cx.getFacets().getb("isSecure", false) ? "http://" + this.getMilestoneDvr().getMilestoneEngineIpAddress() + ":" + this.getMilestoneDvr().getWebClientHttpPort() + "/" : "https://" + this.getMilestoneDvr().getMilestoneEngineIpAddress() + ":" + this.getMilestoneDvr().getWebClientHttpsPort() + "/";
        usernamePasswordMap.put("uri", uri);
        return usernamePasswordMap;
    }

    private static boolean isAllowedToWirePasswords(Context cx) {
        return cx.getFacets().getb("isSecure", false) || BMilestoneCamera.canChangeInsecurely();
    }

    private static boolean canChangeInsecurely() {
        BWebService webService;
        try {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            return true;
        }
        return !webService.getRequireHttpsForPasswords();
    }

    public int getCameraId() {
        return ((BMilestoneCameraDeviceId)this.getVideoDeviceId()).getCameraId();
    }

    public static synchronized int getNextVideoRequestId() {
        return videoRequestId++;
    }

    public BAbsTime getCameraTime() {
        try {
            return BAbsTime.now();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BMilestoneNetwork getMilestoneNetwork() {
        return (BMilestoneNetwork)this.getNetwork();
    }

    public class ConnectionMaintainer
    extends Thread {
        protected boolean running;
        BMilestoneCamera camera;

        public ConnectionMaintainer(BMilestoneCamera camera) {
            super("MilestoneCommunicator:MaintainConnection");
            this.running = true;
            this.camera = camera;
        }

        public BMilestoneCamera getMilestoneCamera() {
            return this.camera;
        }

        @Override
        public void start() {
            this.running = true;
            super.start();
        }

        public void stopConnectionMaintainer() {
            this.running = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    try {
                        this.maintainConnection();
                    }
                    catch (Exception e) {
                        BMilestoneCamera.this.getLogger().log(Level.SEVERE, "Error while maintaining camera connection for ptz control", e);
                    }
                    Thread.sleep(BMilestoneCamera.this.getMilestonePtzReconnectInterval().getMillis());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                BMilestoneCamera.this.getLogger().fine("Connection maintainer thread finished.");
            }
        }

        protected void maintainConnection() {
            BMilestoneCamera milestoneCamera = this.getMilestoneCamera();
            String camDbId = ((BMilestoneCameraDeviceId)this.camera.getVideoDeviceId()).getCameraGuid();
            if (camDbId.length() == 0) {
                milestoneCamera.doPing();
            } else {
                BMilestoneCamera.this.establishMilestonePtzCameraConnection(camDbId);
            }
        }
    }
}

