/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.remoteVideo.RemoteFoxVideoStream;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRemoteFoxVideoSource
extends BFoxVideoSource {
    public static final Property foxVideoSourceSlaveStation = BRemoteFoxVideoSource.newProperty((int)0, (BValue)new BFoxVideoSource(), null);
    public static final Type TYPE = Sys.loadType(BRemoteFoxVideoSource.class);
    protected BRemoteVideoSource remoteVideoSource;
    protected static final Log log = Log.getLog((String)"fox.remoteVideoSource");

    public BFoxVideoSource getFoxVideoSourceSlaveStation() {
        return (BFoxVideoSource)this.get(foxVideoSourceSlaveStation);
    }

    public void setFoxVideoSourceSlaveStation(BFoxVideoSource v) {
        this.set(foxVideoSourceSlaveStation, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getNextVideoStreamId() {
        return super.getNextVideoStreamId();
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        if (log.isTraceOn()) {
            log.trace("Stream to Destination");
        }
        if (this.getComponentSpace().isProxyComponentSpace()) {
            if (log.isTraceOn()) {
                log.trace("Excecuting in a Workbench VM.");
            }
            playbackParams.setVideoSourceOrd(this.getFoxVideoSourceSlaveStation().getSlotPathOrd());
            this.getFoxVideoSourceSlaveStation().streamToDestination(playbackParams, videoDestination);
        } else {
            if (log.isTraceOn()) {
                log.trace("Excecuting in a Master station or Supervisor VM.");
            }
            this.foxStreamFromMasterStationToDestination(playbackParams, videoDestination);
        }
    }

    public BRemoteVideoSource getRemoteVideoSource() {
        if (this.remoteVideoSource == null) {
            this.remoteVideoSource = (BRemoteVideoSource)this.getParent();
        }
        return this.remoteVideoSource;
    }

    public String getNiagaraStation() {
        return this.getRemoteVideoSource().getNiagaraStation();
    }

    public BOrd getCameraOrd() {
        return this.getRemoteVideoSource().getCameraOrd();
    }

    public void foxStreamFromMasterStationToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        BNiagaraNetwork niagaraNet = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation niagaraStation = (BNiagaraStation)niagaraNet.getStation(this.getNiagaraStation());
        try {
            playbackParams.setVideoSourceOrd(this.getCameraOrd());
            new RemoteFoxVideoStream(niagaraStation, playbackParams, this.getNextVideoStreamId(), videoDestination);
        }
        catch (Exception e) {
            if (e instanceof BajaRuntimeException) {
                Throwable cause = e;
                while (cause != null && !(cause instanceof InterruptedException)) {
                    if (cause instanceof BajaRuntimeException) {
                        cause = ((BajaRuntimeException)cause).getCause();
                        continue;
                    }
                    cause = null;
                }
                if (cause != null && cause instanceof InterruptedException) {
                    return;
                }
            }
            throw new BajaRuntimeException((Throwable)e);
        }
    }
}

