/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.ui;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.learn.BNdioBoardEntry;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BNdioBoardManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BNdioBoardManager.class);
    static Lexicon ndioLex = Lexicon.make((String)"ndio");
    static BImage ndioBoardIcon = BImage.make((String)"module://icons/x16/device.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colExts = new DeviceExtsColumn((BDevice)new BNdioBoard());
    MgrColumn colIoPort = new MgrColumn.Prop(BNdioBoard.ioPort, 1);
    MgrColumn colMultiProc = new MgrColumn.Prop(BNdioBoard.multipleProcessors);
    MgrColumn colFirmware = new MgrColumn.Prop(BNdioBoard.firmwareVersion);
    MgrColumn colConfig = new MgrColumn.Prop(BNdioBoard.configCode);
    MgrColumn colUiCount = new MgrColumn.Prop(BNdioBoard.uiCount);
    MgrColumn colBoCount = new MgrColumn.Prop(BNdioBoard.boCount);
    MgrColumn colAoCount = new MgrColumn.Prop(BNdioBoard.aoCount);
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colExts, this.colIoPort, this.colMultiProc, this.colFirmware, this.colConfig, this.colUiCount, this.colBoCount, this.colAoCount, this.colStatus, this.colEnabled, this.colHealth};
    static final Log log = Log.getLog((String)"ndio");
    private BNdioNetwork net = null;
    BNdioBoardEntry[] lastLearn = null;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public BNdioNetwork getNetwork() {
        if (this.net != null) {
            return this.net;
        }
        this.net = (BNdioNetwork)((BIDeviceFolder)this.getCurrentValue()).getNetwork();
        return this.net;
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BNdioBoardEntry[])event.getChildren(BNdioBoardEntry.class);
        this.lastLearn = rows;
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    static class State
    extends MgrState {
        BNdioBoardEntry[] lastLearn = null;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BNdioBoardManager manager = (BNdioBoardManager)m;
            this.lastLearn = manager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BNdioBoardManager manager = (BNdioBoardManager)m;
            if (this.lastLearn != null) {
                manager.lastLearn = this.lastLearn;
                manager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BNdioBoardManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BNdioBoardEntry.ioPort), new MgrColumn.Prop(BNdioBoardEntry.multipleProcessors), new MgrColumn.Prop(BNdioBoardEntry.firmwareVersion), new MgrColumn.Prop(BNdioBoardEntry.configCode), new MgrColumn.Prop(BNdioBoardEntry.uiCount), new MgrColumn.Prop(BNdioBoardEntry.boCount), new MgrColumn.Prop(BNdioBoardEntry.aoCount)};
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return false;
        }

        public BImage getIcon(Object dis) {
            return ndioBoardIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return BNdioBoardManager.this.getModel().getNewTypes();
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BNdioBoardEntry entry = (BNdioBoardEntry)dis;
            row.setCell(BNdioBoardManager.this.colIoPort, (BValue)BInteger.make((int)entry.getIoPort()));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BNdioBoardEntry entry = (BNdioBoardEntry)discovery;
                return entry.is(component);
            }
            catch (Throwable e) {
                return false;
            }
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BNdioBoardManager.this.updateDiscoveryRows((BComponent)job);
        }
    }

    class Model
    extends DeviceModel {
        Model(BNdioBoardManager manager) {
            super((BDeviceManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return BNdioBoardManager.this.cols;
        }
    }

    class Controller
    extends DeviceController {
        Controller(BDeviceManager mgr) {
            super(mgr);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add};
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            BNdioBoardManager.this.getLearn().setJob(BNdioBoardManager.this.getNetwork().submitDiscoveryJob());
            return null;
        }
    }
}

