/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import java.util.Arrays;
import javax.baja.chart.BContinuousAxis;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.UnboundException;

public class BTimeOfDayAxis
extends BContinuousAxis {
    public static final Type TYPE = Sys.loadType(BTimeOfDayAxis.class);
    static final int interval = 30;
    static final int intervalsPerHour = 2;
    static final int minutesInDay = 1440;
    static final int max = 48;
    static final int min = 0;
    static final BInteger maxNumber = BInteger.make((int)48);
    static final BInteger minNumber = BInteger.make((int)0);
    static final Object[] tickValues;
    static final BFacets toStringFacets;

    public Type getType() {
        return TYPE;
    }

    public int hashCode() {
        throw new UnboundException();
    }

    public String getTitle() {
        return "Time of Day";
    }

    public String getUnitLabel() {
        return "";
    }

    public boolean getShowSwatches() {
        return false;
    }

    public Type getValueType() {
        return BRelTime.TYPE;
    }

    public double toPercentOfRange(Object value) {
        return ((BInteger)value).getDouble() / (double)maxNumber.getInt();
    }

    public Object fromPercentOfRange(double percent) {
        return BInteger.make((int)((int)((double)maxNumber.getInt() * percent)));
    }

    public Object getZero() {
        return minNumber;
    }

    public Object getAxisMin() {
        return minNumber;
    }

    public void setAxisMin(Object newMin) {
    }

    public Object getAxisMax() {
        return maxNumber;
    }

    public void setAxisMax(Object newMax) {
    }

    public Object[] getTickValues() {
        return Arrays.copyOf(tickValues, tickValues.length);
    }

    public String valueToString(Object value) {
        int val = (int)((BINumeric)value).getNumeric();
        int hours = val / 2;
        int minutes = (val - hours * 2) * 30;
        StringBuffer sb = new StringBuffer(5);
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        return sb.toString();
    }

    static {
        int intervalsInDay = 48;
        tickValues = new Object[intervalsInDay];
        for (int i = 0; i < tickValues.length; ++i) {
            BTimeOfDayAxis.tickValues[i] = BInteger.make((int)i);
        }
        toStringFacets = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE);
    }
}

