/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import com.tridium.ui.theme.Theme;
import com.tridiumx.analytics.ui.chart.BSpectrumChart;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BDefaultChartLegend;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;

public class BSpectrumChartLegend
extends BDefaultChartLegend {
    public static final Type TYPE = Sys.loadType(BSpectrumChartLegend.class);
    final BEdgePane content;
    final BLabel minLabel = new BLabel("1234");
    final BLabel midLabel = new BLabel();
    final BLabel maxLabel = new BLabel();

    public Type getType() {
        return TYPE;
    }

    public BSpectrumChartLegend() {
        BFlowPane flow = new BFlowPane(BHalign.center, 10, 0);
        flow.add(null, (BValue)this.makeLabelPane(this.minLabel, BColor.white, BColor.blue));
        flow.add(null, (BValue)this.makeLabelPane(this.midLabel, BColor.black, BColor.white));
        flow.add(null, (BValue)this.makeLabelPane(this.maxLabel, BColor.white, BColor.red));
        this.content = new BEdgePane();
        this.content.setCenter((BWidget)flow);
        this.content.layout();
    }

    public void paint(Graphics g) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        this.content.paint(g);
    }

    public void doLayout(BWidget[] kids) {
        if (this.getPane().getAxes(BAxisDimension.y).length == 0) {
            return;
        }
        BSpectrumChart chart = (BSpectrumChart)this.getPane().getCharts()[0];
        BAxis valueAxis = this.getPane().getAxes(BAxisDimension.y)[0];
        BFacets facets = valueAxis.getFacets();
        if (Math.abs(chart.minValue - Double.MAX_VALUE) < 1.0E-7 || Math.abs(chart.maxValue - Double.MIN_VALUE) < 1.0E-7) {
            return;
        }
        this.minLabel.setText(this.makeLabelText("Min", chart.minValue, facets));
        this.midLabel.setText(this.makeLabelText("Mid", chart.midValue, facets));
        this.maxLabel.setText(this.makeLabelText("Max", chart.maxValue, facets));
        this.content.setSize(this.getWidth(), this.getHeight() + 20.0);
        this.content.layout();
    }

    public double getPreferredHeight(double w) {
        this.content.computePreferredSize();
        return this.content.getPreferredHeight();
    }

    private BWidget makeLabelPane(BLabel label, BColor foreground, BColor background) {
        label.setForeground(BBrush.makeSolid((BColor)foreground));
        label.setValign(BValign.center);
        label.setHalign(BHalign.center);
        label.setFont(Theme.label().getBoldText());
        BBorderPane border = new BBorderPane((BWidget)label, BBorder.solid, BInsets.make((double)4.0, (double)8.0, (double)4.0, (double)8.0));
        border.setFill(BBrush.makeSolid((BColor)background));
        return border;
    }

    private String makeLabelText(String name, double value, BFacets facets) {
        StringBuffer sb = new StringBuffer();
        sb.append(name).append(": ");
        sb.append(BDouble.make((double)value).toString((Context)facets));
        return sb.toString();
    }
}

